/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteConnection;
import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java.SQLiteStatement;
import de.mpc.BaseLib.Hexuple;
import de.mpc.BaseLib.Pair;
import de.mpc.BaseLib.Quadruple;
import de.mpc.BaseLib.Quintuple;
import de.mpc.BaseLib.Triple;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.AminoAcidModifications;
import de.mpc.PD.AminoAcidModificationsAminoAcids;
import de.mpc.PD.AminoAcidModificationsAminoAcidsNL;
import de.mpc.PD.AminoAcidModificationsNeutralLosses;
import de.mpc.PD.AminoAcids;
import de.mpc.PD.AnnotationDataVersion;
import de.mpc.PD.AnnotationDataset;
import de.mpc.PD.AnnotationGroups;
import de.mpc.PD.AnnotationTypes;
import de.mpc.PD.Annotations;
import de.mpc.PD.AnnotationsAnnotationGroups;
import de.mpc.PD.AnnotationsProtein;
import de.mpc.PD.Chromatograms;
import de.mpc.PD.CustomDataFields;
import de.mpc.PD.CustomDataPeptides;
import de.mpc.PD.CustomDataPeptides_decoy;
import de.mpc.PD.CustomDataProcessingNodes;
import de.mpc.PD.CustomDataProteins;
import de.mpc.PD.CustomDataProteins_decoy;
import de.mpc.PD.CustomDataSpectra;
import de.mpc.PD.Enzymes;
import de.mpc.PD.EnzymesCleavageSpecificities;
import de.mpc.PD.EventAnnotations;
import de.mpc.PD.EventAreaAnnotations;
import de.mpc.PD.Events;
import de.mpc.PD.FalseDiscoveryRates;
import de.mpc.PD.FastaFiles;
import de.mpc.PD.FastaFilesProteinAnnotations;
import de.mpc.PD.FileInfos;
import de.mpc.PD.IdentifiedMassPeaks2;
import de.mpc.PD.IdentifiedPeptides2;
import de.mpc.PD.MassPeakRelations;
import de.mpc.PD.MassPeaks;
import de.mpc.PD.PDBaseClassPairedPrimaryKey;
import de.mpc.PD.PDBaseClassQuadrupledPrimaryKey;
import de.mpc.PD.PDBaseClassSinglePrimaryKey;
import de.mpc.PD.PDBaseClassTripledPrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import de.mpc.PD.Params.PDProgramParameters;
import de.mpc.PD.Params.SimpleProgramParameters;
import de.mpc.PD.PeptideScores;
import de.mpc.PD.PeptideScores_decoy;
import de.mpc.PD.Peptides;
import de.mpc.PD.PeptidesAminoAcidModifications;
import de.mpc.PD.PeptidesAminoAcidModifications_decoy;
import de.mpc.PD.PeptidesProteins;
import de.mpc.PD.PeptidesProteins_decoy;
import de.mpc.PD.PeptidesReferenceSpectra;
import de.mpc.PD.PeptidesTerminalModifications;
import de.mpc.PD.PeptidesTerminalModifications_decoy;
import de.mpc.PD.Peptides_decoy;
import de.mpc.PD.PrecursorIonAreaSearchSpectra;
import de.mpc.PD.PrecursorIonQuanResults;
import de.mpc.PD.PrecursorIonQuanResultsSearchSpectra;
import de.mpc.PD.ProcessingNodeExtensions;
import de.mpc.PD.ProcessingNodeFilterParameters;
import de.mpc.PD.ProcessingNodeParameters;
import de.mpc.PD.ProcessingNodeScores;
import de.mpc.PD.ProcessingNodes;
import de.mpc.PD.ProcessingNodesSpectra;
import de.mpc.PD.ProteinAnnotations;
import de.mpc.PD.ProteinIdentificationGroups;
import de.mpc.PD.ProteinScores;
import de.mpc.PD.ProteinScores_decoy;
import de.mpc.PD.Proteins;
import de.mpc.PD.ProteinsProteinGroups;
import de.mpc.PD.PtmAnnotationData;
import de.mpc.PD.QuanResults;
import de.mpc.PD.ReferenceSpectra;
import de.mpc.PD.ReporterIonQuanResults;
import de.mpc.PD.ReporterIonQuanResultsSearchSpectra;
import de.mpc.PD.ScanEvents;
import de.mpc.PD.SchemaInfo;
import de.mpc.PD.Spectra;
import de.mpc.PD.SpectrumHeaders;
import de.mpc.PD.SpectrumScores;
import de.mpc.PD.TaxonomyNodes;
import de.mpc.PD.WorkflowMessages;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ABaseClass {
    private final String STR_MUST_OVERRIDE_GET_ID = "Must override getID() of SinglePrimaryKey BaseClass";
    private final String STR_MUST_OVERRIDE_GET_FIRST_ID = "Must override getFirstID() of PairedPrimaryKey BaseClass";
    private final String STR_MUST_OVERRIDE_GET_SECOND_ID = "Must override getSecondID() of PairedPrimaryKey BaseClass";
    private final String STR_MUST_OVERRIDE_SET_ALL_MEMBERS = "Must override setAllMembers() of BaseClass";
    protected final String STR_VERS_11 = "1.1";
    protected final String STR_VERS_12 = "1.2";
    private final String STR_FROM = "from ";
    protected final String STR_ISNULL = " is null: ";
    protected final String STR_ISNULL_IN = " is null in ";
    protected final String STR_NORESFOR = "No results found for ";
    protected final String STR_RESFOR = "Result set for ";
    protected final String STR_ERROR = "Error";
    protected final String STR_WARNING = "Warning";
    protected final String STR_SQL_MSG = "SQL Message: ";
    protected final String STR_DATE_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final String STR_AND_BLANK = " AND ";
    protected static final int STAT_COL_0 = 0;
    protected static final int STAT_COL_1 = 1;
    protected static final int STAT_COL_2 = 2;
    protected static final int STAT_COL_3 = 3;
    protected static final int STAT_COL_4 = 4;
    protected final long UNSET_ID = -1L;
    protected final int COL_0 = 0;
    protected final int COL_1 = 1;
    protected final int COL_2 = 2;
    protected final int COL_3 = 3;
    protected final int COL_4 = 4;
    protected final int COL_5 = 5;
    protected final int COL_6 = 6;
    protected final int COL_7 = 7;
    protected final int COL_8 = 8;
    protected final int COL_9 = 9;
    protected final int PRIM_KEY_INDEX_ZERO = 0;
    protected final int PRIM_KEY_INDEX_ONE = 1;
    protected static String strVersion = "";
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    protected static final Logger statLogger = LoggerFactory.getLogger(ABaseClass.class);
    protected Object[] logParamArray = new Object[3];
    protected boolean bFound = false;
    protected boolean bWarnOnNotFound = false;
    protected int colIndex = 0;
    protected StringBuilder sb = new StringBuilder();
    protected PDProgramParameters pp = null;
    protected SimpleProgramParameters spp = null;
    protected final boolean bDebug = true;
    protected int colSinglePrimaryKeyIndex = 0;
    protected int colPairedPrimaryKeyFirstIndex = 0;
    protected int colPairedPrimaryKeySecondIndex = 1;
    protected SQLiteStatement sql4javaSt = null;
    protected PreparedStatement jdbcPrepSt = null;
    protected Statement jdbcSt = null;
    protected ResultSet rs = null;

    protected ABaseClass(AProgramParameters progPar) {
        if (progPar instanceof PDProgramParameters) {
            this.pp = (PDProgramParameters)progPar;
        } else if (progPar instanceof SimpleProgramParameters) {
            this.spp = (SimpleProgramParameters)progPar;
        } else {
            this.logger.error("Add other AProgramParameters here if necessary.");
        }
    }

    public long getID() {
        this.logger.error("Must override getID() of SinglePrimaryKey BaseClass");
        return -1L;
    }

    public long getFirstID() {
        this.logger.error("Must override getFirstID() of PairedPrimaryKey BaseClass");
        return -1L;
    }

    public long getSecondID() {
        this.logger.error("Must override getSecondID() of PairedPrimaryKey BaseClass");
        return -1L;
    }

    public void setVersion(String version) {
        strVersion = version;
    }

    protected final AProgramParameters getPP() {
        if (this.pp != null) {
            return this.pp;
        }
        if (this.spp != null) {
            return this.spp;
        }
        this.logger.error("AProgramParameters not set in {}", (Object)this.getClass().getName());
        return null;
    }

    private void resetColumnStartIndex() {
        this.colIndex = this.getPP().isUsingSQLite4Java() ? 0 : 1;
    }

    protected final void initAndProcessPrepared(long ... ids) {
        String sqlStr = this.sb.toString();
        if (this.getPP().isUsingSQLite4Java()) {
            this.sql4javaSt = this.initPreparedSQLiteStatement(sqlStr, ids);
            if (this.sql4javaSt != null) {
                this.processPreparedSQLiteStatement(this.sql4javaSt, sqlStr);
            }
        } else {
            this.jdbcPrepSt = this.initPreparedJDBCStatement(sqlStr, ids);
            if (this.jdbcPrepSt != null) {
                this.processPreparedJDBCStatement(this.jdbcPrepSt, sqlStr);
            }
        }
    }

    protected final void initAndProcessPreparedIDStr(long id, String str) {
        String sqlStr = this.sb.toString();
        if (this.getPP().isUsingSQLite4Java()) {
            this.sql4javaSt = this.initPreparedSQLiteStatementIDStr(sqlStr, id, str);
            if (this.sql4javaSt != null) {
                this.processPreparedSQLiteStatement(this.sql4javaSt, sqlStr);
            }
        } else {
            this.jdbcPrepSt = this.initPreparedJDBCStatementIDStr(sqlStr, id, str);
            if (this.jdbcPrepSt != null) {
                this.processPreparedJDBCStatement(this.jdbcPrepSt, sqlStr);
            }
        }
    }

    protected final void initAndProcessPrepared(String name, long ... ids) {
        String sqlStr = this.sb.toString();
        if (this.getPP().isUsingSQLite4Java()) {
            this.sql4javaSt = this.initPreparedSQLiteStatement(sqlStr, name, ids);
            if (this.sql4javaSt != null) {
                this.processPreparedSQLiteStatement(this.sql4javaSt, sqlStr);
            }
        } else {
            this.jdbcPrepSt = this.initPreparedJDBCStatement(sqlStr, name, ids);
            if (this.jdbcPrepSt != null) {
                this.processPreparedJDBCStatement(this.jdbcPrepSt, sqlStr);
            }
        }
    }

    protected final String getWarningMessage() {
        StringBuilder strB = new StringBuilder();
        strB.append("No results found for ");
        strB.append(this.getClass().getSimpleName());
        strB.append(": ").append(MyConstants.newline);
        return strB.toString();
    }

    protected final String getErrorMessage() {
        StringBuilder strB = new StringBuilder();
        strB.append("Result set for ");
        strB.append(this.getClass().getSimpleName());
        strB.append(" is null: ");
        return strB.toString();
    }

    protected final Statement initJDBCStatement(String sqlStr) {
        this.resetSqlStr(sqlStr);
        if (!this.getPP().isUsingSQLite4Java()) {
            try {
                Connection conn = this.getJDBCDBConnection();
                if (conn != null) {
                    return conn.createStatement();
                }
                this.logger.error("conn is null in initJDBCStatement(sqlStr)");
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        } else {
            this.logger.error("According to the ProgramParameters JDBC is not used as connector (0).");
            System.exit(-1);
        }
        return null;
    }

    protected final SQLiteStatement initPreparedSQLiteStatement(String sqlStr, long ... ids) {
        block7: {
            this.resetSqlStr(sqlStr);
            if (this.getPP().isUsingSQLite4Java()) {
                try {
                    SQLiteConnection conn = this.getSQLiteDBConnection();
                    if (conn != null) {
                        SQLiteStatement prepStatement = conn.prepare(sqlStr);
                        if (prepStatement != null) {
                            int colCnt = 1;
                            long[] lArray = ids;
                            int n = ids.length;
                            int n2 = 0;
                            while (n2 < n) {
                                long id = lArray[n2];
                                prepStatement.bind(colCnt++, id);
                                ++n2;
                            }
                            return prepStatement;
                        }
                        break block7;
                    }
                    this.logger.error("conn is null in initPreparedStatement (SQLite-1)");
                }
                catch (SQLiteException sqliteex) {
                    this.handleSQLiteException(sqliteex);
                }
            } else {
                this.logger.error("According to the ProgramParameters SQLite4Java is not used as connector (0).");
                System.exit(-1);
            }
        }
        return null;
    }

    protected final SQLiteStatement initPreparedSQLiteStatementIDStr(String sqlStr, long id, String str) {
        block6: {
            this.resetSqlStr(sqlStr);
            if (this.getPP().isUsingSQLite4Java()) {
                try {
                    SQLiteConnection conn = this.getSQLiteDBConnection();
                    if (conn != null) {
                        SQLiteStatement prepStatement = conn.prepare(sqlStr);
                        if (prepStatement != null) {
                            int colCnt = 1;
                            prepStatement.bind(colCnt++, id);
                            prepStatement.bind(colCnt++, str);
                            return prepStatement;
                        }
                        break block6;
                    }
                    this.logger.error("conn is null in initPreparedStatementIDStr");
                }
                catch (SQLiteException sqliteex) {
                    this.handleSQLiteException(sqliteex);
                }
            } else {
                this.logger.error("According to the ProgramParameters SQLite4Java is not used as connector (1).");
                System.exit(-1);
            }
        }
        return null;
    }

    protected final SQLiteStatement initPreparedSQLiteStatement(String sqlStr, String name, long ... ids) {
        block7: {
            this.resetSqlStr(sqlStr);
            if (this.getPP().isUsingSQLite4Java()) {
                try {
                    SQLiteConnection conn = this.getSQLiteDBConnection();
                    if (conn != null) {
                        SQLiteStatement prepStatement = conn.prepare(sqlStr);
                        if (prepStatement != null) {
                            prepStatement.bind(1, name);
                            int colCnt = 2;
                            long[] lArray = ids;
                            int n = ids.length;
                            int n2 = 0;
                            while (n2 < n) {
                                long id = lArray[n2];
                                prepStatement.bind(colCnt++, id);
                                ++n2;
                            }
                            return prepStatement;
                        }
                        break block7;
                    }
                    this.logger.error("conn is null in initPreparedStatement (SQLite-2)");
                }
                catch (SQLiteException sqliteex) {
                    this.handleSQLiteException(sqliteex);
                }
            } else {
                this.logger.error("According to the ProgramParameters SQLite4Java is not used as connector (2).");
                System.exit(-1);
            }
        }
        return null;
    }

    protected final PreparedStatement initPreparedJDBCStatement(String sqlStr, long ... ids) {
        block7: {
            this.resetSqlStr(sqlStr);
            if (this.getPP().isUsingJDBC()) {
                try {
                    Connection conn = this.getJDBCDBConnection();
                    if (conn != null) {
                        PreparedStatement prepStatement = conn.prepareStatement(sqlStr);
                        if (prepStatement != null) {
                            int colCnt = 1;
                            long[] lArray = ids;
                            int n = ids.length;
                            int n2 = 0;
                            while (n2 < n) {
                                long id = lArray[n2];
                                prepStatement.setLong(colCnt++, id);
                                ++n2;
                            }
                            return prepStatement;
                        }
                        break block7;
                    }
                    this.logger.error("conn is null in initPreparedStatement (JDBC-1)");
                }
                catch (SQLException sqlex) {
                    this.handleSQLException(sqlex);
                }
            } else {
                this.logger.error("According to the ProgramParameters JDBC is not used as connector (0).");
                System.exit(-1);
            }
        }
        return null;
    }

    protected final PreparedStatement initPreparedJDBCStatementIDStr(String sqlStr, long id, String str) {
        block6: {
            this.resetSqlStr(sqlStr);
            if (this.getPP().isUsingJDBC()) {
                try {
                    Connection conn = this.getJDBCDBConnection();
                    if (conn != null) {
                        PreparedStatement prepStatement = conn.prepareStatement(sqlStr);
                        if (prepStatement != null) {
                            int colCnt = 1;
                            prepStatement.setLong(colCnt++, id);
                            prepStatement.setString(colCnt++, str);
                            return prepStatement;
                        }
                        break block6;
                    }
                    this.logger.error("conn is null in initPreparedStatementIDStr");
                }
                catch (SQLException sqlex) {
                    this.handleSQLException(sqlex);
                }
            } else {
                this.logger.error("According to the ProgramParameters JDBC is not used as connector (1).");
                System.exit(-1);
            }
        }
        return null;
    }

    protected final PreparedStatement initPreparedJDBCStatement(String sqlStr, String name, long ... ids) {
        block7: {
            this.resetSqlStr(sqlStr);
            if (this.getPP().isUsingJDBC()) {
                try {
                    Connection conn = this.getJDBCDBConnection();
                    if (conn != null) {
                        PreparedStatement prepStatement = conn.prepareStatement(sqlStr);
                        if (prepStatement != null) {
                            prepStatement.setString(1, name);
                            int colCnt = 2;
                            long[] lArray = ids;
                            int n = ids.length;
                            int n2 = 0;
                            while (n2 < n) {
                                long id = lArray[n2];
                                prepStatement.setLong(colCnt++, id);
                                ++n2;
                            }
                            return prepStatement;
                        }
                        break block7;
                    }
                    this.logger.error("conn is null in initPreparedStatement (JDBC-2)");
                }
                catch (SQLException sqlex) {
                    this.handleSQLException(sqlex);
                }
            } else {
                this.logger.error("According to the ProgramParameters JDBC is not used as connector (2).");
                System.exit(-1);
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void processPreparedSQLiteStatement(SQLiteStatement sqliteStatement, String sqlStr) {
        if (sqliteStatement != null) {
            try {
                try {
                    this.bFound = false;
                    while (sqliteStatement.step()) {
                        this.bFound = true;
                        this.setAllMembers();
                        this.resetColumnStartIndex();
                    }
                    if (this.bFound || !this.bWarnOnNotFound) return;
                    this.showWarning(this.getWarningMessage(), sqlStr);
                    return;
                }
                catch (SQLiteException sqliteex) {
                    this.handleSQLiteException(sqliteex);
                    sqliteStatement.dispose();
                }
                return;
            }
            finally {
                sqliteStatement.dispose();
            }
        } else {
            this.showError(this.getErrorMessage(), sqlStr);
            System.exit(-1);
        }
    }

    protected final void processPreparedJDBCStatement(PreparedStatement jdbcPrepStatement, String sqlStr) {
        if (jdbcPrepStatement != null) {
            try {
                this.bFound = false;
                this.rs = jdbcPrepStatement.executeQuery();
                while (this.rs.next()) {
                    this.bFound = true;
                    this.setAllMembers();
                    this.resetColumnStartIndex();
                }
                if (!this.bFound && this.bWarnOnNotFound) {
                    this.showWarning(this.getWarningMessage(), sqlStr);
                }
                jdbcPrepStatement.close();
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        } else {
            this.showError(this.getErrorMessage(), sqlStr);
            System.exit(-1);
        }
    }

    protected final void showError(String msgText, String sqlStr) {
        StringBuilder sBuilder = new StringBuilder(msgText);
        sBuilder.append(MyConstants.newline);
        sBuilder.append(sqlStr);
        this.logger.error(sBuilder.toString());
    }

    protected final void showWarning(String msgText, String sqlStr) {
        StringBuilder sBuilder = new StringBuilder(msgText);
        sBuilder.append(MyConstants.newline);
        sBuilder.append(sqlStr);
        this.logger.error(sBuilder.toString());
    }

    protected final <T> void processSinglePrimaryKeyObjectResultSetJDBC(String className, HashMap<Long, T> map) {
        try {
            while (this.rs.next()) {
                this.bFound = true;
                long id = this.rs.getLong(this.colSinglePrimaryKeyIndex + 1);
                String tmpStr = " for " + this.getClass().getName() + " with ID: " + this.getID();
                this.logger.debug("Filled " + className + " with ID " + id + " into map" + tmpStr);
                this.putSinglePrimaryKeyObjectIntoCorrespondingMap(className, id, map, new long[0]);
            }
        }
        catch (SQLException sqlex) {
            this.handleSQLException(sqlex);
        }
        if (!this.bFound && this.bWarnOnNotFound) {
            this.showWarning(this.getWarningMessage(), this.sb.toString());
        }
    }

    protected final <T> void processPairedPrimaryKeyObjectResultSetJDBC(String className, HashMap<Pair<Long, Long>, T> map, long firstID, long secondID) {
        try {
            while (this.rs.next()) {
                this.bFound = true;
                String tmpStr = " for " + this.getClass().getName() + " with ID's: " + this.getFirstID() + " and " + this.getSecondID();
                this.logger.debug("Filled {} with ID's {} and {} into map", new Object[]{className, firstID, secondID, tmpStr});
                this.putPairedPrimaryKeyObjectIntoCorrespondingMap(className, (Pair<Long, Long>)new Pair((Object)firstID, (Object)secondID), map);
            }
        }
        catch (SQLException sqlex) {
            this.handleSQLException(sqlex);
        }
        if (!this.bFound && this.bWarnOnNotFound) {
            this.showWarning(this.getWarningMessage(), this.sb.toString());
        }
    }

    protected final <T> void putSinglePrimaryKeyObjectIntoCorrespondingMap(String className, long id, HashMap<Long, T> map, long ... pnns) {
        if (!map.containsKey(id)) {
            if (className.equals(AminoAcids.class.getSimpleName())) {
                map.put(id, new AminoAcids(this.getPP(), id));
            } else if (className.equals(AminoAcidModifications.class.getSimpleName())) {
                map.put(id, new AminoAcidModifications(this.getPP(), id));
            } else if (className.equals(AminoAcidModificationsNeutralLosses.class.getSimpleName())) {
                map.put(id, new AminoAcidModificationsNeutralLosses(this.getPP(), id));
            } else if (className.equals(Annotations.class.getSimpleName())) {
                map.put(id, new Annotations(this.getPP(), id));
            } else if (className.equals(AnnotationDataset.class.getSimpleName())) {
                map.put(id, new AnnotationDataset(this.getPP(), id));
            } else if (className.equals(AnnotationDataVersion.class.getSimpleName())) {
                map.put(id, new AnnotationDataVersion(this.getPP(), id));
            } else if (className.equals(AnnotationTypes.class.getSimpleName())) {
                map.put(id, new AnnotationTypes(this.getPP(), id));
            } else if (className.equals(CustomDataFields.class.getSimpleName())) {
                map.put(id, new CustomDataFields(this.getPP(), id));
            } else if (className.equals(Enzymes.class.getSimpleName())) {
                map.put(id, new Enzymes(this.getPP(), id));
            } else if (className.equals(Events.class.getSimpleName())) {
                map.put(id, new Events(this.getPP(), id));
            } else if (className.equals(EventAnnotations.class.getSimpleName())) {
                map.put(id, new EventAnnotations(this.getPP(), id));
            } else if (className.equals(EventAreaAnnotations.class.getSimpleName())) {
                map.put(id, new EventAreaAnnotations(this.getPP(), id));
            } else if (className.equals(FastaFiles.class.getSimpleName())) {
                map.put(id, new FastaFiles(this.getPP(), id));
            } else if (className.equals(FileInfos.class.getSimpleName())) {
                map.put(id, new FileInfos(this.getPP(), id));
            } else if (className.equals(MassPeaks.class.getSimpleName())) {
                map.put(id, new MassPeaks(this.getPP(), id));
            } else if (className.equals(Peptides.class.getSimpleName())) {
                assert (pnns.length == 1);
                map.put(id, new Peptides(this.getPP(), pnns[0], id, strVersion));
            } else if (className.equals(Peptides_decoy.class.getSimpleName())) {
                assert (pnns.length == 1);
                map.put(id, new Peptides_decoy(this.getPP(), pnns[0], id, strVersion));
            } else if (className.equals(ProcessingNodeExtensions.class.getSimpleName())) {
                map.put(id, new ProcessingNodeExtensions(this.getPP(), id));
            } else if (className.equals(ProcessingNodes.class.getSimpleName())) {
                map.put(id, new ProcessingNodes(this.getPP(), id));
            } else if (className.equals(ProcessingNodeScores.class.getSimpleName())) {
                map.put(id, new ProcessingNodeScores(this.getPP(), id));
            } else if (className.equals(ProteinAnnotations.class.getSimpleName())) {
                map.put(id, new ProteinAnnotations(this.getPP(), id));
            } else if (className.equals(Proteins.class.getSimpleName())) {
                map.put(id, new Proteins(this.getPP(), id, strVersion));
            } else if (className.equals(ScanEvents.class.getSimpleName())) {
                map.put(id, new ScanEvents(this.getPP(), id));
            } else if (className.equals(SchemaInfo.class.getSimpleName())) {
                map.put(id, new SchemaInfo(this.getPP(), id));
            } else if (className.equals(Spectra.class.getSimpleName())) {
                map.put(id, new Spectra(this.getPP(), id));
            } else if (className.equals(SpectrumHeaders.class.getSimpleName())) {
                map.put(id, new SpectrumHeaders(this.getPP(), id));
            } else if (className.equals(TaxonomyNodes.class.getSimpleName())) {
                map.put(id, new TaxonomyNodes(this.getPP(), id));
            } else if (className.equals(WorkflowMessages.class.getSimpleName())) {
                map.put(id, new WorkflowMessages(this.getPP(), id));
            } else {
                this.logger.error(String.valueOf(className) + " not yet handled in method putSinglePrimaryKeyObjectIntoCorrespondingMap() of ABaseClass");
            }
        }
    }

    protected final <T> void putPairedPrimaryKeyObjectIntoCorrespondingMap(String className, Pair<Long, Long> idPair, HashMap<Pair<Long, Long>, T> map) {
        if (!map.containsKey(idPair)) {
            if (className.equals(AminoAcidModificationsAminoAcids.class.getSimpleName())) {
                map.put(idPair, new AminoAcidModificationsAminoAcids(this.getPP(), (Long)idPair.getKey(), (Long)idPair.getValue()));
            } else if (className.equals(AnnotationGroups.class.getSimpleName())) {
                map.put(idPair, new AnnotationGroups(this.getPP(), (Long)idPair.getKey(), (Long)idPair.getValue()));
            } else if (className.equals(AnnotationsAnnotationGroups.class.getSimpleName())) {
                map.put(idPair, new AnnotationsAnnotationGroups(this.getPP(), (Long)idPair.getKey(), (Long)idPair.getValue()));
            } else if (className.equals(Chromatograms.class.getSimpleName())) {
                map.put(idPair, new Chromatograms(this.getPP(), (Long)idPair.getKey(), Chromatograms.TraceType.valueOf(String.valueOf(idPair.getValue()))));
            } else if (className.equals(CustomDataPeptides.class.getSimpleName())) {
                map.put(idPair, new CustomDataPeptides(this.getPP(), (Long)idPair.getKey(), (Long)idPair.getValue()));
            } else if (className.equals(CustomDataPeptides_decoy.class.getSimpleName())) {
                map.put(idPair, new CustomDataPeptides_decoy(this.getPP(), (Long)idPair.getKey(), (Long)idPair.getValue()));
            } else if (className.equals(CustomDataProcessingNodes.class.getSimpleName())) {
                map.put(idPair, new CustomDataProcessingNodes(this.getPP(), (Long)idPair.getKey(), (Long)idPair.getValue()));
            } else if (className.equals(CustomDataProteins.class.getSimpleName())) {
                map.put(idPair, new CustomDataProteins(this.getPP(), (Long)idPair.getKey(), (Long)idPair.getValue()));
            } else if (className.equals(CustomDataProteins_decoy.class.getSimpleName())) {
                map.put(idPair, new CustomDataProteins_decoy(this.getPP(), (Long)idPair.getKey(), (Long)idPair.getValue()));
            } else if (className.equals(CustomDataSpectra.class.getSimpleName())) {
                map.put(idPair, new CustomDataSpectra(this.getPP(), (Long)idPair.getKey(), (Long)idPair.getValue()));
            } else if (className.equals(EnzymesCleavageSpecificities.class.getSimpleName())) {
                map.put(idPair, new EnzymesCleavageSpecificities(this.getPP(), (Long)idPair.getKey(), (Long)idPair.getValue()));
            } else if (className.equals(FastaFilesProteinAnnotations.class.getSimpleName())) {
                map.put(idPair, new FastaFilesProteinAnnotations(this.getPP(), (Long)idPair.getKey(), (Long)idPair.getValue()));
            } else if (className.equals(MassPeakRelations.class.getSimpleName())) {
                map.put(idPair, new MassPeakRelations(this.getPP(), (Long)idPair.getKey(), (Long)idPair.getValue()));
            } else if (className.equals(Peptides.class.getSimpleName())) {
                map.put(idPair, new Peptides(this.getPP(), (Long)idPair.getKey(), (Long)idPair.getValue(), strVersion));
            } else if (className.equals(Peptides_decoy.class.getSimpleName())) {
                map.put(idPair, new Peptides_decoy(this.getPP(), (Long)idPair.getKey(), (Long)idPair.getValue(), strVersion));
            } else if (className.equals(MassPeakRelations.class.getSimpleName())) {
                map.put(idPair, new MassPeakRelations(this.getPP(), (Long)idPair.getKey(), (Long)idPair.getValue()));
            } else if (className.equals(ProcessingNodesSpectra.class.getSimpleName())) {
                map.put(idPair, new ProcessingNodesSpectra(this.getPP(), (Long)idPair.getKey(), (Long)idPair.getValue()));
            } else if (className.equals(ProteinIdentificationGroups.class.getSimpleName())) {
                map.put(idPair, new ProteinIdentificationGroups(this.getPP(), (Long)idPair.getKey(), (Long)idPair.getValue()));
            } else if (className.equals(ProteinScores.class.getSimpleName())) {
                map.put(idPair, new ProteinScores(this.getPP(), (Long)idPair.getKey(), (Long)idPair.getValue()));
            } else if (className.equals(ProteinScores_decoy.class.getSimpleName())) {
                map.put(idPair, new ProteinScores_decoy(this.getPP(), (Long)idPair.getKey(), (Long)idPair.getValue()));
            } else if (className.equals(SpectrumScores.class.getSimpleName())) {
                map.put(idPair, new SpectrumScores(this.getPP(), (Long)idPair.getKey(), (Long)idPair.getValue()));
            } else {
                this.logger.error(String.valueOf(className) + " not yet handled in method putPairedPrimaryKeyObjectIntoCorrespondingMap() of ABaseClass");
            }
        }
    }

    protected final <T> void putTripledPrimaryKeyObjectIntoCorrespondingMap(String className, Triple<Long, Long, Long> idTriple, HashMap<Triple<Long, Long, Long>, T> map) {
        if (!map.containsKey(idTriple)) {
            if (className.equals(AminoAcidModificationsAminoAcidsNL.class.getSimpleName())) {
                map.put(idTriple, new AminoAcidModificationsAminoAcidsNL(this.getPP(), (Long)idTriple.getFirst(), (Long)idTriple.getSecond(), (Long)idTriple.getThird()));
            } else if (className.equals(PeptideScores.class.getSimpleName())) {
                map.put(idTriple, new PeptideScores(this.getPP(), (Long)idTriple.getFirst(), (Long)idTriple.getSecond(), (Long)idTriple.getThird(), strVersion));
            } else if (className.equals(PeptideScores_decoy.class.getSimpleName())) {
                map.put(idTriple, new PeptideScores_decoy(this.getPP(), (Long)idTriple.getFirst(), (Long)idTriple.getSecond(), (Long)idTriple.getThird(), strVersion));
            } else if (className.equals(PeptidesProteins.class.getSimpleName())) {
                map.put(idTriple, new PeptidesProteins(this.getPP(), (Long)idTriple.getFirst(), (Long)idTriple.getSecond(), (Long)idTriple.getThird()));
            } else if (className.equals(PeptidesProteins_decoy.class.getSimpleName())) {
                map.put(idTriple, new PeptidesProteins_decoy(this.getPP(), (Long)idTriple.getFirst(), (Long)idTriple.getSecond(), (Long)idTriple.getThird()));
            } else if (className.equals(PeptidesTerminalModifications.class.getSimpleName())) {
                map.put(idTriple, new PeptidesTerminalModifications(this.getPP(), (Long)idTriple.getFirst(), (Long)idTriple.getSecond(), (Long)idTriple.getThird()));
            } else if (className.equals(PeptidesTerminalModifications_decoy.class.getSimpleName())) {
                map.put(idTriple, new PeptidesTerminalModifications_decoy(this.getPP(), (Long)idTriple.getFirst(), (Long)idTriple.getSecond(), (Long)idTriple.getThird()));
            } else if (className.equals(PtmAnnotationData.class.getSimpleName())) {
                map.put(idTriple, new PtmAnnotationData(this.getPP(), (Long)idTriple.getFirst(), (Long)idTriple.getSecond(), (Long)idTriple.getThird()));
            } else if (className.equals(ReporterIonQuanResults.class.getSimpleName())) {
                map.put(idTriple, new ReporterIonQuanResults(this.getPP(), (Long)idTriple.getFirst(), (Long)idTriple.getSecond(), (Long)idTriple.getThird()));
            } else {
                this.logger.error(String.valueOf(className) + " not yet handled in method putTripledPrimaryKeyObjectIntoCorrespondingMap() of ABaseClass");
            }
        }
    }

    protected final <T> void putQuadrupledPrimaryKeyObjectIntoCorrespondingMap(String className, Quadruple<Long, Long, Long, Long> idQuadruple, HashMap<Quadruple<Long, Long, Long, Long>, T> map) {
        if (!map.containsKey(idQuadruple)) {
            if (className.equals(PeptidesAminoAcidModifications.class.getSimpleName())) {
                map.put(idQuadruple, new PeptidesAminoAcidModifications(this.getPP(), (Long)idQuadruple.getFirst(), (Long)idQuadruple.getSecond(), (Long)idQuadruple.getThird(), (Long)idQuadruple.getFourth(), strVersion));
            } else if (className.equals(PeptidesAminoAcidModifications_decoy.class.getSimpleName())) {
                map.put(idQuadruple, new PeptidesAminoAcidModifications_decoy(this.getPP(), (Long)idQuadruple.getFirst(), (Long)idQuadruple.getSecond(), (Long)idQuadruple.getThird(), (Long)idQuadruple.getFourth(), strVersion));
            } else {
                this.logger.error(String.valueOf(className) + " not yet handled in method putQuadrupledPrimaryKeyObjectIntoCorrespondingMap() of ABaseClass");
            }
        }
    }

    protected final <T> void putQuintupledPrimaryKeyObjectIntoCorrespondingMap(String className, Quintuple<Long, Long, Long, Long, Long> idQuintuple, HashMap<Quintuple<Long, Long, Long, Long, Long>, T> map) {
        if (!map.containsKey(idQuintuple)) {
            if (className.equals(AnnotationsProtein.class.getSimpleName())) {
                map.put(idQuintuple, new AnnotationsProtein(this.getPP(), (Long)idQuintuple.getFirst(), (Long)idQuintuple.getSecond(), (Long)idQuintuple.getThird(), (Long)idQuintuple.getFourth(), String.valueOf(idQuintuple.getFifth())));
            } else {
                this.logger.error(String.valueOf(className) + " not yet handled in method putQuintupledPrimaryKeyObjectIntoCorrespondingMap() of ABaseClass");
            }
        }
    }

    protected final <T> void putHexupledPrimaryKeyObjectIntoCorrespondingMap(String className, Hexuple<Long, Long, Long, Long, Long, Long> idHexuple, HashMap<Hexuple<Long, Long, Long, Long, Long, Long>, T> map) {
        map.containsKey(idHexuple);
    }

    private void resetSqlStr(String sqlStr) {
        this.bFound = false;
        this.sb.setLength(0);
        this.sb.append(sqlStr);
    }

    protected final void handleSQLiteException(SQLiteException sqliteex) {
        this.logger.error(String.valueOf("SQL Message: ") + sqliteex.getLocalizedMessage());
        sqliteex.printStackTrace(System.err);
    }

    protected final void handleSQLException(SQLException sqlex) {
        this.logger.error(String.valueOf("SQL Message: ") + sqlex.getLocalizedMessage());
        sqlex.printStackTrace(System.err);
    }

    protected void setAllMembers() {
        this.logger.error("Must override setAllMembers() of BaseClass");
    }

    private SQLiteConnection getSQLiteDBConnection() {
        return this.getPP().getSQLiteAccess().dbConn;
    }

    private Connection getJDBCDBConnection() {
        return this.getPP().getJDBCAccess().dbConn;
    }

    protected final String getFromLine() {
        StringBuilder strB = new StringBuilder("from ");
        strB.append(this.getClass().getSimpleName()).append(MyConstants.newline);
        return strB.toString();
    }

    private static String selectCountFromStr(String tableName) {
        StringBuilder strB = new StringBuilder();
        strB.append("SELECT COUNT(*)").append(MyConstants.newline);
        strB.append("FROM ").append(tableName);
        return strB.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long getCount(SimpleProgramParameters spp, Class klasse) {
        long nrOfEntries = 0L;
        String tableName = klasse.getSimpleName();
        String sqlStr = ABaseClass.selectCountFromStr(tableName);
        if (spp.isUsingSQLite4Java()) {
            SQLiteConnection conn = spp.getSQLiteAccess().dbConn;
            try {
                SQLiteStatement st;
                if (conn == null || (st = conn.prepare(sqlStr)) == null) return nrOfEntries;
                while (st.step()) {
                    nrOfEntries = st.columnLong(0);
                }
                return nrOfEntries;
            }
            catch (SQLiteException sqliteex) {
                sqliteex.printStackTrace(System.err);
                return -1L;
            }
        }
        Connection conn = spp.getJDBCAccess().dbConn;
        if (conn == null) return nrOfEntries;
        try {
            Statement st = conn.createStatement();
            if (st == null || !st.execute(sqlStr)) return nrOfEntries;
            ResultSet rs = st.getResultSet();
            while (rs.next()) {
                nrOfEntries = rs.getLong(1);
            }
            return nrOfEntries;
        }
        catch (SQLException sqlex) {
            sqlex.printStackTrace(System.err);
            return -1L;
        }
    }

    private static String selectSternFromStr(String tableName) {
        StringBuilder strB = new StringBuilder();
        strB.append("SELECT *").append(MyConstants.newline);
        strB.append("FROM ").append(tableName);
        return strB.toString();
    }

    private static <T> String selectSternFromStr(String tableName, Class klasse, T id) {
        StringBuilder strB = new StringBuilder();
        strB.append("SELECT *").append(MyConstants.newline);
        strB.append("FROM ").append(tableName).append(MyConstants.newline);
        strB.append("WHERE ");
        if (PDBaseClassSinglePrimaryKey.isSinglePrimaryKeyClass(klasse)) {
            if (tableName.equals(AminoAcidModifications.class.getSimpleName())) {
                strB.append("AminoAcidModificationID = ").append((Long)id);
            } else if (tableName.equals(AminoAcidModificationsNeutralLosses.class.getSimpleName())) {
                strB.append("NeutralLossID = ").append((Long)id);
            } else if (tableName.equals(AminoAcids.class.getSimpleName())) {
                strB.append("AminoAcidID = ").append((Long)id);
            } else if (tableName.equals(AnnotationDataVersion.class.getSimpleName())) {
                strB.append("PcDataVersion = ").append((Long)id);
            } else if (tableName.equals(AnnotationDataset.class.getSimpleName())) {
                strB.append("DatasetId = ").append((Long)id);
            } else if (tableName.equals(AnnotationTypes.class.getSimpleName())) {
                strB.append("AnnotationTypeId = ").append((Long)id);
            } else if (tableName.equals(Annotations.class.getSimpleName())) {
                strB.append("AnnotationId = ").append((Long)id);
            } else if (tableName.equals(CustomDataFields.class.getSimpleName())) {
                strB.append("FieldID = ").append((Long)id);
            } else if (tableName.equals(Enzymes.class.getSimpleName())) {
                strB.append("EnzymeID = ").append((Long)id);
            } else if (tableName.equals(EventAnnotations.class.getSimpleName())) {
                strB.append("EventID = ").append((Long)id);
            } else if (tableName.equals(EventAreaAnnotations.class.getSimpleName())) {
                strB.append("EventID = ").append((Long)id);
            } else if (tableName.equals(Events.class.getSimpleName())) {
                strB.append("EventID = ").append((Long)id);
            } else if (tableName.equals(FastaFiles.class.getSimpleName())) {
                strB.append("FastaFileID = ").append((Long)id);
            } else if (tableName.equals(FileInfos.class.getSimpleName())) {
                strB.append("FileID = ").append((Long)id);
            } else if (tableName.equals(IdentifiedMassPeaks2.class.getSimpleName())) {
                strB.append("SpectrumID = ").append((Long)id);
            } else if (tableName.equals(MassPeaks.class.getSimpleName())) {
                strB.append("MassPeakID = ").append((Long)id);
            } else if (tableName.equals(PeptidesReferenceSpectra.class.getSimpleName())) {
                strB.append("PeptideID = ").append((Long)id);
            } else if (tableName.equals(PrecursorIonAreaSearchSpectra.class.getSimpleName())) {
                strB.append("QuanResultID = ").append((Long)id);
            } else if (tableName.equals(ProcessingNodeExtensions.class.getSimpleName())) {
                strB.append("ExtensionID = ").append((Long)id);
            } else if (tableName.equals(ProcessingNodes.class.getSimpleName())) {
                strB.append("ProcessingNodeNumber = ").append((Long)id);
            } else if (tableName.equals(ProcessingNodeScores.class.getSimpleName())) {
                strB.append("ScoreID = ").append((Long)id);
            } else if (tableName.equals(ProteinAnnotations.class.getSimpleName())) {
                strB.append("ProteinAnnotationID = ").append((Long)id);
            } else if (tableName.equals(Proteins.class.getSimpleName())) {
                strB.append("ProteinID = ").append((Long)id);
            } else if (tableName.equals(ReferenceSpectra.class.getSimpleName())) {
                strB.append("ReferenceSpectrumId = ").append((Long)id);
            } else if (tableName.equals(Spectra.class.getSimpleName())) {
                strB.append("UniqueSpectrumID = ").append((Long)id);
            } else if (tableName.equals(ScanEvents.class.getSimpleName())) {
                strB.append("ScanEventID = ").append((Long)id);
            } else if (tableName.equals(SchemaInfo.class.getSimpleName())) {
                strB.append("Version = ").append((Long)id);
            } else if (tableName.equals(SpectrumHeaders.class.getSimpleName())) {
                strB.append("SpectrumID = ").append((Long)id);
            } else if (tableName.equals(TaxonomyNodes.class.getSimpleName())) {
                strB.append("TaxonomyID = ").append((Long)id);
            } else if (tableName.equals(WorkflowMessages.class.getSimpleName())) {
                strB.append("MessageID = ").append((Long)id);
            }
        } else if (PDBaseClassPairedPrimaryKey.isPairedPrimaryKeyClass(klasse)) {
            Pair idPair = (Pair)id;
            if (tableName.equals(AminoAcidModificationsAminoAcids.class.getSimpleName())) {
                strB.append("AminoAcidModificationID = ").append(idPair.getKey()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("AminoAcidID = ").append(idPair.getValue());
            } else if (tableName.equals(AnnotationsAnnotationGroups.class.getSimpleName())) {
                strB.append("AnnotationId = ").append(idPair.getKey()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("AnnotationGroupId = ").append(idPair.getValue());
            } else if (tableName.equals(Chromatograms.class.getSimpleName())) {
                strB.append("FileID = ").append(idPair.getKey()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("TraceType = ").append(idPair.getValue());
            } else if (tableName.equals(CustomDataPeptides.class.getSimpleName())) {
                strB.append("FieldID = ").append(idPair.getKey()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("PeptideID = ").append(idPair.getValue());
            } else if (tableName.equals(CustomDataPeptides_decoy.class.getSimpleName())) {
                strB.append("FieldID = ").append(idPair.getKey()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("PeptideID = ").append(idPair.getValue());
            } else if (tableName.equals(CustomDataProcessingNodes.class.getSimpleName())) {
                strB.append("FieldID = ").append(idPair.getKey()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("ProcessingNodeNumber = ").append(idPair.getValue());
            } else if (tableName.equals(CustomDataProteins.class.getSimpleName())) {
                strB.append("FieldID = ").append(idPair.getKey()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("ProteinID = ").append(idPair.getValue());
            } else if (tableName.equals(CustomDataProteins_decoy.class.getSimpleName())) {
                strB.append("FieldID = ").append(idPair.getKey()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("ProteinID = ").append(idPair.getValue());
            } else if (tableName.equals(CustomDataSpectra.class.getSimpleName())) {
                strB.append("FieldID = ").append(idPair.getKey()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("SpectrumID = ").append(idPair.getValue());
            } else if (tableName.equals(EnzymesCleavageSpecificities.class.getSimpleName())) {
                strB.append("EnzymeID = ").append(idPair.getKey()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("Specificity = ").append(idPair.getValue());
            } else if (tableName.equals(FalseDiscoveryRates.class.getSimpleName())) {
                strB.append("ProcessingNodeNumber = ").append(idPair.getKey()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("ConfidenceLevel = ").append(idPair.getValue());
            } else if (tableName.equals(FastaFilesProteinAnnotations.class.getSimpleName())) {
                strB.append("FastaFileID = ").append(idPair.getKey()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("ProteinAnnotationID = ").append(idPair.getValue());
            } else if (tableName.equals(IdentifiedPeptides2.class.getSimpleName())) {
                strB.append("PeptideID = ").append(idPair.getKey()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("SpectrumID = ").append(idPair.getValue());
            } else if (tableName.equals(MassPeakRelations.class.getSimpleName())) {
                strB.append("MassPeakID = ").append(idPair.getKey()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("RelatedMassPeakID = ").append(idPair.getValue());
            } else if (tableName.equals(Peptides.class.getSimpleName())) {
                strB.append("ProcessingNodeNumber = ").append(idPair.getKey()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("PeptideID = ").append(idPair.getValue());
            } else if (tableName.equals(Peptides_decoy.class.getSimpleName())) {
                strB.append("ProcessingNodeNumber = ").append(idPair.getKey()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("PeptideID = ").append(idPair.getValue());
            } else if (tableName.equals(PrecursorIonQuanResults.class.getSimpleName())) {
                strB.append("QuanChannelID = ").append(idPair.getKey()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("QuanResultID = ").append(idPair.getValue());
            } else if (tableName.equals(PrecursorIonQuanResultsSearchSpectra.class.getSimpleName())) {
                strB.append("QuanResultID = ").append(idPair.getKey()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("SearchSpectrumID = ").append(idPair.getValue());
            } else if (tableName.equals(ProcessingNodesSpectra.class.getSimpleName())) {
                strB.append("SendingProcessingNodeNumber = ").append(idPair.getKey()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("SpectrumID = ").append(idPair.getValue());
            } else if (tableName.equals(ProteinIdentificationGroups.class.getSimpleName())) {
                strB.append("ProteinIdentificationGroupID = ").append(idPair.getKey()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("ProcessingNodeNumber = ").append(idPair.getValue());
            } else if (tableName.equals(ProteinsProteinGroups.class.getSimpleName())) {
                strB.append("ProteinID = ").append(idPair.getKey()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("ProteinGroupID = ").append(idPair.getValue());
            } else if (tableName.equals(ProteinScores.class.getSimpleName())) {
                strB.append("ProcessingNodeNumber = ").append(idPair.getKey()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("ProteinID = ").append(idPair.getValue());
            } else if (tableName.equals(ProteinScores_decoy.class.getSimpleName())) {
                strB.append("ProcessingNodeNumber = ").append(idPair.getKey()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("ProteinID = ").append(idPair.getValue());
            } else if (tableName.equals(QuanResults.class.getSimpleName())) {
                strB.append("QuanResultID = ").append(idPair.getKey()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("SpectrumID = ").append(idPair.getValue());
            } else if (tableName.equals(ReporterIonQuanResultsSearchSpectra.class.getSimpleName())) {
                strB.append("QuanChannelID = ").append(idPair.getKey()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("SpectrumID = ").append(idPair.getValue());
            } else if (tableName.equals(SpectrumScores.class.getSimpleName())) {
                strB.append("SpectrumID = ").append(idPair.getKey()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("ProcessingNodeNumber = ").append(idPair.getValue());
            }
        } else if (PDBaseClassPairedPrimaryKey.isPairedPrimaryKeyStrClass(klasse)) {
            Pair idPair = (Pair)id;
            if (tableName.equals(ProcessingNodeFilterParameters.class.getSimpleName())) {
                strB.append("ProcessingNodeNumber = ").append(idPair.getKey()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("FilterParameterName = '").append((String)idPair.getValue()).append(MyConstants.STR_HOCHKOMMA);
            } else if (tableName.equals(ProcessingNodeParameters.class.getSimpleName())) {
                strB.append("ProcessingNodeNumber = ").append(idPair.getKey()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("ParameterName = '").append((String)idPair.getValue()).append(MyConstants.STR_HOCHKOMMA);
            }
        } else if (PDBaseClassTripledPrimaryKey.isTripledPrimaryKeyClass(klasse)) {
            Triple idTriple = (Triple)id;
            if (tableName.equals(AminoAcidModificationsAminoAcidsNL.class.getSimpleName())) {
                strB.append("AminoAcidModificationID = ").append(idTriple.getFirst()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("AminoAcidID = ").append(idTriple.getSecond()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("NeutralLossID = ").append(idTriple.getThird());
            } else if (tableName.equals(PeptidesProteins.class.getSimpleName())) {
                strB.append("ProcessingNodeNumber = ").append(idTriple.getFirst()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("PeptideID = ").append(idTriple.getSecond()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("ProteinID = ").append(idTriple.getThird());
            } else if (tableName.equals(PeptidesProteins_decoy.class.getSimpleName())) {
                strB.append("ProcessingNodeNumber = ").append(idTriple.getFirst()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("PeptideID = ").append(idTriple.getSecond()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("ProteinID = ").append(idTriple.getThird());
            } else if (tableName.equals(PeptideScores.class.getSimpleName())) {
                strB.append("ProcessingNodeNumber = ").append(idTriple.getFirst()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("PeptideID = ").append(idTriple.getSecond()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("ScoreID = ").append(idTriple.getThird());
            } else if (tableName.equals(PeptideScores_decoy.class.getSimpleName())) {
                strB.append("ProcessingNodeNumber = ").append(idTriple.getFirst()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("PeptideID = ").append(idTriple.getSecond()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("ScoreID = ").append(idTriple.getThird());
            } else if (tableName.equals(PeptidesTerminalModifications.class.getSimpleName())) {
                strB.append("ProcessingNodeNumber = ").append(idTriple.getFirst()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("PeptideID = ").append(idTriple.getSecond()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("TerminalModificationID = ").append(idTriple.getThird());
            } else if (tableName.equals(PeptidesTerminalModifications_decoy.class.getSimpleName())) {
                strB.append("ProcessingNodeNumber = ").append(idTriple.getFirst()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("PeptideID = ").append(idTriple.getSecond()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("TerminalModificationID = ").append(idTriple.getThird());
            } else if (tableName.equals(PtmAnnotationData.class.getSimpleName())) {
                strB.append("ProteinId = ").append(idTriple.getFirst()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("PtmUnimodId = ").append(idTriple.getSecond()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("Position = ").append(idTriple.getThird());
            } else if (tableName.equals(ReporterIonQuanResults.class.getSimpleName())) {
                strB.append("ProcessingNodeNumber = ").append(idTriple.getFirst()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("QuanChannelID = ").append(idTriple.getSecond()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("SpectrumID = ").append(idTriple.getThird());
            }
        } else if (PDBaseClassQuadrupledPrimaryKey.isQuadrupledPrimaryKeyClass(klasse)) {
            Quadruple idQuad = (Quadruple)id;
            if (tableName.equals(PeptidesAminoAcidModifications.class.getSimpleName())) {
                strB.append("ProcessingNodeNumber = ").append(idQuad.getFirst()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("PeptideID = ").append(idQuad.getSecond()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("AminoAcidModificationID = ").append(idQuad.getThird()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("Position = ").append(idQuad.getFourth());
            } else if (tableName.equals(PeptidesProteins.class.getSimpleName())) {
                strB.append("ProcessingNodeNumber = ").append(idQuad.getFirst()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("PeptideID = ").append(idQuad.getSecond()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("AminoAcidModificationID = ").append(idQuad.getThird()).append(MyConstants.newline);
                strB.append(STR_AND_BLANK).append("Position = ").append(idQuad.getFourth());
            }
        }
        return strB.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> ArrayList<T> getObjectIDList(AProgramParameters spp, Class klasse) {
        ArrayList keyList = new ArrayList();
        String tableName = klasse.getSimpleName();
        String sqlStr = ABaseClass.selectSternFromStr(tableName);
        if (spp.isUsingSQLite4Java()) {
            SQLiteConnection conn = spp.getSQLiteAccess().dbConn;
            try {
                SQLiteStatement st;
                if (conn == null || (st = conn.prepare(sqlStr)) == null) return keyList;
                while (st.step()) {
                    if (PDBaseClassSinglePrimaryKey.isSinglePrimaryKeyClass(klasse)) {
                        if (tableName.equals("ProcessingNodeScores")) {
                            ABaseClass.addSinglePrimaryKeyObjectIDToList(st.columnLong(1), tableName, keyList);
                            continue;
                        }
                        ABaseClass.addSinglePrimaryKeyObjectIDToList(st.columnLong(0), tableName, keyList);
                        continue;
                    }
                    if (PDBaseClassPairedPrimaryKey.isPairedPrimaryKeyClass(klasse)) {
                        ABaseClass.addPairedPrimaryKeyObjectIDToList((Pair<Long, Long>)new Pair((Object)st.columnLong(0), (Object)st.columnLong(1)), tableName, keyList);
                        continue;
                    }
                    if (PDBaseClassPairedPrimaryKey.isPairedPrimaryKeyStrClass(klasse)) {
                        ABaseClass.addPairedPrimaryKeyObjectStrIDToList((Pair<Long, String>)new Pair((Object)st.columnLong(0), (Object)st.columnString(1)), tableName, keyList);
                        continue;
                    }
                    if (PDBaseClassTripledPrimaryKey.isTripledPrimaryKeyClass(klasse)) {
                        ABaseClass.addTripledPrimaryKeyObjectIDToList((Triple<Long, Long, Long>)new Triple((Object)st.columnLong(0), (Object)st.columnLong(1), (Object)st.columnLong(2)), tableName, keyList);
                        continue;
                    }
                    if (!PDBaseClassQuadrupledPrimaryKey.isQuadrupledPrimaryKeyClass(klasse)) continue;
                    ABaseClass.addQuadrupledPrimaryKeyObjectIDToList((Quadruple<Long, Long, Long, Long>)new Quadruple((Object)st.columnLong(0), (Object)st.columnLong(1), (Object)st.columnLong(2), (Object)st.columnLong(3)), tableName, keyList);
                }
                return keyList;
            }
            catch (SQLiteException sqliteex) {
                sqliteex.printStackTrace(System.err);
                return null;
            }
        }
        Connection conn = spp.getJDBCAccess().dbConn;
        if (conn == null) return keyList;
        try {
            Statement st = conn.createStatement();
            if (st == null || !st.execute(sqlStr)) return keyList;
            ResultSet rs = st.getResultSet();
            while (rs.next()) {
                if (PDBaseClassSinglePrimaryKey.isSinglePrimaryKeyClass(klasse)) {
                    ABaseClass.addJDBCSinglePrimaryKeyIDToList(rs, tableName, keyList);
                    continue;
                }
                if (PDBaseClassPairedPrimaryKey.isPairedPrimaryKeyClass(klasse)) {
                    ABaseClass.addJDBCPairedPrimaryKeyIDToList(rs, tableName, keyList);
                    continue;
                }
                if (PDBaseClassPairedPrimaryKey.isPairedPrimaryKeyStrClass(klasse)) {
                    ABaseClass.addJDBCPairedPrimaryKeyStrIDToList(rs, tableName, keyList);
                    continue;
                }
                if (PDBaseClassTripledPrimaryKey.isTripledPrimaryKeyClass(klasse)) {
                    ABaseClass.addJDBCTripledPrimaryKeyIDToList(rs, tableName, keyList);
                    continue;
                }
                if (!PDBaseClassQuadrupledPrimaryKey.isQuadrupledPrimaryKeyClass(klasse)) continue;
                ABaseClass.addJDBCQuadrupledPrimaryKeyIDToList(rs, tableName, keyList);
            }
            return keyList;
        }
        catch (SQLException sqlex) {
            sqlex.printStackTrace(System.err);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T1, T2> T1 getObject(SimpleProgramParameters spp, Class klasse, T2 id) {
        T1 obj = null;
        String tableName = klasse.getSimpleName();
        String sqlStr = ABaseClass.selectSternFromStr(tableName);
        if (spp.isUsingSQLite4Java()) {
            SQLiteConnection conn = spp.getSQLiteAccess().dbConn;
            try {
                SQLiteStatement st;
                if (conn == null || (st = conn.prepare(sqlStr)) == null) return obj;
                while (st.step()) {
                    if (PDBaseClassSinglePrimaryKey.isSinglePrimaryKeyClass(klasse)) {
                        if (!(tableName.equals(ProcessingNodeScores.class.getSimpleName()) ? st.columnLong(1) == ((Long)id).longValue() : st.columnLong(0) == ((Long)id).longValue())) continue;
                        return ABaseClass.getCreatedSinglePrimaryKeyObject(spp, klasse, id);
                    }
                    if (PDBaseClassPairedPrimaryKey.isPairedPrimaryKeyClass(klasse)) {
                        if (st.columnLong(0) != ((Long)((Pair)id).getKey()).longValue() || st.columnLong(1) != ((Long)((Pair)id).getValue()).longValue()) continue;
                        return ABaseClass.getCreatedPairedPrimaryKeyObject(spp, klasse, id);
                    }
                    if (PDBaseClassPairedPrimaryKey.isPairedPrimaryKeyStrClass(klasse)) {
                        if (st.columnLong(0) != ((Long)((Pair)id).getKey()).longValue() || !st.columnString(1).equals(((Pair)id).getValue())) continue;
                        return ABaseClass.getCreatedPairedPrimaryKeyStrObject(spp, klasse, id);
                    }
                    if (PDBaseClassTripledPrimaryKey.isTripledPrimaryKeyClass(klasse)) {
                        if (st.columnLong(0) != ((Long)((Triple)id).getFirst()).longValue() || st.columnLong(1) != ((Long)((Triple)id).getSecond()).longValue() || st.columnLong(2) != ((Long)((Triple)id).getThird()).longValue()) continue;
                        return ABaseClass.getCreatedTripledPrimaryKeyObject(spp, klasse, id);
                    }
                    if (!PDBaseClassQuadrupledPrimaryKey.isQuadrupledPrimaryKeyClass(klasse) || st.columnLong(0) != ((Long)((Quadruple)id).getFirst()).longValue() || st.columnLong(1) != ((Long)((Quadruple)id).getSecond()).longValue() || st.columnLong(2) != ((Long)((Quadruple)id).getThird()).longValue() || st.columnLong(3) != ((Long)((Quadruple)id).getFourth()).longValue()) continue;
                    return ABaseClass.getCreatedQuadrupledPrimaryKeyObject(spp, klasse, id);
                }
                return obj;
            }
            catch (SQLiteException sqliteex) {
                sqliteex.printStackTrace(System.err);
                return null;
            }
        }
        Connection conn = spp.getJDBCAccess().dbConn;
        if (conn == null) return obj;
        try {
            Statement st = conn.createStatement();
            if (st == null || !st.execute(sqlStr)) return obj;
            ResultSet rs = st.getResultSet();
            while (rs.next()) {
                if (PDBaseClassSinglePrimaryKey.isSinglePrimaryKeyClass(klasse)) {
                    if (tableName.equals(ProcessingNodeScores.class.getSimpleName())) {
                        if (rs.getLong(2) != ((Long)id).longValue()) continue;
                        return ABaseClass.getCreatedSinglePrimaryKeyObject(spp, klasse, rs.getLong(2));
                    }
                    if (rs.getLong(1) != ((Long)id).longValue()) continue;
                    return ABaseClass.getCreatedSinglePrimaryKeyObject(spp, klasse, rs.getLong(1));
                }
                if (PDBaseClassPairedPrimaryKey.isPairedPrimaryKeyClass(klasse)) {
                    if (rs.getLong(1) != ((Long)((Pair)id).getKey()).longValue() || rs.getLong(2) != ((Long)((Pair)id).getValue()).longValue()) continue;
                    return ABaseClass.getCreatedPairedPrimaryKeyObject(spp, klasse, id);
                }
                if (PDBaseClassPairedPrimaryKey.isPairedPrimaryKeyStrClass(klasse)) {
                    if (rs.getLong(1) != ((Long)((Pair)id).getKey()).longValue() || !rs.getString(2).equals(((Pair)id).getValue())) continue;
                    return ABaseClass.getCreatedPairedPrimaryKeyStrObject(spp, klasse, id);
                }
                if (PDBaseClassTripledPrimaryKey.isTripledPrimaryKeyClass(klasse)) {
                    if (rs.getLong(1) != ((Long)((Triple)id).getFirst()).longValue() || rs.getLong(2) != ((Long)((Triple)id).getSecond()).longValue() || rs.getLong(3) != ((Long)((Triple)id).getThird()).longValue()) continue;
                    return ABaseClass.getCreatedTripledPrimaryKeyObject(spp, klasse, id);
                }
                if (!PDBaseClassQuadrupledPrimaryKey.isQuadrupledPrimaryKeyClass(klasse) || rs.getLong(1) != ((Long)((Quadruple)id).getFirst()).longValue() || rs.getLong(2) != ((Long)((Quadruple)id).getSecond()).longValue() || rs.getLong(3) != ((Long)((Quadruple)id).getThird()).longValue() || rs.getLong(4) != ((Long)((Quadruple)id).getFourth()).longValue()) continue;
                return ABaseClass.getCreatedQuadrupledPrimaryKeyObject(spp, klasse, id);
            }
            return obj;
        }
        catch (SQLException sqlex) {
            sqlex.printStackTrace(System.err);
            return null;
        }
    }

    private static <T1, T2> T1 getCreatedSinglePrimaryKeyObject(SimpleProgramParameters spp, Class klasse, T2 id) {
        String tableName = klasse.getSimpleName();
        Long longID = (Long)id;
        if (tableName.equals(AminoAcidModifications.class.getSimpleName())) {
            return (T1)new AminoAcidModifications(spp, longID);
        }
        if (tableName.equals(AminoAcidModificationsNeutralLosses.class.getSimpleName())) {
            return (T1)new AminoAcidModificationsNeutralLosses(spp, longID);
        }
        if (tableName.equals(AminoAcids.class.getSimpleName())) {
            return (T1)new AminoAcids(spp, longID);
        }
        if (tableName.equals(AnnotationDataVersion.class.getSimpleName())) {
            return (T1)new AnnotationDataVersion(spp, longID);
        }
        if (tableName.equals(AnnotationDataset.class.getSimpleName())) {
            return (T1)new AnnotationDataset(spp, longID);
        }
        if (tableName.equals(AnnotationTypes.class.getSimpleName())) {
            return (T1)new AnnotationTypes(spp, longID);
        }
        if (tableName.equals(Annotations.class.getSimpleName())) {
            return (T1)new Annotations(spp, longID);
        }
        if (tableName.equals(CustomDataFields.class.getSimpleName())) {
            return (T1)new CustomDataFields(spp, longID);
        }
        if (tableName.equals(Enzymes.class.getSimpleName())) {
            return (T1)new Enzymes(spp, longID);
        }
        if (tableName.equals(EventAnnotations.class.getSimpleName())) {
            return (T1)new EventAnnotations(spp, longID);
        }
        if (tableName.equals(EventAreaAnnotations.class.getSimpleName())) {
            return (T1)new EventAreaAnnotations(spp, longID);
        }
        if (tableName.equals(Events.class.getSimpleName())) {
            return (T1)new Events(spp, longID);
        }
        if (tableName.equals(FastaFiles.class.getSimpleName())) {
            return (T1)new FastaFiles(spp, longID);
        }
        if (tableName.equals(FileInfos.class.getSimpleName())) {
            return (T1)new FileInfos(spp, longID);
        }
        if (tableName.equals(IdentifiedMassPeaks2.class.getSimpleName())) {
            return (T1)new IdentifiedMassPeaks2(spp, longID);
        }
        if (tableName.equals(MassPeaks.class.getSimpleName())) {
            return (T1)new MassPeaks(spp, longID);
        }
        if (tableName.equals(PeptidesReferenceSpectra.class.getSimpleName())) {
            return (T1)new PeptidesReferenceSpectra(spp, longID, strVersion);
        }
        if (tableName.equals(PrecursorIonAreaSearchSpectra.class.getSimpleName())) {
            return (T1)new PrecursorIonAreaSearchSpectra(spp, longID);
        }
        if (tableName.equals(ProcessingNodeExtensions.class.getSimpleName())) {
            return (T1)new ProcessingNodeExtensions(spp, longID);
        }
        if (tableName.equals(ProcessingNodeScores.class.getSimpleName())) {
            return (T1)new ProcessingNodeScores(spp, longID);
        }
        if (tableName.equals(ProteinAnnotations.class.getSimpleName())) {
            return (T1)new ProteinAnnotations(spp, longID);
        }
        if (tableName.equals(Proteins.class.getSimpleName())) {
            return (T1)new Proteins(spp, longID, strVersion);
        }
        if (tableName.equals(ReferenceSpectra.class.getSimpleName())) {
            return (T1)new ReferenceSpectra(spp, longID);
        }
        if (tableName.equals(Spectra.class.getSimpleName())) {
            return (T1)new Spectra(spp, longID);
        }
        if (tableName.equals(ScanEvents.class.getSimpleName())) {
            return (T1)new ScanEvents(spp, longID);
        }
        if (tableName.equals(SchemaInfo.class.getSimpleName())) {
            return (T1)new SchemaInfo(spp, longID);
        }
        if (tableName.equals(SpectrumHeaders.class.getSimpleName())) {
            return (T1)new SpectrumHeaders(spp, longID);
        }
        if (tableName.equals(TaxonomyNodes.class.getSimpleName())) {
            return (T1)new TaxonomyNodes(spp, longID);
        }
        if (tableName.equals(ProcessingNodes.class.getSimpleName())) {
            return (T1)new ProcessingNodes(spp, longID);
        }
        if (tableName.equals(WorkflowMessages.class.getSimpleName())) {
            return (T1)new WorkflowMessages(spp, longID);
        }
        statLogger.error("Table name {} not found in getSinglePrimaryKeyObject()", (Object)tableName);
        return null;
    }

    private static <T1, T2> T1 getCreatedPairedPrimaryKeyObject(SimpleProgramParameters spp, Class klasse, T2 id) {
        String tableName = klasse.getSimpleName();
        Pair idPair = (Pair)id;
        if (tableName.equals(AminoAcidModificationsAminoAcids.class.getSimpleName())) {
            return (T1)new AminoAcidModificationsAminoAcids(spp, (Long)idPair.getKey(), (Long)idPair.getValue());
        }
        if (tableName.equals(AnnotationsAnnotationGroups.class.getSimpleName())) {
            return (T1)new AnnotationsAnnotationGroups(spp, (Long)idPair.getKey(), (Long)idPair.getValue());
        }
        if (tableName.equals(Chromatograms.class.getSimpleName())) {
            return (T1)new Chromatograms(spp, (Long)idPair.getKey(), Chromatograms.TraceType.valueOf(String.valueOf(idPair.getValue())));
        }
        if (tableName.equals(CustomDataPeptides.class.getSimpleName())) {
            return (T1)new CustomDataPeptides(spp, (Long)idPair.getKey(), (Long)idPair.getValue());
        }
        if (tableName.equals(CustomDataPeptides_decoy.class.getSimpleName())) {
            return (T1)new CustomDataPeptides_decoy(spp, (Long)idPair.getKey(), (Long)idPair.getValue());
        }
        if (tableName.equals(CustomDataProcessingNodes.class.getSimpleName())) {
            return (T1)new CustomDataProcessingNodes(spp, (Long)idPair.getKey(), (Long)idPair.getValue());
        }
        if (tableName.equals(CustomDataProteins.class.getSimpleName())) {
            return (T1)new CustomDataProteins(spp, (Long)idPair.getKey(), (Long)idPair.getValue());
        }
        if (tableName.equals(CustomDataProteins_decoy.class.getSimpleName())) {
            return (T1)new CustomDataProteins_decoy(spp, (Long)idPair.getKey(), (Long)idPair.getValue());
        }
        if (tableName.equals(CustomDataSpectra.class.getSimpleName())) {
            return (T1)new CustomDataSpectra(spp, (Long)idPair.getKey(), (Long)idPair.getValue());
        }
        if (tableName.equals(EnzymesCleavageSpecificities.class.getSimpleName())) {
            return (T1)new EnzymesCleavageSpecificities(spp, (Long)idPair.getKey(), (Long)idPair.getValue());
        }
        if (tableName.equals(FalseDiscoveryRates.class.getSimpleName())) {
            return (T1)new FalseDiscoveryRates(spp, (Long)idPair.getKey(), (Long)idPair.getValue());
        }
        if (tableName.equals(FastaFilesProteinAnnotations.class.getSimpleName())) {
            return (T1)new FastaFilesProteinAnnotations(spp, (Long)idPair.getKey(), (Long)idPair.getValue());
        }
        if (tableName.equals(IdentifiedPeptides2.class.getSimpleName())) {
            return (T1)new IdentifiedPeptides2(spp, (Long)idPair.getKey(), (Long)idPair.getValue());
        }
        if (tableName.equals(MassPeakRelations.class.getSimpleName())) {
            return (T1)new MassPeakRelations(spp, (Long)idPair.getKey(), (Long)idPair.getValue());
        }
        if (tableName.equals(Peptides.class.getSimpleName())) {
            return (T1)new Peptides(spp, (Long)idPair.getKey(), (Long)idPair.getValue(), strVersion);
        }
        if (tableName.equals(Peptides_decoy.class.getSimpleName())) {
            return (T1)new Peptides_decoy(spp, (Long)idPair.getKey(), (Long)idPair.getValue(), strVersion);
        }
        if (tableName.equals(PrecursorIonQuanResults.class.getSimpleName())) {
            return (T1)new PrecursorIonQuanResults(spp, (Long)idPair.getKey(), (Long)idPair.getValue());
        }
        if (tableName.equals(ProcessingNodesSpectra.class.getSimpleName())) {
            return (T1)new ProcessingNodesSpectra(spp, (Long)idPair.getKey(), (Long)idPair.getValue());
        }
        if (tableName.equals(ProteinIdentificationGroups.class.getSimpleName())) {
            return (T1)new ProteinIdentificationGroups(spp, (Long)idPair.getKey(), (Long)idPair.getValue());
        }
        if (tableName.equals(ProteinsProteinGroups.class.getSimpleName())) {
            return (T1)new ProteinsProteinGroups(spp, (Long)idPair.getKey(), (Long)idPair.getValue());
        }
        if (tableName.equals(ProteinScores.class.getSimpleName())) {
            return (T1)new ProteinScores(spp, (Long)idPair.getKey(), (Long)idPair.getValue());
        }
        if (tableName.equals(ProteinScores_decoy.class.getSimpleName())) {
            return (T1)new ProteinScores_decoy(spp, (Long)idPair.getKey(), (Long)idPair.getValue());
        }
        if (tableName.equals(QuanResults.class.getSimpleName())) {
            return (T1)new QuanResults(spp, (Long)idPair.getKey(), (Long)idPair.getValue());
        }
        if (tableName.equals(ReporterIonQuanResultsSearchSpectra.class.getSimpleName())) {
            return (T1)new ReporterIonQuanResultsSearchSpectra(spp, (Long)idPair.getKey(), (Long)idPair.getValue());
        }
        if (tableName.equals(SpectrumScores.class.getSimpleName())) {
            return (T1)new SpectrumScores(spp, (Long)idPair.getKey(), (Long)idPair.getValue());
        }
        statLogger.error("Table name {} not found in getCreatedPairedPrimaryKeyObject()", (Object)tableName);
        return null;
    }

    private static <T1, T2> T1 getCreatedPairedPrimaryKeyStrObject(SimpleProgramParameters spp, Class klasse, T2 id) {
        String tableName = klasse.getSimpleName();
        Pair idPairStr = (Pair)id;
        if (tableName.equals(ProcessingNodeFilterParameters.class.getSimpleName())) {
            return (T1)new ProcessingNodeFilterParameters(spp, (Long)idPairStr.getKey(), (String)idPairStr.getValue());
        }
        if (tableName.equals(ProcessingNodeParameters.class.getSimpleName())) {
            return (T1)new ProcessingNodeParameters(spp, (Long)idPairStr.getKey(), (String)idPairStr.getValue());
        }
        statLogger.error("Table name {} not found in getCreatedPairedPrimaryKeyStrObject()", (Object)tableName);
        return null;
    }

    private static <T1, T2> T1 getCreatedTripledPrimaryKeyObject(SimpleProgramParameters spp, Class klasse, T2 id) {
        String tableName = klasse.getSimpleName();
        Triple idTriple = (Triple)id;
        if (tableName.equals(AminoAcidModificationsAminoAcidsNL.class.getSimpleName())) {
            return (T1)new AminoAcidModificationsAminoAcidsNL(spp, (Long)idTriple.getFirst(), (Long)idTriple.getSecond(), (Long)idTriple.getThird());
        }
        if (tableName.equals(PeptidesProteins.class.getSimpleName())) {
            return (T1)new PeptidesProteins(spp, (Long)idTriple.getFirst(), (Long)idTriple.getSecond(), (Long)idTriple.getThird());
        }
        if (tableName.equals(PeptidesProteins_decoy.class.getSimpleName())) {
            return (T1)new PeptidesProteins_decoy(spp, (Long)idTriple.getFirst(), (Long)idTriple.getSecond(), (Long)idTriple.getThird());
        }
        if (tableName.equals(PeptideScores.class.getSimpleName())) {
            return (T1)new PeptideScores(spp, (Long)idTriple.getFirst(), (Long)idTriple.getSecond(), (Long)idTriple.getThird(), strVersion);
        }
        if (tableName.equals(PeptideScores_decoy.class.getSimpleName())) {
            return (T1)new PeptideScores_decoy(spp, (Long)idTriple.getFirst(), (Long)idTriple.getSecond(), (Long)idTriple.getThird(), strVersion);
        }
        if (tableName.equals(PeptidesTerminalModifications.class.getSimpleName())) {
            return (T1)new PeptidesTerminalModifications(spp, (Long)idTriple.getFirst(), (Long)idTriple.getSecond(), (Long)idTriple.getThird());
        }
        if (tableName.equals(PeptidesTerminalModifications_decoy.class.getSimpleName())) {
            return (T1)new PeptidesTerminalModifications_decoy(spp, (Long)idTriple.getFirst(), (Long)idTriple.getSecond(), (Long)idTriple.getThird());
        }
        if (tableName.equals(PrecursorIonQuanResultsSearchSpectra.class.getSimpleName())) {
            return (T1)new PrecursorIonQuanResultsSearchSpectra(spp, (Long)idTriple.getFirst(), (Long)idTriple.getSecond(), (Long)idTriple.getThird());
        }
        if (tableName.equals(PtmAnnotationData.class.getSimpleName())) {
            return (T1)new PtmAnnotationData(spp, (Long)idTriple.getFirst(), (Long)idTriple.getSecond(), (Long)idTriple.getThird());
        }
        if (tableName.equals(ReporterIonQuanResults.class.getSimpleName())) {
            return (T1)new ReporterIonQuanResults(spp, (Long)idTriple.getFirst(), (Long)idTriple.getSecond(), (Long)idTriple.getThird());
        }
        statLogger.error("Table name {} not found in getCreatedTripledPrimaryKeyObject()", (Object)tableName);
        return null;
    }

    private static <T1, T2> T1 getCreatedQuadrupledPrimaryKeyObject(SimpleProgramParameters spp, Class klasse, T2 id) {
        String tableName = klasse.getSimpleName();
        Quadruple idQuad = (Quadruple)id;
        if (tableName.equals(PeptidesAminoAcidModifications.class.getSimpleName())) {
            return (T1)new PeptidesAminoAcidModifications(spp, (Long)idQuad.getFirst(), (Long)idQuad.getSecond(), (Long)idQuad.getThird(), (Long)idQuad.getFourth(), strVersion);
        }
        if (tableName.equals(PeptidesAminoAcidModifications_decoy.class.getSimpleName())) {
            return (T1)new PeptidesAminoAcidModifications_decoy(spp, (Long)idQuad.getFirst(), (Long)idQuad.getSecond(), (Long)idQuad.getThird(), (Long)idQuad.getFourth(), strVersion);
        }
        statLogger.error("Table name {} not found in getCreatedTripledPrimaryKeyObject()", (Object)tableName);
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T1, T2> HashMap<T1, T2> getObjectMap(SimpleProgramParameters spp, Class klasse) {
        HashMap keyObjectMap = new HashMap();
        String tableName = klasse.getSimpleName();
        String sqlStr = ABaseClass.selectSternFromStr(tableName);
        if (spp.isUsingSQLite4Java()) {
            SQLiteConnection conn = spp.getSQLiteAccess().dbConn;
            try {
                SQLiteStatement st;
                if (conn == null || (st = conn.prepare(sqlStr)) == null) return keyObjectMap;
                while (st.step()) {
                    if (PDBaseClassSinglePrimaryKey.isSinglePrimaryKeyClass(klasse)) {
                        if (tableName.equals(ProcessingNodeScores.class.getSimpleName())) {
                            ABaseClass.addSinglePrimaryKeyObjectToMap(spp, st.columnLong(1), tableName, keyObjectMap);
                            continue;
                        }
                        ABaseClass.addSinglePrimaryKeyObjectToMap(spp, st.columnLong(0), tableName, keyObjectMap);
                        continue;
                    }
                    if (PDBaseClassPairedPrimaryKey.isPairedPrimaryKeyClass(klasse)) {
                        ABaseClass.addPairedPrimaryKeyObjectToMap(spp, new Pair((Object)st.columnLong(0), (Object)st.columnLong(1)), tableName, keyObjectMap);
                        continue;
                    }
                    if (PDBaseClassPairedPrimaryKey.isPairedPrimaryKeyStrClass(klasse)) {
                        ABaseClass.addPairedPrimaryKeyObjectToMapStr(spp, new Pair((Object)st.columnLong(0), (Object)st.columnString(1)), tableName, keyObjectMap);
                        continue;
                    }
                    if (PDBaseClassTripledPrimaryKey.isTripledPrimaryKeyClass(klasse)) {
                        ABaseClass.addTripledPrimaryKeyObjectToMap(spp, new Triple((Object)st.columnLong(0), (Object)st.columnLong(1), (Object)st.columnLong(2)), tableName, keyObjectMap);
                        continue;
                    }
                    if (!PDBaseClassQuadrupledPrimaryKey.isQuadrupledPrimaryKeyClass(klasse)) continue;
                    ABaseClass.addQuadrupledPrimaryKeyObjectToMap(spp, new Quadruple((Object)st.columnLong(0), (Object)st.columnLong(1), (Object)st.columnLong(2), (Object)st.columnLong(3)), tableName, keyObjectMap);
                }
                return keyObjectMap;
            }
            catch (SQLiteException sqliteex) {
                sqliteex.printStackTrace(System.err);
                return null;
            }
        }
        Connection conn = spp.getJDBCAccess().dbConn;
        if (conn == null) return keyObjectMap;
        try {
            Statement st = conn.createStatement();
            if (st == null || !st.execute(sqlStr)) return keyObjectMap;
            ResultSet rs = st.getResultSet();
            while (rs.next()) {
                if (PDBaseClassSinglePrimaryKey.isSinglePrimaryKeyClass(klasse)) {
                    ABaseClass.addJDBCSinglePrimaryKeyResultToMap(spp, rs, tableName, keyObjectMap);
                    continue;
                }
                if (PDBaseClassPairedPrimaryKey.isPairedPrimaryKeyClass(klasse)) {
                    ABaseClass.addJDBCPairedPrimaryKeyResultToMap(spp, rs, tableName, keyObjectMap);
                    continue;
                }
                if (PDBaseClassPairedPrimaryKey.isPairedPrimaryKeyStrClass(klasse)) {
                    ABaseClass.addJDBCPairedPrimaryKeyStrResultToMap(spp, rs, tableName, keyObjectMap);
                    continue;
                }
                if (PDBaseClassTripledPrimaryKey.isTripledPrimaryKeyClass(klasse)) {
                    ABaseClass.addJDBCTripledPrimaryKeyResultToMap(spp, rs, tableName, keyObjectMap);
                    continue;
                }
                if (!PDBaseClassQuadrupledPrimaryKey.isQuadrupledPrimaryKeyClass(klasse)) continue;
                ABaseClass.addJDBCQuadrupledPrimaryKeyResultToMap(spp, rs, tableName, keyObjectMap);
            }
            return keyObjectMap;
        }
        catch (SQLException sqlex) {
            sqlex.printStackTrace(System.err);
            return null;
        }
    }

    private static <T> void addJDBCSinglePrimaryKeyIDToList(ResultSet rs, String tableName, ArrayList<T> idList) {
        try {
            if (tableName.equals(ProcessingNodeScores.class.getSimpleName())) {
                ABaseClass.addSinglePrimaryKeyObjectIDToList(rs.getLong(2), tableName, idList);
            } else {
                ABaseClass.addSinglePrimaryKeyObjectIDToList(rs.getLong(1), tableName, idList);
            }
        }
        catch (SQLException sex) {
            statLogger.error("Error getting the ID in addJDBCSinglePrimaryKeyIDToList()");
        }
    }

    private static <T> void addJDBCPairedPrimaryKeyIDToList(ResultSet rs, String tableName, ArrayList<T> idList) {
        try {
            ABaseClass.addPairedPrimaryKeyObjectIDToList((Pair<Long, Long>)new Pair((Object)rs.getLong(1), (Object)rs.getLong(2)), tableName, idList);
        }
        catch (SQLException sex) {
            statLogger.error("Error getting the ID in addJDBCPairedPrimaryKeyIDToList()");
        }
    }

    private static <T> void addJDBCPairedPrimaryKeyStrIDToList(ResultSet rs, String tableName, ArrayList<T> idList) {
        try {
            ABaseClass.addPairedPrimaryKeyObjectStrIDToList((Pair<Long, String>)new Pair((Object)rs.getLong(1), (Object)rs.getString(2)), tableName, idList);
        }
        catch (SQLException sex) {
            statLogger.error("Error getting the ID in addJDBCPairedPrimaryKeyStrIDToList()");
        }
    }

    private static <T> void addJDBCTripledPrimaryKeyIDToList(ResultSet rs, String tableName, ArrayList<T> idList) {
        try {
            ABaseClass.addTripledPrimaryKeyObjectIDToList((Triple<Long, Long, Long>)new Triple((Object)rs.getLong(1), (Object)rs.getLong(2), (Object)rs.getLong(3)), tableName, idList);
        }
        catch (SQLException sex) {
            statLogger.error("Error getting the ID in addJDBCTripledPrimaryKeyIDToList()");
        }
    }

    private static <T> void addJDBCQuadrupledPrimaryKeyIDToList(ResultSet rs, String tableName, ArrayList<T> idList) {
        try {
            ABaseClass.addQuadrupledPrimaryKeyObjectIDToList((Quadruple<Long, Long, Long, Long>)new Quadruple((Object)rs.getLong(1), (Object)rs.getLong(2), (Object)rs.getLong(3), (Object)rs.getLong(4)), tableName, idList);
        }
        catch (SQLException sex) {
            statLogger.error("Error getting the ID in addJDBCQuadrupledPrimaryKeyIDToList()");
        }
    }

    private static <T1, T2> void addJDBCSinglePrimaryKeyResultToMap(SimpleProgramParameters spp, ResultSet rs, String tableName, HashMap<T1, T2> keyObjectMap) {
        try {
            if (tableName.equals(ProcessingNodeScores.class.getSimpleName())) {
                ABaseClass.addSinglePrimaryKeyObjectToMap(spp, rs.getLong(2), tableName, keyObjectMap);
            } else {
                ABaseClass.addSinglePrimaryKeyObjectToMap(spp, rs.getLong(1), tableName, keyObjectMap);
            }
        }
        catch (SQLException sex) {
            statLogger.error("Error getting the objects in addJDBCSinglePrimaryKeyResultToMap()");
        }
    }

    private static <T1, T2> void addJDBCPairedPrimaryKeyResultToMap(SimpleProgramParameters spp, ResultSet rs, String tableName, HashMap<T1, T2> keyObjectMap) {
        try {
            ABaseClass.addPairedPrimaryKeyObjectToMap(spp, new Pair((Object)rs.getLong(1), (Object)rs.getLong(2)), tableName, keyObjectMap);
        }
        catch (SQLException sex) {
            statLogger.error("Error getting the id in addJDBCPairedPrimaryKeyResultToMap()");
        }
    }

    private static <T1, T2> void addJDBCPairedPrimaryKeyStrResultToMap(SimpleProgramParameters spp, ResultSet rs, String tableName, HashMap<T1, T2> ppKeyObjectMapStr) {
        try {
            ABaseClass.addPairedPrimaryKeyObjectToMapStr(spp, new Pair((Object)rs.getLong(1), (Object)rs.getString(2)), tableName, ppKeyObjectMapStr);
        }
        catch (SQLException sex) {
            statLogger.error("Error getting the id in addJDBCPairedPrimaryKeyResultToMap()");
        }
    }

    private static <T1, T2> void addJDBCTripledPrimaryKeyResultToMap(SimpleProgramParameters spp, ResultSet rs, String tableName, HashMap<T1, T2> tpKeyObjectMap) {
        try {
            ABaseClass.addTripledPrimaryKeyObjectToMap(spp, new Triple((Object)rs.getLong(1), (Object)rs.getLong(2), (Object)rs.getLong(3)), tableName, tpKeyObjectMap);
        }
        catch (SQLException sex) {
            statLogger.error("Error getting the id in addJDBCTripledPrimaryKeyResultToMap()");
        }
    }

    private static <T1, T2> void addJDBCQuadrupledPrimaryKeyResultToMap(SimpleProgramParameters spp, ResultSet rs, String tableName, HashMap<T1, T2> qpKeyObjectMap) {
        try {
            ABaseClass.addQuadrupledPrimaryKeyObjectToMap(spp, new Quadruple((Object)rs.getLong(1), (Object)rs.getLong(2), (Object)rs.getLong(3), (Object)rs.getLong(4)), tableName, qpKeyObjectMap);
        }
        catch (SQLException sex) {
            statLogger.error("Error getting the id in addJDBCQuadrupledPrimaryKeyResultToMap()");
        }
    }

    private static <T> void addSinglePrimaryKeyObjectIDToList(Long id, String tableName, ArrayList<T> keyList) {
        if (tableName.equals(AminoAcidModifications.class.getSimpleName()) || tableName.equals(AminoAcidModificationsNeutralLosses.class.getSimpleName()) || tableName.equals(AminoAcids.class.getSimpleName()) || tableName.equals(AnnotationDataVersion.class.getSimpleName()) || tableName.equals(AnnotationDataset.class.getSimpleName()) || tableName.equals(AnnotationTypes.class.getSimpleName()) || tableName.equals(Annotations.class.getSimpleName()) || tableName.equals(CustomDataFields.class.getSimpleName()) || tableName.equals(Enzymes.class.getSimpleName()) || tableName.equals(EventAnnotations.class.getSimpleName()) || tableName.equals(EventAreaAnnotations.class.getSimpleName()) || tableName.equals(Events.class.getSimpleName()) || tableName.equals(FastaFiles.class.getSimpleName()) || tableName.equals(FileInfos.class.getSimpleName()) || tableName.equals(IdentifiedMassPeaks2.class.getSimpleName()) || tableName.equals(MassPeaks.class.getSimpleName()) || tableName.equals(PeptidesReferenceSpectra.class.getSimpleName()) || tableName.equals(PrecursorIonAreaSearchSpectra.class.getSimpleName()) || tableName.equals(ProcessingNodeExtensions.class.getSimpleName()) || tableName.equals(ProcessingNodes.class.getSimpleName()) || tableName.equals(ProcessingNodeScores.class.getSimpleName()) || tableName.equals(ProteinAnnotations.class.getSimpleName()) || tableName.equals(Proteins.class.getSimpleName()) || tableName.equals(ReferenceSpectra.class.getSimpleName()) || tableName.equals(ScanEvents.class.getSimpleName()) || tableName.equals(SchemaInfo.class.getSimpleName()) || tableName.equals(Spectra.class.getSimpleName()) || tableName.equals(SpectrumHeaders.class.getSimpleName()) || tableName.equals(TaxonomyNodes.class.getSimpleName()) || tableName.equals(WorkflowMessages.class.getSimpleName())) {
            keyList.add(id);
        } else {
            statLogger.error("Table name {} not found in addSinglePrimaryKeyObjectIDToList()", (Object)tableName);
        }
    }

    private static <T> void addPairedPrimaryKeyObjectIDToList(Pair<Long, Long> pair, String tableName, ArrayList<T> keyList) {
        if (tableName.equals(AminoAcidModificationsAminoAcids.class.getSimpleName()) || tableName.equals(AnnotationsAnnotationGroups.class.getSimpleName()) || tableName.equals(Chromatograms.class.getSimpleName()) || tableName.equals(CustomDataPeptides.class.getSimpleName()) || tableName.equals(CustomDataPeptides_decoy.class.getSimpleName()) || tableName.equals(CustomDataProcessingNodes.class.getSimpleName()) || tableName.equals(CustomDataProteins.class.getSimpleName()) || tableName.equals(CustomDataProteins_decoy.class.getSimpleName()) || tableName.equals(CustomDataSpectra.class.getSimpleName()) || tableName.equals(EnzymesCleavageSpecificities.class.getSimpleName()) || tableName.equals(FalseDiscoveryRates.class.getSimpleName()) || tableName.equals(FastaFilesProteinAnnotations.class.getSimpleName()) || tableName.equals(IdentifiedPeptides2.class.getSimpleName()) || tableName.equals(MassPeakRelations.class.getSimpleName()) || tableName.equals(Peptides.class.getSimpleName()) || tableName.equals(Peptides_decoy.class.getSimpleName()) || tableName.equals(PrecursorIonQuanResults.class.getSimpleName()) || tableName.equals(PrecursorIonQuanResultsSearchSpectra.class.getSimpleName()) || tableName.equals(ProcessingNodesSpectra.class.getSimpleName()) || tableName.equals(ProteinIdentificationGroups.class.getSimpleName()) || tableName.equals(ProteinsProteinGroups.class.getSimpleName()) || tableName.equals(ProteinScores.class.getSimpleName()) || tableName.equals(ProteinScores_decoy.class.getSimpleName()) || tableName.equals(QuanResults.class.getSimpleName()) || tableName.equals(ReporterIonQuanResultsSearchSpectra.class.getSimpleName()) || tableName.equals(SpectrumScores.class.getSimpleName())) {
            keyList.add(pair);
        } else {
            statLogger.error("Table name {} not found in addPairedPrimaryKeyObjectIDToList()", (Object)tableName);
        }
    }

    private static <T> void addPairedPrimaryKeyObjectStrIDToList(Pair<Long, String> pair, String tableName, ArrayList<T> keyList) {
        if (tableName.equals(ProcessingNodeFilterParameters.class.getSimpleName()) || tableName.equals(ProcessingNodeParameters.class.getSimpleName())) {
            keyList.add(pair);
        } else {
            statLogger.error("Table name {} not found in addPairedPrimaryKeyObjectStrIDToList()", (Object)tableName);
        }
    }

    private static <T> void addTripledPrimaryKeyObjectIDToList(Triple<Long, Long, Long> triple, String tableName, ArrayList<T> keyList) {
        if (tableName.equals(AminoAcidModificationsAminoAcidsNL.class.getSimpleName()) || tableName.equals(PeptidesProteins.class.getSimpleName()) || tableName.equals(PeptidesProteins_decoy.class.getSimpleName()) || tableName.equals(PeptideScores.class.getSimpleName()) || tableName.equals(PeptideScores_decoy.class.getSimpleName()) || tableName.equals(PeptidesTerminalModifications.class.getSimpleName()) || tableName.equals(PeptidesTerminalModifications_decoy.class.getSimpleName()) || tableName.equals(PtmAnnotationData.class.getSimpleName()) || tableName.equals(ReporterIonQuanResults.class.getSimpleName())) {
            keyList.add(triple);
        } else {
            statLogger.error("Table name {} not found in addTripledPrimaryKeyObjectIDToList()", (Object)tableName);
        }
    }

    private static <T> void addQuadrupledPrimaryKeyObjectIDToList(Quadruple<Long, Long, Long, Long> quad, String tableName, ArrayList<T> keyList) {
        if (tableName.equals(PeptidesAminoAcidModifications.class.getSimpleName()) || tableName.equals(PeptidesAminoAcidModifications_decoy.class.getSimpleName())) {
            keyList.add(quad);
        } else {
            statLogger.error("Table name {} not found in addQuadrupledPrimaryKeyObjectIDToList()", (Object)tableName);
        }
    }

    private static <T1, T2> void addSinglePrimaryKeyObjectToMap(SimpleProgramParameters spp, T1 id, String tableName, HashMap<T1, T2> keyObjectMap) {
        Long lID = (Long)id;
        if (tableName.equals(AminoAcidModifications.class.getSimpleName())) {
            keyObjectMap.put(id, new AminoAcidModifications(spp, lID));
        } else if (tableName.equals(AminoAcidModificationsNeutralLosses.class.getSimpleName())) {
            keyObjectMap.put(id, new AminoAcidModificationsNeutralLosses(spp, lID));
        } else if (tableName.equals(AminoAcids.class.getSimpleName())) {
            keyObjectMap.put(id, new AminoAcids(spp, lID));
        } else if (tableName.equals(AnnotationDataVersion.class.getSimpleName())) {
            keyObjectMap.put(id, new AnnotationDataVersion(spp, lID));
        } else if (tableName.equals(AnnotationDataset.class.getSimpleName())) {
            keyObjectMap.put(id, new AnnotationDataset(spp, lID));
        } else if (tableName.equals(AnnotationTypes.class.getSimpleName())) {
            keyObjectMap.put(id, new AnnotationTypes(spp, lID));
        } else if (tableName.equals(Annotations.class.getSimpleName())) {
            keyObjectMap.put(id, new Annotations(spp, lID));
        } else if (tableName.equals(CustomDataFields.class.getSimpleName())) {
            keyObjectMap.put(id, new CustomDataFields(spp, lID));
        } else if (tableName.equals(Enzymes.class.getSimpleName())) {
            keyObjectMap.put(id, new Enzymes(spp, lID));
        } else if (tableName.equals(EventAnnotations.class.getSimpleName())) {
            keyObjectMap.put(id, new EventAnnotations(spp, lID));
        } else if (tableName.equals(EventAreaAnnotations.class.getSimpleName())) {
            keyObjectMap.put(id, new EventAreaAnnotations(spp, lID));
        } else if (tableName.equals(Events.class.getSimpleName())) {
            keyObjectMap.put(id, new Events(spp, lID));
        } else if (tableName.equals(FastaFiles.class.getSimpleName())) {
            keyObjectMap.put(id, new FastaFiles(spp, lID));
        } else if (tableName.equals(FileInfos.class.getSimpleName())) {
            keyObjectMap.put(id, new FileInfos(spp, lID));
        } else if (tableName.equals(IdentifiedMassPeaks2.class.getSimpleName())) {
            keyObjectMap.put(id, new IdentifiedMassPeaks2(spp, lID));
        } else if (tableName.equals(MassPeaks.class.getSimpleName())) {
            keyObjectMap.put(id, new MassPeaks(spp, lID));
        } else if (tableName.equals(PeptidesReferenceSpectra.class.getSimpleName())) {
            keyObjectMap.put(id, new PeptidesReferenceSpectra(spp, lID, strVersion));
        } else if (tableName.equals(PrecursorIonAreaSearchSpectra.class.getSimpleName())) {
            keyObjectMap.put(id, new PrecursorIonAreaSearchSpectra(spp, lID));
        } else if (tableName.equals(ProcessingNodeExtensions.class.getSimpleName())) {
            keyObjectMap.put(id, new ProcessingNodeExtensions(spp, lID));
        } else if (tableName.equals(ProcessingNodes.class.getSimpleName())) {
            keyObjectMap.put(id, new ProcessingNodes(spp, lID));
        } else if (tableName.equals(ProcessingNodeScores.class.getSimpleName())) {
            keyObjectMap.put(id, new ProcessingNodeScores(spp, lID));
        } else if (tableName.equals(ProteinAnnotations.class.getSimpleName())) {
            keyObjectMap.put(id, new ProteinAnnotations(spp, lID));
        } else if (tableName.equals(Proteins.class.getSimpleName())) {
            keyObjectMap.put(id, new Proteins(spp, lID, strVersion));
        } else if (tableName.equals(ReferenceSpectra.class.getSimpleName())) {
            keyObjectMap.put(id, new ReferenceSpectra(spp, lID));
        } else if (tableName.equals(ScanEvents.class.getSimpleName())) {
            keyObjectMap.put(id, new ScanEvents(spp, lID));
        } else if (tableName.equals(SchemaInfo.class.getSimpleName())) {
            keyObjectMap.put(id, new SchemaInfo(spp, lID));
        } else if (tableName.equals(Spectra.class.getSimpleName())) {
            keyObjectMap.put(id, new Spectra(spp, lID));
        } else if (tableName.equals(SpectrumHeaders.class.getSimpleName())) {
            keyObjectMap.put(id, new SpectrumHeaders(spp, lID));
        } else if (tableName.equals(TaxonomyNodes.class.getSimpleName())) {
            keyObjectMap.put(id, new TaxonomyNodes(spp, lID));
        } else if (tableName.equals(WorkflowMessages.class.getSimpleName())) {
            keyObjectMap.put(id, new TaxonomyNodes(spp, lID));
        } else {
            statLogger.error("Table name {} not found in addSinglePrimaryKeyObjectToMap()", (Object)tableName);
        }
    }

    private static <T1, T2> void addPairedPrimaryKeyObjectToMap(SimpleProgramParameters spp, T1 idPair, String tableName, HashMap<T1, T2> keyObjectMap) {
        Pair pair = (Pair)idPair;
        if (tableName.equals(Chromatograms.class.getSimpleName())) {
            keyObjectMap.put(idPair, new Chromatograms(spp, (Long)pair.getKey(), Chromatograms.TraceType.fromStringValue(String.valueOf(pair.getValue()))));
        } else if (tableName.equals(CustomDataPeptides.class.getSimpleName())) {
            keyObjectMap.put(idPair, new CustomDataPeptides(spp, (Long)pair.getKey(), (Long)pair.getValue()));
        } else if (tableName.equals(CustomDataPeptides_decoy.class.getSimpleName())) {
            keyObjectMap.put(idPair, new CustomDataPeptides_decoy(spp, (Long)pair.getKey(), (Long)pair.getValue()));
        } else if (tableName.equals(CustomDataProcessingNodes.class.getSimpleName())) {
            keyObjectMap.put(idPair, new CustomDataProcessingNodes(spp, (Long)pair.getKey(), (Long)pair.getValue()));
        } else if (tableName.equals(CustomDataProteins.class.getSimpleName())) {
            keyObjectMap.put(idPair, new CustomDataProteins(spp, (Long)pair.getKey(), (Long)pair.getValue()));
        } else if (tableName.equals(CustomDataProteins_decoy.class.getSimpleName())) {
            keyObjectMap.put(idPair, new CustomDataProteins_decoy(spp, (Long)pair.getKey(), (Long)pair.getValue()));
        } else if (tableName.equals(AminoAcidModificationsAminoAcids.class.getSimpleName())) {
            keyObjectMap.put(idPair, new AminoAcidModificationsAminoAcids(spp, (Long)pair.getKey(), (Long)pair.getValue()));
        } else if (tableName.equals(AnnotationsAnnotationGroups.class.getSimpleName())) {
            keyObjectMap.put(idPair, new AnnotationsAnnotationGroups(spp, (Long)pair.getKey(), (Long)pair.getValue()));
        } else if (tableName.equals(CustomDataSpectra.class.getSimpleName())) {
            keyObjectMap.put(idPair, new CustomDataSpectra(spp, (Long)pair.getKey(), (Long)pair.getValue()));
        } else if (tableName.equals(EnzymesCleavageSpecificities.class.getSimpleName())) {
            keyObjectMap.put(idPair, new EnzymesCleavageSpecificities(spp, (Long)pair.getKey(), (Long)pair.getValue()));
        } else if (tableName.equals(FalseDiscoveryRates.class.getSimpleName())) {
            keyObjectMap.put(idPair, new FalseDiscoveryRates(spp, (Long)pair.getKey(), (Long)pair.getValue()));
        } else if (tableName.equals(FastaFilesProteinAnnotations.class.getSimpleName())) {
            keyObjectMap.put(idPair, new FastaFilesProteinAnnotations(spp, (Long)pair.getKey(), (Long)pair.getValue()));
        } else if (tableName.equals(IdentifiedPeptides2.class.getSimpleName())) {
            keyObjectMap.put(idPair, new IdentifiedPeptides2(spp, (Long)pair.getKey(), (Long)pair.getValue()));
        } else if (tableName.equals(MassPeakRelations.class.getSimpleName())) {
            keyObjectMap.put(idPair, new MassPeakRelations(spp, (Long)pair.getKey(), (Long)pair.getValue()));
        } else if (tableName.equals(Peptides.class.getSimpleName())) {
            keyObjectMap.put(idPair, new Peptides(spp, (Long)pair.getKey(), (Long)pair.getValue(), strVersion));
        } else if (tableName.equals(Peptides_decoy.class.getSimpleName())) {
            keyObjectMap.put(idPair, new Peptides_decoy(spp, (Long)pair.getKey(), (Long)pair.getValue(), strVersion));
        } else if (tableName.equals(PrecursorIonQuanResults.class.getSimpleName())) {
            keyObjectMap.put(idPair, new PrecursorIonQuanResults(spp, (Long)pair.getKey(), (Long)pair.getValue()));
        } else if (tableName.equals(ProcessingNodesSpectra.class.getSimpleName())) {
            keyObjectMap.put(idPair, new ProcessingNodesSpectra(spp, (Long)pair.getKey(), (Long)pair.getValue()));
        } else if (tableName.equals(ProteinIdentificationGroups.class.getSimpleName())) {
            keyObjectMap.put(idPair, new ProteinIdentificationGroups(spp, (Long)pair.getKey(), (Long)pair.getValue()));
        } else if (tableName.equals(ProteinsProteinGroups.class.getSimpleName())) {
            keyObjectMap.put(idPair, new ProteinsProteinGroups(spp, (Long)pair.getKey(), (Long)pair.getValue()));
        } else if (tableName.equals(ProteinScores.class.getSimpleName())) {
            keyObjectMap.put(idPair, new ProteinScores(spp, (Long)pair.getKey(), (Long)pair.getValue()));
        } else if (tableName.equals(ProteinScores_decoy.class.getSimpleName())) {
            keyObjectMap.put(idPair, new ProteinScores_decoy(spp, (Long)pair.getKey(), (Long)pair.getValue()));
        } else if (tableName.equals(QuanResults.class.getSimpleName())) {
            keyObjectMap.put(idPair, new QuanResults(spp, (Long)pair.getKey(), (Long)pair.getValue()));
        } else if (tableName.equals(ReporterIonQuanResultsSearchSpectra.class.getSimpleName())) {
            keyObjectMap.put(idPair, new ReporterIonQuanResultsSearchSpectra(spp, (Long)pair.getKey(), (Long)pair.getValue()));
        } else if (tableName.equals(SpectrumScores.class.getSimpleName())) {
            keyObjectMap.put(idPair, new SpectrumScores(spp, (Long)pair.getKey(), (Long)pair.getValue()));
        } else {
            statLogger.error("Table name {} not found in addPairedPrimaryKeyObjectToMap()", (Object)tableName);
        }
    }

    private static <T1, T2> void addPairedPrimaryKeyObjectToMapStr(SimpleProgramParameters spp, T1 idPair, String tableName, HashMap<T1, T2> ppKeyObjectMap) {
        Pair pair = (Pair)idPair;
        if (tableName.equals(ProcessingNodeFilterParameters.class.getSimpleName())) {
            ppKeyObjectMap.put(idPair, new ProcessingNodeFilterParameters(spp, (Long)pair.getKey(), (String)pair.getValue()));
        } else if (tableName.equals(ProcessingNodeParameters.class.getSimpleName())) {
            ppKeyObjectMap.put(idPair, new ProcessingNodeParameters(spp, (Long)pair.getKey(), (String)pair.getValue()));
        } else {
            statLogger.error("Table name {} not found in addPairedPrimaryKeyObjectToMapStr()", (Object)tableName);
        }
    }

    private static <T1, T2> void addTripledPrimaryKeyObjectToMap(SimpleProgramParameters spp, T1 idTriple, String tableName, HashMap<T1, T2> tpKeyObjectMap) {
        Triple triple = (Triple)idTriple;
        if (tableName.equals(AminoAcidModificationsAminoAcidsNL.class.getSimpleName())) {
            tpKeyObjectMap.put(idTriple, new AminoAcidModificationsAminoAcidsNL(spp, (Long)triple.getFirst(), (Long)triple.getSecond(), (Long)triple.getThird()));
        } else if (tableName.equals(PeptidesProteins.class.getSimpleName())) {
            tpKeyObjectMap.put(idTriple, new PeptidesProteins(spp, (Long)triple.getFirst(), (Long)triple.getSecond(), (Long)triple.getThird()));
        } else if (tableName.equals(PeptidesProteins_decoy.class.getSimpleName())) {
            tpKeyObjectMap.put(idTriple, new PeptidesProteins_decoy(spp, (Long)triple.getFirst(), (Long)triple.getSecond(), (Long)triple.getThird()));
        } else if (tableName.equals(PeptideScores.class.getSimpleName())) {
            tpKeyObjectMap.put(idTriple, new PeptideScores(spp, (Long)triple.getFirst(), (Long)triple.getSecond(), (Long)triple.getThird(), strVersion));
        } else if (tableName.equals(PeptideScores_decoy.class.getSimpleName())) {
            tpKeyObjectMap.put(idTriple, new PeptideScores_decoy(spp, (Long)triple.getFirst(), (Long)triple.getSecond(), (Long)triple.getThird(), strVersion));
        } else if (tableName.equals(PeptidesTerminalModifications.class.getSimpleName())) {
            tpKeyObjectMap.put(idTriple, new PeptidesTerminalModifications(spp, (Long)triple.getFirst(), (Long)triple.getSecond(), (Long)triple.getThird()));
        } else if (tableName.equals(PeptidesTerminalModifications_decoy.class.getSimpleName())) {
            tpKeyObjectMap.put(idTriple, new PeptidesTerminalModifications_decoy(spp, (Long)triple.getFirst(), (Long)triple.getSecond(), (Long)triple.getThird()));
        } else if (tableName.equals(PrecursorIonQuanResultsSearchSpectra.class.getSimpleName())) {
            tpKeyObjectMap.put(idTriple, new PrecursorIonQuanResultsSearchSpectra(spp, (Long)triple.getFirst(), (Long)triple.getSecond(), (Long)triple.getThird()));
        } else if (tableName.equals(PtmAnnotationData.class.getSimpleName())) {
            tpKeyObjectMap.put(idTriple, new PtmAnnotationData(spp, (Long)triple.getFirst(), (Long)triple.getSecond(), (Long)triple.getThird()));
        } else if (tableName.equals(ReporterIonQuanResults.class.getSimpleName())) {
            tpKeyObjectMap.put(idTriple, new ReporterIonQuanResults(spp, (Long)triple.getFirst(), (Long)triple.getSecond(), (Long)triple.getThird()));
        } else {
            statLogger.error("Table name {} not found in addTripledPrimaryKeyObjectToMap()", (Object)tableName);
        }
    }

    private static <T1, T2> void addQuadrupledPrimaryKeyObjectToMap(SimpleProgramParameters spp, T1 quadID, String tableName, HashMap<T1, T2> qpKeyObjectMap) {
        Quadruple quad = (Quadruple)quadID;
        if (tableName.equals(PeptidesAminoAcidModifications.class.getSimpleName())) {
            qpKeyObjectMap.put(quadID, new PeptidesAminoAcidModifications(spp, (Long)quad.getFirst(), (Long)quad.getSecond(), (Long)quad.getThird(), (Long)quad.getFourth(), strVersion));
        } else if (tableName.equals(PeptidesAminoAcidModifications_decoy.class.getSimpleName())) {
            qpKeyObjectMap.put(quadID, new PeptidesAminoAcidModifications_decoy(spp, (Long)quad.getFirst(), (Long)quad.getSecond(), (Long)quad.getThird(), (Long)quad.getFourth(), strVersion));
        } else {
            statLogger.error("Table name {} not found in addTripledPrimaryKeyObjectToMap()", (Object)tableName);
        }
    }
}

