-- migrate:up
create table if not exists spans
(
  `app_id` UUID not null comment 'unique id of the app' codec(ZSTD(3)),
  `span_name` LowCardinality(FixedString(64)) not null comment 'name of the span' codec(ZSTD(3)),
  `span_id` FixedString(16) not null comment 'id of the span' codec(ZSTD(3)),
  `parent_id` FixedString(16) comment 'id of the parent span' codec(ZSTD(3)),
  `trace_id` FixedString(32) not null comment 'id of the trace' codec(ZSTD(3)),
  `session_id` UUID not null comment 'session id' codec(ZSTD(3)),
  `status` UInt8 not null comment 'status of the span 0 (Unset), 1 (Ok) or 2 (Error)' codec(ZSTD(3)),
  `start_time` DateTime64(9, 'UTC') not null comment 'start time' codec(DoubleDelta, ZSTD(3)),
  `end_time` DateTime64(9, 'UTC') not null comment 'end time' codec(DoubleDelta, ZSTD(3)),
  `checkpoints` Array(Tuple(FixedString(64), DateTime64(9, 'UTC'))) comment 'array of checkpoints - {name, timestamp}' codec(ZSTD(3)),
  `attribute.app_unique_id` LowCardinality(FixedString(128)) not null comment 'app bundle identifier' codec(ZSTD(3)),
  `attribute.installation_id` UUID not null comment 'unique id for an installation of an app, generated by sdk' codec(ZSTD(3)),
  `attribute.user_id` LowCardinality(String) comment 'attributed user id' codec(ZSTD(3)),
  `attribute.measure_sdk_version` LowCardinality(FixedString(16)) not null comment 'measure sdk version identifier' codec(ZSTD(3)),
  `attribute.app_version` Tuple(LowCardinality(String), LowCardinality(String)) not null comment 'composite app version' codec(ZSTD(3)),
  `attribute.os_version`  Tuple(LowCardinality(String), LowCardinality(String)) not null comment 'composite os version' codec(ZSTD(3)),
  `attribute.platform` LowCardinality(FixedString(32)) not null comment 'platform identifier' codec(ZSTD(3)),
  `attribute.thread_name` FixedString(64) comment 'thread on which the span was captured' codec(ZSTD(3)),
  `attribute.country_code` LowCardinality(String) comment 'country code' codec(ZSTD(3)),
  `attribute.network_provider` LowCardinality(String) comment 'name of the network service provider' codec(ZSTD(3)),
  `attribute.network_type` LowCardinality(String) comment 'wifi, cellular, vpn and so on' codec(ZSTD(3)),
  `attribute.network_generation` LowCardinality(String) comment '2g, 3g, 4g and so on' codec(ZSTD(3)),
  `attribute.device_name` LowCardinality(String) comment 'name of the device' codec(ZSTD(3)),
  `attribute.device_model` LowCardinality(String) comment 'model of the device' codec(ZSTD(3)),
  `attribute.device_manufacturer` LowCardinality(String) comment 'manufacturer of the device' codec(ZSTD(3)),
  `attribute.device_locale` LowCardinality(String) comment 'rfc 5646 locale string' codec(ZSTD(3)),
  `attribute.device_low_power_mode` Bool not null comment 'true if device is in power saving mode' codec(ZSTD(3)),
  `attribute.device_thermal_throttling_enabled` Bool not null comment 'true if device is has thermal throttling enabled' codec(ZSTD(3)),
  index span_name_bloom_idx `span_name` type bloom_filter granularity 2,
  index span_id_bloom_idx `span_id` type bloom_filter granularity 2,
  index trace_id_bloom_idx `trace_id` type bloom_filter granularity 2,
  index parent_id_bloom_idx `parent_id` type bloom_filter granularity 2,
  index start_time_minmax_idx `start_time` type minmax granularity 2,
  index end_time_minmax_idx `end_time` type minmax granularity 2
)
engine = MergeTree
partition by toYYYYMMDD(start_time)
order by (app_id, span_name, trace_id, span_id, start_time, end_time)
settings index_granularity = 8192
comment 'spans table';

-- migrate:down
drop table if exists spans;