-- migrate:up
alter table events
modify column if exists id codec(LZ4),
modify column if exists type codec(ZSTD(3)),
modify column if exists session_id codec(LZ4),
modify column if exists inet.ipv4 codec(ZSTD(3)),
modify column if exists inet.ipv6 codec(ZSTD(3)),
modify column if exists inet.country_code LowCardinality(FixedString(8)) codec(ZSTD(3)),
modify column if exists timestamp codec(DoubleDelta, ZSTD(3)),
modify column if exists user_triggered codec(ZSTD(3)),
modify column if exists attribute.installation_id codec(LZ4),
modify column if exists attribute.app_version LowCardinality(FixedString(128)) codec(ZSTD(3)),
modify column if exists attribute.app_build codec(ZSTD(3)),
modify column if exists attribute.app_unique_id LowCardinality(FixedString(128)) codec(ZSTD(3)),
modify column if exists attribute.platform codec(ZSTD(3)),
modify column if exists attribute.measure_sdk_version codec(ZSTD(3)),
modify column if exists attribute.thread_name codec(ZSTD(3)),
modify column if exists attribute.user_id codec(ZSTD(3)),
modify column if exists attribute.device_name codec(ZSTD(3)),
modify column if exists attribute.device_model codec(ZSTD(3)),
modify column if exists attribute.device_manufacturer codec(ZSTD(3)),
modify column if exists attribute.device_type codec(ZSTD(3)),
modify column if exists attribute.device_is_foldable codec(ZSTD(3)),
modify column if exists attribute.device_is_physical codec(ZSTD(3)),
modify column if exists attribute.device_density_dpi codec(Delta, ZSTD(3)),
modify column if exists attribute.device_width_px codec(Delta, ZSTD(3)),
modify column if exists attribute.device_height_px codec(Delta, ZSTD(3)),
modify column if exists attribute.device_density codec(Delta, ZSTD(3)),
modify column if exists attribute.device_locale LowCardinality(FixedString(64)) codec(ZSTD(3)),
modify column if exists attribute.os_name LowCardinality(FixedString(32)) codec(ZSTD(3)),
modify column if exists attribute.os_version codec(ZSTD(3)),
modify column if exists attribute.os_page_size codec(Delta, ZSTD(3)),
modify column if exists attribute.network_type codec(ZSTD(3)),
modify column if exists attribute.network_generation codec(ZSTD(3)),
modify column if exists attribute.network_provider codec(ZSTD(3)),
modify column if exists anr.handled codec(ZSTD(3)),
modify column if exists anr.fingerprint codec(ZSTD(3)),
modify column if exists anr.exceptions codec(ZSTD(3)),
modify column if exists anr.threads codec(ZSTD(3)),
modify column if exists anr.foreground codec(ZSTD(3)),
modify column if exists exception.handled codec(ZSTD(3)),
modify column if exists exception.fingerprint codec(ZSTD(3)),
modify column if exists exception.exceptions codec(ZSTD(3)),
modify column if exists exception.threads codec(ZSTD(3)),
modify column if exists exception.foreground codec(ZSTD(3)),
modify column if exists app_exit.reason codec(ZSTD(3)),
modify column if exists app_exit.importance codec(ZSTD(3)),
modify column if exists app_exit.trace codec(ZSTD(3)),
modify column if exists app_exit.process_name codec(ZSTD(3)),
modify column if exists app_exit.pid codec(ZSTD(3)),
modify column if exists string.severity_text codec(ZSTD(3)),
modify column if exists string.string codec(ZSTD(3)),
modify column if exists gesture_long_click.target codec(ZSTD(3)),
modify column if exists gesture_long_click.target_id codec(ZSTD(3)),
modify column if exists gesture_long_click.touch_down_time codec(T64, ZSTD(3)),
modify column if exists gesture_long_click.touch_up_time codec(T64, ZSTD(3)),
modify column if exists gesture_long_click.width codec(T64, ZSTD(3)),
modify column if exists gesture_long_click.height codec(T64, ZSTD(3)),
modify column if exists gesture_long_click.x codec(Delta, ZSTD(3)),
modify column if exists gesture_long_click.y codec(Delta, ZSTD(3)),
modify column if exists gesture_click.target codec(ZSTD(3)),
modify column if exists gesture_click.target_id codec(ZSTD(3)),
modify column if exists gesture_click.touch_down_time codec(T64, ZSTD(3)),
modify column if exists gesture_click.touch_up_time codec(T64, ZSTD(3)),
modify column if exists gesture_click.width codec(Delta, ZSTD(3)),
modify column if exists gesture_click.height codec(Delta, ZSTD(3)),
modify column if exists gesture_click.x codec(Delta, ZSTD(3)),
modify column if exists gesture_click.y codec(Delta, ZSTD(3)),
modify column if exists gesture_scroll.target codec(ZSTD(3)),
modify column if exists gesture_scroll.target_id codec(ZSTD(3)),
modify column if exists gesture_scroll.touch_down_time codec(T64, ZSTD(3)),
modify column if exists gesture_scroll.touch_up_time codec(T64, ZSTD(3)),
modify column if exists gesture_scroll.x codec(Delta, ZSTD(3)),
modify column if exists gesture_scroll.y codec(Delta, ZSTD(3)),
modify column if exists gesture_scroll.end_x codec(Delta, ZSTD(3)),
modify column if exists gesture_scroll.end_y codec(Delta, ZSTD(3)),
modify column if exists gesture_scroll.direction LowCardinality(FixedString(8)) codec(ZSTD(3)),
modify column if exists lifecycle_activity.type LowCardinality(FixedString(32)) codec(ZSTD(3)),
modify column if exists lifecycle_activity.class_name codec(ZSTD(3)),
modify column if exists lifecycle_activity.intent codec(ZSTD(3)),
modify column if exists lifecycle_activity.saved_instance_state codec(ZSTD(3)),
modify column if exists lifecycle_fragment.type LowCardinality(FixedString(32)) codec(ZSTD(3)),
modify column if exists lifecycle_fragment.class_name codec(ZSTD(3)),
modify column if exists lifecycle_fragment.parent_activity codec(ZSTD(3)),
modify column if exists lifecycle_fragment.parent_fragment codec(ZSTD(3)),
modify column if exists lifecycle_fragment.tag codec(ZSTD(3)),
modify column if exists lifecycle_app.type LowCardinality(FixedString(32)) codec(ZSTD(3)),
modify column if exists cold_launch.process_start_uptime codec(T64, ZSTD(3)),
modify column if exists cold_launch.process_start_requested_uptime codec(T64, ZSTD(3)),
modify column if exists cold_launch.content_provider_attach_uptime codec(T64, ZSTD(3)),
modify column if exists cold_launch.on_next_draw_uptime codec(T64, ZSTD(3)),
modify column if exists cold_launch.launched_activity codec(ZSTD(3)),
modify column if exists cold_launch.has_saved_state codec(ZSTD(3)),
modify column if exists cold_launch.intent_data codec(ZSTD(3)),
modify column if exists cold_launch.duration codec(T64, ZSTD(3)),
modify column if exists cold_launch.app_visible_uptime codec(T64, ZSTD(3)),
modify column if exists warm_launch.process_start_uptime codec(T64, ZSTD(3)),
modify column if exists warm_launch.process_start_requested_uptime codec(T64, ZSTD(3)),
modify column if exists warm_launch.content_provider_attach_uptime codec(T64, ZSTD(3)),
modify column if exists warm_launch.on_next_draw_uptime codec(ZSTD(3)),
modify column if exists warm_launch.launched_activity codec(ZSTD(3)),
modify column if exists warm_launch.has_saved_state codec(ZSTD(3)),
modify column if exists warm_launch.intent_data codec(ZSTD(3)),
modify column if exists warm_launch.duration codec(T64, ZSTD(3)),
modify column if exists warm_launch.is_lukewarm codec(ZSTD(3)),
modify column if exists hot_launch.app_visible_uptime codec(T64, ZSTD(3)),
modify column if exists hot_launch.on_next_draw_uptime codec(T64, ZSTD(3)),
modify column if exists hot_launch.launched_activity codec(ZSTD(3)),
modify column if exists hot_launch.has_saved_state codec(ZSTD(3)),
modify column if exists hot_launch.intent_data codec(ZSTD(3)),
modify column if exists hot_launch.duration codec(T64, ZSTD(3)),
modify column if exists network_change.network_type codec(ZSTD(3)),
modify column if exists network_change.previous_network_type codec(ZSTD(3)),
modify column if exists network_change.network_generation codec(ZSTD(3)),
modify column if exists network_change.previous_network_generation codec(ZSTD(3)),
modify column if exists network_change.network_provider codec(ZSTD(3)),
modify column if exists http.url codec(ZSTD(3)),
modify column if exists http.method codec(ZSTD(3)),
modify column if exists http.status_code codec(T64, ZSTD(3)),
modify column if exists http.start_time codec(T64, ZSTD(3)),
modify column if exists http.end_time codec(T64, ZSTD(3)),
modify column if exists http_request_headers codec(ZSTD(3)),
modify column if exists http_response_headers codec(ZSTD(3)),
modify column if exists http.request_body codec(ZSTD(3)),
modify column if exists http.response_body codec(ZSTD(3)),
modify column if exists http.failure_reason codec(ZSTD(3)),
modify column if exists http.failure_description codec(ZSTD(3)),
modify column if exists http.client codec(ZSTD(3)),
modify column if exists memory_usage.java_max_heap codec(T64, ZSTD(3)),
modify column if exists memory_usage.java_total_heap codec(T64, ZSTD(3)),
modify column if exists memory_usage.java_free_heap codec(T64, ZSTD(3)),
modify column if exists memory_usage.total_pss codec(T64, ZSTD(3)),
modify column if exists memory_usage.rss codec(T64, ZSTD(3)),
modify column if exists memory_usage.native_total_heap codec(T64, ZSTD(3)),
modify column if exists memory_usage.native_free_heap codec(T64, ZSTD(3)),
modify column if exists memory_usage.interval codec(T64, ZSTD(3)),
modify column if exists low_memory.java_max_heap codec(T64, ZSTD(3)),
modify column if exists low_memory.java_total_heap codec(T64, ZSTD(3)),
modify column if exists low_memory.java_free_heap codec(T64, ZSTD(3)),
modify column if exists low_memory.total_pss codec(T64, ZSTD(3)),
modify column if exists low_memory.rss codec(T64, ZSTD(3)),
modify column if exists low_memory.native_total_heap codec(T64, ZSTD(3)),
modify column if exists low_memory.native_free_heap codec(T64, ZSTD(3)),
modify column if exists trim_memory.level codec(ZSTD(3)),
modify column if exists cpu_usage.num_cores codec(T64, ZSTD(3)),
modify column if exists cpu_usage.clock_speed codec(T64, ZSTD(3)),
modify column if exists cpu_usage.start_time codec(T64, ZSTD(3)),
modify column if exists cpu_usage.uptime codec(T64, ZSTD(3)),
modify column if exists cpu_usage.utime codec(T64, ZSTD(3)),
modify column if exists cpu_usage.cutime codec(T64, ZSTD(3)),
modify column if exists cpu_usage.stime codec(T64, ZSTD(3)),
modify column if exists cpu_usage.cstime codec(T64, ZSTD(3)),
modify column if exists cpu_usage.interval codec(T64, ZSTD(3)),
modify column if exists cpu_usage.percentage_usage codec(DoubleDelta, ZSTD(3)),
modify column if exists navigation.to codec(ZSTD(3)),
modify column if exists navigation.from codec(ZSTD(3)),
modify column if exists navigation.source codec(ZSTD(3)),
modify column if exists screen_view.name codec(ZSTD(3)),
modify column if exists attachments codec(ZSTD(3));


-- migrate:down
alter table events
modify column if exists id codec(NONE),
modify column if exists type codec(NONE),
modify column if exists session_id codec(NONE),
modify column if exists inet.ipv4 codec(NONE),
modify column if exists inet.ipv6 codec(NONE),
modify column if exists inet.country_code FixedString(8) codec(NONE),
modify column if exists timestamp codec(NONE),
modify column if exists user_triggered codec(NONE),
modify column if exists attribute.installation_id codec(NONE),
modify column if exists attribute.app_version FixedString(128) codec(NONE),
modify column if exists attribute.app_build codec(NONE),
modify column if exists attribute.app_unique_id FixedString(128) codec(NONE),
modify column if exists attribute.platform codec(NONE),
modify column if exists attribute.measure_sdk_version codec(NONE),
modify column if exists attribute.thread_name codec(NONE),
modify column if exists attribute.user_id codec(NONE),
modify column if exists attribute.device_name codec(NONE),
modify column if exists attribute.device_model codec(NONE),
modify column if exists attribute.device_manufacturer codec(NONE),
modify column if exists attribute.device_type codec(NONE),
modify column if exists attribute.device_is_foldable codec(NONE),
modify column if exists attribute.device_is_physical codec(NONE),
modify column if exists attribute.device_density_dpi codec(NONE),
modify column if exists attribute.device_width_px codec(NONE),
modify column if exists attribute.device_height_px codec(NONE),
modify column if exists attribute.device_density codec(NONE),
modify column if exists attribute.device_locale FixedString(64) codec(NONE),
modify column if exists attribute.os_name FixedString(32) codec(NONE),
modify column if exists attribute.os_version codec(NONE),
modify column if exists attribute.os_page_size codec(NONE),
modify column if exists attribute.network_type codec(NONE),
modify column if exists attribute.network_generation codec(NONE),
modify column if exists attribute.network_provider codec(NONE),
modify column if exists anr.handled codec(NONE),
modify column if exists anr.fingerprint codec(NONE),
modify column if exists anr.exceptions codec(NONE),
modify column if exists anr.threads codec(NONE),
modify column if exists anr.foreground codec(NONE),
modify column if exists exception.handled codec(NONE),
modify column if exists exception.fingerprint codec(NONE),
modify column if exists exception.exceptions codec(NONE),
modify column if exists exception.threads codec(NONE),
modify column if exists exception.foreground codec(NONE),
modify column if exists app_exit.reason codec(NONE),
modify column if exists app_exit.importance codec(NONE),
modify column if exists app_exit.trace codec(NONE),
modify column if exists app_exit.process_name codec(NONE),
modify column if exists app_exit.pid codec(NONE),
modify column if exists string.severity_text codec(NONE),
modify column if exists string.string codec(NONE),
modify column if exists gesture_long_click.target codec(NONE),
modify column if exists gesture_long_click.target_id codec(NONE),
modify column if exists gesture_long_click.touch_down_time codec(NONE),
modify column if exists gesture_long_click.touch_up_time codec(NONE),
modify column if exists gesture_long_click.width codec(NONE),
modify column if exists gesture_long_click.height codec(NONE),
modify column if exists gesture_long_click.x codec(NONE),
modify column if exists gesture_long_click.y codec(NONE),
modify column if exists gesture_click.target codec(NONE),
modify column if exists gesture_click.target_id codec(NONE),
modify column if exists gesture_click.touch_down_time codec(NONE),
modify column if exists gesture_click.touch_up_time codec(NONE),
modify column if exists gesture_click.width codec(NONE),
modify column if exists gesture_click.height codec(NONE),
modify column if exists gesture_click.x codec(NONE),
modify column if exists gesture_click.y codec(NONE),
modify column if exists gesture_scroll.target codec(NONE),
modify column if exists gesture_scroll.target_id codec(NONE),
modify column if exists gesture_scroll.target_down_time codec(NONE),
modify column if exists gesture_scroll.target_up_time codec(NONE),
modify column if exists gesture_scroll.x codec(NONE),
modify column if exists gesture_scroll.y codec(NONE),
modify column if exists gesture_scroll.end_x codec(NONE),
modify column if exists gesture_scroll.end_y codec(NONE),
modify column if exists gesture_scroll.direction FixedString(8) codec(NONE),
modify column if exists lifecycle_activity.type FixedString(32) codec(NONE),
modify column if exists lifecycle_activity.class_name codec(NONE),
modify column if exists lifecycle_activity.intent codec(NONE),
modify column if exists lifecycle_activity.saved_instance_state codec(NONE),
modify column if exists lifecycle_fragment.type FixedString(32) codec(NONE),
modify column if exists lifecycle_fragment.class_name codec(NONE),
modify column if exists lifecycle_fragment.parent_activity codec(NONE),
modify column if exists lifecycle_fragment.parent_fragment codec(NONE),
modify column if exists lifecycle_fragment.tag codec(NONE),
modify column if exists lifecycle_app.type FixedString(32) codec(NONE),
modify column if exists cold_launch.process_start_uptime codec(NONE),
modify column if exists cold_launch.process_start_requested_uptime codec(NONE),
modify column if exists cold_launch.content_provider_attach_uptime codec(NONE),
modify column if exists cold_launch.on_next_draw_uptime codec(NONE),
modify column if exists cold_launch.launched_activity codec(NONE),
modify column if exists cold_launch.has_saved_state codec(NONE),
modify column if exists cold_launch.intent_data codec(NONE),
modify column if exists cold_launch.duration codec(NONE),
modify column if exists cold_launch.app_visible_uptime codec(NONE),
modify column if exists warm_launch.process_start_uptime codec(NONE),
modify column if exists warm_launch.process_start_requested_uptime codec(NONE),
modify column if exists warm_launch.content_provider_attach_uptime codec(NONE),
modify column if exists warm_launch.on_next_draw_uptime codec(NONE),
modify column if exists warm_launch.launched_activity codec(NONE),
modify column if exists warm_launch.has_saved_state codec(NONE),
modify column if exists warm_launch.intent_data codec(NONE),
modify column if exists warm_launch.duration codec(NONE),
modify column if exists warm_launch.is_lukewarm codec(NONE),
modify column if exists hot_launch.app_visible_uptime codec(NONE),
modify column if exists hot_launch.on_next_draw_uptime codec(NONE),
modify column if exists hot_launch.launched_activity codec(NONE),
modify column if exists hot_launch.has_saved_state codec(NONE),
modify column if exists hot_launch.intent_data codec(NONE),
modify column if exists hot_launch.duration codec(NONE),
modify column if exists network_change.network_type codec(NONE),
modify column if exists network_change.previous_network_type codec(NONE),
modify column if exists network_change.network_generation codec(NONE),
modify column if exists network_change.previous_network_generation codec(NONE),
modify column if exists network_change.network_provider codec(NONE),
modify column if exists http.url codec(NONE),
modify column if exists http.method codec(NONE),
modify column if exists http.status_code codec(NONE),
modify column if exists http.start_time codec(NONE),
modify column if exists http.end_time codec(NONE),
modify column if exists http_request_headers codec(NONE),
modify column if exists http_response_headers codec(NONE),
modify column if exists http.request_body codec(NONE),
modify column if exists http.response_body codec(NONE),
modify column if exists http.failure_reason codec(NONE),
modify column if exists http.failure_description codec(NONE),
modify column if exists http.client codec(NONE),
modify column if exists memory_usage.java_max_heap codec(NONE),
modify column if exists memory_usage.java_total_heap codec(NONE),
modify column if exists memory_usage.java_free_heap codec(NONE),
modify column if exists memory_usage.total_pss codec(NONE),
modify column if exists memory_usage.rss codec(NONE),
modify column if exists memory_usage.native_total_heap codec(NONE),
modify column if exists memory_usage.native_free_heap codec(NONE),
modify column if exists memory_usage.interval codec(NONE),
modify column if exists low_memory.java_max_heap codec(NONE),
modify column if exists low_memory.java_total_heap codec(NONE),
modify column if exists low_memory.java_free_heap codec(NONE),
modify column if exists low_memory.total_pss codec(NONE),
modify column if exists low_memory.rss codec(NONE),
modify column if exists low_memory.native_total_heap codec(NONE),
modify column if exists low_memory.native_free_heap codec(NONE),
modify column if exists trim_memory.level codec(NONE),
modify column if exists cpu_usage.num_cores codec(NONE),
modify column if exists cpu_usage.clock_speed codec(NONE),
modify column if exists cpu_usage.start_time codec(NONE),
modify column if exists cpu_usage.uptime codec(NONE),
modify column if exists cpu_usage.utime codec(NONE),
modify column if exists cpu_usage.cutime codec(NONE),
modify column if exists cpu_usage.stime codec(NONE),
modify column if exists cpu_usage.cstime codec(NONE),
modify column if exists cpu_usage.interval codec(NONE),
modify column if exists cpu_usage.percentage_usage codec(NONE),
modify column if exists navigation.to codec(NONE),
modify column if exists navigation.from codec(NONE),
modify column if exists navigation.source codec(NONE),
modify column if exists screen_view.name codec(NONE),
modify column if exists attachments codec(NONE);

