# Measure Android Gradle Plugin

Measure Android Gradle Plugin is used to complement the features of Measure Android SDK. To integrate Measure in your
project, please follow the instructions in the [README](README.md#getting-started).

* [Features](#features)
  * [Automatic Instrumentation](#automatic-instrumentation)
    * [OkHttp](#okhttp)
    * [AndroidX Navigation](#androidx-navigation)
  * [Mapping Files Upload](#mapping-files-upload)
  * [App Size](#app-size)
* [Configuration](#configuration)

# Features

## Automatic Instrumentation

Most instrumentation is done directly in the Measure SDK. However, in some cases, the code to instrument is either in a
third party library or requires a lot of manual events to be added.
This gradle plugin makes Measure a drop-in solution, by using bytecode manipulation to automatically instrument your
app, using [ASM](https://asm.ow2.io/). ASM is a heavily used tool in the Java ecosystem, and is used by Android Gradle
Plugin and AndroidX libraries itself to transform classes.

We apply the following transformations to your app, provided your app uses these dependencies:

### OkHttp

* Minimum supported version: `4.7.0`
* Maximum supported version: `5.0.0-alpha.14`

Enables tracking network requests and metrics from OkHttp.
This is done by injecting an [Interceptor](https://square.github.io/okhttp/features/interceptors/)
and an [EventListener](https://square.github.io/okhttp/features/events/#eventlistener) into
all `OkHttpClient's`used by your application, including the ones in third party libraries.

Note that, OkHttp allows only one `EventListener`(https://square.github.io/okhttp/features/events/#eventlistener). If
you already set one, it will continue working as is. Measure plugin does not override it, rather delegates all callbacks
to it.

### AndroidX Navigation

* Minimum supported version: `2.4.0`
* Maximum supported version: `2.8.0-beta06`

Automatically tracks screen transition events from
the [AndroidX Navigation](https://developer.android.com/guide/navigation)
library. This is done by automatically
adding [NavController.OnDestinationChangedListener](https://developer.android.com/reference/androidx/navigation/NavController.OnDestinationChangedListener)
to all the `NavHostController's` in your app.

## Mapping Files Upload

> [!TIP]
> Make sure `sh.measure.android.API_KEY` is set in the manifest file of your app for this feature to work. Without this
> the build will fail.


Measure requires the mapping files generated by Proguard or R8 to de-obfuscate stack traces for
providing meaningful crash reports. The plugin automatically uploads these mapping files to Measure.

This feature works automatically for any app which has `minifyEnabled` set to true. The gradle plugin will upload the
mapping files to Measure after a `assemble<Variant>` or `bundle<Variant>` task completes successfully.

As of now only Proguard/R8 are supported.

## App Size

Measure automatically calculates and tracks the size of your app over time. Measure supports tracking size for both APKs
and AABs. The plugin automatically uploads the size information to Measure after a `assemble<Variant>`
or `bundle<Variant>` task completes successfully.

### APK Size

The plugin calculates APK size by using
apkanalyzer [download-size](https://developer.android.com/tools/apkanalyzer#commands) command, which is the
same tool used by Android Studio to calculate APK sizes. The APK size captured represents the estimated download size of
the APK for the end user.

### AAB Size

The plugin calculates AAB size by using bundletool's [get-size total](https://developer.android.com/tools/bundletool)
command. The AAB size captured represents the maximum size of the APK that can be generated from the AAB.

Read more about AAB format [here](https://developer.android.com/guide/app-bundle).

# Configuration

Measure Android Gradle Plugin can be configured in the `build.gradle` file of your app module. The plugin is applied
to all variants of your app by default. To disable the plugin for a specific variant, you can use the `measure` block.
For example, to disable the plugin for debug variants, you can use the following configuration:

```groovy
measure {
    variantFilter {
        if (name.contains("debug")) {
            enabled = false
        }
    }
}
```
