# Symbolication

Android allows developers to obfuscate their Kotlin/Java code
using [Proguard/R8](https://developer.android.com/build/shrink-code) by setting `minifyEnabled` to `true`
in `build.gradle`. This makes the stacktraces difficult to read and understand as the original class names and method
names are changed.

Measure can automatically de-obfuscate the stacktraces and show the names. This is made possible by
the Measure Gradle plugin, which uploads the mapping file generated by Proguard/R8 to the Measure server at build time.
Internally Measure uses [Retrace](https://developer.android.com/tools/retrace) to de-obfuscate the stacktraces.

Read more about Measure Gradle Plugin [here](../../../android/measure-android-gradle/README.md#upload-mapping-files).

> [!NOTE]  
> Apps obfuscated using Dexguard are not supported yet, but it will be added soon. Track the
> progress [here](https://github.com/measure-sh/measure/issues/549).
