# Feature - App Exit Info

[App Exit Info](https://developer.android.com/reference/android/app/ApplicationExitInfo) was added in API level 30.

App exit info provides the reason why the application process was killed, which could happen formany reasons, including
low memory, crash, ANR, etc.

Along with the reason it also provides information
about [importance](https://developer.android.com/reference/android/app/ActivityManager.RunningAppProcessInfo#constants_1)
of the process at the time of death, which can be useful information to debug ANRs, OOMs and other issues.

App Exit Info can also optionally contain stack traces if the reason for process death was ANR. This trace contains
information about the threads and their state at the time of ANR. A sample snippet from a trace:

```
"main" prio=5 tid=1 Blocked
  at sh.measure.sample.ExceptionDemoActivity.deadLock$lambda$10(ExceptionDemoActivity.kt:66)
  - waiting to lock <0x0a293e9f> (a java.lang.Object) held by thread 22
  at sh.measure.sample.ExceptionDemoActivity.$r8$lambda$kc26SdTV_Hqz6i5PLOpVXKS016U(unavailable:0)
  at sh.measure.sample.ExceptionDemoActivity$$ExternalSyntheticLambda9.run(unavailable:2)
  at android.os.Handler.handleCallback(Handler.java:942)
  at android.os.Handler.dispatchMessage(Handler.java:99)
  at android.os.Looper.loopOnce(Looper.java:201)
  at android.os.Looper.loop(Looper.java:288)
  at android.app.ActivityThread.main(ActivityThread.java:7872)
  at java.lang.reflect.Method.invoke(Native method)
  at com.android.internal.os.RuntimeInit$MethodAndArgsCaller.run(RuntimeInit.java:548)
  at com.android.internal.os.ZygoteInit.main(ZygoteInit.java:936)


"APP: Locker" prio=5 tid=22 Sleeping
  at java.lang.Thread.sleep(Native method)
  - sleeping on <0x06290e31> (a java.lang.Object)
  at java.lang.Thread.sleep(Thread.java:450)
  - locked <0x06290e31> (a java.lang.Object)
  at java.lang.Thread.sleep(Thread.java:355)
  at sh.measure.sample.ExceptionDemoActivity.sleep(ExceptionDemoActivity.kt:86)
  at sh.measure.sample.ExceptionDemoActivity.access$sleep(ExceptionDemoActivity.kt:12)
  at sh.measure.sample.ExceptionDemoActivity$LockerThread.run(ExceptionDemoActivity.kt:80)
  - locked <0x0a293e9f> (a java.lang.Object)
```

Notice that the "main" thread is blocked and is "waiting to lock" held by "thread 22". Checking the state of `tid=22`
shows that it's in "Sleeping" state due a `Thread.sleep` call and is holding the lock on the same object (0x0a293e9f)
that "main" thread is waiting for. Thereby, leading to a deadlock, and an ANR.

> [!NOTE]  
> Starting from API 31, for Native crashes, App Exit Info contains
> the [tombstone](https://source.android.com/docs/core/tests/debug) stack trace. Support for native crash reports is
> not yet implemented and will be coming soon. Track the
> updates [here](https://github.com/measure-sh/measure/issues/103).

## How it works

App exit info is read
from [ActivityManager.getHistoricalProcessExitReasons](https://developer.android.com/reference/kotlin/android/app/ActivityManager#gethistoricalprocessexitreasons)
and sent to the Measure server.

Note that App Exit Info is generated by the system and is stored in a ring buffer, there can be cases where App Exit
Info for a process has been cleared out before we had a chance to send it to Measure.

## Data collected

Checkout all the data collected for App Exit in the [App Exit Event](../../api/sdk/README.md#appexit)
section.
