<p align="center">
  <a href='http://measure.sh'><img alt="measurelogo" src="https://github.com/user-attachments/assets/6d6b161d-653a-4027-83e2-f749140d13d6"></a>
</p>
<p align="center">
  <a href='http://makeapullrequest.com'><img alt='PRs Welcome' src='https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=shields'/></a>
  <img alt="GitHub commit activity" src="https://img.shields.io/github/commit-activity/m/measure-sh/measure"/>
  <img alt="GitHub closed issues" src="https://img.shields.io/github/issues-closed/measure-sh/measure"/>
</p>

## Measure is an open source tool to monitor mobile apps

- Capture Crashes and ANRs automatically
- Monitor app health metrics such as launch times, crash rates and app sizes 
- Get screenshots with exception reports
- View full event timelines of error sessions with auto-tracked user clicks, navigation events, http calls, cpu usage, memory usage and more for deeper context
- Track custom events with additional business specific attributes
- Self hosted and private. Your data stays in your servers


## Table of Contents
- [Quick start](#quick-start)
- [Features](#features)
  - [Session Timelines](#session-timelines)
  - [User Journeys](#user-journeys)
  - [App Health](#app-health)
  - [Crashes and ANRs](#crashes-and-anrs)
- [Philosophy](#philosophy)
- [Support the project](#support-the-project)
- [Docs](#docs)
- [Platforms](#platforms)
- [Roadmap](#roadmap)
- [Open Source](#open-source)
- [Discord](#discord)
- [Team](#team)

## Quick start

Measure is available as a self hosted platform that comes with a simple one line install script. Check out our [Self hosting](./docs/hosting/README.md) and [Android SDK](./docs/android/README.md) guides.

## Features

### Session Timelines

Debug issues easily with full session timelines. Get the complete context with automatic tracking for clicks, navigations, http calls and more.

[Session Timelines demo](https://github.com/user-attachments/assets/e8bac17c-c8c7-4f19-81e3-1979c7e70969)

### User Journeys

Understand how users move through your app. Easily visualise screens most affected by issues.

[Journey demo](https://github.com/user-attachments/assets/54a0f7c5-d078-4e67-a5df-0ae73b2309c9)

### App Health

Monitor important metrics to stay on top of app health. Quickly see deltas to make sure you're moving in the right direction.

[App Health demo](https://github.com/user-attachments/assets/a6e7b57d-2dc8-4671-a461-6708921fdd72)

### Crashes and ANRs

Automatically track Crashes and ANRs. Dive deeper with screenshots, filters and detailed stacktraces

[Crashes and ANRs demo](https://github.com/user-attachments/assets/fb8e3c67-f263-41d7-b547-1f9d09c90ae0)


⭐ If you find Measure useful, please consider [starring this repo!](https://github.com/measure-sh/measure)

## Philosophy

Our mission is to build the best tool for monitoring mobile apps. 

Building and maintaining mobile apps in production is hard and developers need to use a variety of different tools to collect issues, measure performance and analyse user behavior without having any control over where, how and for how long their data is stored. 

We aim to build a tool that unifies and simplifies monitoring capabilities for mobile teams while providing full control over 
the collection and storage of data.

We operate in public as much as possible and we aim to be community focused and driven by feedback from real developers building in the trenches.

We would love for you to contribute to Measure by opening issues, sending PRs and recommending us to your friends! 

## Support the project

If you want to support the project and get updates on new features and releases, please ⭐ this repo and share it with your friends!

## Docs

1. [**Self Hosting Guide**](./docs/hosting/README.md) - Get started with hosting Measure
2. [**Android SDK Guide**](./android/README.md) - Integrate our Android SDK and start measuring in no time
3. [**REST API Docs**](./docs/api/README.md) - REST APIs used by the dashboard app and SDKs
4. [**Versioning Guide**](./docs/versioning/README.md) - Understand how versions are tagged
5. [**Contribution Guide**](./docs/CONTRIBUTING.md) - Contribute to Measure


## Platforms

Currently, we support Android with iOS, Flutter and React Native SDKs planned for the future.

## Roadmap

Check out what's being worked on and what's in the pipeline in our [Roadmap](https://github.com/orgs/measure-sh/projects/5/views/1)

## Open Source

Measure is fully open source and is available under the [Apache 2.0 license](./LICENSE)

## Discord

Come say hi on our [Discord](https://discord.gg/f6zGkBCt42)

## Team

- Gandharva Kumar - [GitHub](https://github.com/gandharva) • [X](https://x.com/gandharva) • [LinkedIn](https://www.linkedin.com/in/gandharvakr/)
- Anup Cowkur - [GitHub](https://github.com/anupcowkur) • [X](https://x.com/anupcowkur) • [LinkedIn](https://www.linkedin.com/in/anupcowkur/)
- Debjeet Biswas - [GitHub](https://github.com/detj) • [X](https://x.com/detj) • [LinkedIn](https://www.linkedin.com/in/debjeet-biswas-9b4337281/)
- Abhay Sood - [GitHub](https://github.com/abhaysood) • [X](https://x.com/abhaysood_) • [LinkedIn](https://www.linkedin.com/in/abhaysood/)
- Adwin Ross - [GitHub](https://github.com/adwinross) • [X](https://x.com/adwinross) • [LinkedIn](https://www.linkedin.com/in/adwin-ronald-ross-0879898b/)
