"""added plural names and alias tables for foods and units

Revision ID: ba1e4a6cfe99
Revises: dded3119c1fe
Create Date: 2023-10-19 19:22:55.369319

"""

import sqlalchemy as sa

import mealie.db.migration_types
from alembic import op

# revision identifiers, used by Alembic.
revision = "ba1e4a6cfe99"
down_revision = "dded3119c1fe"
branch_labels: str | tuple[str, ...] | None = None
depends_on: str | tuple[str, ...] | None = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "ingredient_units_aliases",
        sa.Column("id", mealie.db.migration_types.GUID(), nullable=False),
        sa.Column("unit_id", mealie.db.migration_types.GUID(), nullable=False),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column("name_normalized", sa.String(), nullable=True),
        sa.Column("created_at", sa.DateTime(), nullable=True),
        sa.Column("update_at", sa.DateTime(), nullable=True),
        sa.ForeignKeyConstraint(
            ["unit_id"],
            ["ingredient_units.id"],
        ),
        sa.PrimaryKeyConstraint("id", "unit_id"),
    )
    op.create_index(
        op.f("ix_ingredient_units_aliases_created_at"), "ingredient_units_aliases", ["created_at"], unique=False
    )
    op.create_index(
        op.f("ix_ingredient_units_aliases_name_normalized"),
        "ingredient_units_aliases",
        ["name_normalized"],
        unique=False,
    )
    op.create_table(
        "ingredient_foods_aliases",
        sa.Column("id", mealie.db.migration_types.GUID(), nullable=False),
        sa.Column("food_id", mealie.db.migration_types.GUID(), nullable=False),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column("name_normalized", sa.String(), nullable=True),
        sa.Column("created_at", sa.DateTime(), nullable=True),
        sa.Column("update_at", sa.DateTime(), nullable=True),
        sa.ForeignKeyConstraint(
            ["food_id"],
            ["ingredient_foods.id"],
        ),
        sa.PrimaryKeyConstraint("id", "food_id"),
    )
    op.create_index(
        op.f("ix_ingredient_foods_aliases_created_at"), "ingredient_foods_aliases", ["created_at"], unique=False
    )
    op.create_index(
        op.f("ix_ingredient_foods_aliases_name_normalized"),
        "ingredient_foods_aliases",
        ["name_normalized"],
        unique=False,
    )
    op.add_column("ingredient_foods", sa.Column("plural_name", sa.String(), nullable=True))
    op.add_column("ingredient_foods", sa.Column("plural_name_normalized", sa.String(), nullable=True))
    op.create_index(
        op.f("ix_ingredient_foods_plural_name_normalized"), "ingredient_foods", ["plural_name_normalized"], unique=False
    )
    op.add_column("ingredient_units", sa.Column("plural_name", sa.String(), nullable=True))
    op.add_column("ingredient_units", sa.Column("plural_name_normalized", sa.String(), nullable=True))
    op.create_index(
        op.f("ix_ingredient_units_plural_name_normalized"), "ingredient_units", ["plural_name_normalized"], unique=False
    )
    op.add_column("ingredient_units", sa.Column("plural_abbreviation", sa.String(), nullable=True))
    op.add_column("ingredient_units", sa.Column("plural_abbreviation_normalized", sa.String(), nullable=True))
    op.create_index(
        op.f("ix_ingredient_units_plural_abbreviation_normalized"),
        "ingredient_units",
        ["plural_abbreviation_normalized"],
        unique=False,
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_ingredient_units_plural_abbreviation_normalized"), table_name="ingredient_units")
    op.drop_column("ingredient_units", "plural_abbreviation_normalized")
    op.drop_column("ingredient_units", "plural_abbreviation")
    op.drop_index(op.f("ix_ingredient_units_plural_name_normalized"), table_name="ingredient_units")
    op.drop_column("ingredient_units", "plural_name_normalized")
    op.drop_column("ingredient_units", "plural_name")
    op.drop_index(op.f("ix_ingredient_foods_plural_name_normalized"), table_name="ingredient_foods")
    op.drop_column("ingredient_foods", "plural_name_normalized")
    op.drop_column("ingredient_foods", "plural_name")
    op.drop_index(op.f("ix_ingredient_foods_aliases_name_normalized"), table_name="ingredient_foods_aliases")
    op.drop_index(op.f("ix_ingredient_foods_aliases_created_at"), table_name="ingredient_foods_aliases")
    op.drop_table("ingredient_foods_aliases")
    op.drop_index(op.f("ix_ingredient_units_aliases_name_normalized"), table_name="ingredient_units_aliases")
    op.drop_index(op.f("ix_ingredient_units_aliases_created_at"), table_name="ingredient_units_aliases")
    op.drop_table("ingredient_units_aliases")
    # ### end Alembic commands ###
