"""add missing foreign key and order indices

Revision ID: ff5f73b01a7a
Revises: 165d943c64ee
Create Date: 2023-02-07 20:57:21.066927

"""

from alembic import op

# revision identifiers, used by Alembic.
revision = "ff5f73b01a7a"
down_revision = "165d943c64ee"
branch_labels: str | tuple[str, ...] | None = None
depends_on: str | tuple[str, ...] | None = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_index(op.f("ix_api_extras_created_at"), "api_extras", ["created_at"], unique=False)
    op.create_index(op.f("ix_api_extras_recipee_id"), "api_extras", ["recipee_id"], unique=False)
    op.create_index(op.f("ix_categories_created_at"), "categories", ["created_at"], unique=False)
    op.create_index(op.f("ix_cookbooks_created_at"), "cookbooks", ["created_at"], unique=False)
    op.create_index(op.f("ix_cookbooks_group_id"), "cookbooks", ["group_id"], unique=False)
    op.create_index(op.f("ix_cookbooks_slug"), "cookbooks", ["slug"], unique=False)
    op.create_index(
        op.f("ix_cookbooks_to_categories_category_id"), "cookbooks_to_categories", ["category_id"], unique=False
    )
    op.create_index(
        op.f("ix_cookbooks_to_categories_cookbook_id"), "cookbooks_to_categories", ["cookbook_id"], unique=False
    )
    op.create_index(op.f("ix_cookbooks_to_tags_cookbook_id"), "cookbooks_to_tags", ["cookbook_id"], unique=False)
    op.create_index(op.f("ix_cookbooks_to_tags_tag_id"), "cookbooks_to_tags", ["tag_id"], unique=False)
    op.create_index(op.f("ix_cookbooks_to_tools_cookbook_id"), "cookbooks_to_tools", ["cookbook_id"], unique=False)
    op.create_index(op.f("ix_cookbooks_to_tools_tool_id"), "cookbooks_to_tools", ["tool_id"], unique=False)
    op.create_index(op.f("ix_group_data_exports_created_at"), "group_data_exports", ["created_at"], unique=False)
    op.create_index(
        op.f("ix_group_events_notifier_options_created_at"),
        "group_events_notifier_options",
        ["created_at"],
        unique=False,
    )
    op.create_index(
        op.f("ix_group_events_notifiers_created_at"), "group_events_notifiers", ["created_at"], unique=False
    )
    op.create_index(op.f("ix_group_meal_plan_rules_created_at"), "group_meal_plan_rules", ["created_at"], unique=False)
    op.create_index(op.f("ix_group_meal_plan_rules_group_id"), "group_meal_plan_rules", ["group_id"], unique=False)
    op.create_index(op.f("ix_group_meal_plans_created_at"), "group_meal_plans", ["created_at"], unique=False)
    op.create_index(op.f("ix_group_preferences_created_at"), "group_preferences", ["created_at"], unique=False)
    op.create_index(op.f("ix_group_reports_created_at"), "group_reports", ["created_at"], unique=False)
    op.create_index(op.f("ix_group_to_categories_category_id"), "group_to_categories", ["category_id"], unique=False)
    op.create_index(op.f("ix_group_to_categories_group_id"), "group_to_categories", ["group_id"], unique=False)
    op.create_index(op.f("ix_groups_created_at"), "groups", ["created_at"], unique=False)
    op.create_index(
        op.f("ix_ingredient_food_extras_created_at"), "ingredient_food_extras", ["created_at"], unique=False
    )
    op.create_index(
        op.f("ix_ingredient_food_extras_ingredient_food_id"),
        "ingredient_food_extras",
        ["ingredient_food_id"],
        unique=False,
    )
    op.create_index(op.f("ix_ingredient_foods_created_at"), "ingredient_foods", ["created_at"], unique=False)
    op.create_index(op.f("ix_ingredient_foods_group_id"), "ingredient_foods", ["group_id"], unique=False)
    op.create_index(op.f("ix_ingredient_foods_label_id"), "ingredient_foods", ["label_id"], unique=False)
    op.create_index(op.f("ix_ingredient_units_created_at"), "ingredient_units", ["created_at"], unique=False)
    op.create_index(op.f("ix_ingredient_units_group_id"), "ingredient_units", ["group_id"], unique=False)
    op.create_index(op.f("ix_invite_tokens_created_at"), "invite_tokens", ["created_at"], unique=False)
    op.create_index(op.f("ix_invite_tokens_group_id"), "invite_tokens", ["group_id"], unique=False)
    op.create_index(op.f("ix_long_live_tokens_created_at"), "long_live_tokens", ["created_at"], unique=False)
    op.create_index(op.f("ix_long_live_tokens_token"), "long_live_tokens", ["token"], unique=False)
    op.create_index(op.f("ix_long_live_tokens_user_id"), "long_live_tokens", ["user_id"], unique=False)
    op.create_index(op.f("ix_multi_purpose_labels_created_at"), "multi_purpose_labels", ["created_at"], unique=False)
    op.create_index(op.f("ix_notes_created_at"), "notes", ["created_at"], unique=False)
    op.create_index(op.f("ix_notes_recipe_id"), "notes", ["recipe_id"], unique=False)
    op.create_index(op.f("ix_password_reset_tokens_created_at"), "password_reset_tokens", ["created_at"], unique=False)
    op.create_index(op.f("ix_password_reset_tokens_user_id"), "password_reset_tokens", ["user_id"], unique=False)
    op.create_index(
        op.f("ix_plan_rules_to_categories_category_id"), "plan_rules_to_categories", ["category_id"], unique=False
    )
    op.create_index(
        op.f("ix_plan_rules_to_categories_group_plan_rule_id"),
        "plan_rules_to_categories",
        ["group_plan_rule_id"],
        unique=False,
    )
    op.create_index(op.f("ix_plan_rules_to_tags_plan_rule_id"), "plan_rules_to_tags", ["plan_rule_id"], unique=False)
    op.create_index(op.f("ix_plan_rules_to_tags_tag_id"), "plan_rules_to_tags", ["tag_id"], unique=False)
    op.create_index(op.f("ix_recipe_assets_created_at"), "recipe_assets", ["created_at"], unique=False)
    op.create_index(op.f("ix_recipe_assets_recipe_id"), "recipe_assets", ["recipe_id"], unique=False)
    op.create_index(op.f("ix_recipe_comments_created_at"), "recipe_comments", ["created_at"], unique=False)
    op.create_index(op.f("ix_recipe_comments_recipe_id"), "recipe_comments", ["recipe_id"], unique=False)
    op.create_index(op.f("ix_recipe_comments_user_id"), "recipe_comments", ["user_id"], unique=False)
    op.create_index(
        op.f("ix_recipe_ingredient_ref_link_created_at"), "recipe_ingredient_ref_link", ["created_at"], unique=False
    )
    op.create_index(
        op.f("ix_recipe_ingredient_ref_link_instruction_id"),
        "recipe_ingredient_ref_link",
        ["instruction_id"],
        unique=False,
    )
    op.create_index(
        op.f("ix_recipe_ingredient_ref_link_reference_id"), "recipe_ingredient_ref_link", ["reference_id"], unique=False
    )
    op.create_index(op.f("ix_recipe_instructions_created_at"), "recipe_instructions", ["created_at"], unique=False)
    op.create_index(op.f("ix_recipe_instructions_position"), "recipe_instructions", ["position"], unique=False)
    op.create_index(op.f("ix_recipe_instructions_recipe_id"), "recipe_instructions", ["recipe_id"], unique=False)
    op.create_index(op.f("ix_recipe_nutrition_created_at"), "recipe_nutrition", ["created_at"], unique=False)
    op.create_index(op.f("ix_recipe_nutrition_recipe_id"), "recipe_nutrition", ["recipe_id"], unique=False)
    op.create_index(op.f("ix_recipe_settings_created_at"), "recipe_settings", ["created_at"], unique=False)
    op.create_index(op.f("ix_recipe_settings_recipe_id"), "recipe_settings", ["recipe_id"], unique=False)
    op.create_index(op.f("ix_recipe_share_tokens_created_at"), "recipe_share_tokens", ["created_at"], unique=False)
    op.create_index(op.f("ix_recipe_share_tokens_recipe_id"), "recipe_share_tokens", ["recipe_id"], unique=False)
    op.create_index(
        op.f("ix_recipe_timeline_events_created_at"), "recipe_timeline_events", ["created_at"], unique=False
    )
    op.create_index(op.f("ix_recipe_timeline_events_recipe_id"), "recipe_timeline_events", ["recipe_id"], unique=False)
    op.create_index(op.f("ix_recipe_timeline_events_timestamp"), "recipe_timeline_events", ["timestamp"], unique=False)
    op.create_index(op.f("ix_recipe_timeline_events_user_id"), "recipe_timeline_events", ["user_id"], unique=False)
    op.create_index(op.f("ix_recipes_created_at"), "recipes", ["created_at"], unique=False)
    op.create_index(op.f("ix_recipes_name"), "recipes", ["name"], unique=False)
    op.create_index(op.f("ix_recipes_ingredients_created_at"), "recipes_ingredients", ["created_at"], unique=False)
    op.create_index(op.f("ix_recipes_ingredients_food_id"), "recipes_ingredients", ["food_id"], unique=False)
    op.create_index(op.f("ix_recipes_ingredients_position"), "recipes_ingredients", ["position"], unique=False)
    op.create_index(op.f("ix_recipes_ingredients_unit_id"), "recipes_ingredients", ["unit_id"], unique=False)
    op.create_index(
        op.f("ix_recipes_to_categories_category_id"), "recipes_to_categories", ["category_id"], unique=False
    )
    op.create_index(op.f("ix_recipes_to_categories_recipe_id"), "recipes_to_categories", ["recipe_id"], unique=False)
    op.create_index(op.f("ix_recipes_to_tags_recipe_id"), "recipes_to_tags", ["recipe_id"], unique=False)
    op.create_index(op.f("ix_recipes_to_tags_tag_id"), "recipes_to_tags", ["tag_id"], unique=False)
    op.create_index(op.f("ix_recipes_to_tools_recipe_id"), "recipes_to_tools", ["recipe_id"], unique=False)
    op.create_index(op.f("ix_recipes_to_tools_tool_id"), "recipes_to_tools", ["tool_id"], unique=False)
    op.create_index(op.f("ix_report_entries_created_at"), "report_entries", ["created_at"], unique=False)
    op.create_index(op.f("ix_report_entries_report_id"), "report_entries", ["report_id"], unique=False)
    op.create_index(op.f("ix_server_tasks_created_at"), "server_tasks", ["created_at"], unique=False)
    op.create_index(op.f("ix_shopping_list_extras_created_at"), "shopping_list_extras", ["created_at"], unique=False)
    op.create_index(
        op.f("ix_shopping_list_extras_shopping_list_id"), "shopping_list_extras", ["shopping_list_id"], unique=False
    )
    op.create_index(
        op.f("ix_shopping_list_item_extras_created_at"), "shopping_list_item_extras", ["created_at"], unique=False
    )
    op.create_index(
        op.f("ix_shopping_list_item_extras_shopping_list_item_id"),
        "shopping_list_item_extras",
        ["shopping_list_item_id"],
        unique=False,
    )
    op.create_index(
        op.f("ix_shopping_list_item_recipe_reference_created_at"),
        "shopping_list_item_recipe_reference",
        ["created_at"],
        unique=False,
    )
    op.create_index(op.f("ix_shopping_list_items_created_at"), "shopping_list_items", ["created_at"], unique=False)
    op.create_index(op.f("ix_shopping_list_items_position"), "shopping_list_items", ["position"], unique=False)
    op.create_index(
        op.f("ix_shopping_list_items_shopping_list_id"), "shopping_list_items", ["shopping_list_id"], unique=False
    )
    op.create_index(
        op.f("ix_shopping_list_recipe_reference_created_at"),
        "shopping_list_recipe_reference",
        ["created_at"],
        unique=False,
    )
    op.create_index(op.f("ix_shopping_lists_created_at"), "shopping_lists", ["created_at"], unique=False)
    op.create_index(op.f("ix_tags_created_at"), "tags", ["created_at"], unique=False)
    op.create_index(op.f("ix_tools_created_at"), "tools", ["created_at"], unique=False)
    op.create_index(op.f("ix_tools_group_id"), "tools", ["group_id"], unique=False)
    op.create_index(op.f("ix_users_created_at"), "users", ["created_at"], unique=False)
    op.create_index(op.f("ix_users_to_favorites_recipe_id"), "users_to_favorites", ["recipe_id"], unique=False)
    op.create_index(op.f("ix_users_to_favorites_user_id"), "users_to_favorites", ["user_id"], unique=False)
    op.create_index(op.f("ix_webhook_urls_created_at"), "webhook_urls", ["created_at"], unique=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_webhook_urls_created_at"), table_name="webhook_urls")
    op.drop_index(op.f("ix_users_to_favorites_user_id"), table_name="users_to_favorites")
    op.drop_index(op.f("ix_users_to_favorites_recipe_id"), table_name="users_to_favorites")
    op.drop_index(op.f("ix_users_created_at"), table_name="users")
    op.drop_index(op.f("ix_tools_group_id"), table_name="tools")
    op.drop_index(op.f("ix_tools_created_at"), table_name="tools")
    op.drop_index(op.f("ix_tags_created_at"), table_name="tags")
    op.drop_index(op.f("ix_shopping_lists_created_at"), table_name="shopping_lists")
    op.drop_index(op.f("ix_shopping_list_recipe_reference_created_at"), table_name="shopping_list_recipe_reference")
    op.drop_index(op.f("ix_shopping_list_items_shopping_list_id"), table_name="shopping_list_items")
    op.drop_index(op.f("ix_shopping_list_items_position"), table_name="shopping_list_items")
    op.drop_index(op.f("ix_shopping_list_items_created_at"), table_name="shopping_list_items")
    op.drop_index(
        op.f("ix_shopping_list_item_recipe_reference_created_at"), table_name="shopping_list_item_recipe_reference"
    )
    op.drop_index(op.f("ix_shopping_list_item_extras_shopping_list_item_id"), table_name="shopping_list_item_extras")
    op.drop_index(op.f("ix_shopping_list_item_extras_created_at"), table_name="shopping_list_item_extras")
    op.drop_index(op.f("ix_shopping_list_extras_shopping_list_id"), table_name="shopping_list_extras")
    op.drop_index(op.f("ix_shopping_list_extras_created_at"), table_name="shopping_list_extras")
    op.drop_index(op.f("ix_server_tasks_created_at"), table_name="server_tasks")
    op.drop_index(op.f("ix_report_entries_report_id"), table_name="report_entries")
    op.drop_index(op.f("ix_report_entries_created_at"), table_name="report_entries")
    op.drop_index(op.f("ix_recipes_to_tools_tool_id"), table_name="recipes_to_tools")
    op.drop_index(op.f("ix_recipes_to_tools_recipe_id"), table_name="recipes_to_tools")
    op.drop_index(op.f("ix_recipes_to_tags_tag_id"), table_name="recipes_to_tags")
    op.drop_index(op.f("ix_recipes_to_tags_recipe_id"), table_name="recipes_to_tags")
    op.drop_index(op.f("ix_recipes_to_categories_recipe_id"), table_name="recipes_to_categories")
    op.drop_index(op.f("ix_recipes_to_categories_category_id"), table_name="recipes_to_categories")
    op.drop_index(op.f("ix_recipes_ingredients_unit_id"), table_name="recipes_ingredients")
    op.drop_index(op.f("ix_recipes_ingredients_position"), table_name="recipes_ingredients")
    op.drop_index(op.f("ix_recipes_ingredients_food_id"), table_name="recipes_ingredients")
    op.drop_index(op.f("ix_recipes_ingredients_created_at"), table_name="recipes_ingredients")
    op.drop_index(op.f("ix_recipes_name"), table_name="recipes")
    op.drop_index(op.f("ix_recipes_created_at"), table_name="recipes")
    op.drop_index(op.f("ix_recipe_timeline_events_user_id"), table_name="recipe_timeline_events")
    op.drop_index(op.f("ix_recipe_timeline_events_timestamp"), table_name="recipe_timeline_events")
    op.drop_index(op.f("ix_recipe_timeline_events_recipe_id"), table_name="recipe_timeline_events")
    op.drop_index(op.f("ix_recipe_timeline_events_created_at"), table_name="recipe_timeline_events")
    op.drop_index(op.f("ix_recipe_share_tokens_recipe_id"), table_name="recipe_share_tokens")
    op.drop_index(op.f("ix_recipe_share_tokens_created_at"), table_name="recipe_share_tokens")
    op.drop_index(op.f("ix_recipe_settings_recipe_id"), table_name="recipe_settings")
    op.drop_index(op.f("ix_recipe_settings_created_at"), table_name="recipe_settings")
    op.drop_index(op.f("ix_recipe_nutrition_recipe_id"), table_name="recipe_nutrition")
    op.drop_index(op.f("ix_recipe_nutrition_created_at"), table_name="recipe_nutrition")
    op.drop_index(op.f("ix_recipe_instructions_recipe_id"), table_name="recipe_instructions")
    op.drop_index(op.f("ix_recipe_instructions_position"), table_name="recipe_instructions")
    op.drop_index(op.f("ix_recipe_instructions_created_at"), table_name="recipe_instructions")
    op.drop_index(op.f("ix_recipe_ingredient_ref_link_reference_id"), table_name="recipe_ingredient_ref_link")
    op.drop_index(op.f("ix_recipe_ingredient_ref_link_instruction_id"), table_name="recipe_ingredient_ref_link")
    op.drop_index(op.f("ix_recipe_ingredient_ref_link_created_at"), table_name="recipe_ingredient_ref_link")
    op.drop_index(op.f("ix_recipe_comments_user_id"), table_name="recipe_comments")
    op.drop_index(op.f("ix_recipe_comments_recipe_id"), table_name="recipe_comments")
    op.drop_index(op.f("ix_recipe_comments_created_at"), table_name="recipe_comments")
    op.drop_index(op.f("ix_recipe_assets_recipe_id"), table_name="recipe_assets")
    op.drop_index(op.f("ix_recipe_assets_created_at"), table_name="recipe_assets")
    op.drop_index(op.f("ix_plan_rules_to_tags_tag_id"), table_name="plan_rules_to_tags")
    op.drop_index(op.f("ix_plan_rules_to_tags_plan_rule_id"), table_name="plan_rules_to_tags")
    op.drop_index(op.f("ix_plan_rules_to_categories_group_plan_rule_id"), table_name="plan_rules_to_categories")
    op.drop_index(op.f("ix_plan_rules_to_categories_category_id"), table_name="plan_rules_to_categories")
    op.drop_index(op.f("ix_password_reset_tokens_user_id"), table_name="password_reset_tokens")
    op.drop_index(op.f("ix_password_reset_tokens_created_at"), table_name="password_reset_tokens")
    op.drop_index(op.f("ix_notes_recipe_id"), table_name="notes")
    op.drop_index(op.f("ix_notes_created_at"), table_name="notes")
    op.drop_index(op.f("ix_multi_purpose_labels_created_at"), table_name="multi_purpose_labels")
    op.drop_index(op.f("ix_long_live_tokens_user_id"), table_name="long_live_tokens")
    op.drop_index(op.f("ix_long_live_tokens_token"), table_name="long_live_tokens")
    op.drop_index(op.f("ix_long_live_tokens_created_at"), table_name="long_live_tokens")
    op.drop_index(op.f("ix_invite_tokens_group_id"), table_name="invite_tokens")
    op.drop_index(op.f("ix_invite_tokens_created_at"), table_name="invite_tokens")
    op.drop_index(op.f("ix_ingredient_units_group_id"), table_name="ingredient_units")
    op.drop_index(op.f("ix_ingredient_units_created_at"), table_name="ingredient_units")
    op.drop_index(op.f("ix_ingredient_foods_label_id"), table_name="ingredient_foods")
    op.drop_index(op.f("ix_ingredient_foods_group_id"), table_name="ingredient_foods")
    op.drop_index(op.f("ix_ingredient_foods_created_at"), table_name="ingredient_foods")
    op.drop_index(op.f("ix_ingredient_food_extras_ingredient_food_id"), table_name="ingredient_food_extras")
    op.drop_index(op.f("ix_ingredient_food_extras_created_at"), table_name="ingredient_food_extras")
    op.drop_index(op.f("ix_groups_created_at"), table_name="groups")
    op.drop_index(op.f("ix_group_to_categories_group_id"), table_name="group_to_categories")
    op.drop_index(op.f("ix_group_to_categories_category_id"), table_name="group_to_categories")
    op.drop_index(op.f("ix_group_reports_created_at"), table_name="group_reports")
    op.drop_index(op.f("ix_group_preferences_created_at"), table_name="group_preferences")
    op.drop_index(op.f("ix_group_meal_plans_created_at"), table_name="group_meal_plans")
    op.drop_index(op.f("ix_group_meal_plan_rules_group_id"), table_name="group_meal_plan_rules")
    op.drop_index(op.f("ix_group_meal_plan_rules_created_at"), table_name="group_meal_plan_rules")
    op.drop_index(op.f("ix_group_events_notifiers_created_at"), table_name="group_events_notifiers")
    op.drop_index(op.f("ix_group_events_notifier_options_created_at"), table_name="group_events_notifier_options")
    op.drop_index(op.f("ix_group_data_exports_created_at"), table_name="group_data_exports")
    op.drop_index(op.f("ix_cookbooks_to_tools_tool_id"), table_name="cookbooks_to_tools")
    op.drop_index(op.f("ix_cookbooks_to_tools_cookbook_id"), table_name="cookbooks_to_tools")
    op.drop_index(op.f("ix_cookbooks_to_tags_tag_id"), table_name="cookbooks_to_tags")
    op.drop_index(op.f("ix_cookbooks_to_tags_cookbook_id"), table_name="cookbooks_to_tags")
    op.drop_index(op.f("ix_cookbooks_to_categories_cookbook_id"), table_name="cookbooks_to_categories")
    op.drop_index(op.f("ix_cookbooks_to_categories_category_id"), table_name="cookbooks_to_categories")
    op.drop_index(op.f("ix_cookbooks_slug"), table_name="cookbooks")
    op.drop_index(op.f("ix_cookbooks_group_id"), table_name="cookbooks")
    op.drop_index(op.f("ix_cookbooks_created_at"), table_name="cookbooks")
    op.drop_index(op.f("ix_categories_created_at"), table_name="categories")
    op.drop_index(op.f("ix_api_extras_recipee_id"), table_name="api_extras")
    op.drop_index(op.f("ix_api_extras_created_at"), table_name="api_extras")
    # ### end Alembic commands ###
