"""add related user to mealplan

Revision ID: 165d943c64ee
Revises: 167eb69066ad
Create Date: 2023-01-21 16:54:44.368768

"""

import sqlalchemy as sa

import mealie.db.migration_types
from alembic import op

# revision identifiers, used by Alembic.
revision = "165d943c64ee"
down_revision = "167eb69066ad"
branch_labels: str | tuple[str, ...] | None = None
depends_on: str | tuple[str, ...] | None = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("group_meal_plans", schema=None) as batch_op:
        batch_op.add_column(sa.Column("user_id", mealie.db.migration_types.GUID(), nullable=True))
        batch_op.create_index(batch_op.f("ix_group_meal_plans_user_id"), ["user_id"], unique=False)
        batch_op.create_foreign_key("fk_user_mealplans", "users", ["user_id"], ["id"])

    with op.batch_alter_table("shopping_list_item_recipe_reference", schema=None) as batch_op:
        batch_op.alter_column("recipe_scale", existing_type=sa.FLOAT(), nullable=False)

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("shopping_list_item_recipe_reference", schema=None) as batch_op:
        batch_op.alter_column("recipe_scale", existing_type=sa.FLOAT(), nullable=True)

    with op.batch_alter_table("group_meal_plans", schema=None) as batch_op:
        batch_op.drop_constraint("fk_user_mealplans", type_="foreignkey")
        batch_op.drop_index(batch_op.f("ix_group_meal_plans_user_id"))
        batch_op.drop_column("user_id")

    # ### end Alembic commands ###
