[Back to the overview](overview.md)

# Question 12: Any suggestions for how to improve the Recipes functionality?

> Some things are not intuitive to use when creating recipes. also the import of recipes is sometimes interesting. Generally it works well but its been a while I havent added a new recipe so idont remember any pain points I had other than the ingredients and organizing the sections of steps

> Add the option to make recipes private from other households.

> Generally quite happy with recipe search and display :)

> Editing the ingredients list when creating a recipe feels a little cumbersome and could use some UX love, but mostly I think it works well.

> Highlight the ingredient used in a step that when tapped or clicked on shows the amount to use for that specific step. For example, a recipe uses carrots twice, once in step one and again in step 2. Tapping"carrots" in step one shows a pop up that shows "1 cup" and tapping carrot in step two shows "1/3 cup"

> While cooking offer support, included timers, using AI to discuss/ask questions about current step, next step, etc.

> Scaling ingrediants

> I would love to have a shortcut / one step process to analyze recipes with OpenAI directly on import

> possibility to add more pictures. maybe also a picture per step

> I wish I could have multiple columns of ingredient units, for example, 30 grams or 0,5 dl powdered sugar, because if I share my recipes they may not use weight as a unit like me. If I then increase/decrease the amount of the recipe I would like both units to change.

> One of my user's is bad at including tags. Perhaps an option to remind users to categorize, tag, etc

> Ability to double, triple, etc the ingredient amounts

> I think it works pretty well. Our most used feature of Mealie.

> Lots of improvements were introduced in the last updates here, so I may only add: - The possibility of grouping steps. For example for some pasta recipe, have the steps for the dough in one group, and separately for the sauce, or perhaps have a "sauce" whole category and have the possibility to add a dropdown menu so I can chose which sauce I want to add to the recipe. I wouldnt go as far as making sauce recipes as an indepentand meal recipe because the meal planner would treat them as a meal and mess up with that, but have the option to "+add" a sauce recipe to a meal recipe, and therefore adding it own subset of steps and ingredients to the whole recipe. - Tools: this seems to be only another tagging function but it would be useful is there were a place where I can input the tools that I ALREADY have, and then if some recipe specifies a tool that I DONT have, it would be highlighted so I dont find myself with the issue when im already in the middle of cooking it. Perhaps even the option to add it to the shopping list

> I would love to be able to decrease a serving count. If a recipe does 8 serves, but I only want to do 4, unless I want to manually adjust the scale to 0.5, I can't use the +/- buttons to reduce serving count. Additionally, if I want to do 10 serves instead of 8, I can't use the +/- buttons, it goes up by multiples of the serving count. I understand this wouldn't be for everyone, so maybe allowing the option to change the behaviour?

> add button which can change recipe portions count (if i have recipe for 4 people i should be able to recalculate for 2 or 1)

> The auto import imports weirdly sometimes. Also, absolutely allow fractions (1/4) instead of only .25 as an example

> Maybe add video support, template for receipes type

> Anything that could be done to simply or automate parsing ingredient sizes so that multiples (2x, 3x the recipe size) could be done without so much effort.

> when creating a recipe via text input, don't add example ingredients and steps, always a pain to delete 1 cup of flower, etc.

> I'd like to have the possibility to add macros at the food level - and make recipes calculate the recipe macros from the food macros. Thanks.

> Import from pdf

> Importing, particularly parsing ingredients and setting amounts is a pain. I wish there was a way to at least set the relevant settings by default (as I usually want the ability to scale my recipes)

> I would love ingredients to be identifiable as logical entities in the body-text of the instructions so I can hover over them, and it will pop-up how much. E.g., in Chicken Marsala I remove the fried chicken from the pan and add butter before sautéing the mushrooms. I don't want to scroll back up to the top to see how much butter, that instruction step could be context-aware and able to show me how much butter to add. This could be achieved rudimentarily with a markdown like tag, or an 'insert intergradient' button that would give you a picker of the ingredients already entered in the edit interface. If users didn't want to use them, they could still type ingredients in plain-text as before. A more advanced implementation could looks for matching text and recommend 'smart ingredient' links for the user.

> Would like to be able to enter a recipe for 2 people, but then see ingredients for just 1 person, or 3 etc. Currently you are stuck at a minimum for 2 and multiples thereof.

> No, I love the app. Think it works great.

> On ipad, please don’t make swiping all the way to the top refresh the page. Ive lost manual recipes while creating them.

> When clicking 'parse ingredients', it usually asks to save changes. That save doesn't include any actual changes from the recipe form. It would be nice to flow straight into 'parse ingredients' from the import instead of having to do at least 2 separate editing passes Include recipe as ingredient, with autocomplete and bidirectional referencing. ("Recipes that include this recipe:")

> Not sure how feasible it is, but it would be nice to have the option to turn off authentication for local deployments.

> Calculation of nutritive aspect of the recipes (like cholesterol, lipides, glucides) , based on the ingredient list. For example based on openfoodfacts.org or ciqual.anses.fr

> Ability to increase the servings and automatically multiplying quantities.

> I can't think of anything. It works really well and is a great way to manage our food.

> Improve visibility of ingredients linked to specific steps

> Ingredient categories. They would prob tie into https://github.com/mealie-recipes/mealie/discussions/1761 which would include ingredient sub-sections for sub-recipes, but they would be useful for recipes that have something like a cake and a sauce as well - especially when the cake and sauce both take sugar and it's easier to read when the amounts are split between sub-goals.

> Changing the serving size for fractions of the original is only possible by giving it a number and not the plus and minutes buttons. Typically over wants to decrement or increment by single servings.

> In ingredients list please add better support for non-english languages with more complicated grammar like Polish. We say: * 1 szklanka cukru / 1 cup of sugar * 2 szklanki cukru / 2 cups of sugar * 3 szklanki cukru / 3 cups of sugar * 4 szklanki cukru / 4 cups of sugar * 5 szklanek cukru / 5 cups of sugar * 6 szklanek cukru / 6 cups of sugar etc. * 1/2 szklanki cukru / 1/2 cup of sugar Antoher example: * 1 marchewka / 1 carrot * 2 marchewki / 2 carrots * 3 marchewki / 3 carrots * 4 marchewki / 4 carrots * 5 marchewek / 5 carrots * 6 marchewek / 6 carrots etc * 1/2 marchewki / 1/2 carrot So we have: * form for 1 * form for 2,3, 4 and fractions like 1/2 * form for 5 and more

> I often find that the brute parser is 10x better than the NLP ingredient parser, so I’d love to be able to select it as my default and use it automatically on recipe import.

> Ingredient Calculation should work. X = Ingredient / Default Servings so you can calculate every number.

> more features to support baking. Like portion: small cake(16cm) regular cake (22cm)

> Option to create recipe from url with AI rather than scraper (in many cases, the structure for recipe is not followed by website).

> Being able to import from PDF, spreadsheet, etc from other recipe programs and/or wikis that are private

> It would be good to be able to parse by default, and also add common ingredient aliases. There are ingredients that are commonly described with multiple forms, e.g.: "ground pepper", "black pepper", "pepper" etc. and it gets tedious to have to keep on making the same sorts of replacements instead of just adding a few rules. Similarly, unit conversion would be brilliant. At a basic level, you could make it possible to define units that are automatically converted to other units (e.g. cups to ml). A big step up, but a tricky one, is converting between volume and weight measurements. This is appropriate when say using metric and measurements like "1 cup" of flour, which should become ~150g, not 250ml of flour. Conversion of units and weight/volume seems like an area where having some default values (or an importable source, like with ingredients) that can be added to would make sense. I did some work along these lines myself a while ago and found http://www.fao.org/docrep/017/ap815e/ap815e.pdf a useful resource.

> This is probably mealie's most refined section. I use it all the time. Haven't had any complaints about it in a while.

> I would love to have a text to speech option, so that it can read out tasks while I am busy cooking, it would be great to have a button that reads out one step at a time...and you can just click next or even better just say the word next....i have text set to large on my phone/tablet as my eyes are poor so I keep having to scroll down between steps....I am also a little OCD about touching my phone/tablet with dirty hands so I have to wash my hands between each step before i scroll down on the phone/tablet...sounds like a "me" problem I know.

> I feel everything works great. Sometimes the import is buggy but that's probably due to the site and not mealie

> Not sure if this is updated since I'm on v0.5.6 but being able to section ingredients is important - especially where you have duplicated ingredients (e.g. one for a sauce, one for the main course).

> I'd love to be able to universally enable ingredient amounts.

> - Allow private recipes to be shared with certain individuals or households (vs sharing a link)

> Actually really like this section and the main reason why I use Mealie.

> It would be great if there was some way to convert between metric and imperial units.

> Combining Recipes similar to Tandoor Recipes. Sometimes I have a base dough when baking which can be used with several different baking recipes. Combining and connecting them in recipes would be a nice feature so I do not have to switch back and forth between different recipe parts.

> Support for meals which include multiple recipes e.g. a roast dinner would include links to roast chicken, roast potatoes, braised cabbage and so on. Filtering of recipes should allow tags or categories to be excluded.

> Split ingredient and "amount of ingredient" to allow for eg. convert imported recipes in Imperial units to normal metric and to allow multiplying the recipe for smaller/larger portions.

> Adding and rearranging steps can be quite cumbersome when there are many steps, if there's some way to streamline inserting and rearranging steps, that could be handle.

> none, it's already great!

> I dont have any complaints about this - works fine for my needs. I dont use the OpenAI feature so might look in to this.

> Maybe a way to paste a block of text copy and pasted from a private facebook post, and it would (at least attempt) to parse ingredients and steps. Aside from that, it works pretty well as is.

> I was really excited when I saw that there was a new version, but there's really nothing of interest in it for me which is really disappointing. Out of all the improvements that could have been made, there's household sharing been done which seems pretty niche, surely most people like me just use it for their house. I would have loved to have seen conversion of imperial to metric automatically. I would like to be able to have my main screen show only the main meal recipes, not all the dessert recipes together, just some sort of better separation that you could use on your home screen for the food vs drinks and desserts etc. Coloured tags would be a bonus. An android app where you can press a button to keep the screen on while cooking would be welcome too. I forgot to add for the Meal Planner functionality in the previous screen... There's nothing that can be used for advanced meal prep, when you make 2 or 3 meals on a sunday for the week, you can't plan for that. Your options are only limited to breakfast, lunch and dinner.

> For recipe scaling, scale by multiples instead of by serving count when using the plus and minus buttons, including multiples less than one (1/2, 1/4, etc). Please include a reset button with the plus and minus (which would be the x1 multiplier I suppose). I am often making half a recipe and it would be nice to use the minus button to scale to 1/2, instead of opening the custom number input and calculating the serving size for half the recipe. Please do keep the custom scaling input though, that is very nice in some cases.

> Add images from the recipes that are inlined so they are part of the steps Replace functionality, allow a recipe that was imported to be updated from the URL. Ive sometimes deleted a recipe so I could add it back with better images and nutritional information and then the parser fails so I have to add it all back by hand.

> An android app would be so good. Using the browser is really annoying

> Nope. I love it the way it is :-)

> Link other recipes for base recipes or combine different stuff

> If it was possible to specify the quantities for, say, 1 person, and then in the planner specify how many people are eating and get the required ingredients in the shopping list - that could be very handy.

> Sub-recipe nesting would probably be my biggest point. Also, built-in timers would be convenient.

> Nope! It’s great :)

> I end up with loads of stuff all mixed up, perhaps folders to help me sort it a bit? I think cookbooks might work in this way (just started using). Perhaps sort by number of people? I find the sort by ingredient filter doesn’t really work would be amazing if this did.

> allow for half portions to be selected as well - many recipes are for 4-6 portions, so we have to manually scale them down to 1 or 2 portions before adding to mealie - having that done automatically would be great

> Unless I am misunderstanding usage ideas, I would like to see the cookbooks or silos to be possible to hide one group of recipes from another so the "recipe" for the soap I make does not go into the same silo and show up alongside my cok-au-vin

> automatic unit detection to adjust the size of protions

> more possible entries for nutritional values. adding note for amount food per entred nutritional values. OpenAI calculation for those. editing mode for uploaded or scaped pictures. we found that if pictures are in landscape mealie would rotate the picture in wrong (upright) position. no possibility to change beside adjusting the picture outside of mealie.

> Big ask but calorie & macro computation(s) related to the recipes.

> ADD UNRAID TO YOUR INSTALLATION GUIDES. Make official app on unraid community applications.

> When importing a recipe, it would be great if I could switch on ingredient counts and parse the ingredients right away before saving.

> some websites guard against recipe imports by detecting bots. would be nice to allow the importer to have some kinds of bot evasion options - changing the user-agent, pairing with something like flaresolverr, importing saved raw web pages, explicitly allowing specified local IP address (i see that's a security concern) to allow proxying, etc.

> Make it possible to remove recipes that you don't want anymore.

> A better method for PDF export. Currently the webp images result in large PDFs when exported (multiple MB when webp picture is less than 1MB).

> Give me a compact view!

> Have an option for a secondary measurment option which also scales when you increase the amount of servings. Like if the main option is "1 packet", then have the option to add "2 teaspoons" or "20 ml", etc.

> Works as intended for me

> Add support for Ingredients that change the plural based on the number so like 1 egg 2 eggs

> A cool feature would be to add reminders for some ingredients. Some recipes require X ingredient to soak in water 24 hours or another thing to be prepared well in advance. If the recipe is added in the meal planner, then it should send a notification based on what was configured in Settings that you should prepare that ingredient.

> Better initial parsing of ingredients, specifically automatic creation of unknown item and automatic breakdown of quantities. My partner doesn't like to take the time to clean up recipes so they're unable to take advantage of a lot of other functionality within Mealie as a result. If the recipe was imported via URL, option to save the original webpage as .html/PDF/similar to guard against link rot.

> Quick UI option to 2x,3x,1/2x, etc recipe ingredients

> Honestly love it as is. I go external to figure out the nutritional information for my recipes it would be nice to bring it into mealie https://www.verywellfit.com/recipe-nutrition-analyzer-4157076

> I love overall how recipes function and are laid out. The only thing that would be nice is if you were able to take a picture of a physical recipe and have the parser create the recipe, similar to the URL importer. I know that is a huge ask though and it is not a deal breaking by any means.

> A general tips or something like that would be useful to link, things related with food and cooking but that they are not recipes, for example: cooking temperatures of the meat, type of fat: pro and cons, cuts of meat and which ones are best for each case

> not really. it works great as it is

> Well, its not clear nor easy how to connect to OpenAI and take advantage of ChatGPT properly. I've managed to connect it but when trying to import recipes using it I fail to get it right. I've already tried to get ChatGPT on its free site to get me a recipe from a site which is not compatible with the scraper, and it was very successful to give me a script with Mealie format, although I had to create every ingredient first manually so it wasnt viable, but it would be great if it were possible to use GPT to scrape recipes websites and import them so we can then tweak them a bit if needed. An example is this page my wife loves but is not compatible so she always ends up complaining: https://www.paulinacocina.net/

> Add the option to enable ingredient amounts by default for all recipes

> I think I would just want to be able to share recipes across groups or copy a recipe to another group more easily.

> Print / Export functionality improvements: ### Print - Allow for padding changes or something like "force on one page" or "condense." The amount of whitespace is great for web but not needed and wasteful for print. - Allow change of header/Section formatting (center, left, size) - Allow for margin size changes "Leave space for notes on right" ### Export - I love the new Ingredients Copy function, would love something similar on the instructions side. That way I can easily paste it in a different document or email if needed. - Allow export as text only - basically the download as JSON version, but just the basics to be opened in notepad or word

> Support multiple languages for ingredients, let the user choose preferred names from aliases of foods/units, support abbreviations and aliases in manual ingredients input suggestions, parsing after importing without saving/refreshing the side has weird behavior, better local parsing (brute force add ingredient button does not correctly apply the same ingredient to other fields; local model? pdf/image parsing?), when exiting the editor indicate unsaved changes

> Improve bulk tagging functionality, e.g., let me search for recipes then tag everything that matches the search. Right now I have to scroll through all the recipes and bulk tag everything by hand.

> Hardness (discussed in discord and issue) that can be filtered by. Preamble "before you begin" step.

> Ability to get nutrition information on ingredients would be quite useful

> - Bulk import of recipes based on images. - A way to review all of the imported data before committing it to the database - Allow for multiple images when importing a single recipe.

> Remind me to use the feature that adds ingredients to steps because it's awesome but I always forget to set it up

> When I import a recipe, I want the option to automatically parse my ingredients and take me to the parse page.

> Editing - could we have a 'Save' button at the bottom as well, or better still, that sticks to the same position on-screen? I seem to be forever scrolling back to the top to save it, every time I make an edit. Printing - I sometimes print out a recipe to avoid using my device near the cooker(!) It would be good to have some control over the layout. For instance, the headings Step 1, Step 2, etc, needlessly take up space.

> What about a simplified WYSIWYG Editor for the step text? (My wife will never learn to use Mark down syntax..)

> NA, mealie is great. I appreciate the work done to help quickly build recipes snd ingredients from copying and pasting non structured recipes that can’t be imported.

> In steps, make links to quantities or ingredients so I don't have to scroll up to the top again

> Serving scaling would be amazing

> Loving it, just keeps getting better

> That you can add x many ingredient fields.

> It would be great to have alternative ingredients. I like to use the 'ingredient amounts' and would like to be able to specify 'use *this oil* or *that fat* to fry'.

> Add photos to each step

> Overall, it seems to work well, Maybe a global setting for ingredient amounts?

> When editing a recipe I've not been able to find a way to remove the image, for example I imported a recipe from a URL and it added an image. I didn't want to use an image so I tried to remove it. I couldn't and needed to create a new recipe manually.

> Nutritional function improvements?

> not really. Easy to use!

> I could not find a way to add or remove units (like tsp, cups, etc.) so I've been stuck with a unit called "ts" when I made a typo when entering "tsp". Also have to have plural forms of units (cup/cups); maybe a place to manage units could have a checkbox to indicate "when quantity is equal or greater than 1, use plural form or add an s".

> When ingredients are not linked to steps having the ingredient list stick to the side when scrolling down the steps would help a lot.

> I use Mealie live while cooking, I hate the way it is scaling right now. I would love to have it just as multiplier and not with the "smart way" as it is right now

> I sure miss the native recipe OCR functionality. My main reason for using a recipe keeper was to digitize my cookbooks to make it easier to find recipes. The built-in OCR was a differentiator between Mealie and its competitors (and for whatever it's faults, it worked surprisingly well for me.) The AI implementation was both complicated to setup and didn't work (and I'm not interested in relying on a third-party service either.)

> Have the ingredient quantities enabled by default and supported by the importer

> I would love the required tools to work the same as ingredients. That is, have a counter (i.e., the recipe needs 1 oven, two pans, one small bowl and 3 large bowls) and especially, linking those to the steps. I love the "link ingredients to step" feature, because it allows me to really quickly see what I need for the current step without having to scroll (or touch the screen at all for that matter), but as of now, for the tools I still need to do that.

> Difficulty level (how difficult is it to cook)

> - Allow sorting (manually) of the linked ingredients of a recipe step. - Allow ticking (marking as done) of the linked ingredients of a recipe step. - Automatically save while creating a new recipe (to avoid losing progress). - Make it easier to rename/change existing ingredients in the DB. - Make it possible to clone an existing recipe. - Maybe it would make sense to have a linked recipe within a recipe. For example, a "cake base" that is used by several cakes. - Allow for multiple timers. This would be useful if several steps require a certain amount of time.

> Can't think of an improvement right now.

> Maybe making categories and tags more automatic? I am not sure if it's maybe too hard. But some recpies are called "Noodles with..." and I have a category "Noodles". Would be cool if something like that could be automatically parsed

> * Allow scaling ingredients to different servings ("4 serving(s)" appears clickable but does actually nothing). * Allow creating small variations of a base recipe without fully duplicating (e.g. "the recipe says this, but I usually do this instead"). Comments are too out-of-the-way to suffice. * Allow adding notes/conversions to specific ingredients (e.g. setting conversion rates of substitute ingredients: "1 clove of garlic is 0.25 teaspoons of powder", "the one onion the recipe calls for is about one cup of pre-chopped opnions" or just adding per-ingredient notes that are easier to access)

> I find the detailed ingredients somewhat awkward to use. (but thk you for all the work on mealy ❤️)

> Better integration with Home Assistant

> Link ingredients to steps. I think this is possible in tandoor and would be really great. But please keep also the main ingredient list, just links to the steps. It would probably be good to be able to link one ingredient to multiple steps, like e.g. salt or pepper.

> Could the recipe ingredient parser be built into the recipie editor - no need to navigate away to parse? Drah-and-drop recipe images? Perhaps allow a space to upload a photo of a meal 'as made'

> - ingredient scraper usually needs to be passed and manual adjusted. Not a big deal tho.

> Perfect

> Add an option to hide the 1-5 star ratings on recipes.

> Better UI/UX for parsing Ingredients, sharing Links with PWA imports instantly without the time to change the checkboxes, for parsed recipes allow to decrease the meal portions from 4 to 3 or 2 with plus and minus instead of doubling it or requiring to input something like 0.75 manually.

> Being able to reduce servings would be great. If a recipe is made for 4 servings, being able to see only 2 servings would be nice. I had another thought before, but cannot remember off the top of my head

> Two points that (to my knowledge) are also already discussed online would be 1. Timers linked to steps. 2. Recipes as ingredients or alternatives, with the option to add them to the Meal Planner / Shopping List with a single click.

> Fiddly part for me is to parse the ingredients and convert various units to grams. Not sure how it would work exactly but I think make use of llms. Eg a cup of flour = ?? grams

> Better UI flow

> I would like to see images treated as their own objects, instead of in-line. I always end up having to manually add styles to the img tag, otherwise the image takes too much space. Also would be nice to be able to disable images when printing the recipe.

> More support for sites with different formats. Or picture OCR

> No super happy with it

> Not really, it's great

[Back to the overview](overview.md) or [On to Question 13](q13.md)