import logging
logger = logging.getLogger(__name__)
import inspect
from file_renamer.themes.theme import Theme


class LightLinux(Theme):

    def __init__(self):
        logger.info('class LightLinux')
        self.theme = """
QMainWindow {
    background-color: white;
    color: black;
}

QMenu {
    background-color: white;
    color: black;
    border: 1px solid gray;
}

QMenu::item {
    background-color: transparent;
}

QMenu::item:selected {
    color: white;
    background-color: black;
    font-weight: bold;
}

QToolBar {
    background-color: white;
    color: black;
}

QGroupBox {
    /* border: 1px solid gray;*/
}

QLabel {
    background-color: white;
    color: black;
}

QLabel#label {
    color: white;
    background-color: gray;
    font-weight: bold;
    padding: 3px;
}

QLineEdit, QTextEdit {
    background-color: white;
    color: black;
}

QCheckBox {
    color: black;
}

QPushButton {
    background-color: white;
    color: black;
    padding: 4px 5px;
}

QPushButton:hover {
    background-color: gray;
    color: white;
    font-weight: bold;
    padding: 4px 5px;
}

QPushButton:pressed {
    background-color: white;
    color: gray;
}

QPushButton#rename_btn:hover {
    color: white;
    background-color: maroon;
    font-weight: bold;
    padding: 4px 5px;
}

QComboBox {
    background-color: white;
    color: black;
}

QComboBox QAbstractItemView {
    border: none;
    background-color: white;
}

QComboBox::item {
    background-color: white;
    color: black;
}

QComboBox::item:selected {
    background-color: gray;
    color: white;
}

QMessageBox {
    background-color: white;
    color: gray;
}
"""

    def validate(self, value):
        pass
