/*
 * Efesto - Excel Formula Extractor System and Topological Ordering algorithm.
 * Copyright (C) 2017 Massimo Caliman mcaliman@gmail.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * If AGPL Version 3.0 terms are incompatible with your use of
 * Efesto, alternative license terms are available from Massimo Caliman
 * please direct inquiries about Efesto licensing to mcaliman@gmail.com
 */

package com.trueprogramming.excel.grammar.nonterm.unary;

import com.trueprogramming.excel.grammar.annotations.NonTerminal;
import com.trueprogramming.excel.grammar.annotations.Production;
import com.trueprogramming.excel.grammar.lexicaltokens.CELL;
import com.trueprogramming.excel.grammar.nonterm.Formula;
import com.trueprogramming.excel.grammar.nonterm.FunctionCall;

/**
 * UnOpPrefix = + | -
 *
 * Unary = Plus  | Minus
 * Plus ::= + Formula
 * Minus ::= - Formula
 * @author Massimo Caliman
 */
@NonTerminal
@Production(symbol = "Unary", expression = "Plus")
@Production(symbol = "Unary", expression = "Minus")
public abstract class Unary extends FunctionCall {

    private final Formula formula;
    private final String unOpPrefix;

    public Unary(String unOpPrefix, Formula formula) {
        this.unOpPrefix = unOpPrefix;
        this.formula = formula;
    }

    @Override
    public String toString() {
        if(formula instanceof CELL) return unOpPrefix + ((CELL) formula).getValue();
        else return unOpPrefix + formula.toString();
    }

}
