/*
 * Efesto - Excel Formula Extractor System and Topological Ordering algorithm.
 * Copyright (C) 2017 Massimo Caliman mcaliman@gmail.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * If AGPL Version 3.0 terms are incompatible with your use of
 * Efesto, alternative license terms are available from Massimo Caliman
 * please direct inquiries about Efesto licensing to mcaliman@gmail.com
 */

package com.trueprogramming.excel.grammar.lexicaltokens;


import com.trueprogramming.excel.grammar.annotations.LexicalTokens;
import com.trueprogramming.excel.grammar.nonterm.Prefix;

/**
 * @author Massimo Caliman
 */
@LexicalTokens(name = "FILE", description = "External file reference using number", content = "\\[ [0-9]+ \\]", priority = 5)
public final class FILE extends Prefix {

    private final int ext;
    private final SHEET sheet;


    public FILE(int ext, SHEET sheet) {
        this.ext = ext;
        this.sheet = sheet;
    }

    public boolean isTerminal() {
        return true;
    }

    @Override
    public String toString() {
        return "[" + ext + "]" + sheet.toString();
    }


}
