/*
 * Efesto - Excel Formula Extractor System and Topological Ordering algorithm.
 * Copyright (C) 2017 Massimo Caliman mcaliman@gmail.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * If AGPL Version 3.0 terms are incompatible with your use of
 * Efesto, alternative license terms are available from Massimo Caliman
 * please direct inquiries about Efesto licensing to mcaliman@gmail.com
 */

package com.trueprogramming.excel.grammar.lexicaltokens;

import com.trueprogramming.excel.grammar.annotations.LexicalTokens;
import com.trueprogramming.excel.grammar.nonterm.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;


/**
 * @author Massimo Caliman
 */
@LexicalTokens(name = "EXCEL-FUNCTION", description = "Excel built-in function", content = "(Any entry from the function list3) \\(", priority = 5)
public abstract class EXCEL_FUNCTION extends FunctionCall {

    protected Formula[] args;

    protected EXCEL_FUNCTION(Formula... args) {
        this.args = args;
    }

    public Formula[] getArgs() {
        return args;
    }

    @NotNull
    @Override
    public String toString() {
        return getName() + "(" + argumentsToFormula() + ")";
    }


    private String getName() {
        return getClass().getSimpleName();
    }

    private String argumentsToFormula() {
        if(args == null || args.length == 0) return "Missing";
        var buff = new StringBuilder();
        for(Formula arg : args) buff.append(argumentToFormula(arg)).append(",");
        if(buff.charAt(buff.length() - 1) == ',') buff.deleteCharAt(buff.length() - 1);
        return buff.toString();
    }

    private String argumentToFormula(@Nullable Formula operand) {
        if(operand == null) return "Missing";
        if(operand instanceof RangeReference || operand instanceof NamedRange || operand instanceof PrefixReferenceItem)
            return operand.id();
        else if(operand instanceof CELL) return operand.id();
        else return operand.toString();
    }

}
