$(function() {
	var updateAnchorTimer = null;
	Array.prototype.binarySearch = function(obj) {
		var left = 0;
		var right = this.length;
		while (left <= right) {
			var center = Math.floor((left + right) / 2);
			if (obj < this[center]) {
				right = center - 1;
			} else {
				left = center + 1;
			}
		}
		return right;
	}
	$('.codeBtn').on('click', function() {
		var codeBox = $('.codeBox');
		var codeLayer = layer.open({
			type: 1,
			area: '76.25%',
			title: false,
			content: codeBox,
			btn: false,
			closeBtn: 0,
			shade: [0.2, '#000'],
			shadeClose: true,
			success: function() {
				$('.closeCodeBox').on('click', function() {
					layer.close(codeLayer);
				});
			}
		});
	});
	function updateAnchor(vm, isTransitionStart) {
		var changerMap = [1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24];
		var scrollTopRange = vm.slidesGrid;
		if (isTransitionStart) {
			var timeSpacing = 1000 / 30;
			var step = (vm.translate - vm.previousTranslate) / timeSpacing;
			var counter = 1;
			updateAnchorTimer = setInterval(function() {
				var distance = (vm.previousTranslate + counter * step) ? -(vm.previousTranslate + counter * step) : 0;
				var slideIndex = scrollTopRange.binarySearch(distance);
				var anchorIndex = changerMap.indexOf(slideIndex);
				if (anchorIndex == -1 && slideIndex == 0) {
					$('.anchor-btn').removeClass('current');
				} else if (!$('.anchor-btn').eq(anchorIndex).hasClass('current') && slideIndex != 2) {
					$('.anchor-btn').removeClass('current').eq(anchorIndex).addClass('current');
				}
				counter += 1;
			}, 30)
			return
		}
		var distance = vm.translate ? -vm.translate : 0;
		var slideIndex = scrollTopRange.binarySearch(distance);
		var anchorIndex = changerMap.indexOf(slideIndex);
		if (anchorIndex == -1 && slideIndex == 0) {
			$('.anchor-btn').removeClass('current');
		} else if (!$('.anchor-btn').eq(anchorIndex).hasClass('current') && slideIndex != 2) {
			$('.anchor-btn').removeClass('current').eq(anchorIndex).addClass('current');
		}
	}
	var cityChanger = new Swiper('.city-scroller-container', {
		autoplay: false,
		direction: 'vertical',
		freeMode: true,
		slidesPerView: 'auto',
		roundLengths: true,
		on: {
			init: function() {
				$('.city-scroller-container').css('visibility', 'visible')
				var changerAnchor = null;
				var changerMap = [1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24];
				var firstBtn = $('.anchor-btn')[0];
				var btnHeight = 0;
				if (firstBtn.currentStyle) {
					btnHeight = parseFloat(firstBtn.currentStyle.height).toFixed(2);
				} else {
					btnHeight = parseFloat(getComputedStyle(firstBtn, false).height).toFixed(2);
				}
				navigator.vibrate = navigator.vibrate || navigator.webkitVibrate || navigator.mozVibrate || navigator.msVibrate;
				$('.city-scroller-anchor').on('touchstart touchmove', function(event) {
					var e = event || window.event;
					e.stopPropagation();
					e.preventDefault();
					if (btnHeight) {
						var changerTop = $(this).offset().top;
						var touchData = e.originalEvent.touches[0];
						var index = parseInt((touchData.clientY - changerTop - 10) / btnHeight);
						if (changerAnchor === index) {
							return false;
						}
						if ((index || index === 0) && changerMap[index]) {
							cityChanger.slideTo(changerMap[index], 0, false);
							changerAnchor = index;
							$('.anchor-btn').removeClass('current').eq(index).addClass('current');
							$('.magnifier').text($('.city-scroller-item').eq(changerMap[index]).data('anchor'));
							$('.magnifier').show();
							if (navigator.vibrate) {
								navigator.vibrate(50);
							}
						}
					}
				})
				$('.city-scroller-anchor').on('touchend touchcancel', function() {
					$('.magnifier').hide();

				})
				$('.hot-choice-btn, .letter-choice-link').on('click', function(event) {
					var e = event || window.event;
					if (cityChanger.animating) {
						e.preventDefault();
					}
				})
			},
			touchStart: function(event) {
				cityChanger.setTranslate(cityChanger.getTranslate());
			},
			sliderMove: function(event) {
				if (updateAnchorTimer) {
					clearInterval(updateAnchorTimer);
				}
				updateAnchor(this)
			},
			transitionStart: function(event) {
				if (updateAnchorTimer) {
					clearInterval(updateAnchorTimer);
				}
				updateAnchor(cityChanger, true)
			},
			transitionEnd: function(e) {

				if (updateAnchorTimer) {
					clearInterval(updateAnchorTimer);
				}
				updateAnchor(cityChanger);
			}
		}
	});
})