var toastTimer = null
function toast (text, icon, callback) {
	if (!text) {
		return false
	}
	if (toastTimer) {
		clearTimeout(toastTimer)
		toastTimer = null
		if (callback) {
			callback()
		}
	}
	var toastEleWrapper = document.getElementById('win-toast-wrapper')
	var toastEle = document.getElementById('win-toast')
	if (!toastEleWrapper) {
		toastEleWrapper = document.createElement('div')
		toastEle = document.createElement('div')
		toastEleWrapper.setAttribute('id', 'win-toast-wrapper')
		toastEleWrapper.setAttribute('style', 'position: fixed;left: 0;top: 50%;width: 100%;display: none;-webkit-transform: translate(0, -50%);-ms-transform: translate(0, -50%);transform: translate(0, -50%);')
		toastEle.setAttribute('id', 'win-toast')
		toastEle.setAttribute('style', 'display: table;max-width: 80%;background: rgba(0,0,0,0.54);border-radius: 4px;padding: 20px 30px;font-size: 16px;line-height: 24px;color: #FFFFFF;text-align: center;-webkit-box-sizing: border-box;box-sizing: border-box;margin: 0 auto;')
		var textEle = document.createElement('span')
		textEle.setAttribute('id', 'win-toast-text')
		textEle.setAttribute('style', 'display: table-cell;vertical-align: middle;')
		textEle.innerHTML = text
		toastEle.appendChild(textEle)
	} else {
		var textEle = document.getElementById('win-toast-text')
		textEle.innerHTML = text
		toastEle.innerHTML = ''
		toastEle.appendChild(textEle)
	}
	toastEleWrapper.appendChild(toastEle)
	toastEleWrapper.style.zIndex = (new Date()).getTime()
	toastEleWrapper.style.display = 'block'
	document.getElementsByTagName('body')[0].appendChild(toastEleWrapper)
	if (icon) {
		toastEle.insertBefore(icon, document.getElementById('win-toast-text'))
	}
	toastTimer = setTimeout(function () {
		toastEleWrapper.style.display = 'none'
		if (callback) {
			callback()
		}
	}, 3000)
}
window.$toast = toast

var devicePixelRatio = window.devicePixelRatio
var style = document.createElement('style')
var styleInnerHtml = ''
styleInnerHtml += '.box-border-1px:before{width:' + (100 * devicePixelRatio) + '%;height:' + (100 * devicePixelRatio) + '%;left:' + ((1 - parseFloat(devicePixelRatio)) / 2 * 100) + '%;top:' + ((1 - parseFloat(devicePixelRatio)) / 2 * 100) + '%;-webkit-transform: scale(' + (1 / devicePixelRatio) + ', ' + (1 / devicePixelRatio) + ');-ms-transform: scale(' + (1 / devicePixelRatio) + ', ' + (1 / devicePixelRatio) + ');transform: scale(' + (1 / devicePixelRatio) + ', ' + (1 / devicePixelRatio) + ');border-radius: ' + (devicePixelRatio / 12) + 'em;}'
styleInnerHtml += '.left-line-1px:before{-webkit-transform: scale(' + (1 / devicePixelRatio) + ', 1);-ms-transform: scale(' + (1 / devicePixelRatio) + ', 1);transform: scale(' + (1 / devicePixelRatio) + ', 1);}'
styleInnerHtml += '.top-line-1px:before{-webkit-ransform: scale(1, ' + (1 / devicePixelRatio) + ');-ms-transform: scale(1, ' + (1 / devicePixelRatio) + ');transform: scale(1, ' + (1 / devicePixelRatio) + ');}'
styleInnerHtml += '.right-line-1px:before{-webkit-transform: scale(' + (1 / devicePixelRatio) + ', 1);-ms-transform: scale(' + (1 / devicePixelRatio) + ', 1);transform: scale(' + (1 / devicePixelRatio) + ', 1);}'
styleInnerHtml += '.bottom-line-1px:before{-webkit-transform: scale(1, ' + (1 / devicePixelRatio) + ');-ms-transform: scale(1, ' + (1 / devicePixelRatio) + ');transform: scale(1, ' + (1 / devicePixelRatio) + ');}'
style.innerHTML = styleInnerHtml
document.getElementsByTagName('body')[0].appendChild(style)

$(function(){
        $('.bigCateList').attr('isTaping',0);
        var windowH = document.documentElement?document.documentElement.clientHeight:document.body.clientHeight;
        var headerH = document.getElementById('mobile-header-wrapper').offsetHeight;
        var cateBoxH = $('.cateBox')[0].offsetHeight;
        var sideNavH = $('.sideNav')[0].offsetHeight;
        var cateBoxNewH = (windowH - headerH) < cateBoxH ? windowH - headerH : cateBoxH;
        var sideNavNewH = (windowH - headerH) < sideNavH ? windowH - headerH : sideNavH;
        $('.cateBox').height(cateBoxNewH);
        $('.sideNav').height(sideNavNewH);
        var myScroll1 = new IScroll('#navWrapper', {
            mouseWheel: true,
            scrollbars: false,
            click: true
        });
        var myScroll2 = new IScroll('#cateWrapper', {
            mouseWheel: true,
            scrollbars: false,
            click: true,
            probeType: 3
        });
        $('#bigCateList > li').on('click',function(){
            $('.bigCateList').attr('isTaping',1);
            var _this = $(this);
            var el = $('.bigCateTitle').eq($(this).index());
            myScroll2.scrollToElement(el[0],100,0,0);
            setTimeout(function(){
                $('#bigCateList li').removeClass('current');
                _this.addClass('current');
                $('.bigCateList').attr('isTaping',0);
            },100);
        });
        myScroll2.on('scroll',function(){
            if(parseInt($('.bigCateList').attr('isTaping'))){
                return;
            }
            var bigCateTitle = $('.bigCateTitle');
            var bigCateNav = $('.bigCateList > li');
            bigCateTitle.each(function(index){
                if($(this).next()){
                    if(Math.abs(myScroll2.y) + bigCateTitle[0].offsetTop >= $(this)[0].offsetTop && Math.abs(myScroll2.y) + bigCateTitle[0].offsetTop <= $(this).next()[0].offsetTop){
                        bigCateNav.removeClass('current');
                        bigCateNav.eq(index).addClass('current');
                    }
                }else{
                    if(Math.abs(myScroll2.y) + bigCateTitle[0].offsetTop >= $(this)[0].offsetTop){
                        bigCateNav.removeClass('current');
                        bigCateNav.eq(index).addClass('current');
                    }
                }
            });
        });
    });