UE.registerUI('add_transform_zh2en', function(editor, uiName) {
    editor.registerCommand(uiName, {
        execCommand: function() {
            alert('execCommand:' + uiName)
        }
    });
    var btn = new UE.ui.Button({
        name: uiName,
        title: '中文转英文',
        cssRules :'background-position: 249px 44px;',
        onclick: function() {
            var range = editor.selection.getRange();
            range.select();
            var txt = editor.selection.getText();
            //var txt = editor.getContentTxt();
            if (!txt.length) {
                layer.msg('请先选择文本');
                return false;
            }
            // type = ZH_CN2EN
            $.getJSON(UEDITOR_CONFIG.UEDITOR_HOME_URL + 'simon/transform_zh2en.php?txt='+ txt, function(res) {
                if (res.code) {
                    layer.msg(res.msg);
                    return false;
                }
                //layer.confirm('选中文本将被替换为<br/><span style="color:red">' + res.data + '</span>', function(index){
                    //do something
                    editor.execCommand('insertHtml', res.data);
                    //layer.close(index);
                //});
            })
        }
    });
    //当点到编辑内容上时，按钮要做的状态反射
    editor.addListener('selectionchange', function() {
        var state = editor.queryCommandState(uiName);
        if (state == -1) {
            btn.setDisabled(true);
            btn.setChecked(false);
        } else {
            btn.setDisabled(false);
            btn.setChecked(state);
        }
    });
    //因为你是添加button,所以需要返回这个button
    return btn;
});