<?php
!defined('IN_MYMPS') && exit('FORBIDDEN');
class mysql {
	var $query_num = 0;
	var $link;
	var $halt = 0;
	
	function __construct($dbhost, $dbuser, $dbpw, $dbname, $pconnect = 0) {
		$this->connect($dbhost, $dbuser, $dbpw, $dbname, $pconnect);
	}

	function connect($dbhost, $dbuser, $dbpw, $dbname, $pconnect = 0) {
        global $dbcharset;
		if(strpos($dbhost, ':') === false) {
			$dbport = 3306;
		} else {
			list($dbhost, $dbport) = explode(':', $dbhost);
		}
        if(!$this->link = mysqli_init()) $this->halt('Can not connect to MayiCMS MySQL Server');
		if(!@mysqli_real_connect($this->link, $dbhost, $dbuser, $dbpw, false,$dbport)) $this->halt('Can not connect to MySQL server');
		if ($this->link->server_info > '4.1'){
			if ($dbcharset != 'latin1') mysqli_query($this->link, "SET character_set_connection=$dbcharset, character_set_results=$dbcharset, character_set_client=binary");
			if ($this->link->server_info > '5.0.1') mysqli_query($this->link, "SET sql_mode=''");
		}
		if($dbname && !@mysqli_select_db($this->link, $dbname)) $this->halt('Cannot use database '.$dbname);
		return $this->link;
	}

	function select_db($dbname) {
		return mysqli_select_db($this->link, $dbname);
	}

	function server_info() {
		return mysqli_get_server_info($this->link);
	}
	
	function version() {
		return mysqli_get_server_info($this->link);
	}
	
    function fetchRow($query){
        return mysqli_fetch_assoc($query);
    }
	
	function fetch_first($sql) {
		return $this->fetch_array($this->query($sql));
	}

	function query($SQL) {
		if(!($query = mysqli_query($this->link, $SQL))) $this->halt('MySQL Query Error', $SQL);
        $this->query_num++;
		return $query;
	}
	
    function getOne($sql, $limited = false){
        if ($limited == true){
            $sql = trim($sql . ' LIMIT 1');
        }

        $res = $this->query($sql);
        if ($res !== false){
            $row = mysqli_fetch_row($res);

            if ($row !== false){
                return $row[0];
            }else{
                return '';
            }
        }else{
            return false;
        }
    }
	
	// add for pw
	function get_one($sql, $result_type = MYSQL_ASSOC){
		$result = $this->query($sql);
		$record = $this->fetch_array($result, $result_type);
		return $record;
	}
	// add for pw
	function get_value($sql, $result_type = MYSQL_NUM, $field = 0){
		$result_set = $this->query($sql);
		$rt =& $this->fetch_array($result_set, $result_type);
		return isset($rt[$field]) ? $rt[$field] : false;
	}
	//add for pw
    function escape($s){
		return mysqli_real_escape_string($this->link,$s);
    }
	//add for pw
	function query_unbuffered($sql) {
		$s = $this->query($sql, 'UNBUFFERED');
		return $s;
	}

	function getCol($sql){
		$res = $this->query($sql);
		if ($res !== false){
			$arr = array();
			while ($row = mysqli_fetch_row($res)){
				$arr[] = $row[0];
			}
	
			return $arr;
		}else{
			return false;
		}
	}

    function getAll($sql){
        $res = $this->query($sql);
        if ($res !== false){
            $arr = array();
            while ($row = mysqli_fetch_array($res)){
                $arr[] = $row;
            }

            return $arr;
        } else {
            return false;
        }
    }

    function getRow($sql, $limited = false){
        if ($limited == true){
            $sql = trim($sql . ' LIMIT 1');
        }

        $res = $this->query($sql);
        if ($res !== false){
            return mysqli_fetch_assoc($res);
        }else{
            return false;
        }
    }

    function fetch_array($query, $result_type = 'MYSQL_ASSOC') {
        return mysqli_fetch_array($query);
    }

	function affected_rows() {
		return mysqli_affected_rows($this->link);
	}

	function fetch_row($query) {
		return mysqli_fetch_row($query);
	}

	function num_rows($query) {
		return mysqli_num_rows($query);
	}

	function num_fields($query) {
		return mysqli_num_fields($query);
	}

	function result($query, $row) {
		$query = mysqli_result($query, $row);
		return $query;
	}

	function free_result($query) {
		return mysqli_free_result($query);
	}

	function insert_id() {
		return mysqli_insert_id($this->link);
	}

	function Close() {
		return mysqli_close($this->link);
	}

   	function error() {
		return @mysqli_error($this->link);
	}

    function errno() {
		return intval($this->error());
	}

	function halt($message = '') {
        global $charset;
		$msg = "<html>\n<head>\n";
		$msg .= "<meta content=\"text/html; charset=utf-8\" http-equiv=\"Content-Type\">";
		$msg .= "
		<style type=\"text/css\">
		body{text-align:center;font:14px microsoft yahei;}
		h1{ font-weight:100; margin-bottom:30px; margin-top:30px;}
		.notice{background-color:#F9FBFD;width:50%; line-height:40px;margin:20px auto; padding:20px; text-align:left; border:1px #EDF2F9 solid; border-radius:4px;}
		span{width:130px; display:block;float:left}
		div{}
		</style>";
		$msg .= "</head>";
		$msg .= "<body>
		<h1>MySQL Error</h1>
		<center class=notice>";
		$msg .= $this->error()?"<div><span>ERROR</span>  ".$this->error()."</div>":"";
		//$msg .= "<div><span>Error Number</span>  ".$this->errno()."</div>";
		$msg .= "<div><span>Now Time</span>  ".date("Y-m-d H:i:s")."</div>";
		$msg .= "<div><span>Error Script</span>  http://".$_SERVER['HTTP_HOST'].getenv("REQUEST_URI")."</div>";
		//$msg .= "<div><span>Need Help?</span>  <a href=https://www.mayicms.com target=_blank>View more at MayiCMS.com</a></div>";
		$msg .= "</center></body></html>";
		echo $msg;
		$this->Close();
		exit;
	}
}
$db = new mysql($db_host, $db_user, $db_pass, $db_name);
$db_host = $db_user = $db_pass = NULL;
?>