## mavsdk_server tools

This folder contains a few helper scripts meant to automatize some tasks such as packaging.

### package_mavsdk_server_framework

This script makes a fat binary out of the `mavsdk_server.framework` iOS framework, containing
architectures for iOS and those for the iOS simulator. It requires the builds for the
`ios` and `ios_simulator` targets to have completed successfully.

It can therefore be run from a macOS system with the following commands:


```
make BUILD_MAVSDK_SERVER=YES
make BUILD_MAVSDK_SERVER=YES ios
make BUILD_MAVSDK_SERVER=YES ios_simulator
bash package_mavsdk_server_framework.bash
```

The resulting fat binary will be generated in `./build/fat_bin/`.

### push_mavsdk_server_framework_to_s3

This script pushes the `dronecode-mavsdk_server.zip` archive generated by _package_mavsdk_server_framework.bash_
to amazon s3, under the name `dronecode-mavsdk_server-latest.zip`.

It requires the `awscli` binary, that can be installed from homebrew:

```
brew install awscli
```

Documentation about the s3 commands can be found [here](https://docs.aws.amazon.com/cli/latest/reference/s3/).

Obviously, the script requires the mavsdk_server fat binary to be built, meaning the following commands:

```
make BUILD_MAVSDK_SERVER=YES
make BUILD_MAVSDK_SERVER=YES ios
make BUILD_MAVSDK_SERVER=YES ios_simulator
bash package_dk_server.bash
bash push_mavsdk_server_framework_to_s3.bash
```
