// WARNING: THIS FILE IS AUTOGENERATED! As such, it should not be edited.
// Edits need to be made to the proto files
// (see
// https://github.com/mavlink/MAVSDK-Proto/blob/master/protos/tracking_server/tracking_server.proto)

#include "tracking_server/tracking_server.grpc.pb.h"
#include "plugins/tracking_server/tracking_server.h"

#include "mavsdk.h"

#include "lazy_server_plugin.h"

#include "log.h"
#include <atomic>
#include <cmath>
#include <future>
#include <limits>
#include <memory>
#include <sstream>
#include <vector>

namespace mavsdk {
namespace mavsdk_server {

template<
    typename TrackingServer = TrackingServer,
    typename LazyServerPlugin = LazyServerPlugin<TrackingServer>>

class TrackingServerServiceImpl final
    : public rpc::tracking_server::TrackingServerService::Service {
public:
    TrackingServerServiceImpl(LazyServerPlugin& lazy_plugin) : _lazy_plugin(lazy_plugin) {}

    template<typename ResponseType>
    void
    fillResponseWithResult(ResponseType* response, mavsdk::TrackingServer::Result& result) const
    {
        auto rpc_result = translateToRpcResult(result);

        auto* rpc_tracking_server_result = new rpc::tracking_server::TrackingServerResult();
        rpc_tracking_server_result->set_result(rpc_result);
        std::stringstream ss;
        ss << result;
        rpc_tracking_server_result->set_result_str(ss.str());

        response->set_allocated_tracking_server_result(rpc_tracking_server_result);
    }

    static rpc::tracking_server::CommandAnswer
    translateToRpcCommandAnswer(const mavsdk::TrackingServer::CommandAnswer& command_answer)
    {
        switch (command_answer) {
            default:
                LogErr() << "Unknown command_answer enum value: "
                         << static_cast<int>(command_answer);
            // FALLTHROUGH
            case mavsdk::TrackingServer::CommandAnswer::Accepted:
                return rpc::tracking_server::COMMAND_ANSWER_ACCEPTED;
            case mavsdk::TrackingServer::CommandAnswer::TemporarilyRejected:
                return rpc::tracking_server::COMMAND_ANSWER_TEMPORARILY_REJECTED;
            case mavsdk::TrackingServer::CommandAnswer::Denied:
                return rpc::tracking_server::COMMAND_ANSWER_DENIED;
            case mavsdk::TrackingServer::CommandAnswer::Unsupported:
                return rpc::tracking_server::COMMAND_ANSWER_UNSUPPORTED;
            case mavsdk::TrackingServer::CommandAnswer::Failed:
                return rpc::tracking_server::COMMAND_ANSWER_FAILED;
        }
    }

    static mavsdk::TrackingServer::CommandAnswer
    translateFromRpcCommandAnswer(const rpc::tracking_server::CommandAnswer command_answer)
    {
        switch (command_answer) {
            default:
                LogErr() << "Unknown command_answer enum value: "
                         << static_cast<int>(command_answer);
            // FALLTHROUGH
            case rpc::tracking_server::COMMAND_ANSWER_ACCEPTED:
                return mavsdk::TrackingServer::CommandAnswer::Accepted;
            case rpc::tracking_server::COMMAND_ANSWER_TEMPORARILY_REJECTED:
                return mavsdk::TrackingServer::CommandAnswer::TemporarilyRejected;
            case rpc::tracking_server::COMMAND_ANSWER_DENIED:
                return mavsdk::TrackingServer::CommandAnswer::Denied;
            case rpc::tracking_server::COMMAND_ANSWER_UNSUPPORTED:
                return mavsdk::TrackingServer::CommandAnswer::Unsupported;
            case rpc::tracking_server::COMMAND_ANSWER_FAILED:
                return mavsdk::TrackingServer::CommandAnswer::Failed;
        }
    }

    static std::unique_ptr<rpc::tracking_server::TrackPoint>
    translateToRpcTrackPoint(const mavsdk::TrackingServer::TrackPoint& track_point)
    {
        auto rpc_obj = std::make_unique<rpc::tracking_server::TrackPoint>();

        rpc_obj->set_point_x(track_point.point_x);

        rpc_obj->set_point_y(track_point.point_y);

        rpc_obj->set_radius(track_point.radius);

        return rpc_obj;
    }

    static mavsdk::TrackingServer::TrackPoint
    translateFromRpcTrackPoint(const rpc::tracking_server::TrackPoint& track_point)
    {
        mavsdk::TrackingServer::TrackPoint obj;

        obj.point_x = track_point.point_x();

        obj.point_y = track_point.point_y();

        obj.radius = track_point.radius();

        return obj;
    }

    static std::unique_ptr<rpc::tracking_server::TrackRectangle>
    translateToRpcTrackRectangle(const mavsdk::TrackingServer::TrackRectangle& track_rectangle)
    {
        auto rpc_obj = std::make_unique<rpc::tracking_server::TrackRectangle>();

        rpc_obj->set_top_left_corner_x(track_rectangle.top_left_corner_x);

        rpc_obj->set_top_left_corner_y(track_rectangle.top_left_corner_y);

        rpc_obj->set_bottom_right_corner_x(track_rectangle.bottom_right_corner_x);

        rpc_obj->set_bottom_right_corner_y(track_rectangle.bottom_right_corner_y);

        return rpc_obj;
    }

    static mavsdk::TrackingServer::TrackRectangle
    translateFromRpcTrackRectangle(const rpc::tracking_server::TrackRectangle& track_rectangle)
    {
        mavsdk::TrackingServer::TrackRectangle obj;

        obj.top_left_corner_x = track_rectangle.top_left_corner_x();

        obj.top_left_corner_y = track_rectangle.top_left_corner_y();

        obj.bottom_right_corner_x = track_rectangle.bottom_right_corner_x();

        obj.bottom_right_corner_y = track_rectangle.bottom_right_corner_y();

        return obj;
    }

    static rpc::tracking_server::TrackingServerResult::Result
    translateToRpcResult(const mavsdk::TrackingServer::Result& result)
    {
        switch (result) {
            default:
                LogErr() << "Unknown result enum value: " << static_cast<int>(result);
            // FALLTHROUGH
            case mavsdk::TrackingServer::Result::Unknown:
                return rpc::tracking_server::TrackingServerResult_Result_RESULT_UNKNOWN;
            case mavsdk::TrackingServer::Result::Success:
                return rpc::tracking_server::TrackingServerResult_Result_RESULT_SUCCESS;
            case mavsdk::TrackingServer::Result::NoSystem:
                return rpc::tracking_server::TrackingServerResult_Result_RESULT_NO_SYSTEM;
            case mavsdk::TrackingServer::Result::ConnectionError:
                return rpc::tracking_server::TrackingServerResult_Result_RESULT_CONNECTION_ERROR;
        }
    }

    static mavsdk::TrackingServer::Result
    translateFromRpcResult(const rpc::tracking_server::TrackingServerResult::Result result)
    {
        switch (result) {
            default:
                LogErr() << "Unknown result enum value: " << static_cast<int>(result);
            // FALLTHROUGH
            case rpc::tracking_server::TrackingServerResult_Result_RESULT_UNKNOWN:
                return mavsdk::TrackingServer::Result::Unknown;
            case rpc::tracking_server::TrackingServerResult_Result_RESULT_SUCCESS:
                return mavsdk::TrackingServer::Result::Success;
            case rpc::tracking_server::TrackingServerResult_Result_RESULT_NO_SYSTEM:
                return mavsdk::TrackingServer::Result::NoSystem;
            case rpc::tracking_server::TrackingServerResult_Result_RESULT_CONNECTION_ERROR:
                return mavsdk::TrackingServer::Result::ConnectionError;
        }
    }

    grpc::Status SetTrackingPointStatus(
        grpc::ServerContext* /* context */,
        const rpc::tracking_server::SetTrackingPointStatusRequest* request,
        rpc::tracking_server::SetTrackingPointStatusResponse* /* response */) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "SetTrackingPointStatus sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        _lazy_plugin.maybe_plugin()->set_tracking_point_status(
            translateFromRpcTrackPoint(request->tracked_point()));

        return grpc::Status::OK;
    }

    grpc::Status SetTrackingRectangleStatus(
        grpc::ServerContext* /* context */,
        const rpc::tracking_server::SetTrackingRectangleStatusRequest* request,
        rpc::tracking_server::SetTrackingRectangleStatusResponse* /* response */) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "SetTrackingRectangleStatus sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        _lazy_plugin.maybe_plugin()->set_tracking_rectangle_status(
            translateFromRpcTrackRectangle(request->tracked_rectangle()));

        return grpc::Status::OK;
    }

    grpc::Status SetTrackingOffStatus(
        grpc::ServerContext* /* context */,
        const rpc::tracking_server::SetTrackingOffStatusRequest* /* request */,
        rpc::tracking_server::SetTrackingOffStatusResponse* /* response */) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        _lazy_plugin.maybe_plugin()->set_tracking_off_status();

        return grpc::Status::OK;
    }

    grpc::Status SubscribeTrackingPointCommand(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::tracking_server::SubscribeTrackingPointCommandRequest* /* request */,
        grpc::ServerWriter<rpc::tracking_server::TrackingPointCommandResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::TrackingServer::TrackingPointCommandHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_tracking_point_command(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const mavsdk::TrackingServer::TrackPoint tracking_point_command) {
                    rpc::tracking_server::TrackingPointCommandResponse rpc_response;

                    rpc_response.set_allocated_track_point(
                        translateToRpcTrackPoint(tracking_point_command).release());

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_tracking_point_command(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status SubscribeTrackingRectangleCommand(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::tracking_server::SubscribeTrackingRectangleCommandRequest* /* request */,
        grpc::ServerWriter<rpc::tracking_server::TrackingRectangleCommandResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::TrackingServer::TrackingRectangleCommandHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_tracking_rectangle_command(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const mavsdk::TrackingServer::TrackRectangle tracking_rectangle_command) {
                    rpc::tracking_server::TrackingRectangleCommandResponse rpc_response;

                    rpc_response.set_allocated_track_rectangle(
                        translateToRpcTrackRectangle(tracking_rectangle_command).release());

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_tracking_rectangle_command(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status SubscribeTrackingOffCommand(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::tracking_server::SubscribeTrackingOffCommandRequest* /* request */,
        grpc::ServerWriter<rpc::tracking_server::TrackingOffCommandResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::TrackingServer::TrackingOffCommandHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_tracking_off_command(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const int32_t tracking_off_command) {
                    rpc::tracking_server::TrackingOffCommandResponse rpc_response;

                    rpc_response.set_dummy(tracking_off_command);

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_tracking_off_command(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status RespondTrackingPointCommand(
        grpc::ServerContext* /* context */,
        const rpc::tracking_server::RespondTrackingPointCommandRequest* request,
        rpc::tracking_server::RespondTrackingPointCommandResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                // For server plugins, this should never happen, they should always be
                // constructible.
                auto result = mavsdk::TrackingServer::Result::Unknown;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "RespondTrackingPointCommand sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->respond_tracking_point_command(
            translateFromRpcCommandAnswer(request->command_answer()));

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status RespondTrackingRectangleCommand(
        grpc::ServerContext* /* context */,
        const rpc::tracking_server::RespondTrackingRectangleCommandRequest* request,
        rpc::tracking_server::RespondTrackingRectangleCommandResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                // For server plugins, this should never happen, they should always be
                // constructible.
                auto result = mavsdk::TrackingServer::Result::Unknown;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "RespondTrackingRectangleCommand sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->respond_tracking_rectangle_command(
            translateFromRpcCommandAnswer(request->command_answer()));

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status RespondTrackingOffCommand(
        grpc::ServerContext* /* context */,
        const rpc::tracking_server::RespondTrackingOffCommandRequest* request,
        rpc::tracking_server::RespondTrackingOffCommandResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                // For server plugins, this should never happen, they should always be
                // constructible.
                auto result = mavsdk::TrackingServer::Result::Unknown;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "RespondTrackingOffCommand sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->respond_tracking_off_command(
            translateFromRpcCommandAnswer(request->command_answer()));

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    void stop()
    {
        _stopped.store(true);
        for (auto& prom : _stream_stop_promises) {
            if (auto handle = prom.lock()) {
                handle->set_value();
            }
        }
    }

private:
    void register_stream_stop_promise(std::weak_ptr<std::promise<void>> prom)
    {
        // If we have already stopped, set promise immediately and don't add it to list.
        if (_stopped.load()) {
            if (auto handle = prom.lock()) {
                handle->set_value();
            }
        } else {
            _stream_stop_promises.push_back(prom);
        }
    }

    void unregister_stream_stop_promise(std::shared_ptr<std::promise<void>> prom)
    {
        for (auto it = _stream_stop_promises.begin(); it != _stream_stop_promises.end();
             /* ++it */) {
            if (it->lock() == prom) {
                it = _stream_stop_promises.erase(it);
            } else {
                ++it;
            }
        }
    }

    LazyServerPlugin& _lazy_plugin;

    std::atomic<bool> _stopped{false};
    std::vector<std::weak_ptr<std::promise<void>>> _stream_stop_promises{};
};

} // namespace mavsdk_server
} // namespace mavsdk