// WARNING: THIS FILE IS AUTOGENERATED! As such, it should not be edited.
// Edits need to be made to the proto files
// (see
// https://github.com/mavlink/MAVSDK-Proto/blob/master/protos/telemetry_server/telemetry_server.proto)

#include "telemetry_server/telemetry_server.grpc.pb.h"
#include "plugins/telemetry_server/telemetry_server.h"

#include "mavsdk.h"

#include "lazy_server_plugin.h"

#include "log.h"
#include <atomic>
#include <cmath>
#include <future>
#include <limits>
#include <memory>
#include <mutex>
#include <sstream>
#include <vector>

namespace mavsdk {
namespace mavsdk_server {

template<
    typename TelemetryServer = TelemetryServer,
    typename LazyServerPlugin = LazyServerPlugin<TelemetryServer>>

class TelemetryServerServiceImpl final
    : public rpc::telemetry_server::TelemetryServerService::Service {
public:
    TelemetryServerServiceImpl(LazyServerPlugin& lazy_plugin) : _lazy_plugin(lazy_plugin) {}

    template<typename ResponseType>
    void
    fillResponseWithResult(ResponseType* response, mavsdk::TelemetryServer::Result& result) const
    {
        auto rpc_result = translateToRpcResult(result);

        auto* rpc_telemetry_server_result = new rpc::telemetry_server::TelemetryServerResult();
        rpc_telemetry_server_result->set_result(rpc_result);
        std::stringstream ss;
        ss << result;
        rpc_telemetry_server_result->set_result_str(ss.str());

        response->set_allocated_telemetry_server_result(rpc_telemetry_server_result);
    }

    static rpc::telemetry_server::FixType
    translateToRpcFixType(const mavsdk::TelemetryServer::FixType& fix_type)
    {
        switch (fix_type) {
            default:
                LogErr() << "Unknown fix_type enum value: " << static_cast<int>(fix_type);
            // FALLTHROUGH
            case mavsdk::TelemetryServer::FixType::NoGps:
                return rpc::telemetry_server::FIX_TYPE_NO_GPS;
            case mavsdk::TelemetryServer::FixType::NoFix:
                return rpc::telemetry_server::FIX_TYPE_NO_FIX;
            case mavsdk::TelemetryServer::FixType::Fix2D:
                return rpc::telemetry_server::FIX_TYPE_FIX_2D;
            case mavsdk::TelemetryServer::FixType::Fix3D:
                return rpc::telemetry_server::FIX_TYPE_FIX_3D;
            case mavsdk::TelemetryServer::FixType::FixDgps:
                return rpc::telemetry_server::FIX_TYPE_FIX_DGPS;
            case mavsdk::TelemetryServer::FixType::RtkFloat:
                return rpc::telemetry_server::FIX_TYPE_RTK_FLOAT;
            case mavsdk::TelemetryServer::FixType::RtkFixed:
                return rpc::telemetry_server::FIX_TYPE_RTK_FIXED;
        }
    }

    static mavsdk::TelemetryServer::FixType
    translateFromRpcFixType(const rpc::telemetry_server::FixType fix_type)
    {
        switch (fix_type) {
            default:
                LogErr() << "Unknown fix_type enum value: " << static_cast<int>(fix_type);
            // FALLTHROUGH
            case rpc::telemetry_server::FIX_TYPE_NO_GPS:
                return mavsdk::TelemetryServer::FixType::NoGps;
            case rpc::telemetry_server::FIX_TYPE_NO_FIX:
                return mavsdk::TelemetryServer::FixType::NoFix;
            case rpc::telemetry_server::FIX_TYPE_FIX_2D:
                return mavsdk::TelemetryServer::FixType::Fix2D;
            case rpc::telemetry_server::FIX_TYPE_FIX_3D:
                return mavsdk::TelemetryServer::FixType::Fix3D;
            case rpc::telemetry_server::FIX_TYPE_FIX_DGPS:
                return mavsdk::TelemetryServer::FixType::FixDgps;
            case rpc::telemetry_server::FIX_TYPE_RTK_FLOAT:
                return mavsdk::TelemetryServer::FixType::RtkFloat;
            case rpc::telemetry_server::FIX_TYPE_RTK_FIXED:
                return mavsdk::TelemetryServer::FixType::RtkFixed;
        }
    }

    static rpc::telemetry_server::VtolState
    translateToRpcVtolState(const mavsdk::TelemetryServer::VtolState& vtol_state)
    {
        switch (vtol_state) {
            default:
                LogErr() << "Unknown vtol_state enum value: " << static_cast<int>(vtol_state);
            // FALLTHROUGH
            case mavsdk::TelemetryServer::VtolState::Undefined:
                return rpc::telemetry_server::VTOL_STATE_UNDEFINED;
            case mavsdk::TelemetryServer::VtolState::TransitionToFw:
                return rpc::telemetry_server::VTOL_STATE_TRANSITION_TO_FW;
            case mavsdk::TelemetryServer::VtolState::TransitionToMc:
                return rpc::telemetry_server::VTOL_STATE_TRANSITION_TO_MC;
            case mavsdk::TelemetryServer::VtolState::Mc:
                return rpc::telemetry_server::VTOL_STATE_MC;
            case mavsdk::TelemetryServer::VtolState::Fw:
                return rpc::telemetry_server::VTOL_STATE_FW;
        }
    }

    static mavsdk::TelemetryServer::VtolState
    translateFromRpcVtolState(const rpc::telemetry_server::VtolState vtol_state)
    {
        switch (vtol_state) {
            default:
                LogErr() << "Unknown vtol_state enum value: " << static_cast<int>(vtol_state);
            // FALLTHROUGH
            case rpc::telemetry_server::VTOL_STATE_UNDEFINED:
                return mavsdk::TelemetryServer::VtolState::Undefined;
            case rpc::telemetry_server::VTOL_STATE_TRANSITION_TO_FW:
                return mavsdk::TelemetryServer::VtolState::TransitionToFw;
            case rpc::telemetry_server::VTOL_STATE_TRANSITION_TO_MC:
                return mavsdk::TelemetryServer::VtolState::TransitionToMc;
            case rpc::telemetry_server::VTOL_STATE_MC:
                return mavsdk::TelemetryServer::VtolState::Mc;
            case rpc::telemetry_server::VTOL_STATE_FW:
                return mavsdk::TelemetryServer::VtolState::Fw;
        }
    }

    static rpc::telemetry_server::StatusTextType
    translateToRpcStatusTextType(const mavsdk::TelemetryServer::StatusTextType& status_text_type)
    {
        switch (status_text_type) {
            default:
                LogErr() << "Unknown status_text_type enum value: "
                         << static_cast<int>(status_text_type);
            // FALLTHROUGH
            case mavsdk::TelemetryServer::StatusTextType::Debug:
                return rpc::telemetry_server::STATUS_TEXT_TYPE_DEBUG;
            case mavsdk::TelemetryServer::StatusTextType::Info:
                return rpc::telemetry_server::STATUS_TEXT_TYPE_INFO;
            case mavsdk::TelemetryServer::StatusTextType::Notice:
                return rpc::telemetry_server::STATUS_TEXT_TYPE_NOTICE;
            case mavsdk::TelemetryServer::StatusTextType::Warning:
                return rpc::telemetry_server::STATUS_TEXT_TYPE_WARNING;
            case mavsdk::TelemetryServer::StatusTextType::Error:
                return rpc::telemetry_server::STATUS_TEXT_TYPE_ERROR;
            case mavsdk::TelemetryServer::StatusTextType::Critical:
                return rpc::telemetry_server::STATUS_TEXT_TYPE_CRITICAL;
            case mavsdk::TelemetryServer::StatusTextType::Alert:
                return rpc::telemetry_server::STATUS_TEXT_TYPE_ALERT;
            case mavsdk::TelemetryServer::StatusTextType::Emergency:
                return rpc::telemetry_server::STATUS_TEXT_TYPE_EMERGENCY;
        }
    }

    static mavsdk::TelemetryServer::StatusTextType
    translateFromRpcStatusTextType(const rpc::telemetry_server::StatusTextType status_text_type)
    {
        switch (status_text_type) {
            default:
                LogErr() << "Unknown status_text_type enum value: "
                         << static_cast<int>(status_text_type);
            // FALLTHROUGH
            case rpc::telemetry_server::STATUS_TEXT_TYPE_DEBUG:
                return mavsdk::TelemetryServer::StatusTextType::Debug;
            case rpc::telemetry_server::STATUS_TEXT_TYPE_INFO:
                return mavsdk::TelemetryServer::StatusTextType::Info;
            case rpc::telemetry_server::STATUS_TEXT_TYPE_NOTICE:
                return mavsdk::TelemetryServer::StatusTextType::Notice;
            case rpc::telemetry_server::STATUS_TEXT_TYPE_WARNING:
                return mavsdk::TelemetryServer::StatusTextType::Warning;
            case rpc::telemetry_server::STATUS_TEXT_TYPE_ERROR:
                return mavsdk::TelemetryServer::StatusTextType::Error;
            case rpc::telemetry_server::STATUS_TEXT_TYPE_CRITICAL:
                return mavsdk::TelemetryServer::StatusTextType::Critical;
            case rpc::telemetry_server::STATUS_TEXT_TYPE_ALERT:
                return mavsdk::TelemetryServer::StatusTextType::Alert;
            case rpc::telemetry_server::STATUS_TEXT_TYPE_EMERGENCY:
                return mavsdk::TelemetryServer::StatusTextType::Emergency;
        }
    }

    static rpc::telemetry_server::LandedState
    translateToRpcLandedState(const mavsdk::TelemetryServer::LandedState& landed_state)
    {
        switch (landed_state) {
            default:
                LogErr() << "Unknown landed_state enum value: " << static_cast<int>(landed_state);
            // FALLTHROUGH
            case mavsdk::TelemetryServer::LandedState::Unknown:
                return rpc::telemetry_server::LANDED_STATE_UNKNOWN;
            case mavsdk::TelemetryServer::LandedState::OnGround:
                return rpc::telemetry_server::LANDED_STATE_ON_GROUND;
            case mavsdk::TelemetryServer::LandedState::InAir:
                return rpc::telemetry_server::LANDED_STATE_IN_AIR;
            case mavsdk::TelemetryServer::LandedState::TakingOff:
                return rpc::telemetry_server::LANDED_STATE_TAKING_OFF;
            case mavsdk::TelemetryServer::LandedState::Landing:
                return rpc::telemetry_server::LANDED_STATE_LANDING;
        }
    }

    static mavsdk::TelemetryServer::LandedState
    translateFromRpcLandedState(const rpc::telemetry_server::LandedState landed_state)
    {
        switch (landed_state) {
            default:
                LogErr() << "Unknown landed_state enum value: " << static_cast<int>(landed_state);
            // FALLTHROUGH
            case rpc::telemetry_server::LANDED_STATE_UNKNOWN:
                return mavsdk::TelemetryServer::LandedState::Unknown;
            case rpc::telemetry_server::LANDED_STATE_ON_GROUND:
                return mavsdk::TelemetryServer::LandedState::OnGround;
            case rpc::telemetry_server::LANDED_STATE_IN_AIR:
                return mavsdk::TelemetryServer::LandedState::InAir;
            case rpc::telemetry_server::LANDED_STATE_TAKING_OFF:
                return mavsdk::TelemetryServer::LandedState::TakingOff;
            case rpc::telemetry_server::LANDED_STATE_LANDING:
                return mavsdk::TelemetryServer::LandedState::Landing;
        }
    }

    static std::unique_ptr<rpc::telemetry_server::Position>
    translateToRpcPosition(const mavsdk::TelemetryServer::Position& position)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry_server::Position>();

        rpc_obj->set_latitude_deg(position.latitude_deg);

        rpc_obj->set_longitude_deg(position.longitude_deg);

        rpc_obj->set_absolute_altitude_m(position.absolute_altitude_m);

        rpc_obj->set_relative_altitude_m(position.relative_altitude_m);

        return rpc_obj;
    }

    static mavsdk::TelemetryServer::Position
    translateFromRpcPosition(const rpc::telemetry_server::Position& position)
    {
        mavsdk::TelemetryServer::Position obj;

        obj.latitude_deg = position.latitude_deg();

        obj.longitude_deg = position.longitude_deg();

        obj.absolute_altitude_m = position.absolute_altitude_m();

        obj.relative_altitude_m = position.relative_altitude_m();

        return obj;
    }

    static std::unique_ptr<rpc::telemetry_server::Heading>
    translateToRpcHeading(const mavsdk::TelemetryServer::Heading& heading)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry_server::Heading>();

        rpc_obj->set_heading_deg(heading.heading_deg);

        return rpc_obj;
    }

    static mavsdk::TelemetryServer::Heading
    translateFromRpcHeading(const rpc::telemetry_server::Heading& heading)
    {
        mavsdk::TelemetryServer::Heading obj;

        obj.heading_deg = heading.heading_deg();

        return obj;
    }

    static std::unique_ptr<rpc::telemetry_server::Quaternion>
    translateToRpcQuaternion(const mavsdk::TelemetryServer::Quaternion& quaternion)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry_server::Quaternion>();

        rpc_obj->set_w(quaternion.w);

        rpc_obj->set_x(quaternion.x);

        rpc_obj->set_y(quaternion.y);

        rpc_obj->set_z(quaternion.z);

        rpc_obj->set_timestamp_us(quaternion.timestamp_us);

        return rpc_obj;
    }

    static mavsdk::TelemetryServer::Quaternion
    translateFromRpcQuaternion(const rpc::telemetry_server::Quaternion& quaternion)
    {
        mavsdk::TelemetryServer::Quaternion obj;

        obj.w = quaternion.w();

        obj.x = quaternion.x();

        obj.y = quaternion.y();

        obj.z = quaternion.z();

        obj.timestamp_us = quaternion.timestamp_us();

        return obj;
    }

    static std::unique_ptr<rpc::telemetry_server::EulerAngle>
    translateToRpcEulerAngle(const mavsdk::TelemetryServer::EulerAngle& euler_angle)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry_server::EulerAngle>();

        rpc_obj->set_roll_deg(euler_angle.roll_deg);

        rpc_obj->set_pitch_deg(euler_angle.pitch_deg);

        rpc_obj->set_yaw_deg(euler_angle.yaw_deg);

        rpc_obj->set_timestamp_us(euler_angle.timestamp_us);

        return rpc_obj;
    }

    static mavsdk::TelemetryServer::EulerAngle
    translateFromRpcEulerAngle(const rpc::telemetry_server::EulerAngle& euler_angle)
    {
        mavsdk::TelemetryServer::EulerAngle obj;

        obj.roll_deg = euler_angle.roll_deg();

        obj.pitch_deg = euler_angle.pitch_deg();

        obj.yaw_deg = euler_angle.yaw_deg();

        obj.timestamp_us = euler_angle.timestamp_us();

        return obj;
    }

    static std::unique_ptr<rpc::telemetry_server::AngularVelocityBody>
    translateToRpcAngularVelocityBody(
        const mavsdk::TelemetryServer::AngularVelocityBody& angular_velocity_body)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry_server::AngularVelocityBody>();

        rpc_obj->set_roll_rad_s(angular_velocity_body.roll_rad_s);

        rpc_obj->set_pitch_rad_s(angular_velocity_body.pitch_rad_s);

        rpc_obj->set_yaw_rad_s(angular_velocity_body.yaw_rad_s);

        return rpc_obj;
    }

    static mavsdk::TelemetryServer::AngularVelocityBody translateFromRpcAngularVelocityBody(
        const rpc::telemetry_server::AngularVelocityBody& angular_velocity_body)
    {
        mavsdk::TelemetryServer::AngularVelocityBody obj;

        obj.roll_rad_s = angular_velocity_body.roll_rad_s();

        obj.pitch_rad_s = angular_velocity_body.pitch_rad_s();

        obj.yaw_rad_s = angular_velocity_body.yaw_rad_s();

        return obj;
    }

    static std::unique_ptr<rpc::telemetry_server::GpsInfo>
    translateToRpcGpsInfo(const mavsdk::TelemetryServer::GpsInfo& gps_info)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry_server::GpsInfo>();

        rpc_obj->set_num_satellites(gps_info.num_satellites);

        rpc_obj->set_fix_type(translateToRpcFixType(gps_info.fix_type));

        return rpc_obj;
    }

    static mavsdk::TelemetryServer::GpsInfo
    translateFromRpcGpsInfo(const rpc::telemetry_server::GpsInfo& gps_info)
    {
        mavsdk::TelemetryServer::GpsInfo obj;

        obj.num_satellites = gps_info.num_satellites();

        obj.fix_type = translateFromRpcFixType(gps_info.fix_type());

        return obj;
    }

    static std::unique_ptr<rpc::telemetry_server::RawGps>
    translateToRpcRawGps(const mavsdk::TelemetryServer::RawGps& raw_gps)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry_server::RawGps>();

        rpc_obj->set_timestamp_us(raw_gps.timestamp_us);

        rpc_obj->set_latitude_deg(raw_gps.latitude_deg);

        rpc_obj->set_longitude_deg(raw_gps.longitude_deg);

        rpc_obj->set_absolute_altitude_m(raw_gps.absolute_altitude_m);

        rpc_obj->set_hdop(raw_gps.hdop);

        rpc_obj->set_vdop(raw_gps.vdop);

        rpc_obj->set_velocity_m_s(raw_gps.velocity_m_s);

        rpc_obj->set_cog_deg(raw_gps.cog_deg);

        rpc_obj->set_altitude_ellipsoid_m(raw_gps.altitude_ellipsoid_m);

        rpc_obj->set_horizontal_uncertainty_m(raw_gps.horizontal_uncertainty_m);

        rpc_obj->set_vertical_uncertainty_m(raw_gps.vertical_uncertainty_m);

        rpc_obj->set_velocity_uncertainty_m_s(raw_gps.velocity_uncertainty_m_s);

        rpc_obj->set_heading_uncertainty_deg(raw_gps.heading_uncertainty_deg);

        rpc_obj->set_yaw_deg(raw_gps.yaw_deg);

        return rpc_obj;
    }

    static mavsdk::TelemetryServer::RawGps
    translateFromRpcRawGps(const rpc::telemetry_server::RawGps& raw_gps)
    {
        mavsdk::TelemetryServer::RawGps obj;

        obj.timestamp_us = raw_gps.timestamp_us();

        obj.latitude_deg = raw_gps.latitude_deg();

        obj.longitude_deg = raw_gps.longitude_deg();

        obj.absolute_altitude_m = raw_gps.absolute_altitude_m();

        obj.hdop = raw_gps.hdop();

        obj.vdop = raw_gps.vdop();

        obj.velocity_m_s = raw_gps.velocity_m_s();

        obj.cog_deg = raw_gps.cog_deg();

        obj.altitude_ellipsoid_m = raw_gps.altitude_ellipsoid_m();

        obj.horizontal_uncertainty_m = raw_gps.horizontal_uncertainty_m();

        obj.vertical_uncertainty_m = raw_gps.vertical_uncertainty_m();

        obj.velocity_uncertainty_m_s = raw_gps.velocity_uncertainty_m_s();

        obj.heading_uncertainty_deg = raw_gps.heading_uncertainty_deg();

        obj.yaw_deg = raw_gps.yaw_deg();

        return obj;
    }

    static std::unique_ptr<rpc::telemetry_server::Battery>
    translateToRpcBattery(const mavsdk::TelemetryServer::Battery& battery)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry_server::Battery>();

        rpc_obj->set_voltage_v(battery.voltage_v);

        rpc_obj->set_remaining_percent(battery.remaining_percent);

        return rpc_obj;
    }

    static mavsdk::TelemetryServer::Battery
    translateFromRpcBattery(const rpc::telemetry_server::Battery& battery)
    {
        mavsdk::TelemetryServer::Battery obj;

        obj.voltage_v = battery.voltage_v();

        obj.remaining_percent = battery.remaining_percent();

        return obj;
    }

    static std::unique_ptr<rpc::telemetry_server::RcStatus>
    translateToRpcRcStatus(const mavsdk::TelemetryServer::RcStatus& rc_status)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry_server::RcStatus>();

        rpc_obj->set_was_available_once(rc_status.was_available_once);

        rpc_obj->set_is_available(rc_status.is_available);

        rpc_obj->set_signal_strength_percent(rc_status.signal_strength_percent);

        return rpc_obj;
    }

    static mavsdk::TelemetryServer::RcStatus
    translateFromRpcRcStatus(const rpc::telemetry_server::RcStatus& rc_status)
    {
        mavsdk::TelemetryServer::RcStatus obj;

        obj.was_available_once = rc_status.was_available_once();

        obj.is_available = rc_status.is_available();

        obj.signal_strength_percent = rc_status.signal_strength_percent();

        return obj;
    }

    static std::unique_ptr<rpc::telemetry_server::StatusText>
    translateToRpcStatusText(const mavsdk::TelemetryServer::StatusText& status_text)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry_server::StatusText>();

        rpc_obj->set_type(translateToRpcStatusTextType(status_text.type));

        rpc_obj->set_text(status_text.text);

        return rpc_obj;
    }

    static mavsdk::TelemetryServer::StatusText
    translateFromRpcStatusText(const rpc::telemetry_server::StatusText& status_text)
    {
        mavsdk::TelemetryServer::StatusText obj;

        obj.type = translateFromRpcStatusTextType(status_text.type());

        obj.text = status_text.text();

        return obj;
    }

    static std::unique_ptr<rpc::telemetry_server::ActuatorControlTarget>
    translateToRpcActuatorControlTarget(
        const mavsdk::TelemetryServer::ActuatorControlTarget& actuator_control_target)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry_server::ActuatorControlTarget>();

        rpc_obj->set_group(actuator_control_target.group);

        for (const auto& elem : actuator_control_target.controls) {
            rpc_obj->add_controls(elem);
        }

        return rpc_obj;
    }

    static mavsdk::TelemetryServer::ActuatorControlTarget translateFromRpcActuatorControlTarget(
        const rpc::telemetry_server::ActuatorControlTarget& actuator_control_target)
    {
        mavsdk::TelemetryServer::ActuatorControlTarget obj;

        obj.group = actuator_control_target.group();

        for (const auto& elem : actuator_control_target.controls()) {
            obj.controls.push_back(elem);
        }

        return obj;
    }

    static std::unique_ptr<rpc::telemetry_server::ActuatorOutputStatus>
    translateToRpcActuatorOutputStatus(
        const mavsdk::TelemetryServer::ActuatorOutputStatus& actuator_output_status)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry_server::ActuatorOutputStatus>();

        rpc_obj->set_active(actuator_output_status.active);

        for (const auto& elem : actuator_output_status.actuator) {
            rpc_obj->add_actuator(elem);
        }

        return rpc_obj;
    }

    static mavsdk::TelemetryServer::ActuatorOutputStatus translateFromRpcActuatorOutputStatus(
        const rpc::telemetry_server::ActuatorOutputStatus& actuator_output_status)
    {
        mavsdk::TelemetryServer::ActuatorOutputStatus obj;

        obj.active = actuator_output_status.active();

        for (const auto& elem : actuator_output_status.actuator()) {
            obj.actuator.push_back(elem);
        }

        return obj;
    }

    static std::unique_ptr<rpc::telemetry_server::Covariance>
    translateToRpcCovariance(const mavsdk::TelemetryServer::Covariance& covariance)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry_server::Covariance>();

        for (const auto& elem : covariance.covariance_matrix) {
            rpc_obj->add_covariance_matrix(elem);
        }

        return rpc_obj;
    }

    static mavsdk::TelemetryServer::Covariance
    translateFromRpcCovariance(const rpc::telemetry_server::Covariance& covariance)
    {
        mavsdk::TelemetryServer::Covariance obj;

        for (const auto& elem : covariance.covariance_matrix()) {
            obj.covariance_matrix.push_back(elem);
        }

        return obj;
    }

    static std::unique_ptr<rpc::telemetry_server::VelocityBody>
    translateToRpcVelocityBody(const mavsdk::TelemetryServer::VelocityBody& velocity_body)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry_server::VelocityBody>();

        rpc_obj->set_x_m_s(velocity_body.x_m_s);

        rpc_obj->set_y_m_s(velocity_body.y_m_s);

        rpc_obj->set_z_m_s(velocity_body.z_m_s);

        return rpc_obj;
    }

    static mavsdk::TelemetryServer::VelocityBody
    translateFromRpcVelocityBody(const rpc::telemetry_server::VelocityBody& velocity_body)
    {
        mavsdk::TelemetryServer::VelocityBody obj;

        obj.x_m_s = velocity_body.x_m_s();

        obj.y_m_s = velocity_body.y_m_s();

        obj.z_m_s = velocity_body.z_m_s();

        return obj;
    }

    static std::unique_ptr<rpc::telemetry_server::PositionBody>
    translateToRpcPositionBody(const mavsdk::TelemetryServer::PositionBody& position_body)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry_server::PositionBody>();

        rpc_obj->set_x_m(position_body.x_m);

        rpc_obj->set_y_m(position_body.y_m);

        rpc_obj->set_z_m(position_body.z_m);

        return rpc_obj;
    }

    static mavsdk::TelemetryServer::PositionBody
    translateFromRpcPositionBody(const rpc::telemetry_server::PositionBody& position_body)
    {
        mavsdk::TelemetryServer::PositionBody obj;

        obj.x_m = position_body.x_m();

        obj.y_m = position_body.y_m();

        obj.z_m = position_body.z_m();

        return obj;
    }

    static rpc::telemetry_server::Odometry::MavFrame
    translateToRpcMavFrame(const mavsdk::TelemetryServer::Odometry::MavFrame& mav_frame)
    {
        switch (mav_frame) {
            default:
                LogErr() << "Unknown mav_frame enum value: " << static_cast<int>(mav_frame);
            // FALLTHROUGH
            case mavsdk::TelemetryServer::Odometry::MavFrame::Undef:
                return rpc::telemetry_server::Odometry_MavFrame_MAV_FRAME_UNDEF;
            case mavsdk::TelemetryServer::Odometry::MavFrame::BodyNed:
                return rpc::telemetry_server::Odometry_MavFrame_MAV_FRAME_BODY_NED;
            case mavsdk::TelemetryServer::Odometry::MavFrame::VisionNed:
                return rpc::telemetry_server::Odometry_MavFrame_MAV_FRAME_VISION_NED;
            case mavsdk::TelemetryServer::Odometry::MavFrame::EstimNed:
                return rpc::telemetry_server::Odometry_MavFrame_MAV_FRAME_ESTIM_NED;
        }
    }

    static mavsdk::TelemetryServer::Odometry::MavFrame
    translateFromRpcMavFrame(const rpc::telemetry_server::Odometry::MavFrame mav_frame)
    {
        switch (mav_frame) {
            default:
                LogErr() << "Unknown mav_frame enum value: " << static_cast<int>(mav_frame);
            // FALLTHROUGH
            case rpc::telemetry_server::Odometry_MavFrame_MAV_FRAME_UNDEF:
                return mavsdk::TelemetryServer::Odometry::MavFrame::Undef;
            case rpc::telemetry_server::Odometry_MavFrame_MAV_FRAME_BODY_NED:
                return mavsdk::TelemetryServer::Odometry::MavFrame::BodyNed;
            case rpc::telemetry_server::Odometry_MavFrame_MAV_FRAME_VISION_NED:
                return mavsdk::TelemetryServer::Odometry::MavFrame::VisionNed;
            case rpc::telemetry_server::Odometry_MavFrame_MAV_FRAME_ESTIM_NED:
                return mavsdk::TelemetryServer::Odometry::MavFrame::EstimNed;
        }
    }

    static std::unique_ptr<rpc::telemetry_server::Odometry>
    translateToRpcOdometry(const mavsdk::TelemetryServer::Odometry& odometry)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry_server::Odometry>();

        rpc_obj->set_time_usec(odometry.time_usec);

        rpc_obj->set_frame_id(translateToRpcMavFrame(odometry.frame_id));

        rpc_obj->set_child_frame_id(translateToRpcMavFrame(odometry.child_frame_id));

        rpc_obj->set_allocated_position_body(
            translateToRpcPositionBody(odometry.position_body).release());

        rpc_obj->set_allocated_q(translateToRpcQuaternion(odometry.q).release());

        rpc_obj->set_allocated_velocity_body(
            translateToRpcVelocityBody(odometry.velocity_body).release());

        rpc_obj->set_allocated_angular_velocity_body(
            translateToRpcAngularVelocityBody(odometry.angular_velocity_body).release());

        rpc_obj->set_allocated_pose_covariance(
            translateToRpcCovariance(odometry.pose_covariance).release());

        rpc_obj->set_allocated_velocity_covariance(
            translateToRpcCovariance(odometry.velocity_covariance).release());

        return rpc_obj;
    }

    static mavsdk::TelemetryServer::Odometry
    translateFromRpcOdometry(const rpc::telemetry_server::Odometry& odometry)
    {
        mavsdk::TelemetryServer::Odometry obj;

        obj.time_usec = odometry.time_usec();

        obj.frame_id = translateFromRpcMavFrame(odometry.frame_id());

        obj.child_frame_id = translateFromRpcMavFrame(odometry.child_frame_id());

        obj.position_body = translateFromRpcPositionBody(odometry.position_body());

        obj.q = translateFromRpcQuaternion(odometry.q());

        obj.velocity_body = translateFromRpcVelocityBody(odometry.velocity_body());

        obj.angular_velocity_body =
            translateFromRpcAngularVelocityBody(odometry.angular_velocity_body());

        obj.pose_covariance = translateFromRpcCovariance(odometry.pose_covariance());

        obj.velocity_covariance = translateFromRpcCovariance(odometry.velocity_covariance());

        return obj;
    }

    static std::unique_ptr<rpc::telemetry_server::DistanceSensor>
    translateToRpcDistanceSensor(const mavsdk::TelemetryServer::DistanceSensor& distance_sensor)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry_server::DistanceSensor>();

        rpc_obj->set_minimum_distance_m(distance_sensor.minimum_distance_m);

        rpc_obj->set_maximum_distance_m(distance_sensor.maximum_distance_m);

        rpc_obj->set_current_distance_m(distance_sensor.current_distance_m);

        return rpc_obj;
    }

    static mavsdk::TelemetryServer::DistanceSensor
    translateFromRpcDistanceSensor(const rpc::telemetry_server::DistanceSensor& distance_sensor)
    {
        mavsdk::TelemetryServer::DistanceSensor obj;

        obj.minimum_distance_m = distance_sensor.minimum_distance_m();

        obj.maximum_distance_m = distance_sensor.maximum_distance_m();

        obj.current_distance_m = distance_sensor.current_distance_m();

        return obj;
    }

    static std::unique_ptr<rpc::telemetry_server::ScaledPressure>
    translateToRpcScaledPressure(const mavsdk::TelemetryServer::ScaledPressure& scaled_pressure)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry_server::ScaledPressure>();

        rpc_obj->set_timestamp_us(scaled_pressure.timestamp_us);

        rpc_obj->set_absolute_pressure_hpa(scaled_pressure.absolute_pressure_hpa);

        rpc_obj->set_differential_pressure_hpa(scaled_pressure.differential_pressure_hpa);

        rpc_obj->set_temperature_deg(scaled_pressure.temperature_deg);

        rpc_obj->set_differential_pressure_temperature_deg(
            scaled_pressure.differential_pressure_temperature_deg);

        return rpc_obj;
    }

    static mavsdk::TelemetryServer::ScaledPressure
    translateFromRpcScaledPressure(const rpc::telemetry_server::ScaledPressure& scaled_pressure)
    {
        mavsdk::TelemetryServer::ScaledPressure obj;

        obj.timestamp_us = scaled_pressure.timestamp_us();

        obj.absolute_pressure_hpa = scaled_pressure.absolute_pressure_hpa();

        obj.differential_pressure_hpa = scaled_pressure.differential_pressure_hpa();

        obj.temperature_deg = scaled_pressure.temperature_deg();

        obj.differential_pressure_temperature_deg =
            scaled_pressure.differential_pressure_temperature_deg();

        return obj;
    }

    static std::unique_ptr<rpc::telemetry_server::PositionNed>
    translateToRpcPositionNed(const mavsdk::TelemetryServer::PositionNed& position_ned)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry_server::PositionNed>();

        rpc_obj->set_north_m(position_ned.north_m);

        rpc_obj->set_east_m(position_ned.east_m);

        rpc_obj->set_down_m(position_ned.down_m);

        return rpc_obj;
    }

    static mavsdk::TelemetryServer::PositionNed
    translateFromRpcPositionNed(const rpc::telemetry_server::PositionNed& position_ned)
    {
        mavsdk::TelemetryServer::PositionNed obj;

        obj.north_m = position_ned.north_m();

        obj.east_m = position_ned.east_m();

        obj.down_m = position_ned.down_m();

        return obj;
    }

    static std::unique_ptr<rpc::telemetry_server::VelocityNed>
    translateToRpcVelocityNed(const mavsdk::TelemetryServer::VelocityNed& velocity_ned)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry_server::VelocityNed>();

        rpc_obj->set_north_m_s(velocity_ned.north_m_s);

        rpc_obj->set_east_m_s(velocity_ned.east_m_s);

        rpc_obj->set_down_m_s(velocity_ned.down_m_s);

        return rpc_obj;
    }

    static mavsdk::TelemetryServer::VelocityNed
    translateFromRpcVelocityNed(const rpc::telemetry_server::VelocityNed& velocity_ned)
    {
        mavsdk::TelemetryServer::VelocityNed obj;

        obj.north_m_s = velocity_ned.north_m_s();

        obj.east_m_s = velocity_ned.east_m_s();

        obj.down_m_s = velocity_ned.down_m_s();

        return obj;
    }

    static std::unique_ptr<rpc::telemetry_server::PositionVelocityNed>
    translateToRpcPositionVelocityNed(
        const mavsdk::TelemetryServer::PositionVelocityNed& position_velocity_ned)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry_server::PositionVelocityNed>();

        rpc_obj->set_allocated_position(
            translateToRpcPositionNed(position_velocity_ned.position).release());

        rpc_obj->set_allocated_velocity(
            translateToRpcVelocityNed(position_velocity_ned.velocity).release());

        return rpc_obj;
    }

    static mavsdk::TelemetryServer::PositionVelocityNed translateFromRpcPositionVelocityNed(
        const rpc::telemetry_server::PositionVelocityNed& position_velocity_ned)
    {
        mavsdk::TelemetryServer::PositionVelocityNed obj;

        obj.position = translateFromRpcPositionNed(position_velocity_ned.position());

        obj.velocity = translateFromRpcVelocityNed(position_velocity_ned.velocity());

        return obj;
    }

    static std::unique_ptr<rpc::telemetry_server::GroundTruth>
    translateToRpcGroundTruth(const mavsdk::TelemetryServer::GroundTruth& ground_truth)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry_server::GroundTruth>();

        rpc_obj->set_latitude_deg(ground_truth.latitude_deg);

        rpc_obj->set_longitude_deg(ground_truth.longitude_deg);

        rpc_obj->set_absolute_altitude_m(ground_truth.absolute_altitude_m);

        return rpc_obj;
    }

    static mavsdk::TelemetryServer::GroundTruth
    translateFromRpcGroundTruth(const rpc::telemetry_server::GroundTruth& ground_truth)
    {
        mavsdk::TelemetryServer::GroundTruth obj;

        obj.latitude_deg = ground_truth.latitude_deg();

        obj.longitude_deg = ground_truth.longitude_deg();

        obj.absolute_altitude_m = ground_truth.absolute_altitude_m();

        return obj;
    }

    static std::unique_ptr<rpc::telemetry_server::FixedwingMetrics> translateToRpcFixedwingMetrics(
        const mavsdk::TelemetryServer::FixedwingMetrics& fixedwing_metrics)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry_server::FixedwingMetrics>();

        rpc_obj->set_airspeed_m_s(fixedwing_metrics.airspeed_m_s);

        rpc_obj->set_throttle_percentage(fixedwing_metrics.throttle_percentage);

        rpc_obj->set_climb_rate_m_s(fixedwing_metrics.climb_rate_m_s);

        return rpc_obj;
    }

    static mavsdk::TelemetryServer::FixedwingMetrics translateFromRpcFixedwingMetrics(
        const rpc::telemetry_server::FixedwingMetrics& fixedwing_metrics)
    {
        mavsdk::TelemetryServer::FixedwingMetrics obj;

        obj.airspeed_m_s = fixedwing_metrics.airspeed_m_s();

        obj.throttle_percentage = fixedwing_metrics.throttle_percentage();

        obj.climb_rate_m_s = fixedwing_metrics.climb_rate_m_s();

        return obj;
    }

    static std::unique_ptr<rpc::telemetry_server::AccelerationFrd>
    translateToRpcAccelerationFrd(const mavsdk::TelemetryServer::AccelerationFrd& acceleration_frd)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry_server::AccelerationFrd>();

        rpc_obj->set_forward_m_s2(acceleration_frd.forward_m_s2);

        rpc_obj->set_right_m_s2(acceleration_frd.right_m_s2);

        rpc_obj->set_down_m_s2(acceleration_frd.down_m_s2);

        return rpc_obj;
    }

    static mavsdk::TelemetryServer::AccelerationFrd
    translateFromRpcAccelerationFrd(const rpc::telemetry_server::AccelerationFrd& acceleration_frd)
    {
        mavsdk::TelemetryServer::AccelerationFrd obj;

        obj.forward_m_s2 = acceleration_frd.forward_m_s2();

        obj.right_m_s2 = acceleration_frd.right_m_s2();

        obj.down_m_s2 = acceleration_frd.down_m_s2();

        return obj;
    }

    static std::unique_ptr<rpc::telemetry_server::AngularVelocityFrd>
    translateToRpcAngularVelocityFrd(
        const mavsdk::TelemetryServer::AngularVelocityFrd& angular_velocity_frd)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry_server::AngularVelocityFrd>();

        rpc_obj->set_forward_rad_s(angular_velocity_frd.forward_rad_s);

        rpc_obj->set_right_rad_s(angular_velocity_frd.right_rad_s);

        rpc_obj->set_down_rad_s(angular_velocity_frd.down_rad_s);

        return rpc_obj;
    }

    static mavsdk::TelemetryServer::AngularVelocityFrd translateFromRpcAngularVelocityFrd(
        const rpc::telemetry_server::AngularVelocityFrd& angular_velocity_frd)
    {
        mavsdk::TelemetryServer::AngularVelocityFrd obj;

        obj.forward_rad_s = angular_velocity_frd.forward_rad_s();

        obj.right_rad_s = angular_velocity_frd.right_rad_s();

        obj.down_rad_s = angular_velocity_frd.down_rad_s();

        return obj;
    }

    static std::unique_ptr<rpc::telemetry_server::MagneticFieldFrd> translateToRpcMagneticFieldFrd(
        const mavsdk::TelemetryServer::MagneticFieldFrd& magnetic_field_frd)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry_server::MagneticFieldFrd>();

        rpc_obj->set_forward_gauss(magnetic_field_frd.forward_gauss);

        rpc_obj->set_right_gauss(magnetic_field_frd.right_gauss);

        rpc_obj->set_down_gauss(magnetic_field_frd.down_gauss);

        return rpc_obj;
    }

    static mavsdk::TelemetryServer::MagneticFieldFrd translateFromRpcMagneticFieldFrd(
        const rpc::telemetry_server::MagneticFieldFrd& magnetic_field_frd)
    {
        mavsdk::TelemetryServer::MagneticFieldFrd obj;

        obj.forward_gauss = magnetic_field_frd.forward_gauss();

        obj.right_gauss = magnetic_field_frd.right_gauss();

        obj.down_gauss = magnetic_field_frd.down_gauss();

        return obj;
    }

    static std::unique_ptr<rpc::telemetry_server::Imu>
    translateToRpcImu(const mavsdk::TelemetryServer::Imu& imu)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry_server::Imu>();

        rpc_obj->set_allocated_acceleration_frd(
            translateToRpcAccelerationFrd(imu.acceleration_frd).release());

        rpc_obj->set_allocated_angular_velocity_frd(
            translateToRpcAngularVelocityFrd(imu.angular_velocity_frd).release());

        rpc_obj->set_allocated_magnetic_field_frd(
            translateToRpcMagneticFieldFrd(imu.magnetic_field_frd).release());

        rpc_obj->set_temperature_degc(imu.temperature_degc);

        rpc_obj->set_timestamp_us(imu.timestamp_us);

        return rpc_obj;
    }

    static mavsdk::TelemetryServer::Imu translateFromRpcImu(const rpc::telemetry_server::Imu& imu)
    {
        mavsdk::TelemetryServer::Imu obj;

        obj.acceleration_frd = translateFromRpcAccelerationFrd(imu.acceleration_frd());

        obj.angular_velocity_frd = translateFromRpcAngularVelocityFrd(imu.angular_velocity_frd());

        obj.magnetic_field_frd = translateFromRpcMagneticFieldFrd(imu.magnetic_field_frd());

        obj.temperature_degc = imu.temperature_degc();

        obj.timestamp_us = imu.timestamp_us();

        return obj;
    }

    static rpc::telemetry_server::TelemetryServerResult::Result
    translateToRpcResult(const mavsdk::TelemetryServer::Result& result)
    {
        switch (result) {
            default:
                LogErr() << "Unknown result enum value: " << static_cast<int>(result);
            // FALLTHROUGH
            case mavsdk::TelemetryServer::Result::Unknown:
                return rpc::telemetry_server::TelemetryServerResult_Result_RESULT_UNKNOWN;
            case mavsdk::TelemetryServer::Result::Success:
                return rpc::telemetry_server::TelemetryServerResult_Result_RESULT_SUCCESS;
            case mavsdk::TelemetryServer::Result::NoSystem:
                return rpc::telemetry_server::TelemetryServerResult_Result_RESULT_NO_SYSTEM;
            case mavsdk::TelemetryServer::Result::ConnectionError:
                return rpc::telemetry_server::TelemetryServerResult_Result_RESULT_CONNECTION_ERROR;
            case mavsdk::TelemetryServer::Result::Busy:
                return rpc::telemetry_server::TelemetryServerResult_Result_RESULT_BUSY;
            case mavsdk::TelemetryServer::Result::CommandDenied:
                return rpc::telemetry_server::TelemetryServerResult_Result_RESULT_COMMAND_DENIED;
            case mavsdk::TelemetryServer::Result::Timeout:
                return rpc::telemetry_server::TelemetryServerResult_Result_RESULT_TIMEOUT;
            case mavsdk::TelemetryServer::Result::Unsupported:
                return rpc::telemetry_server::TelemetryServerResult_Result_RESULT_UNSUPPORTED;
        }
    }

    static mavsdk::TelemetryServer::Result
    translateFromRpcResult(const rpc::telemetry_server::TelemetryServerResult::Result result)
    {
        switch (result) {
            default:
                LogErr() << "Unknown result enum value: " << static_cast<int>(result);
            // FALLTHROUGH
            case rpc::telemetry_server::TelemetryServerResult_Result_RESULT_UNKNOWN:
                return mavsdk::TelemetryServer::Result::Unknown;
            case rpc::telemetry_server::TelemetryServerResult_Result_RESULT_SUCCESS:
                return mavsdk::TelemetryServer::Result::Success;
            case rpc::telemetry_server::TelemetryServerResult_Result_RESULT_NO_SYSTEM:
                return mavsdk::TelemetryServer::Result::NoSystem;
            case rpc::telemetry_server::TelemetryServerResult_Result_RESULT_CONNECTION_ERROR:
                return mavsdk::TelemetryServer::Result::ConnectionError;
            case rpc::telemetry_server::TelemetryServerResult_Result_RESULT_BUSY:
                return mavsdk::TelemetryServer::Result::Busy;
            case rpc::telemetry_server::TelemetryServerResult_Result_RESULT_COMMAND_DENIED:
                return mavsdk::TelemetryServer::Result::CommandDenied;
            case rpc::telemetry_server::TelemetryServerResult_Result_RESULT_TIMEOUT:
                return mavsdk::TelemetryServer::Result::Timeout;
            case rpc::telemetry_server::TelemetryServerResult_Result_RESULT_UNSUPPORTED:
                return mavsdk::TelemetryServer::Result::Unsupported;
        }
    }

    grpc::Status PublishPosition(
        grpc::ServerContext* /* context */,
        const rpc::telemetry_server::PublishPositionRequest* request,
        rpc::telemetry_server::PublishPositionResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                // For server plugins, this should never happen, they should always be
                // constructible.
                auto result = mavsdk::TelemetryServer::Result::Unknown;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "PublishPosition sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->publish_position(
            translateFromRpcPosition(request->position()),
            translateFromRpcVelocityNed(request->velocity_ned()),
            translateFromRpcHeading(request->heading()));

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status PublishHome(
        grpc::ServerContext* /* context */,
        const rpc::telemetry_server::PublishHomeRequest* request,
        rpc::telemetry_server::PublishHomeResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                // For server plugins, this should never happen, they should always be
                // constructible.
                auto result = mavsdk::TelemetryServer::Result::Unknown;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "PublishHome sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result =
            _lazy_plugin.maybe_plugin()->publish_home(translateFromRpcPosition(request->home()));

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status PublishSysStatus(
        grpc::ServerContext* /* context */,
        const rpc::telemetry_server::PublishSysStatusRequest* request,
        rpc::telemetry_server::PublishSysStatusResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                // For server plugins, this should never happen, they should always be
                // constructible.
                auto result = mavsdk::TelemetryServer::Result::Unknown;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "PublishSysStatus sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->publish_sys_status(
            translateFromRpcBattery(request->battery()),
            request->rc_receiver_status(),
            request->gyro_status(),
            request->accel_status(),
            request->mag_status(),
            request->gps_status());

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status PublishExtendedSysState(
        grpc::ServerContext* /* context */,
        const rpc::telemetry_server::PublishExtendedSysStateRequest* request,
        rpc::telemetry_server::PublishExtendedSysStateResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                // For server plugins, this should never happen, they should always be
                // constructible.
                auto result = mavsdk::TelemetryServer::Result::Unknown;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "PublishExtendedSysState sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->publish_extended_sys_state(
            translateFromRpcVtolState(request->vtol_state()),
            translateFromRpcLandedState(request->landed_state()));

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status PublishRawGps(
        grpc::ServerContext* /* context */,
        const rpc::telemetry_server::PublishRawGpsRequest* request,
        rpc::telemetry_server::PublishRawGpsResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                // For server plugins, this should never happen, they should always be
                // constructible.
                auto result = mavsdk::TelemetryServer::Result::Unknown;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "PublishRawGps sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->publish_raw_gps(
            translateFromRpcRawGps(request->raw_gps()),
            translateFromRpcGpsInfo(request->gps_info()));

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status PublishBattery(
        grpc::ServerContext* /* context */,
        const rpc::telemetry_server::PublishBatteryRequest* request,
        rpc::telemetry_server::PublishBatteryResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                // For server plugins, this should never happen, they should always be
                // constructible.
                auto result = mavsdk::TelemetryServer::Result::Unknown;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "PublishBattery sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->publish_battery(
            translateFromRpcBattery(request->battery()));

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status PublishStatusText(
        grpc::ServerContext* /* context */,
        const rpc::telemetry_server::PublishStatusTextRequest* request,
        rpc::telemetry_server::PublishStatusTextResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                // For server plugins, this should never happen, they should always be
                // constructible.
                auto result = mavsdk::TelemetryServer::Result::Unknown;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "PublishStatusText sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->publish_status_text(
            translateFromRpcStatusText(request->status_text()));

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status PublishOdometry(
        grpc::ServerContext* /* context */,
        const rpc::telemetry_server::PublishOdometryRequest* request,
        rpc::telemetry_server::PublishOdometryResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                // For server plugins, this should never happen, they should always be
                // constructible.
                auto result = mavsdk::TelemetryServer::Result::Unknown;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "PublishOdometry sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->publish_odometry(
            translateFromRpcOdometry(request->odometry()));

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status PublishPositionVelocityNed(
        grpc::ServerContext* /* context */,
        const rpc::telemetry_server::PublishPositionVelocityNedRequest* request,
        rpc::telemetry_server::PublishPositionVelocityNedResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                // For server plugins, this should never happen, they should always be
                // constructible.
                auto result = mavsdk::TelemetryServer::Result::Unknown;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "PublishPositionVelocityNed sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->publish_position_velocity_ned(
            translateFromRpcPositionVelocityNed(request->position_velocity_ned()));

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status PublishGroundTruth(
        grpc::ServerContext* /* context */,
        const rpc::telemetry_server::PublishGroundTruthRequest* request,
        rpc::telemetry_server::PublishGroundTruthResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                // For server plugins, this should never happen, they should always be
                // constructible.
                auto result = mavsdk::TelemetryServer::Result::Unknown;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "PublishGroundTruth sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->publish_ground_truth(
            translateFromRpcGroundTruth(request->ground_truth()));

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status PublishImu(
        grpc::ServerContext* /* context */,
        const rpc::telemetry_server::PublishImuRequest* request,
        rpc::telemetry_server::PublishImuResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                // For server plugins, this should never happen, they should always be
                // constructible.
                auto result = mavsdk::TelemetryServer::Result::Unknown;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "PublishImu sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->publish_imu(translateFromRpcImu(request->imu()));

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status PublishScaledImu(
        grpc::ServerContext* /* context */,
        const rpc::telemetry_server::PublishScaledImuRequest* request,
        rpc::telemetry_server::PublishScaledImuResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                // For server plugins, this should never happen, they should always be
                // constructible.
                auto result = mavsdk::TelemetryServer::Result::Unknown;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "PublishScaledImu sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result =
            _lazy_plugin.maybe_plugin()->publish_scaled_imu(translateFromRpcImu(request->imu()));

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status PublishRawImu(
        grpc::ServerContext* /* context */,
        const rpc::telemetry_server::PublishRawImuRequest* request,
        rpc::telemetry_server::PublishRawImuResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                // For server plugins, this should never happen, they should always be
                // constructible.
                auto result = mavsdk::TelemetryServer::Result::Unknown;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "PublishRawImu sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result =
            _lazy_plugin.maybe_plugin()->publish_raw_imu(translateFromRpcImu(request->imu()));

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status PublishUnixEpochTime(
        grpc::ServerContext* /* context */,
        const rpc::telemetry_server::PublishUnixEpochTimeRequest* request,
        rpc::telemetry_server::PublishUnixEpochTimeResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                // For server plugins, this should never happen, they should always be
                // constructible.
                auto result = mavsdk::TelemetryServer::Result::Unknown;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "PublishUnixEpochTime sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->publish_unix_epoch_time(request->time_us());

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status PublishDistanceSensor(
        grpc::ServerContext* /* context */,
        const rpc::telemetry_server::PublishDistanceSensorRequest* request,
        rpc::telemetry_server::PublishDistanceSensorResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                // For server plugins, this should never happen, they should always be
                // constructible.
                auto result = mavsdk::TelemetryServer::Result::Unknown;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "PublishDistanceSensor sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->publish_distance_sensor(
            translateFromRpcDistanceSensor(request->distance_sensor()));

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    void stop()
    {
        _stopped.store(true);
        std::lock_guard<std::mutex> lock(_stream_stop_mutex);
        for (auto& prom : _stream_stop_promises) {
            if (auto handle = prom.lock()) {
                handle->set_value();
            }
        }
    }

private:
    void register_stream_stop_promise(std::weak_ptr<std::promise<void>> prom)
    {
        // If we have already stopped, set promise immediately and don't add it to list.
        if (_stopped.load()) {
            if (auto handle = prom.lock()) {
                handle->set_value();
            }
        } else {
            std::lock_guard<std::mutex> lock(_stream_stop_mutex);
            _stream_stop_promises.push_back(prom);
        }
    }

    void unregister_stream_stop_promise(std::shared_ptr<std::promise<void>> prom)
    {
        std::lock_guard<std::mutex> lock(_stream_stop_mutex);
        for (auto it = _stream_stop_promises.begin(); it != _stream_stop_promises.end();
             /* ++it */) {
            if (it->lock() == prom) {
                it = _stream_stop_promises.erase(it);
            } else {
                ++it;
            }
        }
    }

    LazyServerPlugin& _lazy_plugin;

    std::atomic<bool> _stopped{false};
    std::mutex _stream_stop_mutex{};
    std::vector<std::weak_ptr<std::promise<void>>> _stream_stop_promises{};
};

} // namespace mavsdk_server
} // namespace mavsdk