// WARNING: THIS FILE IS AUTOGENERATED! As such, it should not be edited.
// Edits need to be made to the proto files
// (see https://github.com/mavlink/MAVSDK-Proto/blob/master/protos/telemetry/telemetry.proto)

#include "telemetry/telemetry.grpc.pb.h"
#include "plugins/telemetry/telemetry.h"

#include "mavsdk.h"

#include "lazy_plugin.h"

#include "log.h"
#include <atomic>
#include <cmath>
#include <future>
#include <limits>
#include <memory>
#include <mutex>
#include <sstream>
#include <vector>

namespace mavsdk {
namespace mavsdk_server {

template<typename Telemetry = Telemetry, typename LazyPlugin = LazyPlugin<Telemetry>>

class TelemetryServiceImpl final : public rpc::telemetry::TelemetryService::Service {
public:
    TelemetryServiceImpl(LazyPlugin& lazy_plugin) : _lazy_plugin(lazy_plugin) {}

    template<typename ResponseType>
    void fillResponseWithResult(ResponseType* response, mavsdk::Telemetry::Result& result) const
    {
        auto rpc_result = translateToRpcResult(result);

        auto* rpc_telemetry_result = new rpc::telemetry::TelemetryResult();
        rpc_telemetry_result->set_result(rpc_result);
        std::stringstream ss;
        ss << result;
        rpc_telemetry_result->set_result_str(ss.str());

        response->set_allocated_telemetry_result(rpc_telemetry_result);
    }

    static rpc::telemetry::FixType translateToRpcFixType(const mavsdk::Telemetry::FixType& fix_type)
    {
        switch (fix_type) {
            default:
                LogErr() << "Unknown fix_type enum value: " << static_cast<int>(fix_type);
            // FALLTHROUGH
            case mavsdk::Telemetry::FixType::NoGps:
                return rpc::telemetry::FIX_TYPE_NO_GPS;
            case mavsdk::Telemetry::FixType::NoFix:
                return rpc::telemetry::FIX_TYPE_NO_FIX;
            case mavsdk::Telemetry::FixType::Fix2D:
                return rpc::telemetry::FIX_TYPE_FIX_2D;
            case mavsdk::Telemetry::FixType::Fix3D:
                return rpc::telemetry::FIX_TYPE_FIX_3D;
            case mavsdk::Telemetry::FixType::FixDgps:
                return rpc::telemetry::FIX_TYPE_FIX_DGPS;
            case mavsdk::Telemetry::FixType::RtkFloat:
                return rpc::telemetry::FIX_TYPE_RTK_FLOAT;
            case mavsdk::Telemetry::FixType::RtkFixed:
                return rpc::telemetry::FIX_TYPE_RTK_FIXED;
        }
    }

    static mavsdk::Telemetry::FixType
    translateFromRpcFixType(const rpc::telemetry::FixType fix_type)
    {
        switch (fix_type) {
            default:
                LogErr() << "Unknown fix_type enum value: " << static_cast<int>(fix_type);
            // FALLTHROUGH
            case rpc::telemetry::FIX_TYPE_NO_GPS:
                return mavsdk::Telemetry::FixType::NoGps;
            case rpc::telemetry::FIX_TYPE_NO_FIX:
                return mavsdk::Telemetry::FixType::NoFix;
            case rpc::telemetry::FIX_TYPE_FIX_2D:
                return mavsdk::Telemetry::FixType::Fix2D;
            case rpc::telemetry::FIX_TYPE_FIX_3D:
                return mavsdk::Telemetry::FixType::Fix3D;
            case rpc::telemetry::FIX_TYPE_FIX_DGPS:
                return mavsdk::Telemetry::FixType::FixDgps;
            case rpc::telemetry::FIX_TYPE_RTK_FLOAT:
                return mavsdk::Telemetry::FixType::RtkFloat;
            case rpc::telemetry::FIX_TYPE_RTK_FIXED:
                return mavsdk::Telemetry::FixType::RtkFixed;
        }
    }

    static rpc::telemetry::FlightMode
    translateToRpcFlightMode(const mavsdk::Telemetry::FlightMode& flight_mode)
    {
        switch (flight_mode) {
            default:
                LogErr() << "Unknown flight_mode enum value: " << static_cast<int>(flight_mode);
            // FALLTHROUGH
            case mavsdk::Telemetry::FlightMode::Unknown:
                return rpc::telemetry::FLIGHT_MODE_UNKNOWN;
            case mavsdk::Telemetry::FlightMode::Ready:
                return rpc::telemetry::FLIGHT_MODE_READY;
            case mavsdk::Telemetry::FlightMode::Takeoff:
                return rpc::telemetry::FLIGHT_MODE_TAKEOFF;
            case mavsdk::Telemetry::FlightMode::Hold:
                return rpc::telemetry::FLIGHT_MODE_HOLD;
            case mavsdk::Telemetry::FlightMode::Mission:
                return rpc::telemetry::FLIGHT_MODE_MISSION;
            case mavsdk::Telemetry::FlightMode::ReturnToLaunch:
                return rpc::telemetry::FLIGHT_MODE_RETURN_TO_LAUNCH;
            case mavsdk::Telemetry::FlightMode::Land:
                return rpc::telemetry::FLIGHT_MODE_LAND;
            case mavsdk::Telemetry::FlightMode::Offboard:
                return rpc::telemetry::FLIGHT_MODE_OFFBOARD;
            case mavsdk::Telemetry::FlightMode::FollowMe:
                return rpc::telemetry::FLIGHT_MODE_FOLLOW_ME;
            case mavsdk::Telemetry::FlightMode::Manual:
                return rpc::telemetry::FLIGHT_MODE_MANUAL;
            case mavsdk::Telemetry::FlightMode::Altctl:
                return rpc::telemetry::FLIGHT_MODE_ALTCTL;
            case mavsdk::Telemetry::FlightMode::Posctl:
                return rpc::telemetry::FLIGHT_MODE_POSCTL;
            case mavsdk::Telemetry::FlightMode::Acro:
                return rpc::telemetry::FLIGHT_MODE_ACRO;
            case mavsdk::Telemetry::FlightMode::Stabilized:
                return rpc::telemetry::FLIGHT_MODE_STABILIZED;
            case mavsdk::Telemetry::FlightMode::Rattitude:
                return rpc::telemetry::FLIGHT_MODE_RATTITUDE;
        }
    }

    static mavsdk::Telemetry::FlightMode
    translateFromRpcFlightMode(const rpc::telemetry::FlightMode flight_mode)
    {
        switch (flight_mode) {
            default:
                LogErr() << "Unknown flight_mode enum value: " << static_cast<int>(flight_mode);
            // FALLTHROUGH
            case rpc::telemetry::FLIGHT_MODE_UNKNOWN:
                return mavsdk::Telemetry::FlightMode::Unknown;
            case rpc::telemetry::FLIGHT_MODE_READY:
                return mavsdk::Telemetry::FlightMode::Ready;
            case rpc::telemetry::FLIGHT_MODE_TAKEOFF:
                return mavsdk::Telemetry::FlightMode::Takeoff;
            case rpc::telemetry::FLIGHT_MODE_HOLD:
                return mavsdk::Telemetry::FlightMode::Hold;
            case rpc::telemetry::FLIGHT_MODE_MISSION:
                return mavsdk::Telemetry::FlightMode::Mission;
            case rpc::telemetry::FLIGHT_MODE_RETURN_TO_LAUNCH:
                return mavsdk::Telemetry::FlightMode::ReturnToLaunch;
            case rpc::telemetry::FLIGHT_MODE_LAND:
                return mavsdk::Telemetry::FlightMode::Land;
            case rpc::telemetry::FLIGHT_MODE_OFFBOARD:
                return mavsdk::Telemetry::FlightMode::Offboard;
            case rpc::telemetry::FLIGHT_MODE_FOLLOW_ME:
                return mavsdk::Telemetry::FlightMode::FollowMe;
            case rpc::telemetry::FLIGHT_MODE_MANUAL:
                return mavsdk::Telemetry::FlightMode::Manual;
            case rpc::telemetry::FLIGHT_MODE_ALTCTL:
                return mavsdk::Telemetry::FlightMode::Altctl;
            case rpc::telemetry::FLIGHT_MODE_POSCTL:
                return mavsdk::Telemetry::FlightMode::Posctl;
            case rpc::telemetry::FLIGHT_MODE_ACRO:
                return mavsdk::Telemetry::FlightMode::Acro;
            case rpc::telemetry::FLIGHT_MODE_STABILIZED:
                return mavsdk::Telemetry::FlightMode::Stabilized;
            case rpc::telemetry::FLIGHT_MODE_RATTITUDE:
                return mavsdk::Telemetry::FlightMode::Rattitude;
        }
    }

    static rpc::telemetry::StatusTextType
    translateToRpcStatusTextType(const mavsdk::Telemetry::StatusTextType& status_text_type)
    {
        switch (status_text_type) {
            default:
                LogErr() << "Unknown status_text_type enum value: "
                         << static_cast<int>(status_text_type);
            // FALLTHROUGH
            case mavsdk::Telemetry::StatusTextType::Debug:
                return rpc::telemetry::STATUS_TEXT_TYPE_DEBUG;
            case mavsdk::Telemetry::StatusTextType::Info:
                return rpc::telemetry::STATUS_TEXT_TYPE_INFO;
            case mavsdk::Telemetry::StatusTextType::Notice:
                return rpc::telemetry::STATUS_TEXT_TYPE_NOTICE;
            case mavsdk::Telemetry::StatusTextType::Warning:
                return rpc::telemetry::STATUS_TEXT_TYPE_WARNING;
            case mavsdk::Telemetry::StatusTextType::Error:
                return rpc::telemetry::STATUS_TEXT_TYPE_ERROR;
            case mavsdk::Telemetry::StatusTextType::Critical:
                return rpc::telemetry::STATUS_TEXT_TYPE_CRITICAL;
            case mavsdk::Telemetry::StatusTextType::Alert:
                return rpc::telemetry::STATUS_TEXT_TYPE_ALERT;
            case mavsdk::Telemetry::StatusTextType::Emergency:
                return rpc::telemetry::STATUS_TEXT_TYPE_EMERGENCY;
        }
    }

    static mavsdk::Telemetry::StatusTextType
    translateFromRpcStatusTextType(const rpc::telemetry::StatusTextType status_text_type)
    {
        switch (status_text_type) {
            default:
                LogErr() << "Unknown status_text_type enum value: "
                         << static_cast<int>(status_text_type);
            // FALLTHROUGH
            case rpc::telemetry::STATUS_TEXT_TYPE_DEBUG:
                return mavsdk::Telemetry::StatusTextType::Debug;
            case rpc::telemetry::STATUS_TEXT_TYPE_INFO:
                return mavsdk::Telemetry::StatusTextType::Info;
            case rpc::telemetry::STATUS_TEXT_TYPE_NOTICE:
                return mavsdk::Telemetry::StatusTextType::Notice;
            case rpc::telemetry::STATUS_TEXT_TYPE_WARNING:
                return mavsdk::Telemetry::StatusTextType::Warning;
            case rpc::telemetry::STATUS_TEXT_TYPE_ERROR:
                return mavsdk::Telemetry::StatusTextType::Error;
            case rpc::telemetry::STATUS_TEXT_TYPE_CRITICAL:
                return mavsdk::Telemetry::StatusTextType::Critical;
            case rpc::telemetry::STATUS_TEXT_TYPE_ALERT:
                return mavsdk::Telemetry::StatusTextType::Alert;
            case rpc::telemetry::STATUS_TEXT_TYPE_EMERGENCY:
                return mavsdk::Telemetry::StatusTextType::Emergency;
        }
    }

    static rpc::telemetry::LandedState
    translateToRpcLandedState(const mavsdk::Telemetry::LandedState& landed_state)
    {
        switch (landed_state) {
            default:
                LogErr() << "Unknown landed_state enum value: " << static_cast<int>(landed_state);
            // FALLTHROUGH
            case mavsdk::Telemetry::LandedState::Unknown:
                return rpc::telemetry::LANDED_STATE_UNKNOWN;
            case mavsdk::Telemetry::LandedState::OnGround:
                return rpc::telemetry::LANDED_STATE_ON_GROUND;
            case mavsdk::Telemetry::LandedState::InAir:
                return rpc::telemetry::LANDED_STATE_IN_AIR;
            case mavsdk::Telemetry::LandedState::TakingOff:
                return rpc::telemetry::LANDED_STATE_TAKING_OFF;
            case mavsdk::Telemetry::LandedState::Landing:
                return rpc::telemetry::LANDED_STATE_LANDING;
        }
    }

    static mavsdk::Telemetry::LandedState
    translateFromRpcLandedState(const rpc::telemetry::LandedState landed_state)
    {
        switch (landed_state) {
            default:
                LogErr() << "Unknown landed_state enum value: " << static_cast<int>(landed_state);
            // FALLTHROUGH
            case rpc::telemetry::LANDED_STATE_UNKNOWN:
                return mavsdk::Telemetry::LandedState::Unknown;
            case rpc::telemetry::LANDED_STATE_ON_GROUND:
                return mavsdk::Telemetry::LandedState::OnGround;
            case rpc::telemetry::LANDED_STATE_IN_AIR:
                return mavsdk::Telemetry::LandedState::InAir;
            case rpc::telemetry::LANDED_STATE_TAKING_OFF:
                return mavsdk::Telemetry::LandedState::TakingOff;
            case rpc::telemetry::LANDED_STATE_LANDING:
                return mavsdk::Telemetry::LandedState::Landing;
        }
    }

    static rpc::telemetry::VtolState
    translateToRpcVtolState(const mavsdk::Telemetry::VtolState& vtol_state)
    {
        switch (vtol_state) {
            default:
                LogErr() << "Unknown vtol_state enum value: " << static_cast<int>(vtol_state);
            // FALLTHROUGH
            case mavsdk::Telemetry::VtolState::Undefined:
                return rpc::telemetry::VTOL_STATE_UNDEFINED;
            case mavsdk::Telemetry::VtolState::TransitionToFw:
                return rpc::telemetry::VTOL_STATE_TRANSITION_TO_FW;
            case mavsdk::Telemetry::VtolState::TransitionToMc:
                return rpc::telemetry::VTOL_STATE_TRANSITION_TO_MC;
            case mavsdk::Telemetry::VtolState::Mc:
                return rpc::telemetry::VTOL_STATE_MC;
            case mavsdk::Telemetry::VtolState::Fw:
                return rpc::telemetry::VTOL_STATE_FW;
        }
    }

    static mavsdk::Telemetry::VtolState
    translateFromRpcVtolState(const rpc::telemetry::VtolState vtol_state)
    {
        switch (vtol_state) {
            default:
                LogErr() << "Unknown vtol_state enum value: " << static_cast<int>(vtol_state);
            // FALLTHROUGH
            case rpc::telemetry::VTOL_STATE_UNDEFINED:
                return mavsdk::Telemetry::VtolState::Undefined;
            case rpc::telemetry::VTOL_STATE_TRANSITION_TO_FW:
                return mavsdk::Telemetry::VtolState::TransitionToFw;
            case rpc::telemetry::VTOL_STATE_TRANSITION_TO_MC:
                return mavsdk::Telemetry::VtolState::TransitionToMc;
            case rpc::telemetry::VTOL_STATE_MC:
                return mavsdk::Telemetry::VtolState::Mc;
            case rpc::telemetry::VTOL_STATE_FW:
                return mavsdk::Telemetry::VtolState::Fw;
        }
    }

    static std::unique_ptr<rpc::telemetry::Position>
    translateToRpcPosition(const mavsdk::Telemetry::Position& position)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry::Position>();

        rpc_obj->set_latitude_deg(position.latitude_deg);

        rpc_obj->set_longitude_deg(position.longitude_deg);

        rpc_obj->set_absolute_altitude_m(position.absolute_altitude_m);

        rpc_obj->set_relative_altitude_m(position.relative_altitude_m);

        return rpc_obj;
    }

    static mavsdk::Telemetry::Position
    translateFromRpcPosition(const rpc::telemetry::Position& position)
    {
        mavsdk::Telemetry::Position obj;

        obj.latitude_deg = position.latitude_deg();

        obj.longitude_deg = position.longitude_deg();

        obj.absolute_altitude_m = position.absolute_altitude_m();

        obj.relative_altitude_m = position.relative_altitude_m();

        return obj;
    }

    static std::unique_ptr<rpc::telemetry::Heading>
    translateToRpcHeading(const mavsdk::Telemetry::Heading& heading)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry::Heading>();

        rpc_obj->set_heading_deg(heading.heading_deg);

        return rpc_obj;
    }

    static mavsdk::Telemetry::Heading
    translateFromRpcHeading(const rpc::telemetry::Heading& heading)
    {
        mavsdk::Telemetry::Heading obj;

        obj.heading_deg = heading.heading_deg();

        return obj;
    }

    static std::unique_ptr<rpc::telemetry::Quaternion>
    translateToRpcQuaternion(const mavsdk::Telemetry::Quaternion& quaternion)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry::Quaternion>();

        rpc_obj->set_w(quaternion.w);

        rpc_obj->set_x(quaternion.x);

        rpc_obj->set_y(quaternion.y);

        rpc_obj->set_z(quaternion.z);

        rpc_obj->set_timestamp_us(quaternion.timestamp_us);

        return rpc_obj;
    }

    static mavsdk::Telemetry::Quaternion
    translateFromRpcQuaternion(const rpc::telemetry::Quaternion& quaternion)
    {
        mavsdk::Telemetry::Quaternion obj;

        obj.w = quaternion.w();

        obj.x = quaternion.x();

        obj.y = quaternion.y();

        obj.z = quaternion.z();

        obj.timestamp_us = quaternion.timestamp_us();

        return obj;
    }

    static std::unique_ptr<rpc::telemetry::EulerAngle>
    translateToRpcEulerAngle(const mavsdk::Telemetry::EulerAngle& euler_angle)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry::EulerAngle>();

        rpc_obj->set_roll_deg(euler_angle.roll_deg);

        rpc_obj->set_pitch_deg(euler_angle.pitch_deg);

        rpc_obj->set_yaw_deg(euler_angle.yaw_deg);

        rpc_obj->set_timestamp_us(euler_angle.timestamp_us);

        return rpc_obj;
    }

    static mavsdk::Telemetry::EulerAngle
    translateFromRpcEulerAngle(const rpc::telemetry::EulerAngle& euler_angle)
    {
        mavsdk::Telemetry::EulerAngle obj;

        obj.roll_deg = euler_angle.roll_deg();

        obj.pitch_deg = euler_angle.pitch_deg();

        obj.yaw_deg = euler_angle.yaw_deg();

        obj.timestamp_us = euler_angle.timestamp_us();

        return obj;
    }

    static std::unique_ptr<rpc::telemetry::AngularVelocityBody> translateToRpcAngularVelocityBody(
        const mavsdk::Telemetry::AngularVelocityBody& angular_velocity_body)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry::AngularVelocityBody>();

        rpc_obj->set_roll_rad_s(angular_velocity_body.roll_rad_s);

        rpc_obj->set_pitch_rad_s(angular_velocity_body.pitch_rad_s);

        rpc_obj->set_yaw_rad_s(angular_velocity_body.yaw_rad_s);

        return rpc_obj;
    }

    static mavsdk::Telemetry::AngularVelocityBody translateFromRpcAngularVelocityBody(
        const rpc::telemetry::AngularVelocityBody& angular_velocity_body)
    {
        mavsdk::Telemetry::AngularVelocityBody obj;

        obj.roll_rad_s = angular_velocity_body.roll_rad_s();

        obj.pitch_rad_s = angular_velocity_body.pitch_rad_s();

        obj.yaw_rad_s = angular_velocity_body.yaw_rad_s();

        return obj;
    }

    static std::unique_ptr<rpc::telemetry::GpsInfo>
    translateToRpcGpsInfo(const mavsdk::Telemetry::GpsInfo& gps_info)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry::GpsInfo>();

        rpc_obj->set_num_satellites(gps_info.num_satellites);

        rpc_obj->set_fix_type(translateToRpcFixType(gps_info.fix_type));

        return rpc_obj;
    }

    static mavsdk::Telemetry::GpsInfo
    translateFromRpcGpsInfo(const rpc::telemetry::GpsInfo& gps_info)
    {
        mavsdk::Telemetry::GpsInfo obj;

        obj.num_satellites = gps_info.num_satellites();

        obj.fix_type = translateFromRpcFixType(gps_info.fix_type());

        return obj;
    }

    static std::unique_ptr<rpc::telemetry::RawGps>
    translateToRpcRawGps(const mavsdk::Telemetry::RawGps& raw_gps)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry::RawGps>();

        rpc_obj->set_timestamp_us(raw_gps.timestamp_us);

        rpc_obj->set_latitude_deg(raw_gps.latitude_deg);

        rpc_obj->set_longitude_deg(raw_gps.longitude_deg);

        rpc_obj->set_absolute_altitude_m(raw_gps.absolute_altitude_m);

        rpc_obj->set_hdop(raw_gps.hdop);

        rpc_obj->set_vdop(raw_gps.vdop);

        rpc_obj->set_velocity_m_s(raw_gps.velocity_m_s);

        rpc_obj->set_cog_deg(raw_gps.cog_deg);

        rpc_obj->set_altitude_ellipsoid_m(raw_gps.altitude_ellipsoid_m);

        rpc_obj->set_horizontal_uncertainty_m(raw_gps.horizontal_uncertainty_m);

        rpc_obj->set_vertical_uncertainty_m(raw_gps.vertical_uncertainty_m);

        rpc_obj->set_velocity_uncertainty_m_s(raw_gps.velocity_uncertainty_m_s);

        rpc_obj->set_heading_uncertainty_deg(raw_gps.heading_uncertainty_deg);

        rpc_obj->set_yaw_deg(raw_gps.yaw_deg);

        return rpc_obj;
    }

    static mavsdk::Telemetry::RawGps translateFromRpcRawGps(const rpc::telemetry::RawGps& raw_gps)
    {
        mavsdk::Telemetry::RawGps obj;

        obj.timestamp_us = raw_gps.timestamp_us();

        obj.latitude_deg = raw_gps.latitude_deg();

        obj.longitude_deg = raw_gps.longitude_deg();

        obj.absolute_altitude_m = raw_gps.absolute_altitude_m();

        obj.hdop = raw_gps.hdop();

        obj.vdop = raw_gps.vdop();

        obj.velocity_m_s = raw_gps.velocity_m_s();

        obj.cog_deg = raw_gps.cog_deg();

        obj.altitude_ellipsoid_m = raw_gps.altitude_ellipsoid_m();

        obj.horizontal_uncertainty_m = raw_gps.horizontal_uncertainty_m();

        obj.vertical_uncertainty_m = raw_gps.vertical_uncertainty_m();

        obj.velocity_uncertainty_m_s = raw_gps.velocity_uncertainty_m_s();

        obj.heading_uncertainty_deg = raw_gps.heading_uncertainty_deg();

        obj.yaw_deg = raw_gps.yaw_deg();

        return obj;
    }

    static std::unique_ptr<rpc::telemetry::Battery>
    translateToRpcBattery(const mavsdk::Telemetry::Battery& battery)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry::Battery>();

        rpc_obj->set_id(battery.id);

        rpc_obj->set_temperature_degc(battery.temperature_degc);

        rpc_obj->set_voltage_v(battery.voltage_v);

        rpc_obj->set_current_battery_a(battery.current_battery_a);

        rpc_obj->set_capacity_consumed_ah(battery.capacity_consumed_ah);

        rpc_obj->set_remaining_percent(battery.remaining_percent);

        return rpc_obj;
    }

    static mavsdk::Telemetry::Battery
    translateFromRpcBattery(const rpc::telemetry::Battery& battery)
    {
        mavsdk::Telemetry::Battery obj;

        obj.id = battery.id();

        obj.temperature_degc = battery.temperature_degc();

        obj.voltage_v = battery.voltage_v();

        obj.current_battery_a = battery.current_battery_a();

        obj.capacity_consumed_ah = battery.capacity_consumed_ah();

        obj.remaining_percent = battery.remaining_percent();

        return obj;
    }

    static std::unique_ptr<rpc::telemetry::Health>
    translateToRpcHealth(const mavsdk::Telemetry::Health& health)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry::Health>();

        rpc_obj->set_is_gyrometer_calibration_ok(health.is_gyrometer_calibration_ok);

        rpc_obj->set_is_accelerometer_calibration_ok(health.is_accelerometer_calibration_ok);

        rpc_obj->set_is_magnetometer_calibration_ok(health.is_magnetometer_calibration_ok);

        rpc_obj->set_is_local_position_ok(health.is_local_position_ok);

        rpc_obj->set_is_global_position_ok(health.is_global_position_ok);

        rpc_obj->set_is_home_position_ok(health.is_home_position_ok);

        rpc_obj->set_is_armable(health.is_armable);

        return rpc_obj;
    }

    static mavsdk::Telemetry::Health translateFromRpcHealth(const rpc::telemetry::Health& health)
    {
        mavsdk::Telemetry::Health obj;

        obj.is_gyrometer_calibration_ok = health.is_gyrometer_calibration_ok();

        obj.is_accelerometer_calibration_ok = health.is_accelerometer_calibration_ok();

        obj.is_magnetometer_calibration_ok = health.is_magnetometer_calibration_ok();

        obj.is_local_position_ok = health.is_local_position_ok();

        obj.is_global_position_ok = health.is_global_position_ok();

        obj.is_home_position_ok = health.is_home_position_ok();

        obj.is_armable = health.is_armable();

        return obj;
    }

    static std::unique_ptr<rpc::telemetry::RcStatus>
    translateToRpcRcStatus(const mavsdk::Telemetry::RcStatus& rc_status)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry::RcStatus>();

        rpc_obj->set_was_available_once(rc_status.was_available_once);

        rpc_obj->set_is_available(rc_status.is_available);

        rpc_obj->set_signal_strength_percent(rc_status.signal_strength_percent);

        return rpc_obj;
    }

    static mavsdk::Telemetry::RcStatus
    translateFromRpcRcStatus(const rpc::telemetry::RcStatus& rc_status)
    {
        mavsdk::Telemetry::RcStatus obj;

        obj.was_available_once = rc_status.was_available_once();

        obj.is_available = rc_status.is_available();

        obj.signal_strength_percent = rc_status.signal_strength_percent();

        return obj;
    }

    static std::unique_ptr<rpc::telemetry::StatusText>
    translateToRpcStatusText(const mavsdk::Telemetry::StatusText& status_text)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry::StatusText>();

        rpc_obj->set_type(translateToRpcStatusTextType(status_text.type));

        rpc_obj->set_text(status_text.text);

        return rpc_obj;
    }

    static mavsdk::Telemetry::StatusText
    translateFromRpcStatusText(const rpc::telemetry::StatusText& status_text)
    {
        mavsdk::Telemetry::StatusText obj;

        obj.type = translateFromRpcStatusTextType(status_text.type());

        obj.text = status_text.text();

        return obj;
    }

    static std::unique_ptr<rpc::telemetry::ActuatorControlTarget>
    translateToRpcActuatorControlTarget(
        const mavsdk::Telemetry::ActuatorControlTarget& actuator_control_target)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry::ActuatorControlTarget>();

        rpc_obj->set_group(actuator_control_target.group);

        for (const auto& elem : actuator_control_target.controls) {
            rpc_obj->add_controls(elem);
        }

        return rpc_obj;
    }

    static mavsdk::Telemetry::ActuatorControlTarget translateFromRpcActuatorControlTarget(
        const rpc::telemetry::ActuatorControlTarget& actuator_control_target)
    {
        mavsdk::Telemetry::ActuatorControlTarget obj;

        obj.group = actuator_control_target.group();

        for (const auto& elem : actuator_control_target.controls()) {
            obj.controls.push_back(elem);
        }

        return obj;
    }

    static std::unique_ptr<rpc::telemetry::ActuatorOutputStatus> translateToRpcActuatorOutputStatus(
        const mavsdk::Telemetry::ActuatorOutputStatus& actuator_output_status)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry::ActuatorOutputStatus>();

        rpc_obj->set_active(actuator_output_status.active);

        for (const auto& elem : actuator_output_status.actuator) {
            rpc_obj->add_actuator(elem);
        }

        return rpc_obj;
    }

    static mavsdk::Telemetry::ActuatorOutputStatus translateFromRpcActuatorOutputStatus(
        const rpc::telemetry::ActuatorOutputStatus& actuator_output_status)
    {
        mavsdk::Telemetry::ActuatorOutputStatus obj;

        obj.active = actuator_output_status.active();

        for (const auto& elem : actuator_output_status.actuator()) {
            obj.actuator.push_back(elem);
        }

        return obj;
    }

    static std::unique_ptr<rpc::telemetry::Covariance>
    translateToRpcCovariance(const mavsdk::Telemetry::Covariance& covariance)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry::Covariance>();

        for (const auto& elem : covariance.covariance_matrix) {
            rpc_obj->add_covariance_matrix(elem);
        }

        return rpc_obj;
    }

    static mavsdk::Telemetry::Covariance
    translateFromRpcCovariance(const rpc::telemetry::Covariance& covariance)
    {
        mavsdk::Telemetry::Covariance obj;

        for (const auto& elem : covariance.covariance_matrix()) {
            obj.covariance_matrix.push_back(elem);
        }

        return obj;
    }

    static std::unique_ptr<rpc::telemetry::VelocityBody>
    translateToRpcVelocityBody(const mavsdk::Telemetry::VelocityBody& velocity_body)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry::VelocityBody>();

        rpc_obj->set_x_m_s(velocity_body.x_m_s);

        rpc_obj->set_y_m_s(velocity_body.y_m_s);

        rpc_obj->set_z_m_s(velocity_body.z_m_s);

        return rpc_obj;
    }

    static mavsdk::Telemetry::VelocityBody
    translateFromRpcVelocityBody(const rpc::telemetry::VelocityBody& velocity_body)
    {
        mavsdk::Telemetry::VelocityBody obj;

        obj.x_m_s = velocity_body.x_m_s();

        obj.y_m_s = velocity_body.y_m_s();

        obj.z_m_s = velocity_body.z_m_s();

        return obj;
    }

    static std::unique_ptr<rpc::telemetry::PositionBody>
    translateToRpcPositionBody(const mavsdk::Telemetry::PositionBody& position_body)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry::PositionBody>();

        rpc_obj->set_x_m(position_body.x_m);

        rpc_obj->set_y_m(position_body.y_m);

        rpc_obj->set_z_m(position_body.z_m);

        return rpc_obj;
    }

    static mavsdk::Telemetry::PositionBody
    translateFromRpcPositionBody(const rpc::telemetry::PositionBody& position_body)
    {
        mavsdk::Telemetry::PositionBody obj;

        obj.x_m = position_body.x_m();

        obj.y_m = position_body.y_m();

        obj.z_m = position_body.z_m();

        return obj;
    }

    static rpc::telemetry::Odometry::MavFrame
    translateToRpcMavFrame(const mavsdk::Telemetry::Odometry::MavFrame& mav_frame)
    {
        switch (mav_frame) {
            default:
                LogErr() << "Unknown mav_frame enum value: " << static_cast<int>(mav_frame);
            // FALLTHROUGH
            case mavsdk::Telemetry::Odometry::MavFrame::Undef:
                return rpc::telemetry::Odometry_MavFrame_MAV_FRAME_UNDEF;
            case mavsdk::Telemetry::Odometry::MavFrame::BodyNed:
                return rpc::telemetry::Odometry_MavFrame_MAV_FRAME_BODY_NED;
            case mavsdk::Telemetry::Odometry::MavFrame::VisionNed:
                return rpc::telemetry::Odometry_MavFrame_MAV_FRAME_VISION_NED;
            case mavsdk::Telemetry::Odometry::MavFrame::EstimNed:
                return rpc::telemetry::Odometry_MavFrame_MAV_FRAME_ESTIM_NED;
        }
    }

    static mavsdk::Telemetry::Odometry::MavFrame
    translateFromRpcMavFrame(const rpc::telemetry::Odometry::MavFrame mav_frame)
    {
        switch (mav_frame) {
            default:
                LogErr() << "Unknown mav_frame enum value: " << static_cast<int>(mav_frame);
            // FALLTHROUGH
            case rpc::telemetry::Odometry_MavFrame_MAV_FRAME_UNDEF:
                return mavsdk::Telemetry::Odometry::MavFrame::Undef;
            case rpc::telemetry::Odometry_MavFrame_MAV_FRAME_BODY_NED:
                return mavsdk::Telemetry::Odometry::MavFrame::BodyNed;
            case rpc::telemetry::Odometry_MavFrame_MAV_FRAME_VISION_NED:
                return mavsdk::Telemetry::Odometry::MavFrame::VisionNed;
            case rpc::telemetry::Odometry_MavFrame_MAV_FRAME_ESTIM_NED:
                return mavsdk::Telemetry::Odometry::MavFrame::EstimNed;
        }
    }

    static std::unique_ptr<rpc::telemetry::Odometry>
    translateToRpcOdometry(const mavsdk::Telemetry::Odometry& odometry)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry::Odometry>();

        rpc_obj->set_time_usec(odometry.time_usec);

        rpc_obj->set_frame_id(translateToRpcMavFrame(odometry.frame_id));

        rpc_obj->set_child_frame_id(translateToRpcMavFrame(odometry.child_frame_id));

        rpc_obj->set_allocated_position_body(
            translateToRpcPositionBody(odometry.position_body).release());

        rpc_obj->set_allocated_q(translateToRpcQuaternion(odometry.q).release());

        rpc_obj->set_allocated_velocity_body(
            translateToRpcVelocityBody(odometry.velocity_body).release());

        rpc_obj->set_allocated_angular_velocity_body(
            translateToRpcAngularVelocityBody(odometry.angular_velocity_body).release());

        rpc_obj->set_allocated_pose_covariance(
            translateToRpcCovariance(odometry.pose_covariance).release());

        rpc_obj->set_allocated_velocity_covariance(
            translateToRpcCovariance(odometry.velocity_covariance).release());

        return rpc_obj;
    }

    static mavsdk::Telemetry::Odometry
    translateFromRpcOdometry(const rpc::telemetry::Odometry& odometry)
    {
        mavsdk::Telemetry::Odometry obj;

        obj.time_usec = odometry.time_usec();

        obj.frame_id = translateFromRpcMavFrame(odometry.frame_id());

        obj.child_frame_id = translateFromRpcMavFrame(odometry.child_frame_id());

        obj.position_body = translateFromRpcPositionBody(odometry.position_body());

        obj.q = translateFromRpcQuaternion(odometry.q());

        obj.velocity_body = translateFromRpcVelocityBody(odometry.velocity_body());

        obj.angular_velocity_body =
            translateFromRpcAngularVelocityBody(odometry.angular_velocity_body());

        obj.pose_covariance = translateFromRpcCovariance(odometry.pose_covariance());

        obj.velocity_covariance = translateFromRpcCovariance(odometry.velocity_covariance());

        return obj;
    }

    static std::unique_ptr<rpc::telemetry::DistanceSensor>
    translateToRpcDistanceSensor(const mavsdk::Telemetry::DistanceSensor& distance_sensor)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry::DistanceSensor>();

        rpc_obj->set_minimum_distance_m(distance_sensor.minimum_distance_m);

        rpc_obj->set_maximum_distance_m(distance_sensor.maximum_distance_m);

        rpc_obj->set_current_distance_m(distance_sensor.current_distance_m);

        rpc_obj->set_allocated_orientation(
            translateToRpcEulerAngle(distance_sensor.orientation).release());

        return rpc_obj;
    }

    static mavsdk::Telemetry::DistanceSensor
    translateFromRpcDistanceSensor(const rpc::telemetry::DistanceSensor& distance_sensor)
    {
        mavsdk::Telemetry::DistanceSensor obj;

        obj.minimum_distance_m = distance_sensor.minimum_distance_m();

        obj.maximum_distance_m = distance_sensor.maximum_distance_m();

        obj.current_distance_m = distance_sensor.current_distance_m();

        obj.orientation = translateFromRpcEulerAngle(distance_sensor.orientation());

        return obj;
    }

    static std::unique_ptr<rpc::telemetry::ScaledPressure>
    translateToRpcScaledPressure(const mavsdk::Telemetry::ScaledPressure& scaled_pressure)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry::ScaledPressure>();

        rpc_obj->set_timestamp_us(scaled_pressure.timestamp_us);

        rpc_obj->set_absolute_pressure_hpa(scaled_pressure.absolute_pressure_hpa);

        rpc_obj->set_differential_pressure_hpa(scaled_pressure.differential_pressure_hpa);

        rpc_obj->set_temperature_deg(scaled_pressure.temperature_deg);

        rpc_obj->set_differential_pressure_temperature_deg(
            scaled_pressure.differential_pressure_temperature_deg);

        return rpc_obj;
    }

    static mavsdk::Telemetry::ScaledPressure
    translateFromRpcScaledPressure(const rpc::telemetry::ScaledPressure& scaled_pressure)
    {
        mavsdk::Telemetry::ScaledPressure obj;

        obj.timestamp_us = scaled_pressure.timestamp_us();

        obj.absolute_pressure_hpa = scaled_pressure.absolute_pressure_hpa();

        obj.differential_pressure_hpa = scaled_pressure.differential_pressure_hpa();

        obj.temperature_deg = scaled_pressure.temperature_deg();

        obj.differential_pressure_temperature_deg =
            scaled_pressure.differential_pressure_temperature_deg();

        return obj;
    }

    static std::unique_ptr<rpc::telemetry::PositionNed>
    translateToRpcPositionNed(const mavsdk::Telemetry::PositionNed& position_ned)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry::PositionNed>();

        rpc_obj->set_north_m(position_ned.north_m);

        rpc_obj->set_east_m(position_ned.east_m);

        rpc_obj->set_down_m(position_ned.down_m);

        return rpc_obj;
    }

    static mavsdk::Telemetry::PositionNed
    translateFromRpcPositionNed(const rpc::telemetry::PositionNed& position_ned)
    {
        mavsdk::Telemetry::PositionNed obj;

        obj.north_m = position_ned.north_m();

        obj.east_m = position_ned.east_m();

        obj.down_m = position_ned.down_m();

        return obj;
    }

    static std::unique_ptr<rpc::telemetry::VelocityNed>
    translateToRpcVelocityNed(const mavsdk::Telemetry::VelocityNed& velocity_ned)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry::VelocityNed>();

        rpc_obj->set_north_m_s(velocity_ned.north_m_s);

        rpc_obj->set_east_m_s(velocity_ned.east_m_s);

        rpc_obj->set_down_m_s(velocity_ned.down_m_s);

        return rpc_obj;
    }

    static mavsdk::Telemetry::VelocityNed
    translateFromRpcVelocityNed(const rpc::telemetry::VelocityNed& velocity_ned)
    {
        mavsdk::Telemetry::VelocityNed obj;

        obj.north_m_s = velocity_ned.north_m_s();

        obj.east_m_s = velocity_ned.east_m_s();

        obj.down_m_s = velocity_ned.down_m_s();

        return obj;
    }

    static std::unique_ptr<rpc::telemetry::PositionVelocityNed> translateToRpcPositionVelocityNed(
        const mavsdk::Telemetry::PositionVelocityNed& position_velocity_ned)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry::PositionVelocityNed>();

        rpc_obj->set_allocated_position(
            translateToRpcPositionNed(position_velocity_ned.position).release());

        rpc_obj->set_allocated_velocity(
            translateToRpcVelocityNed(position_velocity_ned.velocity).release());

        return rpc_obj;
    }

    static mavsdk::Telemetry::PositionVelocityNed translateFromRpcPositionVelocityNed(
        const rpc::telemetry::PositionVelocityNed& position_velocity_ned)
    {
        mavsdk::Telemetry::PositionVelocityNed obj;

        obj.position = translateFromRpcPositionNed(position_velocity_ned.position());

        obj.velocity = translateFromRpcVelocityNed(position_velocity_ned.velocity());

        return obj;
    }

    static std::unique_ptr<rpc::telemetry::GroundTruth>
    translateToRpcGroundTruth(const mavsdk::Telemetry::GroundTruth& ground_truth)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry::GroundTruth>();

        rpc_obj->set_latitude_deg(ground_truth.latitude_deg);

        rpc_obj->set_longitude_deg(ground_truth.longitude_deg);

        rpc_obj->set_absolute_altitude_m(ground_truth.absolute_altitude_m);

        return rpc_obj;
    }

    static mavsdk::Telemetry::GroundTruth
    translateFromRpcGroundTruth(const rpc::telemetry::GroundTruth& ground_truth)
    {
        mavsdk::Telemetry::GroundTruth obj;

        obj.latitude_deg = ground_truth.latitude_deg();

        obj.longitude_deg = ground_truth.longitude_deg();

        obj.absolute_altitude_m = ground_truth.absolute_altitude_m();

        return obj;
    }

    static std::unique_ptr<rpc::telemetry::FixedwingMetrics>
    translateToRpcFixedwingMetrics(const mavsdk::Telemetry::FixedwingMetrics& fixedwing_metrics)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry::FixedwingMetrics>();

        rpc_obj->set_airspeed_m_s(fixedwing_metrics.airspeed_m_s);

        rpc_obj->set_throttle_percentage(fixedwing_metrics.throttle_percentage);

        rpc_obj->set_climb_rate_m_s(fixedwing_metrics.climb_rate_m_s);

        return rpc_obj;
    }

    static mavsdk::Telemetry::FixedwingMetrics
    translateFromRpcFixedwingMetrics(const rpc::telemetry::FixedwingMetrics& fixedwing_metrics)
    {
        mavsdk::Telemetry::FixedwingMetrics obj;

        obj.airspeed_m_s = fixedwing_metrics.airspeed_m_s();

        obj.throttle_percentage = fixedwing_metrics.throttle_percentage();

        obj.climb_rate_m_s = fixedwing_metrics.climb_rate_m_s();

        return obj;
    }

    static std::unique_ptr<rpc::telemetry::AccelerationFrd>
    translateToRpcAccelerationFrd(const mavsdk::Telemetry::AccelerationFrd& acceleration_frd)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry::AccelerationFrd>();

        rpc_obj->set_forward_m_s2(acceleration_frd.forward_m_s2);

        rpc_obj->set_right_m_s2(acceleration_frd.right_m_s2);

        rpc_obj->set_down_m_s2(acceleration_frd.down_m_s2);

        return rpc_obj;
    }

    static mavsdk::Telemetry::AccelerationFrd
    translateFromRpcAccelerationFrd(const rpc::telemetry::AccelerationFrd& acceleration_frd)
    {
        mavsdk::Telemetry::AccelerationFrd obj;

        obj.forward_m_s2 = acceleration_frd.forward_m_s2();

        obj.right_m_s2 = acceleration_frd.right_m_s2();

        obj.down_m_s2 = acceleration_frd.down_m_s2();

        return obj;
    }

    static std::unique_ptr<rpc::telemetry::AngularVelocityFrd> translateToRpcAngularVelocityFrd(
        const mavsdk::Telemetry::AngularVelocityFrd& angular_velocity_frd)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry::AngularVelocityFrd>();

        rpc_obj->set_forward_rad_s(angular_velocity_frd.forward_rad_s);

        rpc_obj->set_right_rad_s(angular_velocity_frd.right_rad_s);

        rpc_obj->set_down_rad_s(angular_velocity_frd.down_rad_s);

        return rpc_obj;
    }

    static mavsdk::Telemetry::AngularVelocityFrd translateFromRpcAngularVelocityFrd(
        const rpc::telemetry::AngularVelocityFrd& angular_velocity_frd)
    {
        mavsdk::Telemetry::AngularVelocityFrd obj;

        obj.forward_rad_s = angular_velocity_frd.forward_rad_s();

        obj.right_rad_s = angular_velocity_frd.right_rad_s();

        obj.down_rad_s = angular_velocity_frd.down_rad_s();

        return obj;
    }

    static std::unique_ptr<rpc::telemetry::MagneticFieldFrd>
    translateToRpcMagneticFieldFrd(const mavsdk::Telemetry::MagneticFieldFrd& magnetic_field_frd)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry::MagneticFieldFrd>();

        rpc_obj->set_forward_gauss(magnetic_field_frd.forward_gauss);

        rpc_obj->set_right_gauss(magnetic_field_frd.right_gauss);

        rpc_obj->set_down_gauss(magnetic_field_frd.down_gauss);

        return rpc_obj;
    }

    static mavsdk::Telemetry::MagneticFieldFrd
    translateFromRpcMagneticFieldFrd(const rpc::telemetry::MagneticFieldFrd& magnetic_field_frd)
    {
        mavsdk::Telemetry::MagneticFieldFrd obj;

        obj.forward_gauss = magnetic_field_frd.forward_gauss();

        obj.right_gauss = magnetic_field_frd.right_gauss();

        obj.down_gauss = magnetic_field_frd.down_gauss();

        return obj;
    }

    static std::unique_ptr<rpc::telemetry::Imu> translateToRpcImu(const mavsdk::Telemetry::Imu& imu)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry::Imu>();

        rpc_obj->set_allocated_acceleration_frd(
            translateToRpcAccelerationFrd(imu.acceleration_frd).release());

        rpc_obj->set_allocated_angular_velocity_frd(
            translateToRpcAngularVelocityFrd(imu.angular_velocity_frd).release());

        rpc_obj->set_allocated_magnetic_field_frd(
            translateToRpcMagneticFieldFrd(imu.magnetic_field_frd).release());

        rpc_obj->set_temperature_degc(imu.temperature_degc);

        rpc_obj->set_timestamp_us(imu.timestamp_us);

        return rpc_obj;
    }

    static mavsdk::Telemetry::Imu translateFromRpcImu(const rpc::telemetry::Imu& imu)
    {
        mavsdk::Telemetry::Imu obj;

        obj.acceleration_frd = translateFromRpcAccelerationFrd(imu.acceleration_frd());

        obj.angular_velocity_frd = translateFromRpcAngularVelocityFrd(imu.angular_velocity_frd());

        obj.magnetic_field_frd = translateFromRpcMagneticFieldFrd(imu.magnetic_field_frd());

        obj.temperature_degc = imu.temperature_degc();

        obj.timestamp_us = imu.timestamp_us();

        return obj;
    }

    static std::unique_ptr<rpc::telemetry::GpsGlobalOrigin>
    translateToRpcGpsGlobalOrigin(const mavsdk::Telemetry::GpsGlobalOrigin& gps_global_origin)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry::GpsGlobalOrigin>();

        rpc_obj->set_latitude_deg(gps_global_origin.latitude_deg);

        rpc_obj->set_longitude_deg(gps_global_origin.longitude_deg);

        rpc_obj->set_altitude_m(gps_global_origin.altitude_m);

        return rpc_obj;
    }

    static mavsdk::Telemetry::GpsGlobalOrigin
    translateFromRpcGpsGlobalOrigin(const rpc::telemetry::GpsGlobalOrigin& gps_global_origin)
    {
        mavsdk::Telemetry::GpsGlobalOrigin obj;

        obj.latitude_deg = gps_global_origin.latitude_deg();

        obj.longitude_deg = gps_global_origin.longitude_deg();

        obj.altitude_m = gps_global_origin.altitude_m();

        return obj;
    }

    static std::unique_ptr<rpc::telemetry::Altitude>
    translateToRpcAltitude(const mavsdk::Telemetry::Altitude& altitude)
    {
        auto rpc_obj = std::make_unique<rpc::telemetry::Altitude>();

        rpc_obj->set_altitude_monotonic_m(altitude.altitude_monotonic_m);

        rpc_obj->set_altitude_amsl_m(altitude.altitude_amsl_m);

        rpc_obj->set_altitude_local_m(altitude.altitude_local_m);

        rpc_obj->set_altitude_relative_m(altitude.altitude_relative_m);

        rpc_obj->set_altitude_terrain_m(altitude.altitude_terrain_m);

        rpc_obj->set_bottom_clearance_m(altitude.bottom_clearance_m);

        return rpc_obj;
    }

    static mavsdk::Telemetry::Altitude
    translateFromRpcAltitude(const rpc::telemetry::Altitude& altitude)
    {
        mavsdk::Telemetry::Altitude obj;

        obj.altitude_monotonic_m = altitude.altitude_monotonic_m();

        obj.altitude_amsl_m = altitude.altitude_amsl_m();

        obj.altitude_local_m = altitude.altitude_local_m();

        obj.altitude_relative_m = altitude.altitude_relative_m();

        obj.altitude_terrain_m = altitude.altitude_terrain_m();

        obj.bottom_clearance_m = altitude.bottom_clearance_m();

        return obj;
    }

    static rpc::telemetry::TelemetryResult::Result
    translateToRpcResult(const mavsdk::Telemetry::Result& result)
    {
        switch (result) {
            default:
                LogErr() << "Unknown result enum value: " << static_cast<int>(result);
            // FALLTHROUGH
            case mavsdk::Telemetry::Result::Unknown:
                return rpc::telemetry::TelemetryResult_Result_RESULT_UNKNOWN;
            case mavsdk::Telemetry::Result::Success:
                return rpc::telemetry::TelemetryResult_Result_RESULT_SUCCESS;
            case mavsdk::Telemetry::Result::NoSystem:
                return rpc::telemetry::TelemetryResult_Result_RESULT_NO_SYSTEM;
            case mavsdk::Telemetry::Result::ConnectionError:
                return rpc::telemetry::TelemetryResult_Result_RESULT_CONNECTION_ERROR;
            case mavsdk::Telemetry::Result::Busy:
                return rpc::telemetry::TelemetryResult_Result_RESULT_BUSY;
            case mavsdk::Telemetry::Result::CommandDenied:
                return rpc::telemetry::TelemetryResult_Result_RESULT_COMMAND_DENIED;
            case mavsdk::Telemetry::Result::Timeout:
                return rpc::telemetry::TelemetryResult_Result_RESULT_TIMEOUT;
            case mavsdk::Telemetry::Result::Unsupported:
                return rpc::telemetry::TelemetryResult_Result_RESULT_UNSUPPORTED;
        }
    }

    static mavsdk::Telemetry::Result
    translateFromRpcResult(const rpc::telemetry::TelemetryResult::Result result)
    {
        switch (result) {
            default:
                LogErr() << "Unknown result enum value: " << static_cast<int>(result);
            // FALLTHROUGH
            case rpc::telemetry::TelemetryResult_Result_RESULT_UNKNOWN:
                return mavsdk::Telemetry::Result::Unknown;
            case rpc::telemetry::TelemetryResult_Result_RESULT_SUCCESS:
                return mavsdk::Telemetry::Result::Success;
            case rpc::telemetry::TelemetryResult_Result_RESULT_NO_SYSTEM:
                return mavsdk::Telemetry::Result::NoSystem;
            case rpc::telemetry::TelemetryResult_Result_RESULT_CONNECTION_ERROR:
                return mavsdk::Telemetry::Result::ConnectionError;
            case rpc::telemetry::TelemetryResult_Result_RESULT_BUSY:
                return mavsdk::Telemetry::Result::Busy;
            case rpc::telemetry::TelemetryResult_Result_RESULT_COMMAND_DENIED:
                return mavsdk::Telemetry::Result::CommandDenied;
            case rpc::telemetry::TelemetryResult_Result_RESULT_TIMEOUT:
                return mavsdk::Telemetry::Result::Timeout;
            case rpc::telemetry::TelemetryResult_Result_RESULT_UNSUPPORTED:
                return mavsdk::Telemetry::Result::Unsupported;
        }
    }

    grpc::Status SubscribePosition(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::telemetry::SubscribePositionRequest* /* request */,
        grpc::ServerWriter<rpc::telemetry::PositionResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::Telemetry::PositionHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_position(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const mavsdk::Telemetry::Position position) {
                    rpc::telemetry::PositionResponse rpc_response;

                    rpc_response.set_allocated_position(translateToRpcPosition(position).release());

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_position(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status SubscribeHome(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::telemetry::SubscribeHomeRequest* /* request */,
        grpc::ServerWriter<rpc::telemetry::HomeResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::Telemetry::HomeHandle handle = _lazy_plugin.maybe_plugin()->subscribe_home(
            [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                const mavsdk::Telemetry::Position home) {
                rpc::telemetry::HomeResponse rpc_response;

                rpc_response.set_allocated_home(translateToRpcPosition(home).release());

                std::unique_lock<std::mutex> lock(*subscribe_mutex);
                if (!*is_finished && !writer->Write(rpc_response)) {
                    _lazy_plugin.maybe_plugin()->unsubscribe_home(handle);

                    *is_finished = true;
                    unregister_stream_stop_promise(stream_closed_promise);
                    stream_closed_promise->set_value();
                }
            });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status SubscribeInAir(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::telemetry::SubscribeInAirRequest* /* request */,
        grpc::ServerWriter<rpc::telemetry::InAirResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::Telemetry::InAirHandle handle = _lazy_plugin.maybe_plugin()->subscribe_in_air(
            [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                const bool in_air) {
                rpc::telemetry::InAirResponse rpc_response;

                rpc_response.set_is_in_air(in_air);

                std::unique_lock<std::mutex> lock(*subscribe_mutex);
                if (!*is_finished && !writer->Write(rpc_response)) {
                    _lazy_plugin.maybe_plugin()->unsubscribe_in_air(handle);

                    *is_finished = true;
                    unregister_stream_stop_promise(stream_closed_promise);
                    stream_closed_promise->set_value();
                }
            });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status SubscribeLandedState(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::telemetry::SubscribeLandedStateRequest* /* request */,
        grpc::ServerWriter<rpc::telemetry::LandedStateResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::Telemetry::LandedStateHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_landed_state(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const mavsdk::Telemetry::LandedState landed_state) {
                    rpc::telemetry::LandedStateResponse rpc_response;

                    rpc_response.set_landed_state(translateToRpcLandedState(landed_state));

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_landed_state(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status SubscribeArmed(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::telemetry::SubscribeArmedRequest* /* request */,
        grpc::ServerWriter<rpc::telemetry::ArmedResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::Telemetry::ArmedHandle handle = _lazy_plugin.maybe_plugin()->subscribe_armed(
            [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                const bool armed) {
                rpc::telemetry::ArmedResponse rpc_response;

                rpc_response.set_is_armed(armed);

                std::unique_lock<std::mutex> lock(*subscribe_mutex);
                if (!*is_finished && !writer->Write(rpc_response)) {
                    _lazy_plugin.maybe_plugin()->unsubscribe_armed(handle);

                    *is_finished = true;
                    unregister_stream_stop_promise(stream_closed_promise);
                    stream_closed_promise->set_value();
                }
            });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status SubscribeVtolState(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::telemetry::SubscribeVtolStateRequest* /* request */,
        grpc::ServerWriter<rpc::telemetry::VtolStateResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::Telemetry::VtolStateHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_vtol_state(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const mavsdk::Telemetry::VtolState vtol_state) {
                    rpc::telemetry::VtolStateResponse rpc_response;

                    rpc_response.set_vtol_state(translateToRpcVtolState(vtol_state));

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_vtol_state(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status SubscribeAttitudeQuaternion(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::telemetry::SubscribeAttitudeQuaternionRequest* /* request */,
        grpc::ServerWriter<rpc::telemetry::AttitudeQuaternionResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::Telemetry::AttitudeQuaternionHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_attitude_quaternion(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const mavsdk::Telemetry::Quaternion attitude_quaternion) {
                    rpc::telemetry::AttitudeQuaternionResponse rpc_response;

                    rpc_response.set_allocated_attitude_quaternion(
                        translateToRpcQuaternion(attitude_quaternion).release());

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_attitude_quaternion(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status SubscribeAttitudeEuler(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::telemetry::SubscribeAttitudeEulerRequest* /* request */,
        grpc::ServerWriter<rpc::telemetry::AttitudeEulerResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::Telemetry::AttitudeEulerHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_attitude_euler(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const mavsdk::Telemetry::EulerAngle attitude_euler) {
                    rpc::telemetry::AttitudeEulerResponse rpc_response;

                    rpc_response.set_allocated_attitude_euler(
                        translateToRpcEulerAngle(attitude_euler).release());

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_attitude_euler(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status SubscribeAttitudeAngularVelocityBody(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::telemetry::SubscribeAttitudeAngularVelocityBodyRequest* /* request */,
        grpc::ServerWriter<rpc::telemetry::AttitudeAngularVelocityBodyResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::Telemetry::AttitudeAngularVelocityBodyHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_attitude_angular_velocity_body(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const mavsdk::Telemetry::AngularVelocityBody attitude_angular_velocity_body) {
                    rpc::telemetry::AttitudeAngularVelocityBodyResponse rpc_response;

                    rpc_response.set_allocated_attitude_angular_velocity_body(
                        translateToRpcAngularVelocityBody(attitude_angular_velocity_body)
                            .release());

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_attitude_angular_velocity_body(
                            handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status SubscribeVelocityNed(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::telemetry::SubscribeVelocityNedRequest* /* request */,
        grpc::ServerWriter<rpc::telemetry::VelocityNedResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::Telemetry::VelocityNedHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_velocity_ned(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const mavsdk::Telemetry::VelocityNed velocity_ned) {
                    rpc::telemetry::VelocityNedResponse rpc_response;

                    rpc_response.set_allocated_velocity_ned(
                        translateToRpcVelocityNed(velocity_ned).release());

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_velocity_ned(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status SubscribeGpsInfo(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::telemetry::SubscribeGpsInfoRequest* /* request */,
        grpc::ServerWriter<rpc::telemetry::GpsInfoResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::Telemetry::GpsInfoHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_gps_info(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const mavsdk::Telemetry::GpsInfo gps_info) {
                    rpc::telemetry::GpsInfoResponse rpc_response;

                    rpc_response.set_allocated_gps_info(translateToRpcGpsInfo(gps_info).release());

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_gps_info(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status SubscribeRawGps(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::telemetry::SubscribeRawGpsRequest* /* request */,
        grpc::ServerWriter<rpc::telemetry::RawGpsResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::Telemetry::RawGpsHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_raw_gps(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const mavsdk::Telemetry::RawGps raw_gps) {
                    rpc::telemetry::RawGpsResponse rpc_response;

                    rpc_response.set_allocated_raw_gps(translateToRpcRawGps(raw_gps).release());

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_raw_gps(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status SubscribeBattery(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::telemetry::SubscribeBatteryRequest* /* request */,
        grpc::ServerWriter<rpc::telemetry::BatteryResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::Telemetry::BatteryHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_battery(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const mavsdk::Telemetry::Battery battery) {
                    rpc::telemetry::BatteryResponse rpc_response;

                    rpc_response.set_allocated_battery(translateToRpcBattery(battery).release());

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_battery(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status SubscribeFlightMode(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::telemetry::SubscribeFlightModeRequest* /* request */,
        grpc::ServerWriter<rpc::telemetry::FlightModeResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::Telemetry::FlightModeHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_flight_mode(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const mavsdk::Telemetry::FlightMode flight_mode) {
                    rpc::telemetry::FlightModeResponse rpc_response;

                    rpc_response.set_flight_mode(translateToRpcFlightMode(flight_mode));

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_flight_mode(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status SubscribeHealth(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::telemetry::SubscribeHealthRequest* /* request */,
        grpc::ServerWriter<rpc::telemetry::HealthResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::Telemetry::HealthHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_health(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const mavsdk::Telemetry::Health health) {
                    rpc::telemetry::HealthResponse rpc_response;

                    rpc_response.set_allocated_health(translateToRpcHealth(health).release());

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_health(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status SubscribeRcStatus(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::telemetry::SubscribeRcStatusRequest* /* request */,
        grpc::ServerWriter<rpc::telemetry::RcStatusResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::Telemetry::RcStatusHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_rc_status(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const mavsdk::Telemetry::RcStatus rc_status) {
                    rpc::telemetry::RcStatusResponse rpc_response;

                    rpc_response.set_allocated_rc_status(
                        translateToRpcRcStatus(rc_status).release());

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_rc_status(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status SubscribeStatusText(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::telemetry::SubscribeStatusTextRequest* /* request */,
        grpc::ServerWriter<rpc::telemetry::StatusTextResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::Telemetry::StatusTextHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_status_text(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const mavsdk::Telemetry::StatusText status_text) {
                    rpc::telemetry::StatusTextResponse rpc_response;

                    rpc_response.set_allocated_status_text(
                        translateToRpcStatusText(status_text).release());

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_status_text(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status SubscribeActuatorControlTarget(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::telemetry::SubscribeActuatorControlTargetRequest* /* request */,
        grpc::ServerWriter<rpc::telemetry::ActuatorControlTargetResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::Telemetry::ActuatorControlTargetHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_actuator_control_target(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const mavsdk::Telemetry::ActuatorControlTarget actuator_control_target) {
                    rpc::telemetry::ActuatorControlTargetResponse rpc_response;

                    rpc_response.set_allocated_actuator_control_target(
                        translateToRpcActuatorControlTarget(actuator_control_target).release());

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_actuator_control_target(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status SubscribeActuatorOutputStatus(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::telemetry::SubscribeActuatorOutputStatusRequest* /* request */,
        grpc::ServerWriter<rpc::telemetry::ActuatorOutputStatusResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::Telemetry::ActuatorOutputStatusHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_actuator_output_status(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const mavsdk::Telemetry::ActuatorOutputStatus actuator_output_status) {
                    rpc::telemetry::ActuatorOutputStatusResponse rpc_response;

                    rpc_response.set_allocated_actuator_output_status(
                        translateToRpcActuatorOutputStatus(actuator_output_status).release());

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_actuator_output_status(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status SubscribeOdometry(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::telemetry::SubscribeOdometryRequest* /* request */,
        grpc::ServerWriter<rpc::telemetry::OdometryResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::Telemetry::OdometryHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_odometry(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const mavsdk::Telemetry::Odometry odometry) {
                    rpc::telemetry::OdometryResponse rpc_response;

                    rpc_response.set_allocated_odometry(translateToRpcOdometry(odometry).release());

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_odometry(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status SubscribePositionVelocityNed(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::telemetry::SubscribePositionVelocityNedRequest* /* request */,
        grpc::ServerWriter<rpc::telemetry::PositionVelocityNedResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::Telemetry::PositionVelocityNedHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_position_velocity_ned(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const mavsdk::Telemetry::PositionVelocityNed position_velocity_ned) {
                    rpc::telemetry::PositionVelocityNedResponse rpc_response;

                    rpc_response.set_allocated_position_velocity_ned(
                        translateToRpcPositionVelocityNed(position_velocity_ned).release());

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_position_velocity_ned(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status SubscribeGroundTruth(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::telemetry::SubscribeGroundTruthRequest* /* request */,
        grpc::ServerWriter<rpc::telemetry::GroundTruthResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::Telemetry::GroundTruthHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_ground_truth(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const mavsdk::Telemetry::GroundTruth ground_truth) {
                    rpc::telemetry::GroundTruthResponse rpc_response;

                    rpc_response.set_allocated_ground_truth(
                        translateToRpcGroundTruth(ground_truth).release());

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_ground_truth(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status SubscribeFixedwingMetrics(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::telemetry::SubscribeFixedwingMetricsRequest* /* request */,
        grpc::ServerWriter<rpc::telemetry::FixedwingMetricsResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::Telemetry::FixedwingMetricsHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_fixedwing_metrics(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const mavsdk::Telemetry::FixedwingMetrics fixedwing_metrics) {
                    rpc::telemetry::FixedwingMetricsResponse rpc_response;

                    rpc_response.set_allocated_fixedwing_metrics(
                        translateToRpcFixedwingMetrics(fixedwing_metrics).release());

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_fixedwing_metrics(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status SubscribeImu(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::telemetry::SubscribeImuRequest* /* request */,
        grpc::ServerWriter<rpc::telemetry::ImuResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::Telemetry::ImuHandle handle = _lazy_plugin.maybe_plugin()->subscribe_imu(
            [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                const mavsdk::Telemetry::Imu imu) {
                rpc::telemetry::ImuResponse rpc_response;

                rpc_response.set_allocated_imu(translateToRpcImu(imu).release());

                std::unique_lock<std::mutex> lock(*subscribe_mutex);
                if (!*is_finished && !writer->Write(rpc_response)) {
                    _lazy_plugin.maybe_plugin()->unsubscribe_imu(handle);

                    *is_finished = true;
                    unregister_stream_stop_promise(stream_closed_promise);
                    stream_closed_promise->set_value();
                }
            });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status SubscribeScaledImu(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::telemetry::SubscribeScaledImuRequest* /* request */,
        grpc::ServerWriter<rpc::telemetry::ScaledImuResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::Telemetry::ScaledImuHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_scaled_imu(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const mavsdk::Telemetry::Imu scaled_imu) {
                    rpc::telemetry::ScaledImuResponse rpc_response;

                    rpc_response.set_allocated_imu(translateToRpcImu(scaled_imu).release());

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_scaled_imu(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status SubscribeRawImu(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::telemetry::SubscribeRawImuRequest* /* request */,
        grpc::ServerWriter<rpc::telemetry::RawImuResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::Telemetry::RawImuHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_raw_imu(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const mavsdk::Telemetry::Imu raw_imu) {
                    rpc::telemetry::RawImuResponse rpc_response;

                    rpc_response.set_allocated_imu(translateToRpcImu(raw_imu).release());

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_raw_imu(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status SubscribeHealthAllOk(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::telemetry::SubscribeHealthAllOkRequest* /* request */,
        grpc::ServerWriter<rpc::telemetry::HealthAllOkResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::Telemetry::HealthAllOkHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_health_all_ok(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const bool health_all_ok) {
                    rpc::telemetry::HealthAllOkResponse rpc_response;

                    rpc_response.set_is_health_all_ok(health_all_ok);

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_health_all_ok(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status SubscribeUnixEpochTime(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::telemetry::SubscribeUnixEpochTimeRequest* /* request */,
        grpc::ServerWriter<rpc::telemetry::UnixEpochTimeResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::Telemetry::UnixEpochTimeHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_unix_epoch_time(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const uint64_t unix_epoch_time) {
                    rpc::telemetry::UnixEpochTimeResponse rpc_response;

                    rpc_response.set_time_us(unix_epoch_time);

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_unix_epoch_time(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status SubscribeDistanceSensor(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::telemetry::SubscribeDistanceSensorRequest* /* request */,
        grpc::ServerWriter<rpc::telemetry::DistanceSensorResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::Telemetry::DistanceSensorHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_distance_sensor(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const mavsdk::Telemetry::DistanceSensor distance_sensor) {
                    rpc::telemetry::DistanceSensorResponse rpc_response;

                    rpc_response.set_allocated_distance_sensor(
                        translateToRpcDistanceSensor(distance_sensor).release());

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_distance_sensor(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status SubscribeScaledPressure(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::telemetry::SubscribeScaledPressureRequest* /* request */,
        grpc::ServerWriter<rpc::telemetry::ScaledPressureResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::Telemetry::ScaledPressureHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_scaled_pressure(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const mavsdk::Telemetry::ScaledPressure scaled_pressure) {
                    rpc::telemetry::ScaledPressureResponse rpc_response;

                    rpc_response.set_allocated_scaled_pressure(
                        translateToRpcScaledPressure(scaled_pressure).release());

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_scaled_pressure(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status SubscribeHeading(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::telemetry::SubscribeHeadingRequest* /* request */,
        grpc::ServerWriter<rpc::telemetry::HeadingResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::Telemetry::HeadingHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_heading(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const mavsdk::Telemetry::Heading heading) {
                    rpc::telemetry::HeadingResponse rpc_response;

                    rpc_response.set_allocated_heading_deg(
                        translateToRpcHeading(heading).release());

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_heading(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status SubscribeAltitude(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::telemetry::SubscribeAltitudeRequest* /* request */,
        grpc::ServerWriter<rpc::telemetry::AltitudeResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::Telemetry::AltitudeHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_altitude(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const mavsdk::Telemetry::Altitude altitude) {
                    rpc::telemetry::AltitudeResponse rpc_response;

                    rpc_response.set_allocated_altitude(translateToRpcAltitude(altitude).release());

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_altitude(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status SetRatePosition(
        grpc::ServerContext* /* context */,
        const rpc::telemetry::SetRatePositionRequest* request,
        rpc::telemetry::SetRatePositionResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                auto result = mavsdk::Telemetry::Result::NoSystem;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "SetRatePosition sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->set_rate_position(request->rate_hz());

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status SetRateHome(
        grpc::ServerContext* /* context */,
        const rpc::telemetry::SetRateHomeRequest* request,
        rpc::telemetry::SetRateHomeResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                auto result = mavsdk::Telemetry::Result::NoSystem;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "SetRateHome sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->set_rate_home(request->rate_hz());

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status SetRateInAir(
        grpc::ServerContext* /* context */,
        const rpc::telemetry::SetRateInAirRequest* request,
        rpc::telemetry::SetRateInAirResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                auto result = mavsdk::Telemetry::Result::NoSystem;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "SetRateInAir sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->set_rate_in_air(request->rate_hz());

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status SetRateLandedState(
        grpc::ServerContext* /* context */,
        const rpc::telemetry::SetRateLandedStateRequest* request,
        rpc::telemetry::SetRateLandedStateResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                auto result = mavsdk::Telemetry::Result::NoSystem;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "SetRateLandedState sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->set_rate_landed_state(request->rate_hz());

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status SetRateVtolState(
        grpc::ServerContext* /* context */,
        const rpc::telemetry::SetRateVtolStateRequest* request,
        rpc::telemetry::SetRateVtolStateResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                auto result = mavsdk::Telemetry::Result::NoSystem;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "SetRateVtolState sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->set_rate_vtol_state(request->rate_hz());

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status SetRateAttitudeQuaternion(
        grpc::ServerContext* /* context */,
        const rpc::telemetry::SetRateAttitudeQuaternionRequest* request,
        rpc::telemetry::SetRateAttitudeQuaternionResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                auto result = mavsdk::Telemetry::Result::NoSystem;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "SetRateAttitudeQuaternion sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->set_rate_attitude_quaternion(request->rate_hz());

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status SetRateAttitudeEuler(
        grpc::ServerContext* /* context */,
        const rpc::telemetry::SetRateAttitudeEulerRequest* request,
        rpc::telemetry::SetRateAttitudeEulerResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                auto result = mavsdk::Telemetry::Result::NoSystem;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "SetRateAttitudeEuler sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->set_rate_attitude_euler(request->rate_hz());

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status SetRateVelocityNed(
        grpc::ServerContext* /* context */,
        const rpc::telemetry::SetRateVelocityNedRequest* request,
        rpc::telemetry::SetRateVelocityNedResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                auto result = mavsdk::Telemetry::Result::NoSystem;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "SetRateVelocityNed sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->set_rate_velocity_ned(request->rate_hz());

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status SetRateGpsInfo(
        grpc::ServerContext* /* context */,
        const rpc::telemetry::SetRateGpsInfoRequest* request,
        rpc::telemetry::SetRateGpsInfoResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                auto result = mavsdk::Telemetry::Result::NoSystem;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "SetRateGpsInfo sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->set_rate_gps_info(request->rate_hz());

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status SetRateBattery(
        grpc::ServerContext* /* context */,
        const rpc::telemetry::SetRateBatteryRequest* request,
        rpc::telemetry::SetRateBatteryResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                auto result = mavsdk::Telemetry::Result::NoSystem;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "SetRateBattery sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->set_rate_battery(request->rate_hz());

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status SetRateRcStatus(
        grpc::ServerContext* /* context */,
        const rpc::telemetry::SetRateRcStatusRequest* request,
        rpc::telemetry::SetRateRcStatusResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                auto result = mavsdk::Telemetry::Result::NoSystem;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "SetRateRcStatus sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->set_rate_rc_status(request->rate_hz());

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status SetRateActuatorControlTarget(
        grpc::ServerContext* /* context */,
        const rpc::telemetry::SetRateActuatorControlTargetRequest* request,
        rpc::telemetry::SetRateActuatorControlTargetResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                auto result = mavsdk::Telemetry::Result::NoSystem;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "SetRateActuatorControlTarget sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result =
            _lazy_plugin.maybe_plugin()->set_rate_actuator_control_target(request->rate_hz());

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status SetRateActuatorOutputStatus(
        grpc::ServerContext* /* context */,
        const rpc::telemetry::SetRateActuatorOutputStatusRequest* request,
        rpc::telemetry::SetRateActuatorOutputStatusResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                auto result = mavsdk::Telemetry::Result::NoSystem;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "SetRateActuatorOutputStatus sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result =
            _lazy_plugin.maybe_plugin()->set_rate_actuator_output_status(request->rate_hz());

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status SetRateOdometry(
        grpc::ServerContext* /* context */,
        const rpc::telemetry::SetRateOdometryRequest* request,
        rpc::telemetry::SetRateOdometryResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                auto result = mavsdk::Telemetry::Result::NoSystem;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "SetRateOdometry sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->set_rate_odometry(request->rate_hz());

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status SetRatePositionVelocityNed(
        grpc::ServerContext* /* context */,
        const rpc::telemetry::SetRatePositionVelocityNedRequest* request,
        rpc::telemetry::SetRatePositionVelocityNedResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                auto result = mavsdk::Telemetry::Result::NoSystem;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "SetRatePositionVelocityNed sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result =
            _lazy_plugin.maybe_plugin()->set_rate_position_velocity_ned(request->rate_hz());

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status SetRateGroundTruth(
        grpc::ServerContext* /* context */,
        const rpc::telemetry::SetRateGroundTruthRequest* request,
        rpc::telemetry::SetRateGroundTruthResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                auto result = mavsdk::Telemetry::Result::NoSystem;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "SetRateGroundTruth sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->set_rate_ground_truth(request->rate_hz());

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status SetRateFixedwingMetrics(
        grpc::ServerContext* /* context */,
        const rpc::telemetry::SetRateFixedwingMetricsRequest* request,
        rpc::telemetry::SetRateFixedwingMetricsResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                auto result = mavsdk::Telemetry::Result::NoSystem;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "SetRateFixedwingMetrics sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->set_rate_fixedwing_metrics(request->rate_hz());

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status SetRateImu(
        grpc::ServerContext* /* context */,
        const rpc::telemetry::SetRateImuRequest* request,
        rpc::telemetry::SetRateImuResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                auto result = mavsdk::Telemetry::Result::NoSystem;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "SetRateImu sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->set_rate_imu(request->rate_hz());

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status SetRateScaledImu(
        grpc::ServerContext* /* context */,
        const rpc::telemetry::SetRateScaledImuRequest* request,
        rpc::telemetry::SetRateScaledImuResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                auto result = mavsdk::Telemetry::Result::NoSystem;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "SetRateScaledImu sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->set_rate_scaled_imu(request->rate_hz());

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status SetRateRawImu(
        grpc::ServerContext* /* context */,
        const rpc::telemetry::SetRateRawImuRequest* request,
        rpc::telemetry::SetRateRawImuResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                auto result = mavsdk::Telemetry::Result::NoSystem;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "SetRateRawImu sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->set_rate_raw_imu(request->rate_hz());

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status SetRateUnixEpochTime(
        grpc::ServerContext* /* context */,
        const rpc::telemetry::SetRateUnixEpochTimeRequest* request,
        rpc::telemetry::SetRateUnixEpochTimeResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                auto result = mavsdk::Telemetry::Result::NoSystem;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "SetRateUnixEpochTime sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->set_rate_unix_epoch_time(request->rate_hz());

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status SetRateDistanceSensor(
        grpc::ServerContext* /* context */,
        const rpc::telemetry::SetRateDistanceSensorRequest* request,
        rpc::telemetry::SetRateDistanceSensorResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                auto result = mavsdk::Telemetry::Result::NoSystem;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "SetRateDistanceSensor sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->set_rate_distance_sensor(request->rate_hz());

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status SetRateAltitude(
        grpc::ServerContext* /* context */,
        const rpc::telemetry::SetRateAltitudeRequest* request,
        rpc::telemetry::SetRateAltitudeResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                auto result = mavsdk::Telemetry::Result::NoSystem;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "SetRateAltitude sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->set_rate_altitude(request->rate_hz());

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status GetGpsGlobalOrigin(
        grpc::ServerContext* /* context */,
        const rpc::telemetry::GetGpsGlobalOriginRequest* /* request */,
        rpc::telemetry::GetGpsGlobalOriginResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                auto result = mavsdk::Telemetry::Result::NoSystem;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->get_gps_global_origin();

        if (response != nullptr) {
            fillResponseWithResult(response, result.first);

            response->set_allocated_gps_global_origin(
                translateToRpcGpsGlobalOrigin(result.second).release());
        }

        return grpc::Status::OK;
    }

    void stop()
    {
        _stopped.store(true);
        std::lock_guard<std::mutex> lock(_stream_stop_mutex);
        for (auto& prom : _stream_stop_promises) {
            if (auto handle = prom.lock()) {
                handle->set_value();
            }
        }
    }

private:
    void register_stream_stop_promise(std::weak_ptr<std::promise<void>> prom)
    {
        // If we have already stopped, set promise immediately and don't add it to list.
        if (_stopped.load()) {
            if (auto handle = prom.lock()) {
                handle->set_value();
            }
        } else {
            std::lock_guard<std::mutex> lock(_stream_stop_mutex);
            _stream_stop_promises.push_back(prom);
        }
    }

    void unregister_stream_stop_promise(std::shared_ptr<std::promise<void>> prom)
    {
        std::lock_guard<std::mutex> lock(_stream_stop_mutex);
        for (auto it = _stream_stop_promises.begin(); it != _stream_stop_promises.end();
             /* ++it */) {
            if (it->lock() == prom) {
                it = _stream_stop_promises.erase(it);
            } else {
                ++it;
            }
        }
    }

    LazyPlugin& _lazy_plugin;

    std::atomic<bool> _stopped{false};
    std::mutex _stream_stop_mutex{};
    std::vector<std::weak_ptr<std::promise<void>>> _stream_stop_promises{};
};

} // namespace mavsdk_server
} // namespace mavsdk