// WARNING: THIS FILE IS AUTOGENERATED! As such, it should not be edited.
// Edits need to be made to the proto files
// (see https://github.com/mavlink/MAVSDK-Proto/blob/master/protos/shell/shell.proto)

#include "shell/shell.grpc.pb.h"
#include "plugins/shell/shell.h"

#include "mavsdk.h"

#include "lazy_plugin.h"

#include "log.h"
#include <atomic>
#include <cmath>
#include <future>
#include <limits>
#include <memory>
#include <mutex>
#include <sstream>
#include <vector>

namespace mavsdk {
namespace mavsdk_server {

template<typename Shell = Shell, typename LazyPlugin = LazyPlugin<Shell>>

class ShellServiceImpl final : public rpc::shell::ShellService::Service {
public:
    ShellServiceImpl(LazyPlugin& lazy_plugin) : _lazy_plugin(lazy_plugin) {}

    template<typename ResponseType>
    void fillResponseWithResult(ResponseType* response, mavsdk::Shell::Result& result) const
    {
        auto rpc_result = translateToRpcResult(result);

        auto* rpc_shell_result = new rpc::shell::ShellResult();
        rpc_shell_result->set_result(rpc_result);
        std::stringstream ss;
        ss << result;
        rpc_shell_result->set_result_str(ss.str());

        response->set_allocated_shell_result(rpc_shell_result);
    }

    static rpc::shell::ShellResult::Result translateToRpcResult(const mavsdk::Shell::Result& result)
    {
        switch (result) {
            default:
                LogErr() << "Unknown result enum value: " << static_cast<int>(result);
            // FALLTHROUGH
            case mavsdk::Shell::Result::Unknown:
                return rpc::shell::ShellResult_Result_RESULT_UNKNOWN;
            case mavsdk::Shell::Result::Success:
                return rpc::shell::ShellResult_Result_RESULT_SUCCESS;
            case mavsdk::Shell::Result::NoSystem:
                return rpc::shell::ShellResult_Result_RESULT_NO_SYSTEM;
            case mavsdk::Shell::Result::ConnectionError:
                return rpc::shell::ShellResult_Result_RESULT_CONNECTION_ERROR;
            case mavsdk::Shell::Result::NoResponse:
                return rpc::shell::ShellResult_Result_RESULT_NO_RESPONSE;
            case mavsdk::Shell::Result::Busy:
                return rpc::shell::ShellResult_Result_RESULT_BUSY;
        }
    }

    static mavsdk::Shell::Result
    translateFromRpcResult(const rpc::shell::ShellResult::Result result)
    {
        switch (result) {
            default:
                LogErr() << "Unknown result enum value: " << static_cast<int>(result);
            // FALLTHROUGH
            case rpc::shell::ShellResult_Result_RESULT_UNKNOWN:
                return mavsdk::Shell::Result::Unknown;
            case rpc::shell::ShellResult_Result_RESULT_SUCCESS:
                return mavsdk::Shell::Result::Success;
            case rpc::shell::ShellResult_Result_RESULT_NO_SYSTEM:
                return mavsdk::Shell::Result::NoSystem;
            case rpc::shell::ShellResult_Result_RESULT_CONNECTION_ERROR:
                return mavsdk::Shell::Result::ConnectionError;
            case rpc::shell::ShellResult_Result_RESULT_NO_RESPONSE:
                return mavsdk::Shell::Result::NoResponse;
            case rpc::shell::ShellResult_Result_RESULT_BUSY:
                return mavsdk::Shell::Result::Busy;
        }
    }

    grpc::Status Send(
        grpc::ServerContext* /* context */,
        const rpc::shell::SendRequest* request,
        rpc::shell::SendResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                auto result = mavsdk::Shell::Result::NoSystem;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "Send sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->send(request->command());

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status SubscribeReceive(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::shell::SubscribeReceiveRequest* /* request */,
        grpc::ServerWriter<rpc::shell::ReceiveResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::Shell::ReceiveHandle handle = _lazy_plugin.maybe_plugin()->subscribe_receive(
            [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                const std::string receive) {
                rpc::shell::ReceiveResponse rpc_response;

                rpc_response.set_data(receive);

                std::unique_lock<std::mutex> lock(*subscribe_mutex);
                if (!*is_finished && !writer->Write(rpc_response)) {
                    _lazy_plugin.maybe_plugin()->unsubscribe_receive(handle);

                    *is_finished = true;
                    unregister_stream_stop_promise(stream_closed_promise);
                    stream_closed_promise->set_value();
                }
            });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    void stop()
    {
        _stopped.store(true);
        std::lock_guard<std::mutex> lock(_stream_stop_mutex);
        for (auto& prom : _stream_stop_promises) {
            if (auto handle = prom.lock()) {
                handle->set_value();
            }
        }
    }

private:
    void register_stream_stop_promise(std::weak_ptr<std::promise<void>> prom)
    {
        // If we have already stopped, set promise immediately and don't add it to list.
        if (_stopped.load()) {
            if (auto handle = prom.lock()) {
                handle->set_value();
            }
        } else {
            std::lock_guard<std::mutex> lock(_stream_stop_mutex);
            _stream_stop_promises.push_back(prom);
        }
    }

    void unregister_stream_stop_promise(std::shared_ptr<std::promise<void>> prom)
    {
        std::lock_guard<std::mutex> lock(_stream_stop_mutex);
        for (auto it = _stream_stop_promises.begin(); it != _stream_stop_promises.end();
             /* ++it */) {
            if (it->lock() == prom) {
                it = _stream_stop_promises.erase(it);
            } else {
                ++it;
            }
        }
    }

    LazyPlugin& _lazy_plugin;

    std::atomic<bool> _stopped{false};
    std::mutex _stream_stop_mutex{};
    std::vector<std::weak_ptr<std::promise<void>>> _stream_stop_promises{};
};

} // namespace mavsdk_server
} // namespace mavsdk