// WARNING: THIS FILE IS AUTOGENERATED! As such, it should not be edited.
// Edits need to be made to the proto files
// (see https://github.com/mavlink/MAVSDK-Proto/blob/master/protos/gripper/gripper.proto)

#include "gripper/gripper.grpc.pb.h"
#include "plugins/gripper/gripper.h"

#include "mavsdk.h"

#include "lazy_plugin.h"

#include "log.h"
#include <atomic>
#include <cmath>
#include <future>
#include <limits>
#include <memory>
#include <mutex>
#include <sstream>
#include <vector>

namespace mavsdk {
namespace mavsdk_server {

template<typename Gripper = Gripper, typename LazyPlugin = LazyPlugin<Gripper>>

class GripperServiceImpl final : public rpc::gripper::GripperService::Service {
public:
    GripperServiceImpl(LazyPlugin& lazy_plugin) : _lazy_plugin(lazy_plugin) {}

    template<typename ResponseType>
    void fillResponseWithResult(ResponseType* response, mavsdk::Gripper::Result& result) const
    {
        auto rpc_result = translateToRpcResult(result);

        auto* rpc_gripper_result = new rpc::gripper::GripperResult();
        rpc_gripper_result->set_result(rpc_result);
        std::stringstream ss;
        ss << result;
        rpc_gripper_result->set_result_str(ss.str());

        response->set_allocated_gripper_result(rpc_gripper_result);
    }

    static rpc::gripper::GripperAction
    translateToRpcGripperAction(const mavsdk::Gripper::GripperAction& gripper_action)
    {
        switch (gripper_action) {
            default:
                LogErr() << "Unknown gripper_action enum value: "
                         << static_cast<int>(gripper_action);
            // FALLTHROUGH
            case mavsdk::Gripper::GripperAction::Release:
                return rpc::gripper::GRIPPER_ACTION_RELEASE;
            case mavsdk::Gripper::GripperAction::Grab:
                return rpc::gripper::GRIPPER_ACTION_GRAB;
        }
    }

    static mavsdk::Gripper::GripperAction
    translateFromRpcGripperAction(const rpc::gripper::GripperAction gripper_action)
    {
        switch (gripper_action) {
            default:
                LogErr() << "Unknown gripper_action enum value: "
                         << static_cast<int>(gripper_action);
            // FALLTHROUGH
            case rpc::gripper::GRIPPER_ACTION_RELEASE:
                return mavsdk::Gripper::GripperAction::Release;
            case rpc::gripper::GRIPPER_ACTION_GRAB:
                return mavsdk::Gripper::GripperAction::Grab;
        }
    }

    static rpc::gripper::GripperResult::Result
    translateToRpcResult(const mavsdk::Gripper::Result& result)
    {
        switch (result) {
            default:
                LogErr() << "Unknown result enum value: " << static_cast<int>(result);
            // FALLTHROUGH
            case mavsdk::Gripper::Result::Unknown:
                return rpc::gripper::GripperResult_Result_RESULT_UNKNOWN;
            case mavsdk::Gripper::Result::Success:
                return rpc::gripper::GripperResult_Result_RESULT_SUCCESS;
            case mavsdk::Gripper::Result::NoSystem:
                return rpc::gripper::GripperResult_Result_RESULT_NO_SYSTEM;
            case mavsdk::Gripper::Result::Busy:
                return rpc::gripper::GripperResult_Result_RESULT_BUSY;
            case mavsdk::Gripper::Result::Timeout:
                return rpc::gripper::GripperResult_Result_RESULT_TIMEOUT;
            case mavsdk::Gripper::Result::Unsupported:
                return rpc::gripper::GripperResult_Result_RESULT_UNSUPPORTED;
            case mavsdk::Gripper::Result::Failed:
                return rpc::gripper::GripperResult_Result_RESULT_FAILED;
        }
    }

    static mavsdk::Gripper::Result
    translateFromRpcResult(const rpc::gripper::GripperResult::Result result)
    {
        switch (result) {
            default:
                LogErr() << "Unknown result enum value: " << static_cast<int>(result);
            // FALLTHROUGH
            case rpc::gripper::GripperResult_Result_RESULT_UNKNOWN:
                return mavsdk::Gripper::Result::Unknown;
            case rpc::gripper::GripperResult_Result_RESULT_SUCCESS:
                return mavsdk::Gripper::Result::Success;
            case rpc::gripper::GripperResult_Result_RESULT_NO_SYSTEM:
                return mavsdk::Gripper::Result::NoSystem;
            case rpc::gripper::GripperResult_Result_RESULT_BUSY:
                return mavsdk::Gripper::Result::Busy;
            case rpc::gripper::GripperResult_Result_RESULT_TIMEOUT:
                return mavsdk::Gripper::Result::Timeout;
            case rpc::gripper::GripperResult_Result_RESULT_UNSUPPORTED:
                return mavsdk::Gripper::Result::Unsupported;
            case rpc::gripper::GripperResult_Result_RESULT_FAILED:
                return mavsdk::Gripper::Result::Failed;
        }
    }

    grpc::Status Grab(
        grpc::ServerContext* /* context */,
        const rpc::gripper::GrabRequest* request,
        rpc::gripper::GrabResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                auto result = mavsdk::Gripper::Result::NoSystem;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "Grab sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->grab(request->instance());

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status Release(
        grpc::ServerContext* /* context */,
        const rpc::gripper::ReleaseRequest* request,
        rpc::gripper::ReleaseResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                auto result = mavsdk::Gripper::Result::NoSystem;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "Release sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->release(request->instance());

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    void stop()
    {
        _stopped.store(true);
        std::lock_guard<std::mutex> lock(_stream_stop_mutex);
        for (auto& prom : _stream_stop_promises) {
            if (auto handle = prom.lock()) {
                handle->set_value();
            }
        }
    }

private:
    void register_stream_stop_promise(std::weak_ptr<std::promise<void>> prom)
    {
        // If we have already stopped, set promise immediately and don't add it to list.
        if (_stopped.load()) {
            if (auto handle = prom.lock()) {
                handle->set_value();
            }
        } else {
            std::lock_guard<std::mutex> lock(_stream_stop_mutex);
            _stream_stop_promises.push_back(prom);
        }
    }

    void unregister_stream_stop_promise(std::shared_ptr<std::promise<void>> prom)
    {
        std::lock_guard<std::mutex> lock(_stream_stop_mutex);
        for (auto it = _stream_stop_promises.begin(); it != _stream_stop_promises.end();
             /* ++it */) {
            if (it->lock() == prom) {
                it = _stream_stop_promises.erase(it);
            } else {
                ++it;
            }
        }
    }

    LazyPlugin& _lazy_plugin;

    std::atomic<bool> _stopped{false};
    std::mutex _stream_stop_mutex{};
    std::vector<std::weak_ptr<std::promise<void>>> _stream_stop_promises{};
};

} // namespace mavsdk_server
} // namespace mavsdk