// WARNING: THIS FILE IS AUTOGENERATED! As such, it should not be edited.
// Edits need to be made to the proto files
// (see https://github.com/mavlink/MAVSDK-Proto/blob/master/protos/ftp/ftp.proto)

#include "ftp/ftp.grpc.pb.h"
#include "plugins/ftp/ftp.h"

#include "mavsdk.h"

#include "lazy_plugin.h"

#include "log.h"
#include <atomic>
#include <cmath>
#include <future>
#include <limits>
#include <memory>
#include <mutex>
#include <sstream>
#include <vector>

namespace mavsdk {
namespace mavsdk_server {

template<typename Ftp = Ftp, typename LazyPlugin = LazyPlugin<Ftp>>

class FtpServiceImpl final : public rpc::ftp::FtpService::Service {
public:
    FtpServiceImpl(LazyPlugin& lazy_plugin) : _lazy_plugin(lazy_plugin) {}

    template<typename ResponseType>
    void fillResponseWithResult(ResponseType* response, mavsdk::Ftp::Result& result) const
    {
        auto rpc_result = translateToRpcResult(result);

        auto* rpc_ftp_result = new rpc::ftp::FtpResult();
        rpc_ftp_result->set_result(rpc_result);
        std::stringstream ss;
        ss << result;
        rpc_ftp_result->set_result_str(ss.str());

        response->set_allocated_ftp_result(rpc_ftp_result);
    }

    static std::unique_ptr<rpc::ftp::ListDirectoryData>
    translateToRpcListDirectoryData(const mavsdk::Ftp::ListDirectoryData& list_directory_data)
    {
        auto rpc_obj = std::make_unique<rpc::ftp::ListDirectoryData>();

        for (const auto& elem : list_directory_data.dirs) {
            rpc_obj->add_dirs(elem);
        }

        for (const auto& elem : list_directory_data.files) {
            rpc_obj->add_files(elem);
        }

        return rpc_obj;
    }

    static mavsdk::Ftp::ListDirectoryData
    translateFromRpcListDirectoryData(const rpc::ftp::ListDirectoryData& list_directory_data)
    {
        mavsdk::Ftp::ListDirectoryData obj;

        for (const auto& elem : list_directory_data.dirs()) {
            obj.dirs.push_back(elem);
        }

        for (const auto& elem : list_directory_data.files()) {
            obj.files.push_back(elem);
        }

        return obj;
    }

    static std::unique_ptr<rpc::ftp::ProgressData>
    translateToRpcProgressData(const mavsdk::Ftp::ProgressData& progress_data)
    {
        auto rpc_obj = std::make_unique<rpc::ftp::ProgressData>();

        rpc_obj->set_bytes_transferred(progress_data.bytes_transferred);

        rpc_obj->set_total_bytes(progress_data.total_bytes);

        return rpc_obj;
    }

    static mavsdk::Ftp::ProgressData
    translateFromRpcProgressData(const rpc::ftp::ProgressData& progress_data)
    {
        mavsdk::Ftp::ProgressData obj;

        obj.bytes_transferred = progress_data.bytes_transferred();

        obj.total_bytes = progress_data.total_bytes();

        return obj;
    }

    static rpc::ftp::FtpResult::Result translateToRpcResult(const mavsdk::Ftp::Result& result)
    {
        switch (result) {
            default:
                LogErr() << "Unknown result enum value: " << static_cast<int>(result);
            // FALLTHROUGH
            case mavsdk::Ftp::Result::Unknown:
                return rpc::ftp::FtpResult_Result_RESULT_UNKNOWN;
            case mavsdk::Ftp::Result::Success:
                return rpc::ftp::FtpResult_Result_RESULT_SUCCESS;
            case mavsdk::Ftp::Result::Next:
                return rpc::ftp::FtpResult_Result_RESULT_NEXT;
            case mavsdk::Ftp::Result::Timeout:
                return rpc::ftp::FtpResult_Result_RESULT_TIMEOUT;
            case mavsdk::Ftp::Result::Busy:
                return rpc::ftp::FtpResult_Result_RESULT_BUSY;
            case mavsdk::Ftp::Result::FileIoError:
                return rpc::ftp::FtpResult_Result_RESULT_FILE_IO_ERROR;
            case mavsdk::Ftp::Result::FileExists:
                return rpc::ftp::FtpResult_Result_RESULT_FILE_EXISTS;
            case mavsdk::Ftp::Result::FileDoesNotExist:
                return rpc::ftp::FtpResult_Result_RESULT_FILE_DOES_NOT_EXIST;
            case mavsdk::Ftp::Result::FileProtected:
                return rpc::ftp::FtpResult_Result_RESULT_FILE_PROTECTED;
            case mavsdk::Ftp::Result::InvalidParameter:
                return rpc::ftp::FtpResult_Result_RESULT_INVALID_PARAMETER;
            case mavsdk::Ftp::Result::Unsupported:
                return rpc::ftp::FtpResult_Result_RESULT_UNSUPPORTED;
            case mavsdk::Ftp::Result::ProtocolError:
                return rpc::ftp::FtpResult_Result_RESULT_PROTOCOL_ERROR;
            case mavsdk::Ftp::Result::NoSystem:
                return rpc::ftp::FtpResult_Result_RESULT_NO_SYSTEM;
        }
    }

    static mavsdk::Ftp::Result translateFromRpcResult(const rpc::ftp::FtpResult::Result result)
    {
        switch (result) {
            default:
                LogErr() << "Unknown result enum value: " << static_cast<int>(result);
            // FALLTHROUGH
            case rpc::ftp::FtpResult_Result_RESULT_UNKNOWN:
                return mavsdk::Ftp::Result::Unknown;
            case rpc::ftp::FtpResult_Result_RESULT_SUCCESS:
                return mavsdk::Ftp::Result::Success;
            case rpc::ftp::FtpResult_Result_RESULT_NEXT:
                return mavsdk::Ftp::Result::Next;
            case rpc::ftp::FtpResult_Result_RESULT_TIMEOUT:
                return mavsdk::Ftp::Result::Timeout;
            case rpc::ftp::FtpResult_Result_RESULT_BUSY:
                return mavsdk::Ftp::Result::Busy;
            case rpc::ftp::FtpResult_Result_RESULT_FILE_IO_ERROR:
                return mavsdk::Ftp::Result::FileIoError;
            case rpc::ftp::FtpResult_Result_RESULT_FILE_EXISTS:
                return mavsdk::Ftp::Result::FileExists;
            case rpc::ftp::FtpResult_Result_RESULT_FILE_DOES_NOT_EXIST:
                return mavsdk::Ftp::Result::FileDoesNotExist;
            case rpc::ftp::FtpResult_Result_RESULT_FILE_PROTECTED:
                return mavsdk::Ftp::Result::FileProtected;
            case rpc::ftp::FtpResult_Result_RESULT_INVALID_PARAMETER:
                return mavsdk::Ftp::Result::InvalidParameter;
            case rpc::ftp::FtpResult_Result_RESULT_UNSUPPORTED:
                return mavsdk::Ftp::Result::Unsupported;
            case rpc::ftp::FtpResult_Result_RESULT_PROTOCOL_ERROR:
                return mavsdk::Ftp::Result::ProtocolError;
            case rpc::ftp::FtpResult_Result_RESULT_NO_SYSTEM:
                return mavsdk::Ftp::Result::NoSystem;
        }
    }

    grpc::Status SubscribeDownload(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::ftp::SubscribeDownloadRequest* request,
        grpc::ServerWriter<rpc::ftp::DownloadResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            rpc::ftp::DownloadResponse rpc_response;
            auto result = mavsdk::Ftp::Result::NoSystem;
            fillResponseWithResult(&rpc_response, result);
            writer->Write(rpc_response);

            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        _lazy_plugin.maybe_plugin()->download_async(
            request->remote_file_path(),
            request->local_dir(),
            request->use_burst(),
            [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex](
                mavsdk::Ftp::Result result, const mavsdk::Ftp::ProgressData download) {
                rpc::ftp::DownloadResponse rpc_response;

                rpc_response.set_allocated_progress_data(
                    translateToRpcProgressData(download).release());

                auto rpc_result = translateToRpcResult(result);
                auto* rpc_ftp_result = new rpc::ftp::FtpResult();
                rpc_ftp_result->set_result(rpc_result);
                std::stringstream ss;
                ss << result;
                rpc_ftp_result->set_result_str(ss.str());
                rpc_response.set_allocated_ftp_result(rpc_ftp_result);

                std::unique_lock<std::mutex> lock(*subscribe_mutex);
                if (!*is_finished && !writer->Write(rpc_response)) {
                    *is_finished = true;
                    unregister_stream_stop_promise(stream_closed_promise);
                    stream_closed_promise->set_value();
                }
            });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status SubscribeUpload(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::ftp::SubscribeUploadRequest* request,
        grpc::ServerWriter<rpc::ftp::UploadResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            rpc::ftp::UploadResponse rpc_response;
            auto result = mavsdk::Ftp::Result::NoSystem;
            fillResponseWithResult(&rpc_response, result);
            writer->Write(rpc_response);

            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        _lazy_plugin.maybe_plugin()->upload_async(
            request->local_file_path(),
            request->remote_dir(),
            [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex](
                mavsdk::Ftp::Result result, const mavsdk::Ftp::ProgressData upload) {
                rpc::ftp::UploadResponse rpc_response;

                rpc_response.set_allocated_progress_data(
                    translateToRpcProgressData(upload).release());

                auto rpc_result = translateToRpcResult(result);
                auto* rpc_ftp_result = new rpc::ftp::FtpResult();
                rpc_ftp_result->set_result(rpc_result);
                std::stringstream ss;
                ss << result;
                rpc_ftp_result->set_result_str(ss.str());
                rpc_response.set_allocated_ftp_result(rpc_ftp_result);

                std::unique_lock<std::mutex> lock(*subscribe_mutex);
                if (!*is_finished && !writer->Write(rpc_response)) {
                    *is_finished = true;
                    unregister_stream_stop_promise(stream_closed_promise);
                    stream_closed_promise->set_value();
                }
            });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status ListDirectory(
        grpc::ServerContext* /* context */,
        const rpc::ftp::ListDirectoryRequest* request,
        rpc::ftp::ListDirectoryResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                auto result = mavsdk::Ftp::Result::NoSystem;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "ListDirectory sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->list_directory(request->remote_dir());

        if (response != nullptr) {
            fillResponseWithResult(response, result.first);

            response->set_allocated_data(translateToRpcListDirectoryData(result.second).release());
        }

        return grpc::Status::OK;
    }

    grpc::Status CreateDirectory(
        grpc::ServerContext* /* context */,
        const rpc::ftp::CreateDirectoryRequest* request,
        rpc::ftp::CreateDirectoryResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                auto result = mavsdk::Ftp::Result::NoSystem;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "CreateDirectory sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->create_directory(request->remote_dir());

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status RemoveDirectory(
        grpc::ServerContext* /* context */,
        const rpc::ftp::RemoveDirectoryRequest* request,
        rpc::ftp::RemoveDirectoryResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                auto result = mavsdk::Ftp::Result::NoSystem;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "RemoveDirectory sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->remove_directory(request->remote_dir());

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status RemoveFile(
        grpc::ServerContext* /* context */,
        const rpc::ftp::RemoveFileRequest* request,
        rpc::ftp::RemoveFileResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                auto result = mavsdk::Ftp::Result::NoSystem;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "RemoveFile sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->remove_file(request->remote_file_path());

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status Rename(
        grpc::ServerContext* /* context */,
        const rpc::ftp::RenameRequest* request,
        rpc::ftp::RenameResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                auto result = mavsdk::Ftp::Result::NoSystem;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "Rename sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->rename(
            request->remote_from_path(), request->remote_to_path());

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status AreFilesIdentical(
        grpc::ServerContext* /* context */,
        const rpc::ftp::AreFilesIdenticalRequest* request,
        rpc::ftp::AreFilesIdenticalResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                auto result = mavsdk::Ftp::Result::NoSystem;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "AreFilesIdentical sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->are_files_identical(
            request->local_file_path(), request->remote_file_path());

        if (response != nullptr) {
            fillResponseWithResult(response, result.first);

            response->set_are_identical(result.second);
        }

        return grpc::Status::OK;
    }

    grpc::Status SetTargetCompid(
        grpc::ServerContext* /* context */,
        const rpc::ftp::SetTargetCompidRequest* request,
        rpc::ftp::SetTargetCompidResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                auto result = mavsdk::Ftp::Result::NoSystem;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "SetTargetCompid sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->set_target_compid(request->compid());

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    void stop()
    {
        _stopped.store(true);
        std::lock_guard<std::mutex> lock(_stream_stop_mutex);
        for (auto& prom : _stream_stop_promises) {
            if (auto handle = prom.lock()) {
                handle->set_value();
            }
        }
    }

private:
    void register_stream_stop_promise(std::weak_ptr<std::promise<void>> prom)
    {
        // If we have already stopped, set promise immediately and don't add it to list.
        if (_stopped.load()) {
            if (auto handle = prom.lock()) {
                handle->set_value();
            }
        } else {
            std::lock_guard<std::mutex> lock(_stream_stop_mutex);
            _stream_stop_promises.push_back(prom);
        }
    }

    void unregister_stream_stop_promise(std::shared_ptr<std::promise<void>> prom)
    {
        std::lock_guard<std::mutex> lock(_stream_stop_mutex);
        for (auto it = _stream_stop_promises.begin(); it != _stream_stop_promises.end();
             /* ++it */) {
            if (it->lock() == prom) {
                it = _stream_stop_promises.erase(it);
            } else {
                ++it;
            }
        }
    }

    LazyPlugin& _lazy_plugin;

    std::atomic<bool> _stopped{false};
    std::mutex _stream_stop_mutex{};
    std::vector<std::weak_ptr<std::promise<void>>> _stream_stop_promises{};
};

} // namespace mavsdk_server
} // namespace mavsdk