// WARNING: THIS FILE IS AUTOGENERATED! As such, it should not be edited.
// Edits need to be made to the proto files
// (see https://github.com/mavlink/MAVSDK-Proto/blob/master/protos/failure/failure.proto)

#include "failure/failure.grpc.pb.h"
#include "plugins/failure/failure.h"

#include "mavsdk.h"

#include "lazy_plugin.h"

#include "log.h"
#include <atomic>
#include <cmath>
#include <future>
#include <limits>
#include <memory>
#include <mutex>
#include <sstream>
#include <vector>

namespace mavsdk {
namespace mavsdk_server {

template<typename Failure = Failure, typename LazyPlugin = LazyPlugin<Failure>>

class FailureServiceImpl final : public rpc::failure::FailureService::Service {
public:
    FailureServiceImpl(LazyPlugin& lazy_plugin) : _lazy_plugin(lazy_plugin) {}

    template<typename ResponseType>
    void fillResponseWithResult(ResponseType* response, mavsdk::Failure::Result& result) const
    {
        auto rpc_result = translateToRpcResult(result);

        auto* rpc_failure_result = new rpc::failure::FailureResult();
        rpc_failure_result->set_result(rpc_result);
        std::stringstream ss;
        ss << result;
        rpc_failure_result->set_result_str(ss.str());

        response->set_allocated_failure_result(rpc_failure_result);
    }

    static rpc::failure::FailureUnit
    translateToRpcFailureUnit(const mavsdk::Failure::FailureUnit& failure_unit)
    {
        switch (failure_unit) {
            default:
                LogErr() << "Unknown failure_unit enum value: " << static_cast<int>(failure_unit);
            // FALLTHROUGH
            case mavsdk::Failure::FailureUnit::SensorGyro:
                return rpc::failure::FAILURE_UNIT_SENSOR_GYRO;
            case mavsdk::Failure::FailureUnit::SensorAccel:
                return rpc::failure::FAILURE_UNIT_SENSOR_ACCEL;
            case mavsdk::Failure::FailureUnit::SensorMag:
                return rpc::failure::FAILURE_UNIT_SENSOR_MAG;
            case mavsdk::Failure::FailureUnit::SensorBaro:
                return rpc::failure::FAILURE_UNIT_SENSOR_BARO;
            case mavsdk::Failure::FailureUnit::SensorGps:
                return rpc::failure::FAILURE_UNIT_SENSOR_GPS;
            case mavsdk::Failure::FailureUnit::SensorOpticalFlow:
                return rpc::failure::FAILURE_UNIT_SENSOR_OPTICAL_FLOW;
            case mavsdk::Failure::FailureUnit::SensorVio:
                return rpc::failure::FAILURE_UNIT_SENSOR_VIO;
            case mavsdk::Failure::FailureUnit::SensorDistanceSensor:
                return rpc::failure::FAILURE_UNIT_SENSOR_DISTANCE_SENSOR;
            case mavsdk::Failure::FailureUnit::SensorAirspeed:
                return rpc::failure::FAILURE_UNIT_SENSOR_AIRSPEED;
            case mavsdk::Failure::FailureUnit::SystemBattery:
                return rpc::failure::FAILURE_UNIT_SYSTEM_BATTERY;
            case mavsdk::Failure::FailureUnit::SystemMotor:
                return rpc::failure::FAILURE_UNIT_SYSTEM_MOTOR;
            case mavsdk::Failure::FailureUnit::SystemServo:
                return rpc::failure::FAILURE_UNIT_SYSTEM_SERVO;
            case mavsdk::Failure::FailureUnit::SystemAvoidance:
                return rpc::failure::FAILURE_UNIT_SYSTEM_AVOIDANCE;
            case mavsdk::Failure::FailureUnit::SystemRcSignal:
                return rpc::failure::FAILURE_UNIT_SYSTEM_RC_SIGNAL;
            case mavsdk::Failure::FailureUnit::SystemMavlinkSignal:
                return rpc::failure::FAILURE_UNIT_SYSTEM_MAVLINK_SIGNAL;
        }
    }

    static mavsdk::Failure::FailureUnit
    translateFromRpcFailureUnit(const rpc::failure::FailureUnit failure_unit)
    {
        switch (failure_unit) {
            default:
                LogErr() << "Unknown failure_unit enum value: " << static_cast<int>(failure_unit);
            // FALLTHROUGH
            case rpc::failure::FAILURE_UNIT_SENSOR_GYRO:
                return mavsdk::Failure::FailureUnit::SensorGyro;
            case rpc::failure::FAILURE_UNIT_SENSOR_ACCEL:
                return mavsdk::Failure::FailureUnit::SensorAccel;
            case rpc::failure::FAILURE_UNIT_SENSOR_MAG:
                return mavsdk::Failure::FailureUnit::SensorMag;
            case rpc::failure::FAILURE_UNIT_SENSOR_BARO:
                return mavsdk::Failure::FailureUnit::SensorBaro;
            case rpc::failure::FAILURE_UNIT_SENSOR_GPS:
                return mavsdk::Failure::FailureUnit::SensorGps;
            case rpc::failure::FAILURE_UNIT_SENSOR_OPTICAL_FLOW:
                return mavsdk::Failure::FailureUnit::SensorOpticalFlow;
            case rpc::failure::FAILURE_UNIT_SENSOR_VIO:
                return mavsdk::Failure::FailureUnit::SensorVio;
            case rpc::failure::FAILURE_UNIT_SENSOR_DISTANCE_SENSOR:
                return mavsdk::Failure::FailureUnit::SensorDistanceSensor;
            case rpc::failure::FAILURE_UNIT_SENSOR_AIRSPEED:
                return mavsdk::Failure::FailureUnit::SensorAirspeed;
            case rpc::failure::FAILURE_UNIT_SYSTEM_BATTERY:
                return mavsdk::Failure::FailureUnit::SystemBattery;
            case rpc::failure::FAILURE_UNIT_SYSTEM_MOTOR:
                return mavsdk::Failure::FailureUnit::SystemMotor;
            case rpc::failure::FAILURE_UNIT_SYSTEM_SERVO:
                return mavsdk::Failure::FailureUnit::SystemServo;
            case rpc::failure::FAILURE_UNIT_SYSTEM_AVOIDANCE:
                return mavsdk::Failure::FailureUnit::SystemAvoidance;
            case rpc::failure::FAILURE_UNIT_SYSTEM_RC_SIGNAL:
                return mavsdk::Failure::FailureUnit::SystemRcSignal;
            case rpc::failure::FAILURE_UNIT_SYSTEM_MAVLINK_SIGNAL:
                return mavsdk::Failure::FailureUnit::SystemMavlinkSignal;
        }
    }

    static rpc::failure::FailureType
    translateToRpcFailureType(const mavsdk::Failure::FailureType& failure_type)
    {
        switch (failure_type) {
            default:
                LogErr() << "Unknown failure_type enum value: " << static_cast<int>(failure_type);
            // FALLTHROUGH
            case mavsdk::Failure::FailureType::Ok:
                return rpc::failure::FAILURE_TYPE_OK;
            case mavsdk::Failure::FailureType::Off:
                return rpc::failure::FAILURE_TYPE_OFF;
            case mavsdk::Failure::FailureType::Stuck:
                return rpc::failure::FAILURE_TYPE_STUCK;
            case mavsdk::Failure::FailureType::Garbage:
                return rpc::failure::FAILURE_TYPE_GARBAGE;
            case mavsdk::Failure::FailureType::Wrong:
                return rpc::failure::FAILURE_TYPE_WRONG;
            case mavsdk::Failure::FailureType::Slow:
                return rpc::failure::FAILURE_TYPE_SLOW;
            case mavsdk::Failure::FailureType::Delayed:
                return rpc::failure::FAILURE_TYPE_DELAYED;
            case mavsdk::Failure::FailureType::Intermittent:
                return rpc::failure::FAILURE_TYPE_INTERMITTENT;
        }
    }

    static mavsdk::Failure::FailureType
    translateFromRpcFailureType(const rpc::failure::FailureType failure_type)
    {
        switch (failure_type) {
            default:
                LogErr() << "Unknown failure_type enum value: " << static_cast<int>(failure_type);
            // FALLTHROUGH
            case rpc::failure::FAILURE_TYPE_OK:
                return mavsdk::Failure::FailureType::Ok;
            case rpc::failure::FAILURE_TYPE_OFF:
                return mavsdk::Failure::FailureType::Off;
            case rpc::failure::FAILURE_TYPE_STUCK:
                return mavsdk::Failure::FailureType::Stuck;
            case rpc::failure::FAILURE_TYPE_GARBAGE:
                return mavsdk::Failure::FailureType::Garbage;
            case rpc::failure::FAILURE_TYPE_WRONG:
                return mavsdk::Failure::FailureType::Wrong;
            case rpc::failure::FAILURE_TYPE_SLOW:
                return mavsdk::Failure::FailureType::Slow;
            case rpc::failure::FAILURE_TYPE_DELAYED:
                return mavsdk::Failure::FailureType::Delayed;
            case rpc::failure::FAILURE_TYPE_INTERMITTENT:
                return mavsdk::Failure::FailureType::Intermittent;
        }
    }

    static rpc::failure::FailureResult::Result
    translateToRpcResult(const mavsdk::Failure::Result& result)
    {
        switch (result) {
            default:
                LogErr() << "Unknown result enum value: " << static_cast<int>(result);
            // FALLTHROUGH
            case mavsdk::Failure::Result::Unknown:
                return rpc::failure::FailureResult_Result_RESULT_UNKNOWN;
            case mavsdk::Failure::Result::Success:
                return rpc::failure::FailureResult_Result_RESULT_SUCCESS;
            case mavsdk::Failure::Result::NoSystem:
                return rpc::failure::FailureResult_Result_RESULT_NO_SYSTEM;
            case mavsdk::Failure::Result::ConnectionError:
                return rpc::failure::FailureResult_Result_RESULT_CONNECTION_ERROR;
            case mavsdk::Failure::Result::Unsupported:
                return rpc::failure::FailureResult_Result_RESULT_UNSUPPORTED;
            case mavsdk::Failure::Result::Denied:
                return rpc::failure::FailureResult_Result_RESULT_DENIED;
            case mavsdk::Failure::Result::Disabled:
                return rpc::failure::FailureResult_Result_RESULT_DISABLED;
            case mavsdk::Failure::Result::Timeout:
                return rpc::failure::FailureResult_Result_RESULT_TIMEOUT;
        }
    }

    static mavsdk::Failure::Result
    translateFromRpcResult(const rpc::failure::FailureResult::Result result)
    {
        switch (result) {
            default:
                LogErr() << "Unknown result enum value: " << static_cast<int>(result);
            // FALLTHROUGH
            case rpc::failure::FailureResult_Result_RESULT_UNKNOWN:
                return mavsdk::Failure::Result::Unknown;
            case rpc::failure::FailureResult_Result_RESULT_SUCCESS:
                return mavsdk::Failure::Result::Success;
            case rpc::failure::FailureResult_Result_RESULT_NO_SYSTEM:
                return mavsdk::Failure::Result::NoSystem;
            case rpc::failure::FailureResult_Result_RESULT_CONNECTION_ERROR:
                return mavsdk::Failure::Result::ConnectionError;
            case rpc::failure::FailureResult_Result_RESULT_UNSUPPORTED:
                return mavsdk::Failure::Result::Unsupported;
            case rpc::failure::FailureResult_Result_RESULT_DENIED:
                return mavsdk::Failure::Result::Denied;
            case rpc::failure::FailureResult_Result_RESULT_DISABLED:
                return mavsdk::Failure::Result::Disabled;
            case rpc::failure::FailureResult_Result_RESULT_TIMEOUT:
                return mavsdk::Failure::Result::Timeout;
        }
    }

    grpc::Status Inject(
        grpc::ServerContext* /* context */,
        const rpc::failure::InjectRequest* request,
        rpc::failure::InjectResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                auto result = mavsdk::Failure::Result::NoSystem;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "Inject sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->inject(
            translateFromRpcFailureUnit(request->failure_unit()),
            translateFromRpcFailureType(request->failure_type()),
            request->instance());

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    void stop()
    {
        _stopped.store(true);
        std::lock_guard<std::mutex> lock(_stream_stop_mutex);
        for (auto& prom : _stream_stop_promises) {
            if (auto handle = prom.lock()) {
                handle->set_value();
            }
        }
    }

private:
    void register_stream_stop_promise(std::weak_ptr<std::promise<void>> prom)
    {
        // If we have already stopped, set promise immediately and don't add it to list.
        if (_stopped.load()) {
            if (auto handle = prom.lock()) {
                handle->set_value();
            }
        } else {
            std::lock_guard<std::mutex> lock(_stream_stop_mutex);
            _stream_stop_promises.push_back(prom);
        }
    }

    void unregister_stream_stop_promise(std::shared_ptr<std::promise<void>> prom)
    {
        std::lock_guard<std::mutex> lock(_stream_stop_mutex);
        for (auto it = _stream_stop_promises.begin(); it != _stream_stop_promises.end();
             /* ++it */) {
            if (it->lock() == prom) {
                it = _stream_stop_promises.erase(it);
            } else {
                ++it;
            }
        }
    }

    LazyPlugin& _lazy_plugin;

    std::atomic<bool> _stopped{false};
    std::mutex _stream_stop_mutex{};
    std::vector<std::weak_ptr<std::promise<void>>> _stream_stop_promises{};
};

} // namespace mavsdk_server
} // namespace mavsdk