// WARNING: THIS FILE IS AUTOGENERATED! As such, it should not be edited.
// Edits need to be made to the proto files
// (see https://github.com/mavlink/MAVSDK-Proto/blob/master/protos/events/events.proto)

#include "events/events.grpc.pb.h"
#include "plugins/events/events.h"

#include "mavsdk.h"

#include "lazy_plugin.h"

#include "log.h"
#include <atomic>
#include <cmath>
#include <future>
#include <limits>
#include <memory>
#include <mutex>
#include <sstream>
#include <vector>

namespace mavsdk {
namespace mavsdk_server {

template<typename Events = Events, typename LazyPlugin = LazyPlugin<Events>>

class EventsServiceImpl final : public rpc::events::EventsService::Service {
public:
    EventsServiceImpl(LazyPlugin& lazy_plugin) : _lazy_plugin(lazy_plugin) {}

    template<typename ResponseType>
    void fillResponseWithResult(ResponseType* response, mavsdk::Events::Result& result) const
    {
        auto rpc_result = translateToRpcResult(result);

        auto* rpc_events_result = new rpc::events::EventsResult();
        rpc_events_result->set_result(rpc_result);
        std::stringstream ss;
        ss << result;
        rpc_events_result->set_result_str(ss.str());

        response->set_allocated_events_result(rpc_events_result);
    }

    static rpc::events::LogLevel translateToRpcLogLevel(const mavsdk::Events::LogLevel& log_level)
    {
        switch (log_level) {
            default:
                LogErr() << "Unknown log_level enum value: " << static_cast<int>(log_level);
            // FALLTHROUGH
            case mavsdk::Events::LogLevel::Emergency:
                return rpc::events::LOG_LEVEL_EMERGENCY;
            case mavsdk::Events::LogLevel::Alert:
                return rpc::events::LOG_LEVEL_ALERT;
            case mavsdk::Events::LogLevel::Critical:
                return rpc::events::LOG_LEVEL_CRITICAL;
            case mavsdk::Events::LogLevel::Error:
                return rpc::events::LOG_LEVEL_ERROR;
            case mavsdk::Events::LogLevel::Warning:
                return rpc::events::LOG_LEVEL_WARNING;
            case mavsdk::Events::LogLevel::Notice:
                return rpc::events::LOG_LEVEL_NOTICE;
            case mavsdk::Events::LogLevel::Info:
                return rpc::events::LOG_LEVEL_INFO;
            case mavsdk::Events::LogLevel::Debug:
                return rpc::events::LOG_LEVEL_DEBUG;
        }
    }

    static mavsdk::Events::LogLevel translateFromRpcLogLevel(const rpc::events::LogLevel log_level)
    {
        switch (log_level) {
            default:
                LogErr() << "Unknown log_level enum value: " << static_cast<int>(log_level);
            // FALLTHROUGH
            case rpc::events::LOG_LEVEL_EMERGENCY:
                return mavsdk::Events::LogLevel::Emergency;
            case rpc::events::LOG_LEVEL_ALERT:
                return mavsdk::Events::LogLevel::Alert;
            case rpc::events::LOG_LEVEL_CRITICAL:
                return mavsdk::Events::LogLevel::Critical;
            case rpc::events::LOG_LEVEL_ERROR:
                return mavsdk::Events::LogLevel::Error;
            case rpc::events::LOG_LEVEL_WARNING:
                return mavsdk::Events::LogLevel::Warning;
            case rpc::events::LOG_LEVEL_NOTICE:
                return mavsdk::Events::LogLevel::Notice;
            case rpc::events::LOG_LEVEL_INFO:
                return mavsdk::Events::LogLevel::Info;
            case rpc::events::LOG_LEVEL_DEBUG:
                return mavsdk::Events::LogLevel::Debug;
        }
    }

    static std::unique_ptr<rpc::events::Event>
    translateToRpcEvent(const mavsdk::Events::Event& event)
    {
        auto rpc_obj = std::make_unique<rpc::events::Event>();

        rpc_obj->set_compid(event.compid);

        rpc_obj->set_message(event.message);

        rpc_obj->set_description(event.description);

        rpc_obj->set_log_level(translateToRpcLogLevel(event.log_level));

        rpc_obj->set_event_namespace(event.event_namespace);

        rpc_obj->set_event_name(event.event_name);

        return rpc_obj;
    }

    static mavsdk::Events::Event translateFromRpcEvent(const rpc::events::Event& event)
    {
        mavsdk::Events::Event obj;

        obj.compid = event.compid();

        obj.message = event.message();

        obj.description = event.description();

        obj.log_level = translateFromRpcLogLevel(event.log_level());

        obj.event_namespace = event.event_namespace();

        obj.event_name = event.event_name();

        return obj;
    }

    static std::unique_ptr<rpc::events::HealthAndArmingCheckProblem>
    translateToRpcHealthAndArmingCheckProblem(
        const mavsdk::Events::HealthAndArmingCheckProblem& health_and_arming_check_problem)
    {
        auto rpc_obj = std::make_unique<rpc::events::HealthAndArmingCheckProblem>();

        rpc_obj->set_message(health_and_arming_check_problem.message);

        rpc_obj->set_description(health_and_arming_check_problem.description);

        rpc_obj->set_log_level(translateToRpcLogLevel(health_and_arming_check_problem.log_level));

        rpc_obj->set_health_component(health_and_arming_check_problem.health_component);

        return rpc_obj;
    }

    static mavsdk::Events::HealthAndArmingCheckProblem translateFromRpcHealthAndArmingCheckProblem(
        const rpc::events::HealthAndArmingCheckProblem& health_and_arming_check_problem)
    {
        mavsdk::Events::HealthAndArmingCheckProblem obj;

        obj.message = health_and_arming_check_problem.message();

        obj.description = health_and_arming_check_problem.description();

        obj.log_level = translateFromRpcLogLevel(health_and_arming_check_problem.log_level());

        obj.health_component = health_and_arming_check_problem.health_component();

        return obj;
    }

    static std::unique_ptr<rpc::events::HealthAndArmingCheckMode>
    translateToRpcHealthAndArmingCheckMode(
        const mavsdk::Events::HealthAndArmingCheckMode& health_and_arming_check_mode)
    {
        auto rpc_obj = std::make_unique<rpc::events::HealthAndArmingCheckMode>();

        rpc_obj->set_mode_name(health_and_arming_check_mode.mode_name);

        rpc_obj->set_can_arm_or_run(health_and_arming_check_mode.can_arm_or_run);

        for (const auto& elem : health_and_arming_check_mode.problems) {
            auto* ptr = rpc_obj->add_problems();
            ptr->CopyFrom(*translateToRpcHealthAndArmingCheckProblem(elem).release());
        }

        return rpc_obj;
    }

    static mavsdk::Events::HealthAndArmingCheckMode translateFromRpcHealthAndArmingCheckMode(
        const rpc::events::HealthAndArmingCheckMode& health_and_arming_check_mode)
    {
        mavsdk::Events::HealthAndArmingCheckMode obj;

        obj.mode_name = health_and_arming_check_mode.mode_name();

        obj.can_arm_or_run = health_and_arming_check_mode.can_arm_or_run();

        for (const auto& elem : health_and_arming_check_mode.problems()) {
            obj.problems.push_back(translateFromRpcHealthAndArmingCheckProblem(
                static_cast<mavsdk::rpc::events::HealthAndArmingCheckProblem>(elem)));
        }

        return obj;
    }

    static std::unique_ptr<rpc::events::HealthComponentReport> translateToRpcHealthComponentReport(
        const mavsdk::Events::HealthComponentReport& health_component_report)
    {
        auto rpc_obj = std::make_unique<rpc::events::HealthComponentReport>();

        rpc_obj->set_name(health_component_report.name);

        rpc_obj->set_label(health_component_report.label);

        rpc_obj->set_is_present(health_component_report.is_present);

        rpc_obj->set_has_error(health_component_report.has_error);

        rpc_obj->set_has_warning(health_component_report.has_warning);

        return rpc_obj;
    }

    static mavsdk::Events::HealthComponentReport translateFromRpcHealthComponentReport(
        const rpc::events::HealthComponentReport& health_component_report)
    {
        mavsdk::Events::HealthComponentReport obj;

        obj.name = health_component_report.name();

        obj.label = health_component_report.label();

        obj.is_present = health_component_report.is_present();

        obj.has_error = health_component_report.has_error();

        obj.has_warning = health_component_report.has_warning();

        return obj;
    }

    static std::unique_ptr<rpc::events::HealthAndArmingCheckReport>
    translateToRpcHealthAndArmingCheckReport(
        const mavsdk::Events::HealthAndArmingCheckReport& health_and_arming_check_report)
    {
        auto rpc_obj = std::make_unique<rpc::events::HealthAndArmingCheckReport>();

        rpc_obj->set_allocated_current_mode_intention(
            translateToRpcHealthAndArmingCheckMode(
                health_and_arming_check_report.current_mode_intention)
                .release());

        for (const auto& elem : health_and_arming_check_report.health_components) {
            auto* ptr = rpc_obj->add_health_components();
            ptr->CopyFrom(*translateToRpcHealthComponentReport(elem).release());
        }

        for (const auto& elem : health_and_arming_check_report.all_problems) {
            auto* ptr = rpc_obj->add_all_problems();
            ptr->CopyFrom(*translateToRpcHealthAndArmingCheckProblem(elem).release());
        }

        return rpc_obj;
    }

    static mavsdk::Events::HealthAndArmingCheckReport translateFromRpcHealthAndArmingCheckReport(
        const rpc::events::HealthAndArmingCheckReport& health_and_arming_check_report)
    {
        mavsdk::Events::HealthAndArmingCheckReport obj;

        obj.current_mode_intention = translateFromRpcHealthAndArmingCheckMode(
            health_and_arming_check_report.current_mode_intention());

        for (const auto& elem : health_and_arming_check_report.health_components()) {
            obj.health_components.push_back(translateFromRpcHealthComponentReport(
                static_cast<mavsdk::rpc::events::HealthComponentReport>(elem)));
        }

        for (const auto& elem : health_and_arming_check_report.all_problems()) {
            obj.all_problems.push_back(translateFromRpcHealthAndArmingCheckProblem(
                static_cast<mavsdk::rpc::events::HealthAndArmingCheckProblem>(elem)));
        }

        return obj;
    }

    static rpc::events::EventsResult::Result
    translateToRpcResult(const mavsdk::Events::Result& result)
    {
        switch (result) {
            default:
                LogErr() << "Unknown result enum value: " << static_cast<int>(result);
            // FALLTHROUGH
            case mavsdk::Events::Result::Success:
                return rpc::events::EventsResult_Result_RESULT_SUCCESS;
            case mavsdk::Events::Result::NotAvailable:
                return rpc::events::EventsResult_Result_RESULT_NOT_AVAILABLE;
            case mavsdk::Events::Result::ConnectionError:
                return rpc::events::EventsResult_Result_RESULT_CONNECTION_ERROR;
            case mavsdk::Events::Result::Unsupported:
                return rpc::events::EventsResult_Result_RESULT_UNSUPPORTED;
            case mavsdk::Events::Result::Denied:
                return rpc::events::EventsResult_Result_RESULT_DENIED;
            case mavsdk::Events::Result::Failed:
                return rpc::events::EventsResult_Result_RESULT_FAILED;
            case mavsdk::Events::Result::Timeout:
                return rpc::events::EventsResult_Result_RESULT_TIMEOUT;
            case mavsdk::Events::Result::NoSystem:
                return rpc::events::EventsResult_Result_RESULT_NO_SYSTEM;
        }
    }

    static mavsdk::Events::Result
    translateFromRpcResult(const rpc::events::EventsResult::Result result)
    {
        switch (result) {
            default:
                LogErr() << "Unknown result enum value: " << static_cast<int>(result);
            // FALLTHROUGH
            case rpc::events::EventsResult_Result_RESULT_SUCCESS:
                return mavsdk::Events::Result::Success;
            case rpc::events::EventsResult_Result_RESULT_NOT_AVAILABLE:
                return mavsdk::Events::Result::NotAvailable;
            case rpc::events::EventsResult_Result_RESULT_CONNECTION_ERROR:
                return mavsdk::Events::Result::ConnectionError;
            case rpc::events::EventsResult_Result_RESULT_UNSUPPORTED:
                return mavsdk::Events::Result::Unsupported;
            case rpc::events::EventsResult_Result_RESULT_DENIED:
                return mavsdk::Events::Result::Denied;
            case rpc::events::EventsResult_Result_RESULT_FAILED:
                return mavsdk::Events::Result::Failed;
            case rpc::events::EventsResult_Result_RESULT_TIMEOUT:
                return mavsdk::Events::Result::Timeout;
            case rpc::events::EventsResult_Result_RESULT_NO_SYSTEM:
                return mavsdk::Events::Result::NoSystem;
        }
    }

    grpc::Status SubscribeEvents(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::events::SubscribeEventsRequest* /* request */,
        grpc::ServerWriter<rpc::events::EventsResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::Events::EventsHandle handle = _lazy_plugin.maybe_plugin()->subscribe_events(
            [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                const mavsdk::Events::Event events) {
                rpc::events::EventsResponse rpc_response;

                rpc_response.set_allocated_event(translateToRpcEvent(events).release());

                std::unique_lock<std::mutex> lock(*subscribe_mutex);
                if (!*is_finished && !writer->Write(rpc_response)) {
                    _lazy_plugin.maybe_plugin()->unsubscribe_events(handle);

                    *is_finished = true;
                    unregister_stream_stop_promise(stream_closed_promise);
                    stream_closed_promise->set_value();
                }
            });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status SubscribeHealthAndArmingChecks(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::events::SubscribeHealthAndArmingChecksRequest* /* request */,
        grpc::ServerWriter<rpc::events::HealthAndArmingChecksResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::Events::HealthAndArmingChecksHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_health_and_arming_checks(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const mavsdk::Events::HealthAndArmingCheckReport health_and_arming_checks) {
                    rpc::events::HealthAndArmingChecksResponse rpc_response;

                    rpc_response.set_allocated_report(
                        translateToRpcHealthAndArmingCheckReport(health_and_arming_checks)
                            .release());

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_health_and_arming_checks(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status GetHealthAndArmingChecksReport(
        grpc::ServerContext* /* context */,
        const rpc::events::GetHealthAndArmingChecksReportRequest* /* request */,
        rpc::events::GetHealthAndArmingChecksReportResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                auto result = mavsdk::Events::Result::NoSystem;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->get_health_and_arming_checks_report();

        if (response != nullptr) {
            fillResponseWithResult(response, result.first);

            response->set_allocated_report(
                translateToRpcHealthAndArmingCheckReport(result.second).release());
        }

        return grpc::Status::OK;
    }

    void stop()
    {
        _stopped.store(true);
        std::lock_guard<std::mutex> lock(_stream_stop_mutex);
        for (auto& prom : _stream_stop_promises) {
            if (auto handle = prom.lock()) {
                handle->set_value();
            }
        }
    }

private:
    void register_stream_stop_promise(std::weak_ptr<std::promise<void>> prom)
    {
        // If we have already stopped, set promise immediately and don't add it to list.
        if (_stopped.load()) {
            if (auto handle = prom.lock()) {
                handle->set_value();
            }
        } else {
            std::lock_guard<std::mutex> lock(_stream_stop_mutex);
            _stream_stop_promises.push_back(prom);
        }
    }

    void unregister_stream_stop_promise(std::shared_ptr<std::promise<void>> prom)
    {
        std::lock_guard<std::mutex> lock(_stream_stop_mutex);
        for (auto it = _stream_stop_promises.begin(); it != _stream_stop_promises.end();
             /* ++it */) {
            if (it->lock() == prom) {
                it = _stream_stop_promises.erase(it);
            } else {
                ++it;
            }
        }
    }

    LazyPlugin& _lazy_plugin;

    std::atomic<bool> _stopped{false};
    std::mutex _stream_stop_mutex{};
    std::vector<std::weak_ptr<std::promise<void>>> _stream_stop_promises{};
};

} // namespace mavsdk_server
} // namespace mavsdk