// WARNING: THIS FILE IS AUTOGENERATED! As such, it should not be edited.
// Edits need to be made to the proto files
// (see
// https://github.com/mavlink/MAVSDK-Proto/blob/master/protos/component_metadata_server/component_metadata_server.proto)

#include "component_metadata_server/component_metadata_server.grpc.pb.h"
#include "plugins/component_metadata_server/component_metadata_server.h"

#include "mavsdk.h"

#include "lazy_server_plugin.h"

#include "log.h"
#include <atomic>
#include <cmath>
#include <future>
#include <limits>
#include <memory>
#include <mutex>
#include <sstream>
#include <vector>

namespace mavsdk {
namespace mavsdk_server {

template<
    typename ComponentMetadataServer = ComponentMetadataServer,
    typename LazyServerPlugin = LazyServerPlugin<ComponentMetadataServer>>

class ComponentMetadataServerServiceImpl final
    : public rpc::component_metadata_server::ComponentMetadataServerService::Service {
public:
    ComponentMetadataServerServiceImpl(LazyServerPlugin& lazy_plugin) : _lazy_plugin(lazy_plugin) {}

    static rpc::component_metadata_server::MetadataType
    translateToRpcMetadataType(const mavsdk::ComponentMetadataServer::MetadataType& metadata_type)
    {
        switch (metadata_type) {
            default:
                LogErr() << "Unknown metadata_type enum value: " << static_cast<int>(metadata_type);
            // FALLTHROUGH
            case mavsdk::ComponentMetadataServer::MetadataType::Parameter:
                return rpc::component_metadata_server::METADATA_TYPE_PARAMETER;
            case mavsdk::ComponentMetadataServer::MetadataType::Events:
                return rpc::component_metadata_server::METADATA_TYPE_EVENTS;
            case mavsdk::ComponentMetadataServer::MetadataType::Actuators:
                return rpc::component_metadata_server::METADATA_TYPE_ACTUATORS;
        }
    }

    static mavsdk::ComponentMetadataServer::MetadataType
    translateFromRpcMetadataType(const rpc::component_metadata_server::MetadataType metadata_type)
    {
        switch (metadata_type) {
            default:
                LogErr() << "Unknown metadata_type enum value: " << static_cast<int>(metadata_type);
            // FALLTHROUGH
            case rpc::component_metadata_server::METADATA_TYPE_PARAMETER:
                return mavsdk::ComponentMetadataServer::MetadataType::Parameter;
            case rpc::component_metadata_server::METADATA_TYPE_EVENTS:
                return mavsdk::ComponentMetadataServer::MetadataType::Events;
            case rpc::component_metadata_server::METADATA_TYPE_ACTUATORS:
                return mavsdk::ComponentMetadataServer::MetadataType::Actuators;
        }
    }

    static std::unique_ptr<rpc::component_metadata_server::Metadata>
    translateToRpcMetadata(const mavsdk::ComponentMetadataServer::Metadata& metadata)
    {
        auto rpc_obj = std::make_unique<rpc::component_metadata_server::Metadata>();

        rpc_obj->set_type(translateToRpcMetadataType(metadata.type));

        rpc_obj->set_json_metadata(metadata.json_metadata);

        return rpc_obj;
    }

    static mavsdk::ComponentMetadataServer::Metadata
    translateFromRpcMetadata(const rpc::component_metadata_server::Metadata& metadata)
    {
        mavsdk::ComponentMetadataServer::Metadata obj;

        obj.type = translateFromRpcMetadataType(metadata.type());

        obj.json_metadata = metadata.json_metadata();

        return obj;
    }

    grpc::Status SetMetadata(
        grpc::ServerContext* /* context */,
        const rpc::component_metadata_server::SetMetadataRequest* request,
        rpc::component_metadata_server::SetMetadataResponse* /* response */) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "SetMetadata sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        std::vector<mavsdk::ComponentMetadataServer::Metadata> metadata_vec;
        for (const auto& elem : request->metadata()) {
            metadata_vec.push_back(translateFromRpcMetadata(elem));
        }

        _lazy_plugin.maybe_plugin()->set_metadata(metadata_vec);

        return grpc::Status::OK;
    }

    void stop()
    {
        _stopped.store(true);
        std::lock_guard<std::mutex> lock(_stream_stop_mutex);
        for (auto& prom : _stream_stop_promises) {
            if (auto handle = prom.lock()) {
                handle->set_value();
            }
        }
    }

private:
    void register_stream_stop_promise(std::weak_ptr<std::promise<void>> prom)
    {
        // If we have already stopped, set promise immediately and don't add it to list.
        if (_stopped.load()) {
            if (auto handle = prom.lock()) {
                handle->set_value();
            }
        } else {
            std::lock_guard<std::mutex> lock(_stream_stop_mutex);
            _stream_stop_promises.push_back(prom);
        }
    }

    void unregister_stream_stop_promise(std::shared_ptr<std::promise<void>> prom)
    {
        std::lock_guard<std::mutex> lock(_stream_stop_mutex);
        for (auto it = _stream_stop_promises.begin(); it != _stream_stop_promises.end();
             /* ++it */) {
            if (it->lock() == prom) {
                it = _stream_stop_promises.erase(it);
            } else {
                ++it;
            }
        }
    }

    LazyServerPlugin& _lazy_plugin;

    std::atomic<bool> _stopped{false};
    std::mutex _stream_stop_mutex{};
    std::vector<std::weak_ptr<std::promise<void>>> _stream_stop_promises{};
};

} // namespace mavsdk_server
} // namespace mavsdk