// WARNING: THIS FILE IS AUTOGENERATED! As such, it should not be edited.
// Edits need to be made to the proto files
// (see
// https://github.com/mavlink/MAVSDK-Proto/blob/master/protos/component_metadata/component_metadata.proto)

#include "component_metadata/component_metadata.grpc.pb.h"
#include "plugins/component_metadata/component_metadata.h"

#include "mavsdk.h"

#include "lazy_plugin.h"

#include "log.h"
#include <atomic>
#include <cmath>
#include <future>
#include <limits>
#include <memory>
#include <mutex>
#include <sstream>
#include <vector>

namespace mavsdk {
namespace mavsdk_server {

template<
    typename ComponentMetadata = ComponentMetadata,
    typename LazyPlugin = LazyPlugin<ComponentMetadata>>

class ComponentMetadataServiceImpl final
    : public rpc::component_metadata::ComponentMetadataService::Service {
public:
    ComponentMetadataServiceImpl(LazyPlugin& lazy_plugin) : _lazy_plugin(lazy_plugin) {}

    template<typename ResponseType>
    void
    fillResponseWithResult(ResponseType* response, mavsdk::ComponentMetadata::Result& result) const
    {
        auto rpc_result = translateToRpcResult(result);

        auto* rpc_component_metadata_result =
            new rpc::component_metadata::ComponentMetadataResult();
        rpc_component_metadata_result->set_result(rpc_result);
        std::stringstream ss;
        ss << result;
        rpc_component_metadata_result->set_result_str(ss.str());

        response->set_allocated_component_metadata_result(rpc_component_metadata_result);
    }

    static rpc::component_metadata::MetadataType
    translateToRpcMetadataType(const mavsdk::ComponentMetadata::MetadataType& metadata_type)
    {
        switch (metadata_type) {
            default:
                LogErr() << "Unknown metadata_type enum value: " << static_cast<int>(metadata_type);
            // FALLTHROUGH
            case mavsdk::ComponentMetadata::MetadataType::AllCompleted:
                return rpc::component_metadata::METADATA_TYPE_ALL_COMPLETED;
            case mavsdk::ComponentMetadata::MetadataType::Parameter:
                return rpc::component_metadata::METADATA_TYPE_PARAMETER;
            case mavsdk::ComponentMetadata::MetadataType::Events:
                return rpc::component_metadata::METADATA_TYPE_EVENTS;
            case mavsdk::ComponentMetadata::MetadataType::Actuators:
                return rpc::component_metadata::METADATA_TYPE_ACTUATORS;
        }
    }

    static mavsdk::ComponentMetadata::MetadataType
    translateFromRpcMetadataType(const rpc::component_metadata::MetadataType metadata_type)
    {
        switch (metadata_type) {
            default:
                LogErr() << "Unknown metadata_type enum value: " << static_cast<int>(metadata_type);
            // FALLTHROUGH
            case rpc::component_metadata::METADATA_TYPE_ALL_COMPLETED:
                return mavsdk::ComponentMetadata::MetadataType::AllCompleted;
            case rpc::component_metadata::METADATA_TYPE_PARAMETER:
                return mavsdk::ComponentMetadata::MetadataType::Parameter;
            case rpc::component_metadata::METADATA_TYPE_EVENTS:
                return mavsdk::ComponentMetadata::MetadataType::Events;
            case rpc::component_metadata::METADATA_TYPE_ACTUATORS:
                return mavsdk::ComponentMetadata::MetadataType::Actuators;
        }
    }

    static std::unique_ptr<rpc::component_metadata::MetadataData>
    translateToRpcMetadataData(const mavsdk::ComponentMetadata::MetadataData& metadata_data)
    {
        auto rpc_obj = std::make_unique<rpc::component_metadata::MetadataData>();

        rpc_obj->set_json_metadata(metadata_data.json_metadata);

        return rpc_obj;
    }

    static mavsdk::ComponentMetadata::MetadataData
    translateFromRpcMetadataData(const rpc::component_metadata::MetadataData& metadata_data)
    {
        mavsdk::ComponentMetadata::MetadataData obj;

        obj.json_metadata = metadata_data.json_metadata();

        return obj;
    }

    static rpc::component_metadata::ComponentMetadataResult::Result
    translateToRpcResult(const mavsdk::ComponentMetadata::Result& result)
    {
        switch (result) {
            default:
                LogErr() << "Unknown result enum value: " << static_cast<int>(result);
            // FALLTHROUGH
            case mavsdk::ComponentMetadata::Result::Success:
                return rpc::component_metadata::ComponentMetadataResult_Result_RESULT_SUCCESS;
            case mavsdk::ComponentMetadata::Result::NotAvailable:
                return rpc::component_metadata::ComponentMetadataResult_Result_RESULT_NOT_AVAILABLE;
            case mavsdk::ComponentMetadata::Result::ConnectionError:
                return rpc::component_metadata::
                    ComponentMetadataResult_Result_RESULT_CONNECTION_ERROR;
            case mavsdk::ComponentMetadata::Result::Unsupported:
                return rpc::component_metadata::ComponentMetadataResult_Result_RESULT_UNSUPPORTED;
            case mavsdk::ComponentMetadata::Result::Denied:
                return rpc::component_metadata::ComponentMetadataResult_Result_RESULT_DENIED;
            case mavsdk::ComponentMetadata::Result::Failed:
                return rpc::component_metadata::ComponentMetadataResult_Result_RESULT_FAILED;
            case mavsdk::ComponentMetadata::Result::Timeout:
                return rpc::component_metadata::ComponentMetadataResult_Result_RESULT_TIMEOUT;
            case mavsdk::ComponentMetadata::Result::NoSystem:
                return rpc::component_metadata::ComponentMetadataResult_Result_RESULT_NO_SYSTEM;
            case mavsdk::ComponentMetadata::Result::NotRequested:
                return rpc::component_metadata::ComponentMetadataResult_Result_RESULT_NOT_REQUESTED;
        }
    }

    static mavsdk::ComponentMetadata::Result
    translateFromRpcResult(const rpc::component_metadata::ComponentMetadataResult::Result result)
    {
        switch (result) {
            default:
                LogErr() << "Unknown result enum value: " << static_cast<int>(result);
            // FALLTHROUGH
            case rpc::component_metadata::ComponentMetadataResult_Result_RESULT_SUCCESS:
                return mavsdk::ComponentMetadata::Result::Success;
            case rpc::component_metadata::ComponentMetadataResult_Result_RESULT_NOT_AVAILABLE:
                return mavsdk::ComponentMetadata::Result::NotAvailable;
            case rpc::component_metadata::ComponentMetadataResult_Result_RESULT_CONNECTION_ERROR:
                return mavsdk::ComponentMetadata::Result::ConnectionError;
            case rpc::component_metadata::ComponentMetadataResult_Result_RESULT_UNSUPPORTED:
                return mavsdk::ComponentMetadata::Result::Unsupported;
            case rpc::component_metadata::ComponentMetadataResult_Result_RESULT_DENIED:
                return mavsdk::ComponentMetadata::Result::Denied;
            case rpc::component_metadata::ComponentMetadataResult_Result_RESULT_FAILED:
                return mavsdk::ComponentMetadata::Result::Failed;
            case rpc::component_metadata::ComponentMetadataResult_Result_RESULT_TIMEOUT:
                return mavsdk::ComponentMetadata::Result::Timeout;
            case rpc::component_metadata::ComponentMetadataResult_Result_RESULT_NO_SYSTEM:
                return mavsdk::ComponentMetadata::Result::NoSystem;
            case rpc::component_metadata::ComponentMetadataResult_Result_RESULT_NOT_REQUESTED:
                return mavsdk::ComponentMetadata::Result::NotRequested;
        }
    }

    static std::unique_ptr<rpc::component_metadata::MetadataUpdate>
    translateToRpcMetadataUpdate(const mavsdk::ComponentMetadata::MetadataUpdate& metadata_update)
    {
        auto rpc_obj = std::make_unique<rpc::component_metadata::MetadataUpdate>();

        rpc_obj->set_compid(metadata_update.compid);

        rpc_obj->set_type(translateToRpcMetadataType(metadata_update.type));

        rpc_obj->set_json_metadata(metadata_update.json_metadata);

        return rpc_obj;
    }

    static mavsdk::ComponentMetadata::MetadataUpdate
    translateFromRpcMetadataUpdate(const rpc::component_metadata::MetadataUpdate& metadata_update)
    {
        mavsdk::ComponentMetadata::MetadataUpdate obj;

        obj.compid = metadata_update.compid();

        obj.type = translateFromRpcMetadataType(metadata_update.type());

        obj.json_metadata = metadata_update.json_metadata();

        return obj;
    }

    grpc::Status RequestComponent(
        grpc::ServerContext* /* context */,
        const rpc::component_metadata::RequestComponentRequest* request,
        rpc::component_metadata::RequestComponentResponse* /* response */) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "RequestComponent sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        _lazy_plugin.maybe_plugin()->request_component(request->compid());

        return grpc::Status::OK;
    }

    grpc::Status RequestAutopilotComponent(
        grpc::ServerContext* /* context */,
        const rpc::component_metadata::RequestAutopilotComponentRequest* /* request */,
        rpc::component_metadata::RequestAutopilotComponentResponse* /* response */) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        _lazy_plugin.maybe_plugin()->request_autopilot_component();

        return grpc::Status::OK;
    }

    grpc::Status SubscribeMetadataAvailable(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::component_metadata::SubscribeMetadataAvailableRequest* /* request */,
        grpc::ServerWriter<rpc::component_metadata::MetadataAvailableResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::ComponentMetadata::MetadataAvailableHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_metadata_available(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const mavsdk::ComponentMetadata::MetadataUpdate metadata_available) {
                    rpc::component_metadata::MetadataAvailableResponse rpc_response;

                    rpc_response.set_allocated_data(
                        translateToRpcMetadataUpdate(metadata_available).release());

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_metadata_available(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status GetMetadata(
        grpc::ServerContext* /* context */,
        const rpc::component_metadata::GetMetadataRequest* request,
        rpc::component_metadata::GetMetadataResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                auto result = mavsdk::ComponentMetadata::Result::NoSystem;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "GetMetadata sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->get_metadata(
            request->compid(), translateFromRpcMetadataType(request->metadata_type()));

        if (response != nullptr) {
            fillResponseWithResult(response, result.first);

            response->set_allocated_response(translateToRpcMetadataData(result.second).release());
        }

        return grpc::Status::OK;
    }

    void stop()
    {
        _stopped.store(true);
        std::lock_guard<std::mutex> lock(_stream_stop_mutex);
        for (auto& prom : _stream_stop_promises) {
            if (auto handle = prom.lock()) {
                handle->set_value();
            }
        }
    }

private:
    void register_stream_stop_promise(std::weak_ptr<std::promise<void>> prom)
    {
        // If we have already stopped, set promise immediately and don't add it to list.
        if (_stopped.load()) {
            if (auto handle = prom.lock()) {
                handle->set_value();
            }
        } else {
            std::lock_guard<std::mutex> lock(_stream_stop_mutex);
            _stream_stop_promises.push_back(prom);
        }
    }

    void unregister_stream_stop_promise(std::shared_ptr<std::promise<void>> prom)
    {
        std::lock_guard<std::mutex> lock(_stream_stop_mutex);
        for (auto it = _stream_stop_promises.begin(); it != _stream_stop_promises.end();
             /* ++it */) {
            if (it->lock() == prom) {
                it = _stream_stop_promises.erase(it);
            } else {
                ++it;
            }
        }
    }

    LazyPlugin& _lazy_plugin;

    std::atomic<bool> _stopped{false};
    std::mutex _stream_stop_mutex{};
    std::vector<std::weak_ptr<std::promise<void>>> _stream_stop_promises{};
};

} // namespace mavsdk_server
} // namespace mavsdk