// WARNING: THIS FILE IS AUTOGENERATED! As such, it should not be edited.
// Edits need to be made to the proto files
// (see
// https://github.com/mavlink/MAVSDK-Proto/blob/master/protos/camera_server/camera_server.proto)

#include "camera_server/camera_server.grpc.pb.h"
#include "plugins/camera_server/camera_server.h"

#include "mavsdk.h"

#include "lazy_server_plugin.h"

#include "log.h"
#include <atomic>
#include <cmath>
#include <future>
#include <limits>
#include <memory>
#include <mutex>
#include <sstream>
#include <vector>

namespace mavsdk {
namespace mavsdk_server {

template<
    typename CameraServer = CameraServer,
    typename LazyServerPlugin = LazyServerPlugin<CameraServer>>

class CameraServerServiceImpl final : public rpc::camera_server::CameraServerService::Service {
public:
    CameraServerServiceImpl(LazyServerPlugin& lazy_plugin) : _lazy_plugin(lazy_plugin) {}

    template<typename ResponseType>
    void fillResponseWithResult(ResponseType* response, mavsdk::CameraServer::Result& result) const
    {
        auto rpc_result = translateToRpcResult(result);

        auto* rpc_camera_server_result = new rpc::camera_server::CameraServerResult();
        rpc_camera_server_result->set_result(rpc_result);
        std::stringstream ss;
        ss << result;
        rpc_camera_server_result->set_result_str(ss.str());

        response->set_allocated_camera_server_result(rpc_camera_server_result);
    }

    static rpc::camera_server::CameraFeedback
    translateToRpcCameraFeedback(const mavsdk::CameraServer::CameraFeedback& camera_feedback)
    {
        switch (camera_feedback) {
            default:
                LogErr() << "Unknown camera_feedback enum value: "
                         << static_cast<int>(camera_feedback);
            // FALLTHROUGH
            case mavsdk::CameraServer::CameraFeedback::Unknown:
                return rpc::camera_server::CAMERA_FEEDBACK_UNKNOWN;
            case mavsdk::CameraServer::CameraFeedback::Ok:
                return rpc::camera_server::CAMERA_FEEDBACK_OK;
            case mavsdk::CameraServer::CameraFeedback::Busy:
                return rpc::camera_server::CAMERA_FEEDBACK_BUSY;
            case mavsdk::CameraServer::CameraFeedback::Failed:
                return rpc::camera_server::CAMERA_FEEDBACK_FAILED;
        }
    }

    static mavsdk::CameraServer::CameraFeedback
    translateFromRpcCameraFeedback(const rpc::camera_server::CameraFeedback camera_feedback)
    {
        switch (camera_feedback) {
            default:
                LogErr() << "Unknown camera_feedback enum value: "
                         << static_cast<int>(camera_feedback);
            // FALLTHROUGH
            case rpc::camera_server::CAMERA_FEEDBACK_UNKNOWN:
                return mavsdk::CameraServer::CameraFeedback::Unknown;
            case rpc::camera_server::CAMERA_FEEDBACK_OK:
                return mavsdk::CameraServer::CameraFeedback::Ok;
            case rpc::camera_server::CAMERA_FEEDBACK_BUSY:
                return mavsdk::CameraServer::CameraFeedback::Busy;
            case rpc::camera_server::CAMERA_FEEDBACK_FAILED:
                return mavsdk::CameraServer::CameraFeedback::Failed;
        }
    }

    static rpc::camera_server::Mode translateToRpcMode(const mavsdk::CameraServer::Mode& mode)
    {
        switch (mode) {
            default:
                LogErr() << "Unknown mode enum value: " << static_cast<int>(mode);
            // FALLTHROUGH
            case mavsdk::CameraServer::Mode::Unknown:
                return rpc::camera_server::MODE_UNKNOWN;
            case mavsdk::CameraServer::Mode::Photo:
                return rpc::camera_server::MODE_PHOTO;
            case mavsdk::CameraServer::Mode::Video:
                return rpc::camera_server::MODE_VIDEO;
        }
    }

    static mavsdk::CameraServer::Mode translateFromRpcMode(const rpc::camera_server::Mode mode)
    {
        switch (mode) {
            default:
                LogErr() << "Unknown mode enum value: " << static_cast<int>(mode);
            // FALLTHROUGH
            case rpc::camera_server::MODE_UNKNOWN:
                return mavsdk::CameraServer::Mode::Unknown;
            case rpc::camera_server::MODE_PHOTO:
                return mavsdk::CameraServer::Mode::Photo;
            case rpc::camera_server::MODE_VIDEO:
                return mavsdk::CameraServer::Mode::Video;
        }
    }

    static std::unique_ptr<rpc::camera_server::Information>
    translateToRpcInformation(const mavsdk::CameraServer::Information& information)
    {
        auto rpc_obj = std::make_unique<rpc::camera_server::Information>();

        rpc_obj->set_vendor_name(information.vendor_name);

        rpc_obj->set_model_name(information.model_name);

        rpc_obj->set_firmware_version(information.firmware_version);

        rpc_obj->set_focal_length_mm(information.focal_length_mm);

        rpc_obj->set_horizontal_sensor_size_mm(information.horizontal_sensor_size_mm);

        rpc_obj->set_vertical_sensor_size_mm(information.vertical_sensor_size_mm);

        rpc_obj->set_horizontal_resolution_px(information.horizontal_resolution_px);

        rpc_obj->set_vertical_resolution_px(information.vertical_resolution_px);

        rpc_obj->set_lens_id(information.lens_id);

        rpc_obj->set_definition_file_version(information.definition_file_version);

        rpc_obj->set_definition_file_uri(information.definition_file_uri);

        rpc_obj->set_image_in_video_mode_supported(information.image_in_video_mode_supported);

        rpc_obj->set_video_in_image_mode_supported(information.video_in_image_mode_supported);

        return rpc_obj;
    }

    static mavsdk::CameraServer::Information
    translateFromRpcInformation(const rpc::camera_server::Information& information)
    {
        mavsdk::CameraServer::Information obj;

        obj.vendor_name = information.vendor_name();

        obj.model_name = information.model_name();

        obj.firmware_version = information.firmware_version();

        obj.focal_length_mm = information.focal_length_mm();

        obj.horizontal_sensor_size_mm = information.horizontal_sensor_size_mm();

        obj.vertical_sensor_size_mm = information.vertical_sensor_size_mm();

        obj.horizontal_resolution_px = information.horizontal_resolution_px();

        obj.vertical_resolution_px = information.vertical_resolution_px();

        obj.lens_id = information.lens_id();

        obj.definition_file_version = information.definition_file_version();

        obj.definition_file_uri = information.definition_file_uri();

        obj.image_in_video_mode_supported = information.image_in_video_mode_supported();

        obj.video_in_image_mode_supported = information.video_in_image_mode_supported();

        return obj;
    }

    static std::unique_ptr<rpc::camera_server::VideoStreaming>
    translateToRpcVideoStreaming(const mavsdk::CameraServer::VideoStreaming& video_streaming)
    {
        auto rpc_obj = std::make_unique<rpc::camera_server::VideoStreaming>();

        rpc_obj->set_has_rtsp_server(video_streaming.has_rtsp_server);

        rpc_obj->set_rtsp_uri(video_streaming.rtsp_uri);

        return rpc_obj;
    }

    static mavsdk::CameraServer::VideoStreaming
    translateFromRpcVideoStreaming(const rpc::camera_server::VideoStreaming& video_streaming)
    {
        mavsdk::CameraServer::VideoStreaming obj;

        obj.has_rtsp_server = video_streaming.has_rtsp_server();

        obj.rtsp_uri = video_streaming.rtsp_uri();

        return obj;
    }

    static std::unique_ptr<rpc::camera_server::Position>
    translateToRpcPosition(const mavsdk::CameraServer::Position& position)
    {
        auto rpc_obj = std::make_unique<rpc::camera_server::Position>();

        rpc_obj->set_latitude_deg(position.latitude_deg);

        rpc_obj->set_longitude_deg(position.longitude_deg);

        rpc_obj->set_absolute_altitude_m(position.absolute_altitude_m);

        rpc_obj->set_relative_altitude_m(position.relative_altitude_m);

        return rpc_obj;
    }

    static mavsdk::CameraServer::Position
    translateFromRpcPosition(const rpc::camera_server::Position& position)
    {
        mavsdk::CameraServer::Position obj;

        obj.latitude_deg = position.latitude_deg();

        obj.longitude_deg = position.longitude_deg();

        obj.absolute_altitude_m = position.absolute_altitude_m();

        obj.relative_altitude_m = position.relative_altitude_m();

        return obj;
    }

    static std::unique_ptr<rpc::camera_server::Quaternion>
    translateToRpcQuaternion(const mavsdk::CameraServer::Quaternion& quaternion)
    {
        auto rpc_obj = std::make_unique<rpc::camera_server::Quaternion>();

        rpc_obj->set_w(quaternion.w);

        rpc_obj->set_x(quaternion.x);

        rpc_obj->set_y(quaternion.y);

        rpc_obj->set_z(quaternion.z);

        return rpc_obj;
    }

    static mavsdk::CameraServer::Quaternion
    translateFromRpcQuaternion(const rpc::camera_server::Quaternion& quaternion)
    {
        mavsdk::CameraServer::Quaternion obj;

        obj.w = quaternion.w();

        obj.x = quaternion.x();

        obj.y = quaternion.y();

        obj.z = quaternion.z();

        return obj;
    }

    static std::unique_ptr<rpc::camera_server::CaptureInfo>
    translateToRpcCaptureInfo(const mavsdk::CameraServer::CaptureInfo& capture_info)
    {
        auto rpc_obj = std::make_unique<rpc::camera_server::CaptureInfo>();

        rpc_obj->set_allocated_position(translateToRpcPosition(capture_info.position).release());

        rpc_obj->set_allocated_attitude_quaternion(
            translateToRpcQuaternion(capture_info.attitude_quaternion).release());

        rpc_obj->set_time_utc_us(capture_info.time_utc_us);

        rpc_obj->set_is_success(capture_info.is_success);

        rpc_obj->set_index(capture_info.index);

        rpc_obj->set_file_url(capture_info.file_url);

        return rpc_obj;
    }

    static mavsdk::CameraServer::CaptureInfo
    translateFromRpcCaptureInfo(const rpc::camera_server::CaptureInfo& capture_info)
    {
        mavsdk::CameraServer::CaptureInfo obj;

        obj.position = translateFromRpcPosition(capture_info.position());

        obj.attitude_quaternion = translateFromRpcQuaternion(capture_info.attitude_quaternion());

        obj.time_utc_us = capture_info.time_utc_us();

        obj.is_success = capture_info.is_success();

        obj.index = capture_info.index();

        obj.file_url = capture_info.file_url();

        return obj;
    }

    static rpc::camera_server::CameraServerResult::Result
    translateToRpcResult(const mavsdk::CameraServer::Result& result)
    {
        switch (result) {
            default:
                LogErr() << "Unknown result enum value: " << static_cast<int>(result);
            // FALLTHROUGH
            case mavsdk::CameraServer::Result::Unknown:
                return rpc::camera_server::CameraServerResult_Result_RESULT_UNKNOWN;
            case mavsdk::CameraServer::Result::Success:
                return rpc::camera_server::CameraServerResult_Result_RESULT_SUCCESS;
            case mavsdk::CameraServer::Result::InProgress:
                return rpc::camera_server::CameraServerResult_Result_RESULT_IN_PROGRESS;
            case mavsdk::CameraServer::Result::Busy:
                return rpc::camera_server::CameraServerResult_Result_RESULT_BUSY;
            case mavsdk::CameraServer::Result::Denied:
                return rpc::camera_server::CameraServerResult_Result_RESULT_DENIED;
            case mavsdk::CameraServer::Result::Error:
                return rpc::camera_server::CameraServerResult_Result_RESULT_ERROR;
            case mavsdk::CameraServer::Result::Timeout:
                return rpc::camera_server::CameraServerResult_Result_RESULT_TIMEOUT;
            case mavsdk::CameraServer::Result::WrongArgument:
                return rpc::camera_server::CameraServerResult_Result_RESULT_WRONG_ARGUMENT;
            case mavsdk::CameraServer::Result::NoSystem:
                return rpc::camera_server::CameraServerResult_Result_RESULT_NO_SYSTEM;
        }
    }

    static mavsdk::CameraServer::Result
    translateFromRpcResult(const rpc::camera_server::CameraServerResult::Result result)
    {
        switch (result) {
            default:
                LogErr() << "Unknown result enum value: " << static_cast<int>(result);
            // FALLTHROUGH
            case rpc::camera_server::CameraServerResult_Result_RESULT_UNKNOWN:
                return mavsdk::CameraServer::Result::Unknown;
            case rpc::camera_server::CameraServerResult_Result_RESULT_SUCCESS:
                return mavsdk::CameraServer::Result::Success;
            case rpc::camera_server::CameraServerResult_Result_RESULT_IN_PROGRESS:
                return mavsdk::CameraServer::Result::InProgress;
            case rpc::camera_server::CameraServerResult_Result_RESULT_BUSY:
                return mavsdk::CameraServer::Result::Busy;
            case rpc::camera_server::CameraServerResult_Result_RESULT_DENIED:
                return mavsdk::CameraServer::Result::Denied;
            case rpc::camera_server::CameraServerResult_Result_RESULT_ERROR:
                return mavsdk::CameraServer::Result::Error;
            case rpc::camera_server::CameraServerResult_Result_RESULT_TIMEOUT:
                return mavsdk::CameraServer::Result::Timeout;
            case rpc::camera_server::CameraServerResult_Result_RESULT_WRONG_ARGUMENT:
                return mavsdk::CameraServer::Result::WrongArgument;
            case rpc::camera_server::CameraServerResult_Result_RESULT_NO_SYSTEM:
                return mavsdk::CameraServer::Result::NoSystem;
        }
    }

    static rpc::camera_server::StorageInformation::StorageStatus translateToRpcStorageStatus(
        const mavsdk::CameraServer::StorageInformation::StorageStatus& storage_status)
    {
        switch (storage_status) {
            default:
                LogErr() << "Unknown storage_status enum value: "
                         << static_cast<int>(storage_status);
            // FALLTHROUGH
            case mavsdk::CameraServer::StorageInformation::StorageStatus::NotAvailable:
                return rpc::camera_server::
                    StorageInformation_StorageStatus_STORAGE_STATUS_NOT_AVAILABLE;
            case mavsdk::CameraServer::StorageInformation::StorageStatus::Unformatted:
                return rpc::camera_server::
                    StorageInformation_StorageStatus_STORAGE_STATUS_UNFORMATTED;
            case mavsdk::CameraServer::StorageInformation::StorageStatus::Formatted:
                return rpc::camera_server::
                    StorageInformation_StorageStatus_STORAGE_STATUS_FORMATTED;
            case mavsdk::CameraServer::StorageInformation::StorageStatus::NotSupported:
                return rpc::camera_server::
                    StorageInformation_StorageStatus_STORAGE_STATUS_NOT_SUPPORTED;
        }
    }

    static mavsdk::CameraServer::StorageInformation::StorageStatus translateFromRpcStorageStatus(
        const rpc::camera_server::StorageInformation::StorageStatus storage_status)
    {
        switch (storage_status) {
            default:
                LogErr() << "Unknown storage_status enum value: "
                         << static_cast<int>(storage_status);
            // FALLTHROUGH
            case rpc::camera_server::StorageInformation_StorageStatus_STORAGE_STATUS_NOT_AVAILABLE:
                return mavsdk::CameraServer::StorageInformation::StorageStatus::NotAvailable;
            case rpc::camera_server::StorageInformation_StorageStatus_STORAGE_STATUS_UNFORMATTED:
                return mavsdk::CameraServer::StorageInformation::StorageStatus::Unformatted;
            case rpc::camera_server::StorageInformation_StorageStatus_STORAGE_STATUS_FORMATTED:
                return mavsdk::CameraServer::StorageInformation::StorageStatus::Formatted;
            case rpc::camera_server::StorageInformation_StorageStatus_STORAGE_STATUS_NOT_SUPPORTED:
                return mavsdk::CameraServer::StorageInformation::StorageStatus::NotSupported;
        }
    }

    static rpc::camera_server::StorageInformation::StorageType translateToRpcStorageType(
        const mavsdk::CameraServer::StorageInformation::StorageType& storage_type)
    {
        switch (storage_type) {
            default:
                LogErr() << "Unknown storage_type enum value: " << static_cast<int>(storage_type);
            // FALLTHROUGH
            case mavsdk::CameraServer::StorageInformation::StorageType::Unknown:
                return rpc::camera_server::StorageInformation_StorageType_STORAGE_TYPE_UNKNOWN;
            case mavsdk::CameraServer::StorageInformation::StorageType::UsbStick:
                return rpc::camera_server::StorageInformation_StorageType_STORAGE_TYPE_USB_STICK;
            case mavsdk::CameraServer::StorageInformation::StorageType::Sd:
                return rpc::camera_server::StorageInformation_StorageType_STORAGE_TYPE_SD;
            case mavsdk::CameraServer::StorageInformation::StorageType::Microsd:
                return rpc::camera_server::StorageInformation_StorageType_STORAGE_TYPE_MICROSD;
            case mavsdk::CameraServer::StorageInformation::StorageType::Hd:
                return rpc::camera_server::StorageInformation_StorageType_STORAGE_TYPE_HD;
            case mavsdk::CameraServer::StorageInformation::StorageType::Other:
                return rpc::camera_server::StorageInformation_StorageType_STORAGE_TYPE_OTHER;
        }
    }

    static mavsdk::CameraServer::StorageInformation::StorageType translateFromRpcStorageType(
        const rpc::camera_server::StorageInformation::StorageType storage_type)
    {
        switch (storage_type) {
            default:
                LogErr() << "Unknown storage_type enum value: " << static_cast<int>(storage_type);
            // FALLTHROUGH
            case rpc::camera_server::StorageInformation_StorageType_STORAGE_TYPE_UNKNOWN:
                return mavsdk::CameraServer::StorageInformation::StorageType::Unknown;
            case rpc::camera_server::StorageInformation_StorageType_STORAGE_TYPE_USB_STICK:
                return mavsdk::CameraServer::StorageInformation::StorageType::UsbStick;
            case rpc::camera_server::StorageInformation_StorageType_STORAGE_TYPE_SD:
                return mavsdk::CameraServer::StorageInformation::StorageType::Sd;
            case rpc::camera_server::StorageInformation_StorageType_STORAGE_TYPE_MICROSD:
                return mavsdk::CameraServer::StorageInformation::StorageType::Microsd;
            case rpc::camera_server::StorageInformation_StorageType_STORAGE_TYPE_HD:
                return mavsdk::CameraServer::StorageInformation::StorageType::Hd;
            case rpc::camera_server::StorageInformation_StorageType_STORAGE_TYPE_OTHER:
                return mavsdk::CameraServer::StorageInformation::StorageType::Other;
        }
    }

    static std::unique_ptr<rpc::camera_server::StorageInformation> translateToRpcStorageInformation(
        const mavsdk::CameraServer::StorageInformation& storage_information)
    {
        auto rpc_obj = std::make_unique<rpc::camera_server::StorageInformation>();

        rpc_obj->set_used_storage_mib(storage_information.used_storage_mib);

        rpc_obj->set_available_storage_mib(storage_information.available_storage_mib);

        rpc_obj->set_total_storage_mib(storage_information.total_storage_mib);

        rpc_obj->set_storage_status(
            translateToRpcStorageStatus(storage_information.storage_status));

        rpc_obj->set_storage_id(storage_information.storage_id);

        rpc_obj->set_storage_type(translateToRpcStorageType(storage_information.storage_type));

        rpc_obj->set_read_speed_mib_s(storage_information.read_speed_mib_s);

        rpc_obj->set_write_speed_mib_s(storage_information.write_speed_mib_s);

        return rpc_obj;
    }

    static mavsdk::CameraServer::StorageInformation translateFromRpcStorageInformation(
        const rpc::camera_server::StorageInformation& storage_information)
    {
        mavsdk::CameraServer::StorageInformation obj;

        obj.used_storage_mib = storage_information.used_storage_mib();

        obj.available_storage_mib = storage_information.available_storage_mib();

        obj.total_storage_mib = storage_information.total_storage_mib();

        obj.storage_status = translateFromRpcStorageStatus(storage_information.storage_status());

        obj.storage_id = storage_information.storage_id();

        obj.storage_type = translateFromRpcStorageType(storage_information.storage_type());

        obj.read_speed_mib_s = storage_information.read_speed_mib_s();

        obj.write_speed_mib_s = storage_information.write_speed_mib_s();

        return obj;
    }

    static rpc::camera_server::CaptureStatus::ImageStatus
    translateToRpcImageStatus(const mavsdk::CameraServer::CaptureStatus::ImageStatus& image_status)
    {
        switch (image_status) {
            default:
                LogErr() << "Unknown image_status enum value: " << static_cast<int>(image_status);
            // FALLTHROUGH
            case mavsdk::CameraServer::CaptureStatus::ImageStatus::Idle:
                return rpc::camera_server::CaptureStatus_ImageStatus_IMAGE_STATUS_IDLE;
            case mavsdk::CameraServer::CaptureStatus::ImageStatus::CaptureInProgress:
                return rpc::camera_server::
                    CaptureStatus_ImageStatus_IMAGE_STATUS_CAPTURE_IN_PROGRESS;
            case mavsdk::CameraServer::CaptureStatus::ImageStatus::IntervalIdle:
                return rpc::camera_server::CaptureStatus_ImageStatus_IMAGE_STATUS_INTERVAL_IDLE;
            case mavsdk::CameraServer::CaptureStatus::ImageStatus::IntervalInProgress:
                return rpc::camera_server::
                    CaptureStatus_ImageStatus_IMAGE_STATUS_INTERVAL_IN_PROGRESS;
        }
    }

    static mavsdk::CameraServer::CaptureStatus::ImageStatus
    translateFromRpcImageStatus(const rpc::camera_server::CaptureStatus::ImageStatus image_status)
    {
        switch (image_status) {
            default:
                LogErr() << "Unknown image_status enum value: " << static_cast<int>(image_status);
            // FALLTHROUGH
            case rpc::camera_server::CaptureStatus_ImageStatus_IMAGE_STATUS_IDLE:
                return mavsdk::CameraServer::CaptureStatus::ImageStatus::Idle;
            case rpc::camera_server::CaptureStatus_ImageStatus_IMAGE_STATUS_CAPTURE_IN_PROGRESS:
                return mavsdk::CameraServer::CaptureStatus::ImageStatus::CaptureInProgress;
            case rpc::camera_server::CaptureStatus_ImageStatus_IMAGE_STATUS_INTERVAL_IDLE:
                return mavsdk::CameraServer::CaptureStatus::ImageStatus::IntervalIdle;
            case rpc::camera_server::CaptureStatus_ImageStatus_IMAGE_STATUS_INTERVAL_IN_PROGRESS:
                return mavsdk::CameraServer::CaptureStatus::ImageStatus::IntervalInProgress;
        }
    }

    static rpc::camera_server::CaptureStatus::VideoStatus
    translateToRpcVideoStatus(const mavsdk::CameraServer::CaptureStatus::VideoStatus& video_status)
    {
        switch (video_status) {
            default:
                LogErr() << "Unknown video_status enum value: " << static_cast<int>(video_status);
            // FALLTHROUGH
            case mavsdk::CameraServer::CaptureStatus::VideoStatus::Idle:
                return rpc::camera_server::CaptureStatus_VideoStatus_VIDEO_STATUS_IDLE;
            case mavsdk::CameraServer::CaptureStatus::VideoStatus::CaptureInProgress:
                return rpc::camera_server::
                    CaptureStatus_VideoStatus_VIDEO_STATUS_CAPTURE_IN_PROGRESS;
        }
    }

    static mavsdk::CameraServer::CaptureStatus::VideoStatus
    translateFromRpcVideoStatus(const rpc::camera_server::CaptureStatus::VideoStatus video_status)
    {
        switch (video_status) {
            default:
                LogErr() << "Unknown video_status enum value: " << static_cast<int>(video_status);
            // FALLTHROUGH
            case rpc::camera_server::CaptureStatus_VideoStatus_VIDEO_STATUS_IDLE:
                return mavsdk::CameraServer::CaptureStatus::VideoStatus::Idle;
            case rpc::camera_server::CaptureStatus_VideoStatus_VIDEO_STATUS_CAPTURE_IN_PROGRESS:
                return mavsdk::CameraServer::CaptureStatus::VideoStatus::CaptureInProgress;
        }
    }

    static std::unique_ptr<rpc::camera_server::CaptureStatus>
    translateToRpcCaptureStatus(const mavsdk::CameraServer::CaptureStatus& capture_status)
    {
        auto rpc_obj = std::make_unique<rpc::camera_server::CaptureStatus>();

        rpc_obj->set_image_interval_s(capture_status.image_interval_s);

        rpc_obj->set_recording_time_s(capture_status.recording_time_s);

        rpc_obj->set_available_capacity_mib(capture_status.available_capacity_mib);

        rpc_obj->set_image_status(translateToRpcImageStatus(capture_status.image_status));

        rpc_obj->set_video_status(translateToRpcVideoStatus(capture_status.video_status));

        rpc_obj->set_image_count(capture_status.image_count);

        return rpc_obj;
    }

    static mavsdk::CameraServer::CaptureStatus
    translateFromRpcCaptureStatus(const rpc::camera_server::CaptureStatus& capture_status)
    {
        mavsdk::CameraServer::CaptureStatus obj;

        obj.image_interval_s = capture_status.image_interval_s();

        obj.recording_time_s = capture_status.recording_time_s();

        obj.available_capacity_mib = capture_status.available_capacity_mib();

        obj.image_status = translateFromRpcImageStatus(capture_status.image_status());

        obj.video_status = translateFromRpcVideoStatus(capture_status.video_status());

        obj.image_count = capture_status.image_count();

        return obj;
    }

    static std::unique_ptr<rpc::camera_server::TrackPoint>
    translateToRpcTrackPoint(const mavsdk::CameraServer::TrackPoint& track_point)
    {
        auto rpc_obj = std::make_unique<rpc::camera_server::TrackPoint>();

        rpc_obj->set_point_x(track_point.point_x);

        rpc_obj->set_point_y(track_point.point_y);

        rpc_obj->set_radius(track_point.radius);

        return rpc_obj;
    }

    static mavsdk::CameraServer::TrackPoint
    translateFromRpcTrackPoint(const rpc::camera_server::TrackPoint& track_point)
    {
        mavsdk::CameraServer::TrackPoint obj;

        obj.point_x = track_point.point_x();

        obj.point_y = track_point.point_y();

        obj.radius = track_point.radius();

        return obj;
    }

    static std::unique_ptr<rpc::camera_server::TrackRectangle>
    translateToRpcTrackRectangle(const mavsdk::CameraServer::TrackRectangle& track_rectangle)
    {
        auto rpc_obj = std::make_unique<rpc::camera_server::TrackRectangle>();

        rpc_obj->set_top_left_corner_x(track_rectangle.top_left_corner_x);

        rpc_obj->set_top_left_corner_y(track_rectangle.top_left_corner_y);

        rpc_obj->set_bottom_right_corner_x(track_rectangle.bottom_right_corner_x);

        rpc_obj->set_bottom_right_corner_y(track_rectangle.bottom_right_corner_y);

        return rpc_obj;
    }

    static mavsdk::CameraServer::TrackRectangle
    translateFromRpcTrackRectangle(const rpc::camera_server::TrackRectangle& track_rectangle)
    {
        mavsdk::CameraServer::TrackRectangle obj;

        obj.top_left_corner_x = track_rectangle.top_left_corner_x();

        obj.top_left_corner_y = track_rectangle.top_left_corner_y();

        obj.bottom_right_corner_x = track_rectangle.bottom_right_corner_x();

        obj.bottom_right_corner_y = track_rectangle.bottom_right_corner_y();

        return obj;
    }

    grpc::Status SetInformation(
        grpc::ServerContext* /* context */,
        const rpc::camera_server::SetInformationRequest* request,
        rpc::camera_server::SetInformationResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                // For server plugins, this should never happen, they should always be
                // constructible.
                auto result = mavsdk::CameraServer::Result::Unknown;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "SetInformation sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->set_information(
            translateFromRpcInformation(request->information()));

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status SetVideoStreaming(
        grpc::ServerContext* /* context */,
        const rpc::camera_server::SetVideoStreamingRequest* request,
        rpc::camera_server::SetVideoStreamingResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                // For server plugins, this should never happen, they should always be
                // constructible.
                auto result = mavsdk::CameraServer::Result::Unknown;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "SetVideoStreaming sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->set_video_streaming(
            translateFromRpcVideoStreaming(request->video_streaming()));

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status SetInProgress(
        grpc::ServerContext* /* context */,
        const rpc::camera_server::SetInProgressRequest* request,
        rpc::camera_server::SetInProgressResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                // For server plugins, this should never happen, they should always be
                // constructible.
                auto result = mavsdk::CameraServer::Result::Unknown;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "SetInProgress sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->set_in_progress(request->in_progress());

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status SubscribeTakePhoto(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::camera_server::SubscribeTakePhotoRequest* /* request */,
        grpc::ServerWriter<rpc::camera_server::TakePhotoResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::CameraServer::TakePhotoHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_take_photo(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const int32_t take_photo) {
                    rpc::camera_server::TakePhotoResponse rpc_response;

                    rpc_response.set_index(take_photo);

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_take_photo(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status RespondTakePhoto(
        grpc::ServerContext* /* context */,
        const rpc::camera_server::RespondTakePhotoRequest* request,
        rpc::camera_server::RespondTakePhotoResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                // For server plugins, this should never happen, they should always be
                // constructible.
                auto result = mavsdk::CameraServer::Result::Unknown;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "RespondTakePhoto sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->respond_take_photo(
            translateFromRpcCameraFeedback(request->take_photo_feedback()),
            translateFromRpcCaptureInfo(request->capture_info()));

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status SubscribeStartVideo(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::camera_server::SubscribeStartVideoRequest* /* request */,
        grpc::ServerWriter<rpc::camera_server::StartVideoResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::CameraServer::StartVideoHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_start_video(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const int32_t start_video) {
                    rpc::camera_server::StartVideoResponse rpc_response;

                    rpc_response.set_stream_id(start_video);

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_start_video(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status RespondStartVideo(
        grpc::ServerContext* /* context */,
        const rpc::camera_server::RespondStartVideoRequest* request,
        rpc::camera_server::RespondStartVideoResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                // For server plugins, this should never happen, they should always be
                // constructible.
                auto result = mavsdk::CameraServer::Result::Unknown;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "RespondStartVideo sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->respond_start_video(
            translateFromRpcCameraFeedback(request->start_video_feedback()));

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status SubscribeStopVideo(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::camera_server::SubscribeStopVideoRequest* /* request */,
        grpc::ServerWriter<rpc::camera_server::StopVideoResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::CameraServer::StopVideoHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_stop_video(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const int32_t stop_video) {
                    rpc::camera_server::StopVideoResponse rpc_response;

                    rpc_response.set_stream_id(stop_video);

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_stop_video(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status RespondStopVideo(
        grpc::ServerContext* /* context */,
        const rpc::camera_server::RespondStopVideoRequest* request,
        rpc::camera_server::RespondStopVideoResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                // For server plugins, this should never happen, they should always be
                // constructible.
                auto result = mavsdk::CameraServer::Result::Unknown;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "RespondStopVideo sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->respond_stop_video(
            translateFromRpcCameraFeedback(request->stop_video_feedback()));

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status SubscribeStartVideoStreaming(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::camera_server::SubscribeStartVideoStreamingRequest* /* request */,
        grpc::ServerWriter<rpc::camera_server::StartVideoStreamingResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::CameraServer::StartVideoStreamingHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_start_video_streaming(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const int32_t start_video_streaming) {
                    rpc::camera_server::StartVideoStreamingResponse rpc_response;

                    rpc_response.set_stream_id(start_video_streaming);

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_start_video_streaming(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status RespondStartVideoStreaming(
        grpc::ServerContext* /* context */,
        const rpc::camera_server::RespondStartVideoStreamingRequest* request,
        rpc::camera_server::RespondStartVideoStreamingResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                // For server plugins, this should never happen, they should always be
                // constructible.
                auto result = mavsdk::CameraServer::Result::Unknown;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "RespondStartVideoStreaming sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->respond_start_video_streaming(
            translateFromRpcCameraFeedback(request->start_video_streaming_feedback()));

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status SubscribeStopVideoStreaming(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::camera_server::SubscribeStopVideoStreamingRequest* /* request */,
        grpc::ServerWriter<rpc::camera_server::StopVideoStreamingResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::CameraServer::StopVideoStreamingHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_stop_video_streaming(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const int32_t stop_video_streaming) {
                    rpc::camera_server::StopVideoStreamingResponse rpc_response;

                    rpc_response.set_stream_id(stop_video_streaming);

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_stop_video_streaming(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status RespondStopVideoStreaming(
        grpc::ServerContext* /* context */,
        const rpc::camera_server::RespondStopVideoStreamingRequest* request,
        rpc::camera_server::RespondStopVideoStreamingResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                // For server plugins, this should never happen, they should always be
                // constructible.
                auto result = mavsdk::CameraServer::Result::Unknown;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "RespondStopVideoStreaming sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->respond_stop_video_streaming(
            translateFromRpcCameraFeedback(request->stop_video_streaming_feedback()));

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status SubscribeSetMode(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::camera_server::SubscribeSetModeRequest* /* request */,
        grpc::ServerWriter<rpc::camera_server::SetModeResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::CameraServer::SetModeHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_set_mode(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const mavsdk::CameraServer::Mode set_mode) {
                    rpc::camera_server::SetModeResponse rpc_response;

                    rpc_response.set_mode(translateToRpcMode(set_mode));

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_set_mode(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status RespondSetMode(
        grpc::ServerContext* /* context */,
        const rpc::camera_server::RespondSetModeRequest* request,
        rpc::camera_server::RespondSetModeResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                // For server plugins, this should never happen, they should always be
                // constructible.
                auto result = mavsdk::CameraServer::Result::Unknown;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "RespondSetMode sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->respond_set_mode(
            translateFromRpcCameraFeedback(request->set_mode_feedback()));

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status SubscribeStorageInformation(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::camera_server::SubscribeStorageInformationRequest* /* request */,
        grpc::ServerWriter<rpc::camera_server::StorageInformationResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::CameraServer::StorageInformationHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_storage_information(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const int32_t storage_information) {
                    rpc::camera_server::StorageInformationResponse rpc_response;

                    rpc_response.set_storage_id(storage_information);

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_storage_information(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status RespondStorageInformation(
        grpc::ServerContext* /* context */,
        const rpc::camera_server::RespondStorageInformationRequest* request,
        rpc::camera_server::RespondStorageInformationResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                // For server plugins, this should never happen, they should always be
                // constructible.
                auto result = mavsdk::CameraServer::Result::Unknown;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "RespondStorageInformation sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->respond_storage_information(
            translateFromRpcCameraFeedback(request->storage_information_feedback()),
            translateFromRpcStorageInformation(request->storage_information()));

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status SubscribeCaptureStatus(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::camera_server::SubscribeCaptureStatusRequest* /* request */,
        grpc::ServerWriter<rpc::camera_server::CaptureStatusResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::CameraServer::CaptureStatusHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_capture_status(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const int32_t capture_status) {
                    rpc::camera_server::CaptureStatusResponse rpc_response;

                    rpc_response.set_reserved(capture_status);

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_capture_status(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status RespondCaptureStatus(
        grpc::ServerContext* /* context */,
        const rpc::camera_server::RespondCaptureStatusRequest* request,
        rpc::camera_server::RespondCaptureStatusResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                // For server plugins, this should never happen, they should always be
                // constructible.
                auto result = mavsdk::CameraServer::Result::Unknown;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "RespondCaptureStatus sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->respond_capture_status(
            translateFromRpcCameraFeedback(request->capture_status_feedback()),
            translateFromRpcCaptureStatus(request->capture_status()));

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status SubscribeFormatStorage(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::camera_server::SubscribeFormatStorageRequest* /* request */,
        grpc::ServerWriter<rpc::camera_server::FormatStorageResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::CameraServer::FormatStorageHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_format_storage(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const int32_t format_storage) {
                    rpc::camera_server::FormatStorageResponse rpc_response;

                    rpc_response.set_storage_id(format_storage);

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_format_storage(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status RespondFormatStorage(
        grpc::ServerContext* /* context */,
        const rpc::camera_server::RespondFormatStorageRequest* request,
        rpc::camera_server::RespondFormatStorageResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                // For server plugins, this should never happen, they should always be
                // constructible.
                auto result = mavsdk::CameraServer::Result::Unknown;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "RespondFormatStorage sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->respond_format_storage(
            translateFromRpcCameraFeedback(request->format_storage_feedback()));

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status SubscribeResetSettings(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::camera_server::SubscribeResetSettingsRequest* /* request */,
        grpc::ServerWriter<rpc::camera_server::ResetSettingsResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::CameraServer::ResetSettingsHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_reset_settings(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const int32_t reset_settings) {
                    rpc::camera_server::ResetSettingsResponse rpc_response;

                    rpc_response.set_reserved(reset_settings);

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_reset_settings(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status RespondResetSettings(
        grpc::ServerContext* /* context */,
        const rpc::camera_server::RespondResetSettingsRequest* request,
        rpc::camera_server::RespondResetSettingsResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                // For server plugins, this should never happen, they should always be
                // constructible.
                auto result = mavsdk::CameraServer::Result::Unknown;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "RespondResetSettings sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->respond_reset_settings(
            translateFromRpcCameraFeedback(request->reset_settings_feedback()));

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status SubscribeZoomInStart(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::camera_server::SubscribeZoomInStartRequest* /* request */,
        grpc::ServerWriter<rpc::camera_server::ZoomInStartResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::CameraServer::ZoomInStartHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_zoom_in_start(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const int32_t zoom_in_start) {
                    rpc::camera_server::ZoomInStartResponse rpc_response;

                    rpc_response.set_reserved(zoom_in_start);

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_zoom_in_start(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status RespondZoomInStart(
        grpc::ServerContext* /* context */,
        const rpc::camera_server::RespondZoomInStartRequest* request,
        rpc::camera_server::RespondZoomInStartResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                // For server plugins, this should never happen, they should always be
                // constructible.
                auto result = mavsdk::CameraServer::Result::Unknown;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "RespondZoomInStart sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->respond_zoom_in_start(
            translateFromRpcCameraFeedback(request->zoom_in_start_feedback()));

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status SubscribeZoomOutStart(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::camera_server::SubscribeZoomOutStartRequest* /* request */,
        grpc::ServerWriter<rpc::camera_server::ZoomOutStartResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::CameraServer::ZoomOutStartHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_zoom_out_start(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const int32_t zoom_out_start) {
                    rpc::camera_server::ZoomOutStartResponse rpc_response;

                    rpc_response.set_reserved(zoom_out_start);

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_zoom_out_start(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status RespondZoomOutStart(
        grpc::ServerContext* /* context */,
        const rpc::camera_server::RespondZoomOutStartRequest* request,
        rpc::camera_server::RespondZoomOutStartResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                // For server plugins, this should never happen, they should always be
                // constructible.
                auto result = mavsdk::CameraServer::Result::Unknown;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "RespondZoomOutStart sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->respond_zoom_out_start(
            translateFromRpcCameraFeedback(request->zoom_out_start_feedback()));

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status SubscribeZoomStop(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::camera_server::SubscribeZoomStopRequest* /* request */,
        grpc::ServerWriter<rpc::camera_server::ZoomStopResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::CameraServer::ZoomStopHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_zoom_stop(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const int32_t zoom_stop) {
                    rpc::camera_server::ZoomStopResponse rpc_response;

                    rpc_response.set_reserved(zoom_stop);

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_zoom_stop(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status RespondZoomStop(
        grpc::ServerContext* /* context */,
        const rpc::camera_server::RespondZoomStopRequest* request,
        rpc::camera_server::RespondZoomStopResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                // For server plugins, this should never happen, they should always be
                // constructible.
                auto result = mavsdk::CameraServer::Result::Unknown;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "RespondZoomStop sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->respond_zoom_stop(
            translateFromRpcCameraFeedback(request->zoom_stop_feedback()));

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status SubscribeZoomRange(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::camera_server::SubscribeZoomRangeRequest* /* request */,
        grpc::ServerWriter<rpc::camera_server::ZoomRangeResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::CameraServer::ZoomRangeHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_zoom_range(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const float zoom_range) {
                    rpc::camera_server::ZoomRangeResponse rpc_response;

                    rpc_response.set_factor(zoom_range);

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_zoom_range(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status RespondZoomRange(
        grpc::ServerContext* /* context */,
        const rpc::camera_server::RespondZoomRangeRequest* request,
        rpc::camera_server::RespondZoomRangeResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                // For server plugins, this should never happen, they should always be
                // constructible.
                auto result = mavsdk::CameraServer::Result::Unknown;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "RespondZoomRange sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->respond_zoom_range(
            translateFromRpcCameraFeedback(request->zoom_range_feedback()));

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status SetTrackingRectangleStatus(
        grpc::ServerContext* /* context */,
        const rpc::camera_server::SetTrackingRectangleStatusRequest* request,
        rpc::camera_server::SetTrackingRectangleStatusResponse* /* response */) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "SetTrackingRectangleStatus sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        _lazy_plugin.maybe_plugin()->set_tracking_rectangle_status(
            translateFromRpcTrackRectangle(request->tracked_rectangle()));

        return grpc::Status::OK;
    }

    grpc::Status SetTrackingOffStatus(
        grpc::ServerContext* /* context */,
        const rpc::camera_server::SetTrackingOffStatusRequest* /* request */,
        rpc::camera_server::SetTrackingOffStatusResponse* /* response */) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        _lazy_plugin.maybe_plugin()->set_tracking_off_status();

        return grpc::Status::OK;
    }

    grpc::Status SubscribeTrackingPointCommand(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::camera_server::SubscribeTrackingPointCommandRequest* /* request */,
        grpc::ServerWriter<rpc::camera_server::TrackingPointCommandResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::CameraServer::TrackingPointCommandHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_tracking_point_command(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const mavsdk::CameraServer::TrackPoint tracking_point_command) {
                    rpc::camera_server::TrackingPointCommandResponse rpc_response;

                    rpc_response.set_allocated_track_point(
                        translateToRpcTrackPoint(tracking_point_command).release());

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_tracking_point_command(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status SubscribeTrackingRectangleCommand(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::camera_server::SubscribeTrackingRectangleCommandRequest* /* request */,
        grpc::ServerWriter<rpc::camera_server::TrackingRectangleCommandResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::CameraServer::TrackingRectangleCommandHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_tracking_rectangle_command(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const mavsdk::CameraServer::TrackRectangle tracking_rectangle_command) {
                    rpc::camera_server::TrackingRectangleCommandResponse rpc_response;

                    rpc_response.set_allocated_track_rectangle(
                        translateToRpcTrackRectangle(tracking_rectangle_command).release());

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_tracking_rectangle_command(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status SubscribeTrackingOffCommand(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::camera_server::SubscribeTrackingOffCommandRequest* /* request */,
        grpc::ServerWriter<rpc::camera_server::TrackingOffCommandResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::CameraServer::TrackingOffCommandHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_tracking_off_command(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const int32_t tracking_off_command) {
                    rpc::camera_server::TrackingOffCommandResponse rpc_response;

                    rpc_response.set_dummy(tracking_off_command);

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_tracking_off_command(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status RespondTrackingPointCommand(
        grpc::ServerContext* /* context */,
        const rpc::camera_server::RespondTrackingPointCommandRequest* request,
        rpc::camera_server::RespondTrackingPointCommandResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                // For server plugins, this should never happen, they should always be
                // constructible.
                auto result = mavsdk::CameraServer::Result::Unknown;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "RespondTrackingPointCommand sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->respond_tracking_point_command(
            translateFromRpcCameraFeedback(request->stop_video_feedback()));

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status RespondTrackingRectangleCommand(
        grpc::ServerContext* /* context */,
        const rpc::camera_server::RespondTrackingRectangleCommandRequest* request,
        rpc::camera_server::RespondTrackingRectangleCommandResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                // For server plugins, this should never happen, they should always be
                // constructible.
                auto result = mavsdk::CameraServer::Result::Unknown;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "RespondTrackingRectangleCommand sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->respond_tracking_rectangle_command(
            translateFromRpcCameraFeedback(request->stop_video_feedback()));

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status RespondTrackingOffCommand(
        grpc::ServerContext* /* context */,
        const rpc::camera_server::RespondTrackingOffCommandRequest* request,
        rpc::camera_server::RespondTrackingOffCommandResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                // For server plugins, this should never happen, they should always be
                // constructible.
                auto result = mavsdk::CameraServer::Result::Unknown;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "RespondTrackingOffCommand sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->respond_tracking_off_command(
            translateFromRpcCameraFeedback(request->stop_video_feedback()));

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    void stop()
    {
        _stopped.store(true);
        std::lock_guard<std::mutex> lock(_stream_stop_mutex);
        for (auto& prom : _stream_stop_promises) {
            if (auto handle = prom.lock()) {
                handle->set_value();
            }
        }
    }

private:
    void register_stream_stop_promise(std::weak_ptr<std::promise<void>> prom)
    {
        // If we have already stopped, set promise immediately and don't add it to list.
        if (_stopped.load()) {
            if (auto handle = prom.lock()) {
                handle->set_value();
            }
        } else {
            std::lock_guard<std::mutex> lock(_stream_stop_mutex);
            _stream_stop_promises.push_back(prom);
        }
    }

    void unregister_stream_stop_promise(std::shared_ptr<std::promise<void>> prom)
    {
        std::lock_guard<std::mutex> lock(_stream_stop_mutex);
        for (auto it = _stream_stop_promises.begin(); it != _stream_stop_promises.end();
             /* ++it */) {
            if (it->lock() == prom) {
                it = _stream_stop_promises.erase(it);
            } else {
                ++it;
            }
        }
    }

    LazyServerPlugin& _lazy_plugin;

    std::atomic<bool> _stopped{false};
    std::mutex _stream_stop_mutex{};
    std::vector<std::weak_ptr<std::promise<void>>> _stream_stop_promises{};
};

} // namespace mavsdk_server
} // namespace mavsdk