// WARNING: THIS FILE IS AUTOGENERATED! As such, it should not be edited.
// Edits need to be made to the proto files
// (see
// https://github.com/mavlink/MAVSDK-Proto/blob/master/protos/arm_authorizer_server/arm_authorizer_server.proto)

#include "arm_authorizer_server/arm_authorizer_server.grpc.pb.h"
#include "plugins/arm_authorizer_server/arm_authorizer_server.h"

#include "mavsdk.h"

#include "lazy_server_plugin.h"

#include "log.h"
#include <atomic>
#include <cmath>
#include <future>
#include <limits>
#include <memory>
#include <mutex>
#include <sstream>
#include <vector>

namespace mavsdk {
namespace mavsdk_server {

template<
    typename ArmAuthorizerServer = ArmAuthorizerServer,
    typename LazyServerPlugin = LazyServerPlugin<ArmAuthorizerServer>>

class ArmAuthorizerServerServiceImpl final
    : public rpc::arm_authorizer_server::ArmAuthorizerServerService::Service {
public:
    ArmAuthorizerServerServiceImpl(LazyServerPlugin& lazy_plugin) : _lazy_plugin(lazy_plugin) {}

    template<typename ResponseType>
    void fillResponseWithResult(
        ResponseType* response, mavsdk::ArmAuthorizerServer::Result& result) const
    {
        auto rpc_result = translateToRpcResult(result);

        auto* rpc_arm_authorizer_server_result =
            new rpc::arm_authorizer_server::ArmAuthorizerServerResult();
        rpc_arm_authorizer_server_result->set_result(rpc_result);
        std::stringstream ss;
        ss << result;
        rpc_arm_authorizer_server_result->set_result_str(ss.str());

        response->set_allocated_arm_authorizer_server_result(rpc_arm_authorizer_server_result);
    }

    static rpc::arm_authorizer_server::RejectionReason translateToRpcRejectionReason(
        const mavsdk::ArmAuthorizerServer::RejectionReason& rejection_reason)
    {
        switch (rejection_reason) {
            default:
                LogErr() << "Unknown rejection_reason enum value: "
                         << static_cast<int>(rejection_reason);
            // FALLTHROUGH
            case mavsdk::ArmAuthorizerServer::RejectionReason::Generic:
                return rpc::arm_authorizer_server::REJECTION_REASON_GENERIC;
            case mavsdk::ArmAuthorizerServer::RejectionReason::None:
                return rpc::arm_authorizer_server::REJECTION_REASON_NONE;
            case mavsdk::ArmAuthorizerServer::RejectionReason::InvalidWaypoint:
                return rpc::arm_authorizer_server::REJECTION_REASON_INVALID_WAYPOINT;
            case mavsdk::ArmAuthorizerServer::RejectionReason::Timeout:
                return rpc::arm_authorizer_server::REJECTION_REASON_TIMEOUT;
            case mavsdk::ArmAuthorizerServer::RejectionReason::AirspaceInUse:
                return rpc::arm_authorizer_server::REJECTION_REASON_AIRSPACE_IN_USE;
            case mavsdk::ArmAuthorizerServer::RejectionReason::BadWeather:
                return rpc::arm_authorizer_server::REJECTION_REASON_BAD_WEATHER;
        }
    }

    static mavsdk::ArmAuthorizerServer::RejectionReason translateFromRpcRejectionReason(
        const rpc::arm_authorizer_server::RejectionReason rejection_reason)
    {
        switch (rejection_reason) {
            default:
                LogErr() << "Unknown rejection_reason enum value: "
                         << static_cast<int>(rejection_reason);
            // FALLTHROUGH
            case rpc::arm_authorizer_server::REJECTION_REASON_GENERIC:
                return mavsdk::ArmAuthorizerServer::RejectionReason::Generic;
            case rpc::arm_authorizer_server::REJECTION_REASON_NONE:
                return mavsdk::ArmAuthorizerServer::RejectionReason::None;
            case rpc::arm_authorizer_server::REJECTION_REASON_INVALID_WAYPOINT:
                return mavsdk::ArmAuthorizerServer::RejectionReason::InvalidWaypoint;
            case rpc::arm_authorizer_server::REJECTION_REASON_TIMEOUT:
                return mavsdk::ArmAuthorizerServer::RejectionReason::Timeout;
            case rpc::arm_authorizer_server::REJECTION_REASON_AIRSPACE_IN_USE:
                return mavsdk::ArmAuthorizerServer::RejectionReason::AirspaceInUse;
            case rpc::arm_authorizer_server::REJECTION_REASON_BAD_WEATHER:
                return mavsdk::ArmAuthorizerServer::RejectionReason::BadWeather;
        }
    }

    static rpc::arm_authorizer_server::ArmAuthorizerServerResult::Result
    translateToRpcResult(const mavsdk::ArmAuthorizerServer::Result& result)
    {
        switch (result) {
            default:
                LogErr() << "Unknown result enum value: " << static_cast<int>(result);
            // FALLTHROUGH
            case mavsdk::ArmAuthorizerServer::Result::Unknown:
                return rpc::arm_authorizer_server::ArmAuthorizerServerResult_Result_RESULT_UNKNOWN;
            case mavsdk::ArmAuthorizerServer::Result::Success:
                return rpc::arm_authorizer_server::ArmAuthorizerServerResult_Result_RESULT_SUCCESS;
            case mavsdk::ArmAuthorizerServer::Result::Failed:
                return rpc::arm_authorizer_server::ArmAuthorizerServerResult_Result_RESULT_FAILED;
        }
    }

    static mavsdk::ArmAuthorizerServer::Result translateFromRpcResult(
        const rpc::arm_authorizer_server::ArmAuthorizerServerResult::Result result)
    {
        switch (result) {
            default:
                LogErr() << "Unknown result enum value: " << static_cast<int>(result);
            // FALLTHROUGH
            case rpc::arm_authorizer_server::ArmAuthorizerServerResult_Result_RESULT_UNKNOWN:
                return mavsdk::ArmAuthorizerServer::Result::Unknown;
            case rpc::arm_authorizer_server::ArmAuthorizerServerResult_Result_RESULT_SUCCESS:
                return mavsdk::ArmAuthorizerServer::Result::Success;
            case rpc::arm_authorizer_server::ArmAuthorizerServerResult_Result_RESULT_FAILED:
                return mavsdk::ArmAuthorizerServer::Result::Failed;
        }
    }

    grpc::Status SubscribeArmAuthorization(
        grpc::ServerContext* /* context */,
        const mavsdk::rpc::arm_authorizer_server::SubscribeArmAuthorizationRequest* /* request */,
        grpc::ServerWriter<rpc::arm_authorizer_server::ArmAuthorizationResponse>* writer) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            return grpc::Status::OK;
        }

        auto stream_closed_promise = std::make_shared<std::promise<void>>();
        auto stream_closed_future = stream_closed_promise->get_future();
        register_stream_stop_promise(stream_closed_promise);

        auto is_finished = std::make_shared<bool>(false);
        auto subscribe_mutex = std::make_shared<std::mutex>();

        const mavsdk::ArmAuthorizerServer::ArmAuthorizationHandle handle =
            _lazy_plugin.maybe_plugin()->subscribe_arm_authorization(
                [this, &writer, &stream_closed_promise, is_finished, subscribe_mutex, &handle](
                    const uint32_t arm_authorization) {
                    rpc::arm_authorizer_server::ArmAuthorizationResponse rpc_response;

                    rpc_response.set_system_id(arm_authorization);

                    std::unique_lock<std::mutex> lock(*subscribe_mutex);
                    if (!*is_finished && !writer->Write(rpc_response)) {
                        _lazy_plugin.maybe_plugin()->unsubscribe_arm_authorization(handle);

                        *is_finished = true;
                        unregister_stream_stop_promise(stream_closed_promise);
                        stream_closed_promise->set_value();
                    }
                });

        stream_closed_future.wait();
        std::unique_lock<std::mutex> lock(*subscribe_mutex);
        *is_finished = true;

        return grpc::Status::OK;
    }

    grpc::Status AcceptArmAuthorization(
        grpc::ServerContext* /* context */,
        const rpc::arm_authorizer_server::AcceptArmAuthorizationRequest* request,
        rpc::arm_authorizer_server::AcceptArmAuthorizationResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                // For server plugins, this should never happen, they should always be
                // constructible.
                auto result = mavsdk::ArmAuthorizerServer::Result::Unknown;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "AcceptArmAuthorization sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result =
            _lazy_plugin.maybe_plugin()->accept_arm_authorization(request->valid_time_s());

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    grpc::Status RejectArmAuthorization(
        grpc::ServerContext* /* context */,
        const rpc::arm_authorizer_server::RejectArmAuthorizationRequest* request,
        rpc::arm_authorizer_server::RejectArmAuthorizationResponse* response) override
    {
        if (_lazy_plugin.maybe_plugin() == nullptr) {
            if (response != nullptr) {
                // For server plugins, this should never happen, they should always be
                // constructible.
                auto result = mavsdk::ArmAuthorizerServer::Result::Unknown;
                fillResponseWithResult(response, result);
            }

            return grpc::Status::OK;
        }

        if (request == nullptr) {
            LogWarn() << "RejectArmAuthorization sent with a null request! Ignoring...";
            return grpc::Status::OK;
        }

        auto result = _lazy_plugin.maybe_plugin()->reject_arm_authorization(
            request->temporarily(),
            translateFromRpcRejectionReason(request->reason()),
            request->extra_info());

        if (response != nullptr) {
            fillResponseWithResult(response, result);
        }

        return grpc::Status::OK;
    }

    void stop()
    {
        _stopped.store(true);
        std::lock_guard<std::mutex> lock(_stream_stop_mutex);
        for (auto& prom : _stream_stop_promises) {
            if (auto handle = prom.lock()) {
                handle->set_value();
            }
        }
    }

private:
    void register_stream_stop_promise(std::weak_ptr<std::promise<void>> prom)
    {
        // If we have already stopped, set promise immediately and don't add it to list.
        if (_stopped.load()) {
            if (auto handle = prom.lock()) {
                handle->set_value();
            }
        } else {
            std::lock_guard<std::mutex> lock(_stream_stop_mutex);
            _stream_stop_promises.push_back(prom);
        }
    }

    void unregister_stream_stop_promise(std::shared_ptr<std::promise<void>> prom)
    {
        std::lock_guard<std::mutex> lock(_stream_stop_mutex);
        for (auto it = _stream_stop_promises.begin(); it != _stream_stop_promises.end();
             /* ++it */) {
            if (it->lock() == prom) {
                it = _stream_stop_promises.erase(it);
            } else {
                ++it;
            }
        }
    }

    LazyServerPlugin& _lazy_plugin;

    std::atomic<bool> _stopped{false};
    std::mutex _stream_stop_mutex{};
    std::vector<std::weak_ptr<std::promise<void>>> _stream_stop_promises{};
};

} // namespace mavsdk_server
} // namespace mavsdk