// WARNING: THIS FILE IS AUTOGENERATED! As such, it should not be edited.
// Edits need to be made to the proto files
// (see https://github.com/mavlink/MAVSDK-Proto/blob/main/protos/rtk/rtk.proto)

#pragma once

#include <array>
#include <cmath>
#include <functional>
#include <limits>
#include <memory>
#include <string>
#include <utility>
#include <vector>

#include "plugin_base.h"

#include "handle.h"

namespace mavsdk {

class System;
class RtkImpl;

/**
 * @brief Service to send RTK corrections to the vehicle.
 */
class Rtk : public PluginBase {
public:
    /**
     * @brief Constructor. Creates the plugin for a specific System.
     *
     * The plugin is typically created as shown below:
     *
     *     ```cpp
     *     auto rtk = Rtk(system);
     *     ```
     *
     * @param system The specific system associated with this plugin.
     */
    explicit Rtk(System& system); // deprecated

    /**
     * @brief Constructor. Creates the plugin for a specific System.
     *
     * The plugin is typically created as shown below:
     *
     *     ```cpp
     *     auto rtk = Rtk(system);
     *     ```
     *
     * @param system The specific system associated with this plugin.
     */
    explicit Rtk(std::shared_ptr<System> system); // new

    /**
     * @brief Destructor (internal use only).
     */
    ~Rtk() override;

    /**
     * @brief RTCM data type
     */
    struct RtcmData {
        std::string data_base64{}; /**< @brief The data encoded as a base64 string */
    };

    /**
     * @brief Equal operator to compare two `Rtk::RtcmData` objects.
     *
     * @return `true` if items are equal.
     */
    friend bool operator==(const Rtk::RtcmData& lhs, const Rtk::RtcmData& rhs);

    /**
     * @brief Stream operator to print information about a `Rtk::RtcmData`.
     *
     * @return A reference to the stream.
     */
    friend std::ostream& operator<<(std::ostream& str, Rtk::RtcmData const& rtcm_data);

    /**
     * @brief Possible results returned for rtk requests.
     */
    enum class Result {
        Unknown, /**< @brief Unknown result. */
        Success, /**< @brief Request succeeded. */
        TooLong, /**< @brief Passed data is too long. */
        NoSystem, /**< @brief No system connected. */
        ConnectionError, /**< @brief Connection error. */
    };

    /**
     * @brief Stream operator to print information about a `Rtk::Result`.
     *
     * @return A reference to the stream.
     */
    friend std::ostream& operator<<(std::ostream& str, Rtk::Result const& result);

    /**
     * @brief Callback type for asynchronous Rtk calls.
     */
    using ResultCallback = std::function<void(Result)>;

    /**
     * @brief Send RTCM data.
     *
     * This function is blocking.
     *
     * @return Result of request.
     */
    Result send_rtcm_data(RtcmData rtcm_data) const;

    /**
     * @brief Copy constructor.
     */
    Rtk(const Rtk& other);

    /**
     * @brief Equality operator (object is not copyable).
     */
    const Rtk& operator=(const Rtk&) = delete;

private:
    /** @private Underlying implementation, set at instantiation */
    std::unique_ptr<RtkImpl> _impl;
};

} // namespace mavsdk