// WARNING: THIS FILE IS AUTOGENERATED! As such, it should not be edited.
// Edits need to be made to the proto files
// (see https://github.com/mavlink/MAVSDK-Proto/blob/main/protos/param_server/param_server.proto)

#pragma once

#include <array>
#include <cmath>
#include <functional>
#include <limits>
#include <memory>
#include <string>
#include <utility>
#include <vector>

#include "server_plugin_base.h"

#include "handle.h"

namespace mavsdk {

class ServerComponent;
class ParamServerImpl;

/**
 * @brief Provide raw access to retrieve and provide server parameters.
 */
class ParamServer : public ServerPluginBase {
public:
    /**
     * @brief Constructor. Creates the plugin for a ServerComponent instance.
     *
     * The plugin is typically created as shown below:
     *
     *     ```cpp
     *     auto param_server = ParamServer(server_component);
     *     ```
     *
     * @param server_component The ServerComponent instance associated with this server plugin.
     */
    explicit ParamServer(std::shared_ptr<ServerComponent> server_component);

    /**
     * @brief Destructor (internal use only).
     */
    ~ParamServer() override;

    /**
     * @brief Type for integer parameters.
     */
    struct IntParam {
        std::string name{}; /**< @brief Name of the parameter */
        int32_t value{}; /**< @brief Value of the parameter */
    };

    /**
     * @brief Equal operator to compare two `ParamServer::IntParam` objects.
     *
     * @return `true` if items are equal.
     */
    friend bool operator==(const ParamServer::IntParam& lhs, const ParamServer::IntParam& rhs);

    /**
     * @brief Stream operator to print information about a `ParamServer::IntParam`.
     *
     * @return A reference to the stream.
     */
    friend std::ostream& operator<<(std::ostream& str, ParamServer::IntParam const& int_param);

    /**
     * @brief Type for float parameters.
     */
    struct FloatParam {
        std::string name{}; /**< @brief Name of the parameter */
        float value{}; /**< @brief Value of the parameter */
    };

    /**
     * @brief Equal operator to compare two `ParamServer::FloatParam` objects.
     *
     * @return `true` if items are equal.
     */
    friend bool operator==(const ParamServer::FloatParam& lhs, const ParamServer::FloatParam& rhs);

    /**
     * @brief Stream operator to print information about a `ParamServer::FloatParam`.
     *
     * @return A reference to the stream.
     */
    friend std::ostream& operator<<(std::ostream& str, ParamServer::FloatParam const& float_param);

    /**
     * @brief Type for float parameters.
     */
    struct CustomParam {
        std::string name{}; /**< @brief Name of the parameter */
        std::string value{}; /**< @brief Value of the parameter */
    };

    /**
     * @brief Equal operator to compare two `ParamServer::CustomParam` objects.
     *
     * @return `true` if items are equal.
     */
    friend bool
    operator==(const ParamServer::CustomParam& lhs, const ParamServer::CustomParam& rhs);

    /**
     * @brief Stream operator to print information about a `ParamServer::CustomParam`.
     *
     * @return A reference to the stream.
     */
    friend std::ostream&
    operator<<(std::ostream& str, ParamServer::CustomParam const& custom_param);

    /**
     * @brief Type collecting all integer, float, and custom parameters.
     */
    struct AllParams {
        std::vector<IntParam>
            int_params{}; /**< @brief Collection of all parameter names and values of type int */
        std::vector<FloatParam> float_params{}; /**< @brief Collection of all parameter names and
                                                   values of type float */
        std::vector<CustomParam> custom_params{}; /**< @brief Collection of all parameter names and
                                                     values of type custom */
    };

    /**
     * @brief Equal operator to compare two `ParamServer::AllParams` objects.
     *
     * @return `true` if items are equal.
     */
    friend bool operator==(const ParamServer::AllParams& lhs, const ParamServer::AllParams& rhs);

    /**
     * @brief Stream operator to print information about a `ParamServer::AllParams`.
     *
     * @return A reference to the stream.
     */
    friend std::ostream& operator<<(std::ostream& str, ParamServer::AllParams const& all_params);

    /**
     * @brief Possible results returned for param requests.
     */
    enum class Result {
        Unknown, /**< @brief Unknown result. */
        Success, /**< @brief Request succeeded. */
        NotFound, /**< @brief Not Found. */
        WrongType, /**< @brief Wrong type. */
        ParamNameTooLong, /**< @brief Parameter name too long (> 16). */
        NoSystem, /**< @brief No system available. */
        ParamValueTooLong, /**< @brief Parameter name too long (> 128). */
    };

    /**
     * @brief Stream operator to print information about a `ParamServer::Result`.
     *
     * @return A reference to the stream.
     */
    friend std::ostream& operator<<(std::ostream& str, ParamServer::Result const& result);

    /**
     * @brief Callback type for asynchronous ParamServer calls.
     */
    using ResultCallback = std::function<void(Result)>;

    /**
     * @brief Retrieve an int parameter.
     *
     * If the type is wrong, the result will be `WRONG_TYPE`.
     *
     * This function is blocking.
     *
     * @return Result of request.
     */
    std::pair<Result, int32_t> retrieve_param_int(std::string name) const;

    /**
     * @brief Provide an int parameter.
     *
     * If the type is wrong, the result will be `WRONG_TYPE`.
     *
     * This function is blocking.
     *
     * @return Result of request.
     */
    Result provide_param_int(std::string name, int32_t value) const;

    /**
     * @brief Retrieve a float parameter.
     *
     * If the type is wrong, the result will be `WRONG_TYPE`.
     *
     * This function is blocking.
     *
     * @return Result of request.
     */
    std::pair<Result, float> retrieve_param_float(std::string name) const;

    /**
     * @brief Provide a float parameter.
     *
     * If the type is wrong, the result will be `WRONG_TYPE`.
     *
     * This function is blocking.
     *
     * @return Result of request.
     */
    Result provide_param_float(std::string name, float value) const;

    /**
     * @brief Retrieve a custom parameter.
     *
     * If the type is wrong, the result will be `WRONG_TYPE`.
     *
     * This function is blocking.
     *
     * @return Result of request.
     */
    std::pair<Result, std::string> retrieve_param_custom(std::string name) const;

    /**
     * @brief Provide a custom parameter.
     *
     * If the type is wrong, the result will be `WRONG_TYPE`.
     *
     * This function is blocking.
     *
     * @return Result of request.
     */
    Result provide_param_custom(std::string name, std::string value) const;

    /**
     * @brief Retrieve all parameters.
     *
     * This function is blocking.
     *
     * @return Result of request.
     */
    ParamServer::AllParams retrieve_all_params() const;

    /**
     * @brief Callback type for subscribe_changed_param_int.
     */
    using ChangedParamIntCallback = std::function<void(IntParam)>;

    /**
     * @brief Handle type for subscribe_changed_param_int.
     */
    using ChangedParamIntHandle = Handle<IntParam>;

    /**
     * @brief Subscribe to changed int param.
     */
    ChangedParamIntHandle subscribe_changed_param_int(const ChangedParamIntCallback& callback);

    /**
     * @brief Unsubscribe from subscribe_changed_param_int
     */
    void unsubscribe_changed_param_int(ChangedParamIntHandle handle);

    /**
     * @brief Callback type for subscribe_changed_param_float.
     */
    using ChangedParamFloatCallback = std::function<void(FloatParam)>;

    /**
     * @brief Handle type for subscribe_changed_param_float.
     */
    using ChangedParamFloatHandle = Handle<FloatParam>;

    /**
     * @brief Subscribe to changed float param.
     */
    ChangedParamFloatHandle
    subscribe_changed_param_float(const ChangedParamFloatCallback& callback);

    /**
     * @brief Unsubscribe from subscribe_changed_param_float
     */
    void unsubscribe_changed_param_float(ChangedParamFloatHandle handle);

    /**
     * @brief Callback type for subscribe_changed_param_custom.
     */
    using ChangedParamCustomCallback = std::function<void(CustomParam)>;

    /**
     * @brief Handle type for subscribe_changed_param_custom.
     */
    using ChangedParamCustomHandle = Handle<CustomParam>;

    /**
     * @brief Subscribe to changed custom param.
     */
    ChangedParamCustomHandle
    subscribe_changed_param_custom(const ChangedParamCustomCallback& callback);

    /**
     * @brief Unsubscribe from subscribe_changed_param_custom
     */
    void unsubscribe_changed_param_custom(ChangedParamCustomHandle handle);

    /**
     * @brief Copy constructor.
     */
    ParamServer(const ParamServer& other);

    /**
     * @brief Equality operator (object is not copyable).
     */
    const ParamServer& operator=(const ParamServer&) = delete;

private:
    /** @private Underlying implementation, set at instantiation */
    std::unique_ptr<ParamServerImpl> _impl;
};

} // namespace mavsdk