// WARNING: THIS FILE IS AUTOGENERATED! As such, it should not be edited.
// Edits need to be made to the proto files
// (see
// https://github.com/mavlink/MAVSDK-Proto/blob/master/protos/mission_raw_server/mission_raw_server.proto)

#include <iomanip>

#include "mission_raw_server_impl.h"
#include "plugins/mission_raw_server/mission_raw_server.h"

namespace mavsdk {

using MissionItem = MissionRawServer::MissionItem;
using MissionPlan = MissionRawServer::MissionPlan;
using MissionProgress = MissionRawServer::MissionProgress;

MissionRawServer::MissionRawServer(std::shared_ptr<ServerComponent> server_component) :
    ServerPluginBase(),
    _impl{std::make_unique<MissionRawServerImpl>(server_component)}
{}

MissionRawServer::~MissionRawServer() {}

MissionRawServer::IncomingMissionHandle
MissionRawServer::subscribe_incoming_mission(const IncomingMissionCallback& callback)
{
    return _impl->subscribe_incoming_mission(callback);
}

void MissionRawServer::unsubscribe_incoming_mission(IncomingMissionHandle handle)
{
    _impl->unsubscribe_incoming_mission(handle);
}

MissionRawServer::MissionPlan MissionRawServer::incoming_mission() const
{
    return _impl->incoming_mission();
}

MissionRawServer::CurrentItemChangedHandle
MissionRawServer::subscribe_current_item_changed(const CurrentItemChangedCallback& callback)
{
    return _impl->subscribe_current_item_changed(callback);
}

void MissionRawServer::unsubscribe_current_item_changed(CurrentItemChangedHandle handle)
{
    _impl->unsubscribe_current_item_changed(handle);
}

MissionRawServer::MissionItem MissionRawServer::current_item_changed() const
{
    return _impl->current_item_changed();
}

void MissionRawServer::set_current_item_complete() const
{
    _impl->set_current_item_complete();
}

MissionRawServer::ClearAllHandle
MissionRawServer::subscribe_clear_all(const ClearAllCallback& callback)
{
    return _impl->subscribe_clear_all(callback);
}

void MissionRawServer::unsubscribe_clear_all(ClearAllHandle handle)
{
    _impl->unsubscribe_clear_all(handle);
}

uint32_t MissionRawServer::clear_all() const
{
    return _impl->clear_all();
}

bool operator==(const MissionRawServer::MissionItem& lhs, const MissionRawServer::MissionItem& rhs)
{
    return (rhs.seq == lhs.seq) && (rhs.frame == lhs.frame) && (rhs.command == lhs.command) &&
           (rhs.current == lhs.current) && (rhs.autocontinue == lhs.autocontinue) &&
           ((std::isnan(rhs.param1) && std::isnan(lhs.param1)) || rhs.param1 == lhs.param1) &&
           ((std::isnan(rhs.param2) && std::isnan(lhs.param2)) || rhs.param2 == lhs.param2) &&
           ((std::isnan(rhs.param3) && std::isnan(lhs.param3)) || rhs.param3 == lhs.param3) &&
           ((std::isnan(rhs.param4) && std::isnan(lhs.param4)) || rhs.param4 == lhs.param4) &&
           (rhs.x == lhs.x) && (rhs.y == lhs.y) &&
           ((std::isnan(rhs.z) && std::isnan(lhs.z)) || rhs.z == lhs.z) &&
           (rhs.mission_type == lhs.mission_type);
}

std::ostream& operator<<(std::ostream& str, MissionRawServer::MissionItem const& mission_item)
{
    str << std::setprecision(15);
    str << "mission_item:" << '\n' << "{\n";
    str << "    seq: " << mission_item.seq << '\n';
    str << "    frame: " << mission_item.frame << '\n';
    str << "    command: " << mission_item.command << '\n';
    str << "    current: " << mission_item.current << '\n';
    str << "    autocontinue: " << mission_item.autocontinue << '\n';
    str << "    param1: " << mission_item.param1 << '\n';
    str << "    param2: " << mission_item.param2 << '\n';
    str << "    param3: " << mission_item.param3 << '\n';
    str << "    param4: " << mission_item.param4 << '\n';
    str << "    x: " << mission_item.x << '\n';
    str << "    y: " << mission_item.y << '\n';
    str << "    z: " << mission_item.z << '\n';
    str << "    mission_type: " << mission_item.mission_type << '\n';
    str << '}';
    return str;
}

bool operator==(const MissionRawServer::MissionPlan& lhs, const MissionRawServer::MissionPlan& rhs)
{
    return (rhs.mission_items == lhs.mission_items);
}

std::ostream& operator<<(std::ostream& str, MissionRawServer::MissionPlan const& mission_plan)
{
    str << std::setprecision(15);
    str << "mission_plan:" << '\n' << "{\n";
    str << "    mission_items: [";
    for (auto it = mission_plan.mission_items.begin(); it != mission_plan.mission_items.end();
         ++it) {
        str << *it;
        str << (it + 1 != mission_plan.mission_items.end() ? ", " : "]\n");
    }
    str << '}';
    return str;
}

bool operator==(
    const MissionRawServer::MissionProgress& lhs, const MissionRawServer::MissionProgress& rhs)
{
    return (rhs.current == lhs.current) && (rhs.total == lhs.total);
}

std::ostream&
operator<<(std::ostream& str, MissionRawServer::MissionProgress const& mission_progress)
{
    str << std::setprecision(15);
    str << "mission_progress:" << '\n' << "{\n";
    str << "    current: " << mission_progress.current << '\n';
    str << "    total: " << mission_progress.total << '\n';
    str << '}';
    return str;
}

std::ostream& operator<<(std::ostream& str, MissionRawServer::Result const& result)
{
    switch (result) {
        case MissionRawServer::Result::Unknown:
            return str << "Unknown";
        case MissionRawServer::Result::Success:
            return str << "Success";
        case MissionRawServer::Result::Error:
            return str << "Error";
        case MissionRawServer::Result::TooManyMissionItems:
            return str << "Too Many Mission Items";
        case MissionRawServer::Result::Busy:
            return str << "Busy";
        case MissionRawServer::Result::Timeout:
            return str << "Timeout";
        case MissionRawServer::Result::InvalidArgument:
            return str << "Invalid Argument";
        case MissionRawServer::Result::Unsupported:
            return str << "Unsupported";
        case MissionRawServer::Result::NoMissionAvailable:
            return str << "No Mission Available";
        case MissionRawServer::Result::UnsupportedMissionCmd:
            return str << "Unsupported Mission Cmd";
        case MissionRawServer::Result::TransferCancelled:
            return str << "Transfer Cancelled";
        case MissionRawServer::Result::NoSystem:
            return str << "No System";
        case MissionRawServer::Result::Next:
            return str << "Next";
        default:
            return str << "Unknown";
    }
}

} // namespace mavsdk