// WARNING: THIS FILE IS AUTOGENERATED! As such, it should not be edited.
// Edits need to be made to the proto files
// (see https://github.com/mavlink/MAVSDK-Proto/blob/main/protos/events/events.proto)

#pragma once

#include <array>
#include <cmath>
#include <functional>
#include <limits>
#include <memory>
#include <string>
#include <utility>
#include <vector>

#include "plugin_base.h"

#include "handle.h"

namespace mavsdk {

class System;
class EventsImpl;

/**
 * @brief Get event notifications, such as takeoff, or arming checks
 */
class Events : public PluginBase {
public:
    /**
     * @brief Constructor. Creates the plugin for a specific System.
     *
     * The plugin is typically created as shown below:
     *
     *     ```cpp
     *     auto events = Events(system);
     *     ```
     *
     * @param system The specific system associated with this plugin.
     */
    explicit Events(System& system); // deprecated

    /**
     * @brief Constructor. Creates the plugin for a specific System.
     *
     * The plugin is typically created as shown below:
     *
     *     ```cpp
     *     auto events = Events(system);
     *     ```
     *
     * @param system The specific system associated with this plugin.
     */
    explicit Events(std::shared_ptr<System> system); // new

    /**
     * @brief Destructor (internal use only).
     */
    ~Events() override;

    /**
     * @brief
     */
    enum class LogLevel {
        Emergency, /**< @brief. */
        Alert, /**< @brief. */
        Critical, /**< @brief. */
        Error, /**< @brief. */
        Warning, /**< @brief. */
        Notice, /**< @brief. */
        Info, /**< @brief. */
        Debug, /**< @brief. */
    };

    /**
     * @brief Stream operator to print information about a `Events::LogLevel`.
     *
     * @return A reference to the stream.
     */
    friend std::ostream& operator<<(std::ostream& str, Events::LogLevel const& log_level);

    /**
     * @brief
     */
    struct Event {
        uint32_t compid{}; /**< @brief The source component ID of the event */
        std::string message{}; /**< @brief Short, single-line message */
        std::string
            description{}; /**< @brief Detailed description (optional, might be multiple lines) */
        LogLevel log_level{}; /**< @brief */
        std::string event_namespace{}; /**< @brief Namespace, e.g. "px4" */
        std::string event_name{}; /**< @brief Event name (unique within the namespace) */
    };

    /**
     * @brief Equal operator to compare two `Events::Event` objects.
     *
     * @return `true` if items are equal.
     */
    friend bool operator==(const Events::Event& lhs, const Events::Event& rhs);

    /**
     * @brief Stream operator to print information about a `Events::Event`.
     *
     * @return A reference to the stream.
     */
    friend std::ostream& operator<<(std::ostream& str, Events::Event const& event);

    /**
     * @brief
     */
    struct HealthAndArmingCheckProblem {
        std::string message{}; /**< @brief Short, single-line message */
        std::string
            description{}; /**< @brief Detailed description (optional, might be multiple lines) */
        LogLevel log_level{}; /**< @brief */
        std::string health_component{}; /**< @brief Associated health component, e.g. "gps" */
    };

    /**
     * @brief Equal operator to compare two `Events::HealthAndArmingCheckProblem` objects.
     *
     * @return `true` if items are equal.
     */
    friend bool operator==(
        const Events::HealthAndArmingCheckProblem& lhs,
        const Events::HealthAndArmingCheckProblem& rhs);

    /**
     * @brief Stream operator to print information about a `Events::HealthAndArmingCheckProblem`.
     *
     * @return A reference to the stream.
     */
    friend std::ostream& operator<<(
        std::ostream& str,
        Events::HealthAndArmingCheckProblem const& health_and_arming_check_problem);

    /**
     * @brief Arming checks for a specific mode
     */
    struct HealthAndArmingCheckMode {
        std::string mode_name{}; /**< @brief Mode name, e.g. "Position" */
        bool can_arm_or_run{}; /**< @brief If disarmed: indicates if arming is possible. If armed:
                                  indicates if the mode can be selected */
        std::vector<HealthAndArmingCheckProblem>
            problems{}; /**< @brief List of reported problems for the mode */
    };

    /**
     * @brief Equal operator to compare two `Events::HealthAndArmingCheckMode` objects.
     *
     * @return `true` if items are equal.
     */
    friend bool operator==(
        const Events::HealthAndArmingCheckMode& lhs, const Events::HealthAndArmingCheckMode& rhs);

    /**
     * @brief Stream operator to print information about a `Events::HealthAndArmingCheckMode`.
     *
     * @return A reference to the stream.
     */
    friend std::ostream& operator<<(
        std::ostream& str, Events::HealthAndArmingCheckMode const& health_and_arming_check_mode);

    /**
     * @brief
     */
    struct HealthComponentReport {
        std::string name{}; /**< @brief Unique component name, e.g. "gps" */
        std::string label{}; /**< @brief Human readable label of the component, e.g. "GPS" or
                                "Accelerometer" */
        bool is_present{}; /**< @brief If the component is present */
        bool has_error{}; /**< @brief If the component has errors */
        bool has_warning{}; /**< @brief If the component has warnings */
    };

    /**
     * @brief Equal operator to compare two `Events::HealthComponentReport` objects.
     *
     * @return `true` if items are equal.
     */
    friend bool
    operator==(const Events::HealthComponentReport& lhs, const Events::HealthComponentReport& rhs);

    /**
     * @brief Stream operator to print information about a `Events::HealthComponentReport`.
     *
     * @return A reference to the stream.
     */
    friend std::ostream&
    operator<<(std::ostream& str, Events::HealthComponentReport const& health_component_report);

    /**
     * @brief
     */
    struct HealthAndArmingCheckReport {
        HealthAndArmingCheckMode
            current_mode_intention{}; /**< @brief Report for currently intended mode */
        std::vector<HealthComponentReport>
            health_components{}; /**< @brief Health components list (e.g. for "gps") */
        std::vector<HealthAndArmingCheckProblem>
            all_problems{}; /**< @brief Complete list of problems */
    };

    /**
     * @brief Equal operator to compare two `Events::HealthAndArmingCheckReport` objects.
     *
     * @return `true` if items are equal.
     */
    friend bool operator==(
        const Events::HealthAndArmingCheckReport& lhs,
        const Events::HealthAndArmingCheckReport& rhs);

    /**
     * @brief Stream operator to print information about a `Events::HealthAndArmingCheckReport`.
     *
     * @return A reference to the stream.
     */
    friend std::ostream& operator<<(
        std::ostream& str,
        Events::HealthAndArmingCheckReport const& health_and_arming_check_report);

    /**
     * @brief
     */
    enum class Result {
        Success, /**< @brief. */
        NotAvailable, /**< @brief. */
        ConnectionError, /**< @brief. */
        Unsupported, /**< @brief. */
        Denied, /**< @brief. */
        Failed, /**< @brief. */
        Timeout, /**< @brief. */
        NoSystem, /**< @brief. */
    };

    /**
     * @brief Stream operator to print information about a `Events::Result`.
     *
     * @return A reference to the stream.
     */
    friend std::ostream& operator<<(std::ostream& str, Events::Result const& result);

    /**
     * @brief Callback type for asynchronous Events calls.
     */
    using ResultCallback = std::function<void(Result)>;

    /**
     * @brief Callback type for subscribe_events.
     */
    using EventsCallback = std::function<void(Event)>;

    /**
     * @brief Handle type for subscribe_events.
     */
    using EventsHandle = Handle<Event>;

    /**
     * @brief Subscribe to event updates.
     */
    EventsHandle subscribe_events(const EventsCallback& callback);

    /**
     * @brief Unsubscribe from subscribe_events
     */
    void unsubscribe_events(EventsHandle handle);

    /**
     * @brief Callback type for subscribe_health_and_arming_checks.
     */
    using HealthAndArmingChecksCallback = std::function<void(HealthAndArmingCheckReport)>;

    /**
     * @brief Handle type for subscribe_health_and_arming_checks.
     */
    using HealthAndArmingChecksHandle = Handle<HealthAndArmingCheckReport>;

    /**
     * @brief Subscribe to arming check updates.
     */
    HealthAndArmingChecksHandle
    subscribe_health_and_arming_checks(const HealthAndArmingChecksCallback& callback);

    /**
     * @brief Unsubscribe from subscribe_health_and_arming_checks
     */
    void unsubscribe_health_and_arming_checks(HealthAndArmingChecksHandle handle);

    /**
     * @brief Get the latest report.
     *
     * This function is blocking.
     *
     * @return Result of request.
     */
    std::pair<Result, Events::HealthAndArmingCheckReport>
    get_health_and_arming_checks_report() const;

    /**
     * @brief Copy constructor.
     */
    Events(const Events& other);

    /**
     * @brief Equality operator (object is not copyable).
     */
    const Events& operator=(const Events&) = delete;

private:
    /** @private Underlying implementation, set at instantiation */
    std::unique_ptr<EventsImpl> _impl;
};

} // namespace mavsdk