// WARNING: THIS FILE IS AUTOGENERATED! As such, it should not be edited.
// Edits need to be made to the proto files
// (see https://github.com/mavlink/MAVSDK-Proto/blob/master/protos/events/events.proto)

#include <iomanip>

#include "events_impl.h"
#include "plugins/events/events.h"

namespace mavsdk {

using Event = Events::Event;
using HealthAndArmingCheckProblem = Events::HealthAndArmingCheckProblem;
using HealthAndArmingCheckMode = Events::HealthAndArmingCheckMode;
using HealthComponentReport = Events::HealthComponentReport;
using HealthAndArmingCheckReport = Events::HealthAndArmingCheckReport;

Events::Events(System& system) : PluginBase(), _impl{std::make_unique<EventsImpl>(system)} {}

Events::Events(std::shared_ptr<System> system) :
    PluginBase(),
    _impl{std::make_unique<EventsImpl>(system)}
{}

Events::~Events() {}

Events::EventsHandle Events::subscribe_events(const EventsCallback& callback)
{
    return _impl->subscribe_events(callback);
}

void Events::unsubscribe_events(EventsHandle handle)
{
    _impl->unsubscribe_events(handle);
}

Events::HealthAndArmingChecksHandle
Events::subscribe_health_and_arming_checks(const HealthAndArmingChecksCallback& callback)
{
    return _impl->subscribe_health_and_arming_checks(callback);
}

void Events::unsubscribe_health_and_arming_checks(HealthAndArmingChecksHandle handle)
{
    _impl->unsubscribe_health_and_arming_checks(handle);
}

std::pair<Events::Result, Events::HealthAndArmingCheckReport>
Events::get_health_and_arming_checks_report() const
{
    return _impl->get_health_and_arming_checks_report();
}

bool operator==(const Events::Event& lhs, const Events::Event& rhs)
{
    return (rhs.compid == lhs.compid) && (rhs.message == lhs.message) &&
           (rhs.description == lhs.description) && (rhs.log_level == lhs.log_level) &&
           (rhs.event_namespace == lhs.event_namespace) && (rhs.event_name == lhs.event_name);
}

std::ostream& operator<<(std::ostream& str, Events::Event const& event)
{
    str << std::setprecision(15);
    str << "event:" << '\n' << "{\n";
    str << "    compid: " << event.compid << '\n';
    str << "    message: " << event.message << '\n';
    str << "    description: " << event.description << '\n';
    str << "    log_level: " << event.log_level << '\n';
    str << "    event_namespace: " << event.event_namespace << '\n';
    str << "    event_name: " << event.event_name << '\n';
    str << '}';
    return str;
}

bool operator==(
    const Events::HealthAndArmingCheckProblem& lhs, const Events::HealthAndArmingCheckProblem& rhs)
{
    return (rhs.message == lhs.message) && (rhs.description == lhs.description) &&
           (rhs.log_level == lhs.log_level) && (rhs.health_component == lhs.health_component);
}

std::ostream& operator<<(
    std::ostream& str, Events::HealthAndArmingCheckProblem const& health_and_arming_check_problem)
{
    str << std::setprecision(15);
    str << "health_and_arming_check_problem:" << '\n' << "{\n";
    str << "    message: " << health_and_arming_check_problem.message << '\n';
    str << "    description: " << health_and_arming_check_problem.description << '\n';
    str << "    log_level: " << health_and_arming_check_problem.log_level << '\n';
    str << "    health_component: " << health_and_arming_check_problem.health_component << '\n';
    str << '}';
    return str;
}

bool operator==(
    const Events::HealthAndArmingCheckMode& lhs, const Events::HealthAndArmingCheckMode& rhs)
{
    return (rhs.mode_name == lhs.mode_name) && (rhs.can_arm_or_run == lhs.can_arm_or_run) &&
           (rhs.problems == lhs.problems);
}

std::ostream&
operator<<(std::ostream& str, Events::HealthAndArmingCheckMode const& health_and_arming_check_mode)
{
    str << std::setprecision(15);
    str << "health_and_arming_check_mode:" << '\n' << "{\n";
    str << "    mode_name: " << health_and_arming_check_mode.mode_name << '\n';
    str << "    can_arm_or_run: " << health_and_arming_check_mode.can_arm_or_run << '\n';
    str << "    problems: [";
    for (auto it = health_and_arming_check_mode.problems.begin();
         it != health_and_arming_check_mode.problems.end();
         ++it) {
        str << *it;
        str << (it + 1 != health_and_arming_check_mode.problems.end() ? ", " : "]\n");
    }
    str << '}';
    return str;
}

bool operator==(const Events::HealthComponentReport& lhs, const Events::HealthComponentReport& rhs)
{
    return (rhs.name == lhs.name) && (rhs.label == lhs.label) &&
           (rhs.is_present == lhs.is_present) && (rhs.has_error == lhs.has_error) &&
           (rhs.has_warning == lhs.has_warning);
}

std::ostream&
operator<<(std::ostream& str, Events::HealthComponentReport const& health_component_report)
{
    str << std::setprecision(15);
    str << "health_component_report:" << '\n' << "{\n";
    str << "    name: " << health_component_report.name << '\n';
    str << "    label: " << health_component_report.label << '\n';
    str << "    is_present: " << health_component_report.is_present << '\n';
    str << "    has_error: " << health_component_report.has_error << '\n';
    str << "    has_warning: " << health_component_report.has_warning << '\n';
    str << '}';
    return str;
}

bool operator==(
    const Events::HealthAndArmingCheckReport& lhs, const Events::HealthAndArmingCheckReport& rhs)
{
    return (rhs.current_mode_intention == lhs.current_mode_intention) &&
           (rhs.health_components == lhs.health_components) &&
           (rhs.all_problems == lhs.all_problems);
}

std::ostream& operator<<(
    std::ostream& str, Events::HealthAndArmingCheckReport const& health_and_arming_check_report)
{
    str << std::setprecision(15);
    str << "health_and_arming_check_report:" << '\n' << "{\n";
    str << "    current_mode_intention: " << health_and_arming_check_report.current_mode_intention
        << '\n';
    str << "    health_components: [";
    for (auto it = health_and_arming_check_report.health_components.begin();
         it != health_and_arming_check_report.health_components.end();
         ++it) {
        str << *it;
        str << (it + 1 != health_and_arming_check_report.health_components.end() ? ", " : "]\n");
    }
    str << "    all_problems: [";
    for (auto it = health_and_arming_check_report.all_problems.begin();
         it != health_and_arming_check_report.all_problems.end();
         ++it) {
        str << *it;
        str << (it + 1 != health_and_arming_check_report.all_problems.end() ? ", " : "]\n");
    }
    str << '}';
    return str;
}

std::ostream& operator<<(std::ostream& str, Events::Result const& result)
{
    switch (result) {
        case Events::Result::Success:
            return str << "Success";
        case Events::Result::NotAvailable:
            return str << "Not Available";
        case Events::Result::ConnectionError:
            return str << "Connection Error";
        case Events::Result::Unsupported:
            return str << "Unsupported";
        case Events::Result::Denied:
            return str << "Denied";
        case Events::Result::Failed:
            return str << "Failed";
        case Events::Result::Timeout:
            return str << "Timeout";
        case Events::Result::NoSystem:
            return str << "No System";
        default:
            return str << "Unknown";
    }
}

std::ostream& operator<<(std::ostream& str, Events::LogLevel const& log_level)
{
    switch (log_level) {
        case Events::LogLevel::Emergency:
            return str << "Emergency";
        case Events::LogLevel::Alert:
            return str << "Alert";
        case Events::LogLevel::Critical:
            return str << "Critical";
        case Events::LogLevel::Error:
            return str << "Error";
        case Events::LogLevel::Warning:
            return str << "Warning";
        case Events::LogLevel::Notice:
            return str << "Notice";
        case Events::LogLevel::Info:
            return str << "Info";
        case Events::LogLevel::Debug:
            return str << "Debug";
        default:
            return str << "Unknown";
    }
}

} // namespace mavsdk