// WARNING: THIS FILE IS AUTOGENERATED! As such, it should not be edited.
// Edits need to be made to the proto files
// (see
// https://github.com/mavlink/MAVSDK-Proto/blob/main/protos/component_metadata_server/component_metadata_server.proto)

#pragma once

#include <array>
#include <cmath>
#include <functional>
#include <limits>
#include <memory>
#include <string>
#include <utility>
#include <vector>

#include "server_plugin_base.h"

#include "handle.h"

namespace mavsdk {

class ServerComponent;
class ComponentMetadataServerImpl;

/**
 * @brief Provide component metadata json definitions, such as parameters.
 */
class ComponentMetadataServer : public ServerPluginBase {
public:
    /**
     * @brief Constructor. Creates the plugin for a ServerComponent instance.
     *
     * The plugin is typically created as shown below:
     *
     *     ```cpp
     *     auto component_metadata_server = ComponentMetadataServer(server_component);
     *     ```
     *
     * @param server_component The ServerComponent instance associated with this server plugin.
     */
    explicit ComponentMetadataServer(std::shared_ptr<ServerComponent> server_component);

    /**
     * @brief Destructor (internal use only).
     */
    ~ComponentMetadataServer() override;

    /**
     * @brief
     */
    enum class MetadataType {
        Parameter, /**< @brief Parameter metadata. */
        Events, /**< @brief Event definitions. */
        Actuators, /**< @brief Actuator definitions. */
    };

    /**
     * @brief Stream operator to print information about a `ComponentMetadataServer::MetadataType`.
     *
     * @return A reference to the stream.
     */
    friend std::ostream&
    operator<<(std::ostream& str, ComponentMetadataServer::MetadataType const& metadata_type);

    /**
     * @brief
     */
    struct Metadata {
        MetadataType type{}; /**< @brief The metadata type */
        std::string json_metadata{}; /**< @brief The JSON metadata */
    };

    /**
     * @brief Equal operator to compare two `ComponentMetadataServer::Metadata` objects.
     *
     * @return `true` if items are equal.
     */
    friend bool operator==(
        const ComponentMetadataServer::Metadata& lhs, const ComponentMetadataServer::Metadata& rhs);

    /**
     * @brief Stream operator to print information about a `ComponentMetadataServer::Metadata`.
     *
     * @return A reference to the stream.
     */
    friend std::ostream&
    operator<<(std::ostream& str, ComponentMetadataServer::Metadata const& metadata);

    /**
     * @brief Provide metadata (can only be called once)
     *
     * This function is blocking.
     *
     * @return Result of request.
     */
    void set_metadata(std::vector<Metadata> metadata) const;

    /**
     * @brief Copy constructor.
     */
    ComponentMetadataServer(const ComponentMetadataServer& other);

    /**
     * @brief Equality operator (object is not copyable).
     */
    const ComponentMetadataServer& operator=(const ComponentMetadataServer&) = delete;

private:
    /** @private Underlying implementation, set at instantiation */
    std::unique_ptr<ComponentMetadataServerImpl> _impl;
};

} // namespace mavsdk