// WARNING: THIS FILE IS AUTOGENERATED! As such, it should not be edited.
// Edits need to be made to the proto files
// (see
// https://github.com/mavlink/MAVSDK-Proto/blob/master/protos/component_metadata/component_metadata.proto)

#include <iomanip>

#include "component_metadata_impl.h"
#include "plugins/component_metadata/component_metadata.h"

namespace mavsdk {

using MetadataData = ComponentMetadata::MetadataData;

using MetadataUpdate = ComponentMetadata::MetadataUpdate;

ComponentMetadata::ComponentMetadata(System& system) :
    PluginBase(),
    _impl{std::make_unique<ComponentMetadataImpl>(system)}
{}

ComponentMetadata::ComponentMetadata(std::shared_ptr<System> system) :
    PluginBase(),
    _impl{std::make_unique<ComponentMetadataImpl>(system)}
{}

ComponentMetadata::~ComponentMetadata() {}

void ComponentMetadata::request_component(uint32_t compid) const
{
    _impl->request_component(compid);
}

void ComponentMetadata::request_autopilot_component() const
{
    _impl->request_autopilot_component();
}

ComponentMetadata::MetadataAvailableHandle
ComponentMetadata::subscribe_metadata_available(const MetadataAvailableCallback& callback)
{
    return _impl->subscribe_metadata_available(callback);
}

void ComponentMetadata::unsubscribe_metadata_available(MetadataAvailableHandle handle)
{
    _impl->unsubscribe_metadata_available(handle);
}

std::pair<ComponentMetadata::Result, ComponentMetadata::MetadataData>
ComponentMetadata::get_metadata(uint32_t compid, MetadataType metadata_type) const
{
    return _impl->get_metadata(compid, metadata_type);
}

bool operator==(
    const ComponentMetadata::MetadataData& lhs, const ComponentMetadata::MetadataData& rhs)
{
    return (rhs.json_metadata == lhs.json_metadata);
}

std::ostream& operator<<(std::ostream& str, ComponentMetadata::MetadataData const& metadata_data)
{
    str << std::setprecision(15);
    str << "metadata_data:" << '\n' << "{\n";
    str << "    json_metadata: " << metadata_data.json_metadata << '\n';
    str << '}';
    return str;
}

std::ostream& operator<<(std::ostream& str, ComponentMetadata::Result const& result)
{
    switch (result) {
        case ComponentMetadata::Result::Success:
            return str << "Success";
        case ComponentMetadata::Result::NotAvailable:
            return str << "Not Available";
        case ComponentMetadata::Result::ConnectionError:
            return str << "Connection Error";
        case ComponentMetadata::Result::Unsupported:
            return str << "Unsupported";
        case ComponentMetadata::Result::Denied:
            return str << "Denied";
        case ComponentMetadata::Result::Failed:
            return str << "Failed";
        case ComponentMetadata::Result::Timeout:
            return str << "Timeout";
        case ComponentMetadata::Result::NoSystem:
            return str << "No System";
        case ComponentMetadata::Result::NotRequested:
            return str << "Not Requested";
        default:
            return str << "Unknown";
    }
}

bool operator==(
    const ComponentMetadata::MetadataUpdate& lhs, const ComponentMetadata::MetadataUpdate& rhs)
{
    return (rhs.compid == lhs.compid) && (rhs.type == lhs.type) &&
           (rhs.json_metadata == lhs.json_metadata);
}

std::ostream&
operator<<(std::ostream& str, ComponentMetadata::MetadataUpdate const& metadata_update)
{
    str << std::setprecision(15);
    str << "metadata_update:" << '\n' << "{\n";
    str << "    compid: " << metadata_update.compid << '\n';
    str << "    type: " << metadata_update.type << '\n';
    str << "    json_metadata: " << metadata_update.json_metadata << '\n';
    str << '}';
    return str;
}

std::ostream& operator<<(std::ostream& str, ComponentMetadata::MetadataType const& metadata_type)
{
    switch (metadata_type) {
        case ComponentMetadata::MetadataType::AllCompleted:
            return str << "All Completed";
        case ComponentMetadata::MetadataType::Parameter:
            return str << "Parameter";
        case ComponentMetadata::MetadataType::Events:
            return str << "Events";
        case ComponentMetadata::MetadataType::Actuators:
            return str << "Actuators";
        default:
            return str << "Unknown";
    }
}

} // namespace mavsdk