// WARNING: THIS FILE IS AUTOGENERATED! As such, it should not be edited.
// Edits need to be made to the proto files
// (see
// https://github.com/mavlink/MAVSDK-Proto/blob/master/protos/action_server/action_server.proto)

#include <iomanip>

#include "action_server_impl.h"
#include "plugins/action_server/action_server.h"

namespace mavsdk {

using AllowableFlightModes = ActionServer::AllowableFlightModes;
using ArmDisarm = ActionServer::ArmDisarm;

ActionServer::ActionServer(std::shared_ptr<ServerComponent> server_component) :
    ServerPluginBase(),
    _impl{std::make_unique<ActionServerImpl>(server_component)}
{}

ActionServer::~ActionServer() {}

ActionServer::ArmDisarmHandle ActionServer::subscribe_arm_disarm(const ArmDisarmCallback& callback)
{
    return _impl->subscribe_arm_disarm(callback);
}

void ActionServer::unsubscribe_arm_disarm(ArmDisarmHandle handle)
{
    _impl->unsubscribe_arm_disarm(handle);
}

ActionServer::FlightModeChangeHandle
ActionServer::subscribe_flight_mode_change(const FlightModeChangeCallback& callback)
{
    return _impl->subscribe_flight_mode_change(callback);
}

void ActionServer::unsubscribe_flight_mode_change(FlightModeChangeHandle handle)
{
    _impl->unsubscribe_flight_mode_change(handle);
}

ActionServer::TakeoffHandle ActionServer::subscribe_takeoff(const TakeoffCallback& callback)
{
    return _impl->subscribe_takeoff(callback);
}

void ActionServer::unsubscribe_takeoff(TakeoffHandle handle)
{
    _impl->unsubscribe_takeoff(handle);
}

ActionServer::LandHandle ActionServer::subscribe_land(const LandCallback& callback)
{
    return _impl->subscribe_land(callback);
}

void ActionServer::unsubscribe_land(LandHandle handle)
{
    _impl->unsubscribe_land(handle);
}

ActionServer::RebootHandle ActionServer::subscribe_reboot(const RebootCallback& callback)
{
    return _impl->subscribe_reboot(callback);
}

void ActionServer::unsubscribe_reboot(RebootHandle handle)
{
    _impl->unsubscribe_reboot(handle);
}

ActionServer::ShutdownHandle ActionServer::subscribe_shutdown(const ShutdownCallback& callback)
{
    return _impl->subscribe_shutdown(callback);
}

void ActionServer::unsubscribe_shutdown(ShutdownHandle handle)
{
    _impl->unsubscribe_shutdown(handle);
}

ActionServer::TerminateHandle ActionServer::subscribe_terminate(const TerminateCallback& callback)
{
    return _impl->subscribe_terminate(callback);
}

void ActionServer::unsubscribe_terminate(TerminateHandle handle)
{
    _impl->unsubscribe_terminate(handle);
}

ActionServer::Result ActionServer::set_allow_takeoff(bool allow_takeoff) const
{
    return _impl->set_allow_takeoff(allow_takeoff);
}

ActionServer::Result ActionServer::set_armable(bool armable, bool force_armable) const
{
    return _impl->set_armable(armable, force_armable);
}

ActionServer::Result ActionServer::set_disarmable(bool disarmable, bool force_disarmable) const
{
    return _impl->set_disarmable(disarmable, force_disarmable);
}

ActionServer::Result
ActionServer::set_allowable_flight_modes(AllowableFlightModes flight_modes) const
{
    return _impl->set_allowable_flight_modes(flight_modes);
}

ActionServer::AllowableFlightModes ActionServer::get_allowable_flight_modes() const
{
    return _impl->get_allowable_flight_modes();
}

bool operator==(
    const ActionServer::AllowableFlightModes& lhs, const ActionServer::AllowableFlightModes& rhs)
{
    return (rhs.can_auto_mode == lhs.can_auto_mode) &&
           (rhs.can_guided_mode == lhs.can_guided_mode) &&
           (rhs.can_stabilize_mode == lhs.can_stabilize_mode);
}

std::ostream&
operator<<(std::ostream& str, ActionServer::AllowableFlightModes const& allowable_flight_modes)
{
    str << std::setprecision(15);
    str << "allowable_flight_modes:" << '\n' << "{\n";
    str << "    can_auto_mode: " << allowable_flight_modes.can_auto_mode << '\n';
    str << "    can_guided_mode: " << allowable_flight_modes.can_guided_mode << '\n';
    str << "    can_stabilize_mode: " << allowable_flight_modes.can_stabilize_mode << '\n';
    str << '}';
    return str;
}

bool operator==(const ActionServer::ArmDisarm& lhs, const ActionServer::ArmDisarm& rhs)
{
    return (rhs.arm == lhs.arm) && (rhs.force == lhs.force);
}

std::ostream& operator<<(std::ostream& str, ActionServer::ArmDisarm const& arm_disarm)
{
    str << std::setprecision(15);
    str << "arm_disarm:" << '\n' << "{\n";
    str << "    arm: " << arm_disarm.arm << '\n';
    str << "    force: " << arm_disarm.force << '\n';
    str << '}';
    return str;
}

std::ostream& operator<<(std::ostream& str, ActionServer::Result const& result)
{
    switch (result) {
        case ActionServer::Result::Unknown:
            return str << "Unknown";
        case ActionServer::Result::Success:
            return str << "Success";
        case ActionServer::Result::NoSystem:
            return str << "No System";
        case ActionServer::Result::ConnectionError:
            return str << "Connection Error";
        case ActionServer::Result::Busy:
            return str << "Busy";
        case ActionServer::Result::CommandDenied:
            return str << "Command Denied";
        case ActionServer::Result::CommandDeniedLandedStateUnknown:
            return str << "Command Denied Landed State Unknown";
        case ActionServer::Result::CommandDeniedNotLanded:
            return str << "Command Denied Not Landed";
        case ActionServer::Result::Timeout:
            return str << "Timeout";
        case ActionServer::Result::VtolTransitionSupportUnknown:
            return str << "Vtol Transition Support Unknown";
        case ActionServer::Result::NoVtolTransitionSupport:
            return str << "No Vtol Transition Support";
        case ActionServer::Result::ParameterError:
            return str << "Parameter Error";
        case ActionServer::Result::Next:
            return str << "Next";
        default:
            return str << "Unknown";
    }
}

std::ostream& operator<<(std::ostream& str, ActionServer::FlightMode const& flight_mode)
{
    switch (flight_mode) {
        case ActionServer::FlightMode::Unknown:
            return str << "Unknown";
        case ActionServer::FlightMode::Ready:
            return str << "Ready";
        case ActionServer::FlightMode::Takeoff:
            return str << "Takeoff";
        case ActionServer::FlightMode::Hold:
            return str << "Hold";
        case ActionServer::FlightMode::Mission:
            return str << "Mission";
        case ActionServer::FlightMode::ReturnToLaunch:
            return str << "Return To Launch";
        case ActionServer::FlightMode::Land:
            return str << "Land";
        case ActionServer::FlightMode::Offboard:
            return str << "Offboard";
        case ActionServer::FlightMode::FollowMe:
            return str << "Follow Me";
        case ActionServer::FlightMode::Manual:
            return str << "Manual";
        case ActionServer::FlightMode::Altctl:
            return str << "Altctl";
        case ActionServer::FlightMode::Posctl:
            return str << "Posctl";
        case ActionServer::FlightMode::Acro:
            return str << "Acro";
        case ActionServer::FlightMode::Stabilized:
            return str << "Stabilized";
        default:
            return str << "Unknown";
    }
}

} // namespace mavsdk