# Maru OS

[![Join the chat at https://gitter.im/maruos/maruos](https://badges.gitter.im/maruos/maruos.svg)](https://gitter.im/maruos/maruos)

Welcome to the Maru OS Project!

[Maru](https://maruos.com) makes personal computing more context-aware by giving you the best interface for your environment. That means when you're on the go, Maru is your phone; when you're at your desk, Maru is your desktop. It's that simple!

To be more precise, Maru is an operating system that enables interactive virtual environments on Android. It's based on the Android Open Source Project and focuses on mobile hardware. It uses lightweight OS virtualization (containers) to spin up virtual systems on demand, and provides a bridge into Android's I/O framework for interactivity.

## Structure

Maru is a fairly large project with code split across several repositories. You can browse through them [here](https://github.com/maruos).

## Getting involved

### Engage with the community

* [User Group](https://groups.google.com/forum/#!forum/maru-os) for general user discussion
* [Developer Group](https://groups.google.com/forum/#!forum/maru-os-dev) for technical discussion
* [Twitter](https://twitter.com/getmaru) for the latest news on Maru

### Report bugs and feature requests

File them as issues on this repository.

### Build and run documentation site locally

```shell
export NODE_OPTIONS=--openssl-legacy-provider
cd docs
npm install
npm run build
npm run dev
```

After that, we can visit http://localhost:8080/docs to verify documentation sites.

### Contribute

Check out the [wiki](https://github.com/maruos/maruos/wiki) to get started.

## Thanks

Maru wouldn't have been possible without the hard work from a lot of people in the open source community. Special thanks to:

* [AOSP](https://source.android.com)
* [Debian GNU/Linux](https://www.debian.org)
* [LXC](https://linuxcontainers.org)

## License

Most of the code is licensed under the Apache License, Version 2.0. See each
repository's licensing information for details and exceptions.
