package com.dimple.system.service.service;



import com.dimple.system.api.model.SysUserBO;

import java.util.List;

/**
 * 用户 业务层
 *
 * @author Dimple
 */
public interface SysUserService {
    /**
     * 根据条件分页查询用户列表
     *
     * @param user 用户信息
     * @return 用户信息集合信息
     */
    List<SysUserBO> selectUserList(SysUserBO user);

    /**
     * 根据条件分页查询已分配用户角色列表
     *
     * @param user 用户信息
     * @return 用户信息集合信息
     */
    List<SysUserBO> selectAllocatedList(SysUserBO user);

    /**
     * 根据条件分页查询未分配用户角色列表
     *
     * @param user 用户信息
     * @return 用户信息集合信息
     */
    List<SysUserBO> selectUnallocatedList(SysUserBO user);

    /**
     * 通过用户名查询用户
     *
     * @param userName 用户名
     * @return 用户对象信息
     */
    SysUserBO selectUserByUserName(String userName);

    /**
     * 通过用户ID查询用户
     *
     * @param userId 用户ID
     * @return 用户对象信息
     */
    SysUserBO selectUserById(Long userId);

    /**
     * 根据用户ID查询用户所属角色组
     *
     * @param userName 用户名
     * @return affected lines
     */
    String selectUserRoleGroup(String userName);

    /**
     * 校验用户名称是否唯一
     *
     * @param user 用户信息
     * @return affected lines
     */
    String checkUserNameUnique(SysUserBO user);

    /**
     * 校验手机号码是否唯一
     *
     * @param user 用户信息
     * @return affected lines
     */
    String checkPhoneUnique(SysUserBO user);

    /**
     * 校验email是否唯一
     *
     * @param user 用户信息
     * @return affected lines
     */
    String checkEmailUnique(SysUserBO user);

    /**
     * 校验用户是否允许操作
     *
     * @param user 用户信息
     */
    void checkUserAllowed(SysUserBO user);

    /**
     * 校验用户是否有数据权限
     *
     * @param userId 用户id
     */
    void checkUserDataScope(Long userId);

    /**
     * 新增用户信息
     *
     * @param user 用户信息
     * @return affected lines
     */
    int insertUser(SysUserBO user);

    /**
     * 注册用户信息
     *
     * @param user 用户信息
     * @return affected lines
     */
    boolean registerUser(SysUserBO user);

    /**
     * 修改用户信息
     *
     * @param user 用户信息
     * @return affected lines
     */
    int updateUser(SysUserBO user);

    /**
     * 用户授权角色
     *
     * @param userId  用户ID
     * @param roleIds 角色组
     */
    void insertUserAuth(Long userId, Long[] roleIds);

    /**
     * 修改用户状态
     *
     * @param user 用户信息
     * @return affected lines
     */
    int updateUserStatus(SysUserBO user);

    /**
     * 修改用户基本信息
     *
     * @param user 用户信息
     * @return affected lines
     */
    int updateUserProfile(SysUserBO user);

    /**
     * 修改用户头像
     *
     * @param userName 用户名
     * @param avatar   头像地址
     * @return affected lines
     */
    boolean updateUserAvatar(String userName, String avatar);

    /**
     * 重置用户密码
     *
     * @param user 用户信息
     * @return affected lines
     */
    int resetPwd(SysUserBO user);

    /**
     * 重置用户密码
     *
     * @param userName 用户名
     * @param password 密码
     * @return affected lines
     */
    int resetUserPwd(String userName, String password);

    /**
     * 通过用户ID删除用户
     *
     * @param userId 用户ID
     * @return affected lines
     */
    int deleteUserById(Long userId);

    /**
     * 批量删除用户信息
     *
     * @param userIds 需要删除的用户ID
     * @return affected lines
     */
    int deleteUserByIds(Long[] userIds);

    /**
     * 导入用户数据
     *
     * @param userList        用户数据列表
     * @param isUpdateSupport 是否更新支持，如果已存在，则进行更新数据
     * @param operName        操作用户
     * @return affected lines
     */
    String importUser(List<SysUserBO> userList, Boolean isUpdateSupport, String operName);
}
