package com.dimple.system.service.service;


import com.dimple.system.api.model.SysRoleBO;
import com.dimple.system.service.service.bo.SysUserRoleBO;

import java.util.List;
import java.util.Set;

/**
 * 角色业务层
 *
 * @author Dimple
 */
public interface SysRoleService {
    /**
     * 根据条件分页查询角色数据
     *
     * @param role 角色信息
     * @return 角色数据集合信息
     */
    List<SysRoleBO> selectRoleList(SysRoleBO role);

    /**
     * 根据用户ID查询角色列表
     *
     * @param userId 用户ID
     * @return 角色列表
     */
    List<SysRoleBO> selectRolesByUserId(Long userId);

    /**
     * 根据用户ID查询角色权限
     *
     * @param userId 用户ID
     * @return 权限列表
     */
    Set<String> selectRolePermissionByUserId(Long userId);

    /**
     * 查询所有角色
     *
     * @return 角色列表
     */
    List<SysRoleBO> selectRoleAll();

    /**
     * 根据用户ID获取角色选择框列表
     *
     * @param userId 用户ID
     * @return 选中角色ID列表
     */
    List<Long> selectRoleListByUserId(Long userId);

    /**
     * 通过角色ID查询角色
     *
     * @param roleId 角色ID
     * @return 角色对象信息
     */
    SysRoleBO selectRoleById(Long roleId);

    /**
     * 校验角色名称是否唯一
     *
     * @param role 角色信息
     * @return affected lines
     */
    String checkRoleNameUnique(SysRoleBO role);

    /**
     * 校验角色权限是否唯一
     *
     * @param role 角色信息
     * @return affected lines
     */
    String checkRoleKeyUnique(SysRoleBO role);

    /**
     * 校验角色是否允许操作
     *
     * @param role 角色信息
     */
    void checkRoleAllowed(SysRoleBO role);

    /**
     * 校验角色是否有数据权限
     *
     * @param roleId 角色id
     */
    void checkRoleDataScope(Long roleId);

    /**
     * 通过角色ID查询角色使用数量
     *
     * @param roleId 角色ID
     * @return affected lines
     */
    int countUserRoleByRoleId(Long roleId);

    /**
     * 新增保存角色信息
     *
     * @param role 角色信息
     * @return affected lines
     */
    int insertRole(SysRoleBO role);

    /**
     * 修改保存角色信息
     *
     * @param role 角色信息
     * @return affected lines
     */
    int updateRole(SysRoleBO role);

    /**
     * 修改角色状态
     *
     * @param role 角色信息
     * @return affected lines
     */
    int updateRoleStatus(SysRoleBO role);

    /**
     * 修改数据权限信息
     *
     * @param role 角色信息
     * @return affected lines
     */
    int authDataScope(SysRoleBO role);

    /**
     * 通过角色ID删除角色
     *
     * @param roleId 角色ID
     * @return affected lines
     */
    int deleteRoleById(Long roleId);

    /**
     * 批量删除角色信息
     *
     * @param roleIds 需要删除的角色ID
     * @return affected lines
     */
    int deleteRoleByIds(Long[] roleIds);

    /**
     * 取消授权用户角色
     *
     * @param userRole 用户和角色关联信息
     * @return affected lines
     */
    int deleteAuthUser(SysUserRoleBO userRole);

    /**
     * 批量取消授权用户角色
     *
     * @param roleId  角色ID
     * @param userIds 需要取消授权的用户数据ID
     * @return affected lines
     */
    int deleteAuthUsers(Long roleId, Long[] userIds);

    /**
     * 批量选择授权用户角色
     *
     * @param roleId  角色ID
     * @param userIds 需要删除的用户数据ID
     * @return affected lines
     */
    int insertAuthUsers(Long roleId, Long[] userIds);
}
