package com.dimple.system.service.service;



import com.dimple.system.service.service.bo.SysConfigBO;

import java.util.List;

/**
 * 参数配置 服务层
 *
 * @author Dimple
 */
public interface SysConfigService {
    /**
     * 查询参数配置信息
     *
     * @param id 参数配置ID
     * @return 参数配置信息
     */
    SysConfigBO selectConfigById(Long id);

    /**
     * 根据键名查询参数配置信息
     *
     * @param configKey 参数键名
     * @return 参数键值
     */
    String selectConfigByKey(String configKey);

    /**
     * 查询参数配置列表
     *
     * @param config 参数配置信息
     * @return 参数配置集合
     */
    List<SysConfigBO> selectConfigList(SysConfigBO config);

    /**
     * 新增参数配置
     *
     * @param config 参数配置信息
     * @return affected lines
     */
    int insertConfig(SysConfigBO config);

    /**
     * 修改参数配置
     *
     * @param config 参数配置信息
     * @return affected lines
     */
    int updateConfig(SysConfigBO config);

    /**
     * 批量删除参数信息
     *
     * @param ids 需要删除的参数ID
     */
    void deleteConfigByIds(Long[] ids);

    /**
     * 加载参数缓存数据
     */
    void loadingConfigCache();

    /**
     * 清空参数缓存数据
     */
    void clearConfigCache();

    /**
     * 重置参数缓存数据
     */
    void resetConfigCache();

    /**
     * 校验参数键名是否唯一
     *
     * @param config 参数信息
     * @return affected lines
     */
    String checkConfigKeyUnique(SysConfigBO config);
}
