package com.dimple.system.service.mapper;


import com.dimple.system.service.entity.SysDictType;

import java.util.List;

/**
 * 字典表 数据层
 *
 * @author Dimple
 */
 public interface SysDictTypeMapper {
    /**
     * 根据条件分页查询字典类型
     *
     * @param dictType 字典类型信息
     * @return 字典类型集合信息
     */
     List<SysDictType> selectDictTypeList(SysDictType dictType);

    /**
     * 根据所有字典类型
     *
     * @return 字典类型集合信息
     */
     List<SysDictType> selectDictTypeAll();

    /**
     * 根据字典类型ID查询信息
     *
     * @param id 字典类型ID
     * @return 字典类型
     */
     SysDictType selectDictTypeById(Long id);

    /**
     * 根据字典类型查询信息
     *
     * @param dictType 字典类型
     * @return 字典类型
     */
     SysDictType selectDictTypeByType(String dictType);

    /**
     * 通过字典ID删除字典信息
     *
     * @param id 字典ID
     * @return affected lines
     */
     int deleteDictTypeById(Long id);

    /**
     * 批量删除字典类型信息
     *
     * @param ids 需要删除的字典ID
     * @return affected lines
     */
     int deleteDictTypeByIds(Long[] ids);

    /**
     * 新增字典类型信息
     *
     * @param dictType 字典类型信息
     * @return affected lines
     */
     int insertDictType(SysDictType dictType);

    /**
     * 修改字典类型信息
     *
     * @param dictType 字典类型信息
     * @return affected lines
     */
     int updateDictType(SysDictType dictType);

    /**
     * 校验字典类型称是否唯一
     *
     * @param dictType 字典类型
     * @return affected lines
     */
     SysDictType checkDictTypeUnique(String dictType);
}
