package com.dimple.monitor.service.service.impl;

import com.dimple.common.core.utils.StringUtils;
import com.dimple.monitor.service.service.SysUserOnlineService;
import com.dimple.monitor.service.service.impl.bo.SysUserOnlineBO;
import com.dimple.system.api.model.LoginUser;
import org.springframework.stereotype.Service;

/**
 * 在线用户 服务层处理
 *
 * @author Dimple
 */
@Service
public class SysUserOnlineServiceImpl implements SysUserOnlineService {
    /**
     * 通过登录地址查询信息
     *
     * @param ip 登录地址
     * @param user   用户信息
     * @return 在线用户信息
     */
    @Override
    public SysUserOnlineBO selectOnlineByip(String ip, LoginUser user) {
        if (StringUtils.equals(ip, user.getIp())) {
            return loginUserToUserOnline(user);
        }
        return null;
    }

    /**
     * 通过用户名称查询信息
     *
     * @param userName 用户名称
     * @param user     用户信息
     * @return 在线用户信息
     */
    @Override
    public SysUserOnlineBO selectOnlineByUserName(String userName, LoginUser user) {
        if (StringUtils.equals(userName, user.getUsername())) {
            return loginUserToUserOnline(user);
        }
        return null;
    }

    /**
     * 通过登录地址/用户名称查询信息
     *
     * @param ip   登录地址
     * @param userName 用户名称
     * @param user     用户信息
     * @return 在线用户信息
     */
    @Override
    public SysUserOnlineBO selectOnlineByInfo(String ip, String userName, LoginUser user) {
        if (StringUtils.equals(ip, user.getIp()) && StringUtils.equals(userName, user.getUsername())) {
            return loginUserToUserOnline(user);
        }
        return null;
    }

    /**
     * 设置在线用户信息
     *
     * @param user 用户信息
     * @return 在线用户
     */
    @Override
    public SysUserOnlineBO loginUserToUserOnline(LoginUser user) {
        if (StringUtils.isNull(user)) {
            return null;
        }
        SysUserOnlineBO sysUserOnline = new SysUserOnlineBO();
        sysUserOnline.setTokenId(user.getToken());
        sysUserOnline.setUserName(user.getUsername());
        sysUserOnline.setIp(user.getIp());
        sysUserOnline.setLoginTime(user.getLoginTime());
        return sysUserOnline;
    }
}
