package com.dimple.job.web.controller;

import com.dimple.common.core.utils.bean.BeanMapper;
import com.dimple.common.core.utils.poi.ExcelUtil;
import com.dimple.common.core.web.controller.BaseController;
import com.dimple.common.core.web.page.TableDataInfo;
import com.dimple.common.core.web.vo.params.AjaxResult;
import com.dimple.common.log.annotation.OperationLog;
import com.dimple.common.log.enums.BusinessType;
import com.dimple.common.security.annotation.RequiresPermissions;
import com.dimple.job.service.service.SysJobLogService;
import com.dimple.job.service.service.bo.SysJobLogBO;
import com.dimple.job.web.controller.vo.SysJobLogVO;
import com.dimple.job.web.controller.vo.params.SysJobLogVOParams;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 调度日志操作处理
 *
 * @author Dimple
 */
@RestController
@RequestMapping("/job/log")
public class SysJobLogController extends BaseController {
    @Autowired
    private SysJobLogService jobLogService;

    /**
     * 查询定时任务调度日志列表
     */
    @RequiresPermissions("log:joblog:list")
    @GetMapping("/list")
    public TableDataInfo list(SysJobLogVOParams sysJobLog) {
        startPage();
        List<SysJobLogBO> list = jobLogService.selectJobLogList(BeanMapper.convert(sysJobLog, SysJobLogBO.class));
        return getDataTable(BeanMapper.convertList(list, SysJobLogVO.class));
    }

    /**
     * 导出定时任务调度日志列表
     */
    @RequiresPermissions("log:joblog:export")
    @OperationLog(title = "任务调度日志", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SysJobLogVOParams sysJobLog) {
        List<SysJobLogBO> list = jobLogService.selectJobLogList(BeanMapper.convert(sysJobLog, SysJobLogBO.class));
        ExcelUtil<SysJobLogVO> util = new ExcelUtil<>(SysJobLogVO.class);
        util.exportExcel(response, BeanMapper.convertList(list, SysJobLogVO.class), "调度日志");
    }

    /**
     * 根据调度编号获取详细信息
     */
    @RequiresPermissions("log:joblog:query")
    @GetMapping("/{id}")
    public AjaxResult getInfo(@PathVariable Long id) {
        return success(jobLogService.selectJobLogById(id));
    }

    /**
     * 删除定时任务调度日志
     */
    @RequiresPermissions("log:joblog:remove")
    @OperationLog(title = "定时任务调度日志", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids) {
        return toAjax(jobLogService.deleteJobLogByIds(ids));
    }

    /**
     * 清空定时任务调度日志
     */
    @RequiresPermissions("log:joblog:remove")
    @OperationLog(title = "调度日志", businessType = BusinessType.CLEAN)
    @DeleteMapping("/clean")
    public AjaxResult clean() {
        jobLogService.cleanJobLog();
        return success();
    }
}
