package com.dimple.blog.front.web.controller;

import com.dimple.blog.api.bo.BlogArchivesBO;
import com.dimple.blog.front.service.service.BlogRestArchivesService;
import com.dimple.blog.front.web.controller.vo.BlogArchivesVO;
import com.dimple.blog.front.web.controller.vo.params.BlogArchivesVOParams;
import com.dimple.common.core.utils.bean.BeanMapper;
import com.dimple.common.core.web.controller.BaseController;
import com.dimple.common.core.web.page.TableDataInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * BlogArchivesController
 *
 * @author Dimple
 * @date 2/28/2023 11:06 AM
 */
@RestController
@RequestMapping("/archives")
public class BlogArchivesRest extends BaseController {

    @Autowired
    private BlogRestArchivesService archivesService;

    @GetMapping
    public TableDataInfo getArchives(BlogArchivesVOParams params) {
        List<BlogArchivesBO> archives = archivesService.getArchives(params.getCountType());
        return getDataTable(BeanMapper.convertList(archives, BlogArchivesVO.class));
    }
}
