///
/// NamedCurve.hpp
/// This file was generated by nitrogen. DO NOT MODIFY THIS FILE.
/// https://github.com/mrousavy/nitro
/// Copyright © 2024 Marc Rousavy @ Margelo
///

#pragma once

#if __has_include(<NitroModules/NitroHash.hpp>)
#include <NitroModules/NitroHash.hpp>
#else
#error NitroModules cannot be found! Are you sure you installed NitroModules properly?
#endif
#if __has_include(<NitroModules/JSIConverter.hpp>)
#include <NitroModules/JSIConverter.hpp>
#else
#error NitroModules cannot be found! Are you sure you installed NitroModules properly?
#endif
#if __has_include(<NitroModules/NitroDefines.hpp>)
#include <NitroModules/NitroDefines.hpp>
#else
#error NitroModules cannot be found! Are you sure you installed NitroModules properly?
#endif

namespace margelo::nitro::crypto {

  /**
   * An enum which can be represented as a JavaScript union (NamedCurve).
   */
  enum class NamedCurve {
    P_256      SWIFT_NAME(p256) = 0,
    P_384      SWIFT_NAME(p384) = 1,
    P_521      SWIFT_NAME(p521) = 2,
  } CLOSED_ENUM;

} // namespace margelo::nitro::crypto

namespace margelo::nitro {

  using namespace margelo::nitro::crypto;

  // C++ NamedCurve <> JS NamedCurve (union)
  template <>
  struct JSIConverter<NamedCurve> {
    static inline NamedCurve fromJSI(jsi::Runtime& runtime, const jsi::Value& arg) {
      std::string unionValue = JSIConverter<std::string>::fromJSI(runtime, arg);
      switch (hashString(unionValue.c_str(), unionValue.size())) {
        case hashString("P-256"): return NamedCurve::P_256;
        case hashString("P-384"): return NamedCurve::P_384;
        case hashString("P-521"): return NamedCurve::P_521;
        default: [[unlikely]]
          throw std::invalid_argument("Cannot convert \"" + unionValue + "\" to enum NamedCurve - invalid value!");
      }
    }
    static inline jsi::Value toJSI(jsi::Runtime& runtime, NamedCurve arg) {
      switch (arg) {
        case NamedCurve::P_256: return JSIConverter<std::string>::toJSI(runtime, "P-256");
        case NamedCurve::P_384: return JSIConverter<std::string>::toJSI(runtime, "P-384");
        case NamedCurve::P_521: return JSIConverter<std::string>::toJSI(runtime, "P-521");
        default: [[unlikely]]
          throw std::invalid_argument("Cannot convert NamedCurve to JS - invalid value: "
                                    + std::to_string(static_cast<int>(arg)) + "!");
      }
    }
    static inline bool canConvert(jsi::Runtime& runtime, const jsi::Value& value) {
      if (!value.isString()) {
        return false;
      }
      std::string unionValue = JSIConverter<std::string>::fromJSI(runtime, value);
      switch (hashString(unionValue.c_str(), unionValue.size())) {
        case hashString("P-256"):
        case hashString("P-384"):
        case hashString("P-521"):
          return true;
        default:
          return false;
      }
    }
  };

} // namespace margelo::nitro
