///
/// KeyUsage.hpp
/// This file was generated by nitrogen. DO NOT MODIFY THIS FILE.
/// https://github.com/mrousavy/nitro
/// Copyright © 2024 Marc Rousavy @ Margelo
///

#pragma once

#if __has_include(<NitroModules/NitroHash.hpp>)
#include <NitroModules/NitroHash.hpp>
#else
#error NitroModules cannot be found! Are you sure you installed NitroModules properly?
#endif
#if __has_include(<NitroModules/JSIConverter.hpp>)
#include <NitroModules/JSIConverter.hpp>
#else
#error NitroModules cannot be found! Are you sure you installed NitroModules properly?
#endif
#if __has_include(<NitroModules/NitroDefines.hpp>)
#include <NitroModules/NitroDefines.hpp>
#else
#error NitroModules cannot be found! Are you sure you installed NitroModules properly?
#endif

namespace margelo::nitro::crypto {

  /**
   * An enum which can be represented as a JavaScript union (KeyUsage).
   */
  enum class KeyUsage {
    ENCRYPT      SWIFT_NAME(encrypt) = 0,
    DECRYPT      SWIFT_NAME(decrypt) = 1,
    SIGN      SWIFT_NAME(sign) = 2,
    VERIFY      SWIFT_NAME(verify) = 3,
    DERIVEKEY      SWIFT_NAME(derivekey) = 4,
    DERIVEBITS      SWIFT_NAME(derivebits) = 5,
    WRAPKEY      SWIFT_NAME(wrapkey) = 6,
    UNWRAPKEY      SWIFT_NAME(unwrapkey) = 7,
  } CLOSED_ENUM;

} // namespace margelo::nitro::crypto

namespace margelo::nitro {

  using namespace margelo::nitro::crypto;

  // C++ KeyUsage <> JS KeyUsage (union)
  template <>
  struct JSIConverter<KeyUsage> {
    static inline KeyUsage fromJSI(jsi::Runtime& runtime, const jsi::Value& arg) {
      std::string unionValue = JSIConverter<std::string>::fromJSI(runtime, arg);
      switch (hashString(unionValue.c_str(), unionValue.size())) {
        case hashString("encrypt"): return KeyUsage::ENCRYPT;
        case hashString("decrypt"): return KeyUsage::DECRYPT;
        case hashString("sign"): return KeyUsage::SIGN;
        case hashString("verify"): return KeyUsage::VERIFY;
        case hashString("deriveKey"): return KeyUsage::DERIVEKEY;
        case hashString("deriveBits"): return KeyUsage::DERIVEBITS;
        case hashString("wrapKey"): return KeyUsage::WRAPKEY;
        case hashString("unwrapKey"): return KeyUsage::UNWRAPKEY;
        default: [[unlikely]]
          throw std::invalid_argument("Cannot convert \"" + unionValue + "\" to enum KeyUsage - invalid value!");
      }
    }
    static inline jsi::Value toJSI(jsi::Runtime& runtime, KeyUsage arg) {
      switch (arg) {
        case KeyUsage::ENCRYPT: return JSIConverter<std::string>::toJSI(runtime, "encrypt");
        case KeyUsage::DECRYPT: return JSIConverter<std::string>::toJSI(runtime, "decrypt");
        case KeyUsage::SIGN: return JSIConverter<std::string>::toJSI(runtime, "sign");
        case KeyUsage::VERIFY: return JSIConverter<std::string>::toJSI(runtime, "verify");
        case KeyUsage::DERIVEKEY: return JSIConverter<std::string>::toJSI(runtime, "deriveKey");
        case KeyUsage::DERIVEBITS: return JSIConverter<std::string>::toJSI(runtime, "deriveBits");
        case KeyUsage::WRAPKEY: return JSIConverter<std::string>::toJSI(runtime, "wrapKey");
        case KeyUsage::UNWRAPKEY: return JSIConverter<std::string>::toJSI(runtime, "unwrapKey");
        default: [[unlikely]]
          throw std::invalid_argument("Cannot convert KeyUsage to JS - invalid value: "
                                    + std::to_string(static_cast<int>(arg)) + "!");
      }
    }
    static inline bool canConvert(jsi::Runtime& runtime, const jsi::Value& value) {
      if (!value.isString()) {
        return false;
      }
      std::string unionValue = JSIConverter<std::string>::fromJSI(runtime, value);
      switch (hashString(unionValue.c_str(), unionValue.size())) {
        case hashString("encrypt"):
        case hashString("decrypt"):
        case hashString("sign"):
        case hashString("verify"):
        case hashString("deriveKey"):
        case hashString("deriveBits"):
        case hashString("wrapKey"):
        case hashString("unwrapKey"):
          return true;
        default:
          return false;
      }
    }
  };

} // namespace margelo::nitro
